/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSAvcEncoderConfig.h"

#include "JSDOMConvertOptional.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> ConversionResult<IDLDictionary<AvcEncoderConfig>> convertDictionary<AvcEncoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    AvcEncoderConfig result;
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto formatConversionResult = convertOptionalWithDefault<IDLEnumeration<AvcEncoderConfig::BitstreamFormat>>(lexicalGlobalObject, formatValue, [&]() -> ConversionResult<IDLEnumeration<AvcEncoderConfig::BitstreamFormat>> { return Converter<IDLEnumeration<AvcEncoderConfig::BitstreamFormat>>::ReturnType { AvcEncoderConfig::BitstreamFormat::Avc }; });
    if (formatConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.format = formatConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const AvcEncoderConfig& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto formatValue = toJS<IDLEnumeration<AvcEncoderConfig::BitstreamFormat>>(lexicalGlobalObject, throwScope, dictionary.format);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "format"_s), formatValue);
    return result;
}

#endif

#if ENABLE(WEB_CODECS)

String convertEnumerationToString(AvcEncoderConfig::BitstreamFormat enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("annexb"),
        MAKE_STATIC_STRING_IMPL("avc"),
    };
    static_assert(static_cast<size_t>(AvcEncoderConfig::BitstreamFormat::Annexb) == 0, "AvcEncoderConfig::BitstreamFormat::Annexb is not 0 as expected");
    static_assert(static_cast<size_t>(AvcEncoderConfig::BitstreamFormat::Avc) == 1, "AvcEncoderConfig::BitstreamFormat::Avc is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, AvcEncoderConfig::BitstreamFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<AvcEncoderConfig::BitstreamFormat> parseEnumerationFromString<AvcEncoderConfig::BitstreamFormat>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, AvcEncoderConfig::BitstreamFormat>, 2> mappings {
        std::pair<ComparableASCIILiteral, AvcEncoderConfig::BitstreamFormat> { "annexb"_s, AvcEncoderConfig::BitstreamFormat::Annexb },
        std::pair<ComparableASCIILiteral, AvcEncoderConfig::BitstreamFormat> { "avc"_s, AvcEncoderConfig::BitstreamFormat::Avc },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<AvcEncoderConfig::BitstreamFormat> parseEnumeration<AvcEncoderConfig::BitstreamFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<AvcEncoderConfig::BitstreamFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<AvcEncoderConfig::BitstreamFormat>()
{
    return "\"annexb\", \"avc\""_s;
}

#endif

} // namespace WebCore


#endif // ENABLE(WEB_CODECS)
