/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFaceDetector.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBlob.h"
#include "JSCSSStyleImageValue.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSDetectedFace.h"
#include "JSFaceDetectorOptions.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageBitmap.h"
#include "JSImageData.h"
#include "JSOffscreenCanvas.h"
#include "JSSVGImageElement.h"
#include "JSWebCodecsVideoFrame.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFaceDetectorPrototypeFunction_detect);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFaceDetectorConstructor);

class JSFaceDetectorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFaceDetectorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFaceDetectorPrototype* ptr = new (NotNull, JSC::allocateCell<JSFaceDetectorPrototype>(vm)) JSFaceDetectorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFaceDetectorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFaceDetectorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFaceDetectorPrototype, JSFaceDetectorPrototype::Base);

using JSFaceDetectorDOMConstructor = JSDOMConstructor<JSFaceDetector>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSFaceDetectorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSFaceDetectorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "FaceDetector"_s);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto faceDetectorOptionsConversionResult = convert<IDLDictionary<FaceDetectorOptions>>(*lexicalGlobalObject, argument0.value());
    if (faceDetectorOptionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = FaceDetector::create(*context, faceDetectorOptionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<FaceDetector>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<FaceDetector>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSFaceDetectorDOMConstructorConstruct, JSFaceDetectorDOMConstructor::construct);

template<> const ClassInfo JSFaceDetectorDOMConstructor::s_info = { "FaceDetector"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFaceDetectorDOMConstructor) };

template<> JSValue JSFaceDetectorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFaceDetectorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FaceDetector"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFaceDetector::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSFaceDetectorPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFaceDetectorConstructor, 0 } },
    HashTableValue { "detect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFaceDetectorPrototypeFunction_detect, 1 } },
};

const ClassInfo JSFaceDetectorPrototype::s_info = { "FaceDetector"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFaceDetectorPrototype) };

void JSFaceDetectorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFaceDetector::info(), JSFaceDetectorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFaceDetector::s_info = { "FaceDetector"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFaceDetector) };

JSFaceDetector::JSFaceDetector(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FaceDetector>&& impl)
    : JSDOMWrapper<FaceDetector>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, FaceDetector>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSFaceDetector::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFaceDetectorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFaceDetectorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFaceDetector::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFaceDetector>(vm, globalObject);
}

JSValue JSFaceDetector::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFaceDetectorDOMConstructor, DOMConstructorID::FaceDetector>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFaceDetector::destroy(JSC::JSCell* cell)
{
    JSFaceDetector* thisObject = static_cast<JSFaceDetector*>(cell);
    thisObject->JSFaceDetector::~JSFaceDetector();
}

JSC_DEFINE_CUSTOM_GETTER(jsFaceDetectorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFaceDetectorPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFaceDetector::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFaceDetectorPrototypeFunction_detectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFaceDetector>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto imageConversionResult = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLVideoElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<SVGImageElement>, IDLInterface<ImageBitmap>, IDLInterface<OffscreenCanvas>, IDLInterface<CSSStyleImageValue>, IDLInterface<WebCodecsVideoFrame>, IDLInterface<Blob>, IDLInterface<ImageData>>>(*lexicalGlobalObject, argument0.value());
    if (imageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLDictionary<DetectedFace>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.detect(*context, imageConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFaceDetectorPrototypeFunction_detect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFaceDetector>::call<jsFaceDetectorPrototypeFunction_detectBody>(*lexicalGlobalObject, *callFrame, "detect");
}

JSC::GCClient::IsoSubspace* JSFaceDetector::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFaceDetector, UseCustomHeapCellType::No>(vm, "JSFaceDetector"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFaceDetector.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFaceDetector = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFaceDetector.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFaceDetector = std::forward<decltype(space)>(space); }
    );
}

void JSFaceDetector::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFaceDetector*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFaceDetectorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFaceDetectorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFaceDetector = static_cast<JSFaceDetector*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFaceDetector->protectedWrapped().ptr(), jsFaceDetector);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FaceDetector@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12FaceDetectorE[]; }
#endif
template<std::same_as<FaceDetector> T>
static inline void verifyVTable(FaceDetector* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FaceDetector@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12FaceDetectorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FaceDetector has subclasses. If FaceDetector has subclasses that get passed
        // to toJS() we currently require FaceDetector you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FaceDetector>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FaceDetector>(impl.ptr());
#endif
    return createWrapper<FaceDetector>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FaceDetector& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FaceDetector* JSFaceDetector::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFaceDetector*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
