/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESStandardDerivatives.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSOESStandardDerivativesPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESStandardDerivativesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESStandardDerivativesPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESStandardDerivativesPrototype>(vm)) JSOESStandardDerivativesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESStandardDerivativesPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESStandardDerivativesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESStandardDerivativesPrototype, JSOESStandardDerivativesPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSOESStandardDerivativesPrototypeTableValues {
    HashTableValue { "FRAGMENT_SHADER_DERIVATIVE_HINT_OES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8B8B } },
};

const ClassInfo JSOESStandardDerivativesPrototype::s_info = { "OESStandardDerivatives"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESStandardDerivativesPrototype) };

void JSOESStandardDerivativesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESStandardDerivatives::info(), JSOESStandardDerivativesPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESStandardDerivatives::s_info = { "OESStandardDerivatives"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESStandardDerivatives) };

JSOESStandardDerivatives::JSOESStandardDerivatives(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESStandardDerivatives>&& impl)
    : JSDOMWrapper<OESStandardDerivatives>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESStandardDerivatives>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESStandardDerivatives::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESStandardDerivativesPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESStandardDerivativesPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESStandardDerivatives::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESStandardDerivatives>(vm, globalObject);
}

void JSOESStandardDerivatives::destroy(JSC::JSCell* cell)
{
    JSOESStandardDerivatives* thisObject = static_cast<JSOESStandardDerivatives*>(cell);
    thisObject->JSOESStandardDerivatives::~JSOESStandardDerivatives();
}

JSC::GCClient::IsoSubspace* JSOESStandardDerivatives::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESStandardDerivatives, UseCustomHeapCellType::No>(vm, "JSOESStandardDerivatives"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESStandardDerivatives.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESStandardDerivatives = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESStandardDerivatives.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESStandardDerivatives = std::forward<decltype(space)>(space); }
    );
}

void JSOESStandardDerivatives::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESStandardDerivatives*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESStandardDerivativesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsOESStandardDerivatives = jsCast<JSOESStandardDerivatives*>(handle.slot()->asCell());
    auto& owner = jsOESStandardDerivatives->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsOESStandardDerivatives"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESStandardDerivativesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESStandardDerivatives = static_cast<JSOESStandardDerivatives*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESStandardDerivatives->protectedWrapped().ptr(), jsOESStandardDerivatives);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESStandardDerivatives@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22OESStandardDerivativesE[]; }
#endif
template<std::same_as<OESStandardDerivatives> T>
static inline void verifyVTable(OESStandardDerivatives* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESStandardDerivatives@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22OESStandardDerivativesE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESStandardDerivatives has subclasses. If OESStandardDerivatives has subclasses that get passed
        // to toJS() we currently require OESStandardDerivatives you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESStandardDerivatives>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OESStandardDerivatives>(impl.ptr());
#endif
    return createWrapper<OESStandardDerivatives>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESStandardDerivatives& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESStandardDerivatives* JSOESStandardDerivatives::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESStandardDerivatives*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
