#pragma once
#include "livekit/video_frame_buffer.h"
#include <cstdint>
#include <memory>

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#endif // __clang__

namespace livekit {
  enum class VideoFrameBufferType : ::std::int32_t;
  using VideoFrameBuffer = ::livekit::VideoFrameBuffer;
  using PlanarYuvBuffer = ::livekit::PlanarYuvBuffer;
  using PlanarYuv8Buffer = ::livekit::PlanarYuv8Buffer;
  using PlanarYuv16BBuffer = ::livekit::PlanarYuv16BBuffer;
  using BiplanarYuvBuffer = ::livekit::BiplanarYuvBuffer;
  using BiplanarYuv8Buffer = ::livekit::BiplanarYuv8Buffer;
  using I420Buffer = ::livekit::I420Buffer;
  using I420ABuffer = ::livekit::I420ABuffer;
  using I422Buffer = ::livekit::I422Buffer;
  using I444Buffer = ::livekit::I444Buffer;
  using I010Buffer = ::livekit::I010Buffer;
  using NV12Buffer = ::livekit::NV12Buffer;
  using PlatformImageBuffer = ::livekit::PlatformImageBuffer;
}

namespace livekit {
#ifndef CXXBRIDGE1_ENUM_livekit$VideoFrameBufferType
#define CXXBRIDGE1_ENUM_livekit$VideoFrameBufferType
enum class VideoFrameBufferType : ::std::int32_t {
  Native = 0,
  I420 = 1,
  I420A = 2,
  I422 = 3,
  I444 = 4,
  I010 = 5,
  NV12 = 6,
};
#endif // CXXBRIDGE1_ENUM_livekit$VideoFrameBufferType
} // namespace livekit

#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
