const char *cylinders_fs =
  "varying vec3 fnormal;\n"
  "\n"
  "uniform float opacity;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  vec3 N = normalize(fnormal);\n"
  "  vec3 L = normalize(vec3(0, 1, 1));\n"
  "  vec3 E = vec3(0, 0, 1);\n"
  "  vec3 H = normalize(L + E);\n"
  "  float df = max(0.0, dot(N, L));\n"
  "  float sf = max(0.0, dot(N, H));\n"
  "  vec4 ambient = 0.4 * gl_Color;\n"
  "  vec4 diffuse = 0.55 * gl_Color;\n"
  "  vec4 specular = 0.5 * (vec4(1, 1, 1, 1) - gl_Color);\n"
  "  gl_FragColor = ambient + df * diffuse + pow(sf, 20.0) * specular;\n"
  "  gl_FragColor.a = opacity;\n"
  "}\n"
  "\n";
