
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "bookmarks_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_Bookmarks_Type = nullptr;
static PyTypeObject *Sbk_Bookmarks_TypeF(void)
{
    return _Sbk_Bookmarks_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void BookmarksWrapper::pysideInitQtMetaTypes()
{
}

void BookmarksWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

BookmarksWrapper::BookmarksWrapper(::QObject * parent) : Bookmarks(parent)
{
}

void BookmarksWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Bookmarks_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("Bookmarks", funcName, gil, pyOverride, event);
}

void BookmarksWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Bookmarks_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("Bookmarks", funcName, gil, pyOverride, signal);
}

void BookmarksWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Bookmarks_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("Bookmarks", funcName, gil, pyOverride, event);
}

void BookmarksWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Bookmarks_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("Bookmarks", funcName, gil, pyOverride, signal);
}

bool BookmarksWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Bookmarks_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("Bookmarks", funcName, gil, pyOverride, event);
}

bool BookmarksWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Bookmarks_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("Bookmarks", funcName, gil, pyOverride, watched, event);
}

void BookmarksWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Bookmarks_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("Bookmarks", funcName, gil, pyOverride, event);
}

const QMetaObject *BookmarksWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Bookmarks::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int BookmarksWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Bookmarks::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *BookmarksWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< BookmarksWrapper *>(this));
    }
    return Bookmarks::qt_metacast(_clname);
}

BookmarksWrapper::~BookmarksWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_Bookmarks_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Bookmarks_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Bookmarks >()))
        return -1;

    BookmarksWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:Bookmarks", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Bookmarks::Bookmarks(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // Bookmarks(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // Bookmarks(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // Bookmarks(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) BookmarksWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new BookmarksWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< Bookmarks >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);
    };


    return 1;
}

static PyObject *Sbk_BookmarksFunc_addBookmark(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addBookmark", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Bookmarks::addBookmark(BookmarkItem*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addBookmark(BookmarkItem*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addBookmark", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addBookmark(BookmarkItem*,BookmarkItem*)
            cppSelf->addBookmark(cppArg0, cppArg1);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyArgs[0]);
            Shiboken::Object::releaseOwnership(pyArgs[1]);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksFunc_canBeModified(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::canBeModified(BookmarkItem*)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArg)))) {
        overloadId = 0; // canBeModified(BookmarkItem*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "canBeModified", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // canBeModified(BookmarkItem*)const
            bool cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->canBeModified(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_changeBookmark(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::changeBookmark(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArg)))) {
        overloadId = 0; // changeBookmark(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "changeBookmark", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // changeBookmark(BookmarkItem*)
            cppSelf->changeBookmark(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksFunc_insertBookmark(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "insertBookmark", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Bookmarks::insertBookmark(BookmarkItem*,int,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArgs[2])))) {
        overloadId = 0; // insertBookmark(BookmarkItem*,int,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insertBookmark", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertBookmark(BookmarkItem*,int,BookmarkItem*)
            cppSelf->insertBookmark(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksFunc_isBookmarked(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::isBookmarked(QUrl)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // isBookmarked(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isBookmarked", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // isBookmarked(QUrl)
            bool cppResult = cppSelf->isBookmarked(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_lastUsedFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // lastUsedFolder()const
        BookmarkItem * cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->lastUsedFolder();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksFunc_menuFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // menuFolder()const
        BookmarkItem * cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->menuFolder();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // model()const
        BookmarksModel * cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->model();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarksModel_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_removeBookmark(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::removeBookmark(BookmarkItem*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyArg)))) {
        overloadId = 0; // removeBookmark(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeBookmark", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeBookmark(BookmarkItem*)
            bool cppResult = cppSelf->removeBookmark(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_rootItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // rootItem()const
        BookmarkItem * cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->rootItem();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_searchBookmarks(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "searchBookmarks", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:searchBookmarks", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Bookmarks::searchBookmarks(QString,int=,Qt::CaseSensitivity=)const->QList<BookmarkItem*>
    // 1: Bookmarks::searchBookmarks(QUrl)const->QList<BookmarkItem*>
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // searchBookmarks(QString,int,Qt::CaseSensitivity)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // searchBookmarks(QString,int,Qt::CaseSensitivity)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_CaseSensitivity_IDX])))->converter, (pyArgs[2])))) {
                overloadId = 0; // searchBookmarks(QString,int,Qt::CaseSensitivity)const
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        overloadId = 1; // searchBookmarks(QUrl)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "searchBookmarks", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // searchBookmarks(const QString &string, int limit, Qt::CaseSensitivity sensitive) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"limit", 1}, {"sensitive", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_CaseSensitivity_IDX])))->converter, (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "searchBookmarks", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = -1;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::CaseSensitivity cppArg2(Qt::CaseInsensitive);
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // searchBookmarks(QString,int,Qt::CaseSensitivity)const
                QList<BookmarkItem*> cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->searchBookmarks(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BookmarkItemPTR_IDX], &cppResult);
            }
            break;
        }
        case 1: // searchBookmarks(const QUrl &url) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "searchBookmarks", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // searchBookmarks(QUrl)const
                QList<BookmarkItem*> cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->searchBookmarks(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BookmarkItemPTR_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_searchKeyword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::searchKeyword(QString)const->QList<BookmarkItem*>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // searchKeyword(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "searchKeyword", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // searchKeyword(QString)const
            QList<BookmarkItem*> cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->searchKeyword(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BookmarkItemPTR_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_setShowOnlyIconsInToolbar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::setShowOnlyIconsInToolbar(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowOnlyIconsInToolbar(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowOnlyIconsInToolbar", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowOnlyIconsInToolbar(bool)
            cppSelf->setShowOnlyIconsInToolbar(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksFunc_setShowOnlyTextInToolbar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Bookmarks::setShowOnlyTextInToolbar(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowOnlyTextInToolbar(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowOnlyTextInToolbar", errInfo, SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowOnlyTextInToolbar(bool)
            cppSelf->setShowOnlyTextInToolbar(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BookmarksFunc_showOnlyIconsInToolbar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showOnlyIconsInToolbar()const
        bool cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->showOnlyIconsInToolbar();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_showOnlyTextInToolbar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showOnlyTextInToolbar()const
        bool cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->showOnlyTextInToolbar();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_toolbarFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolbarFolder()const
        BookmarkItem * cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->toolbarFolder();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_BookmarksFunc_unsortedFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<BookmarksWrapper *>(reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // unsortedFolder()const
        BookmarkItem * cppResult = const_cast<const BookmarksWrapper *>(cppSelf)->unsortedFolder();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_Bookmarks_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Bookmarks_methods[] = {
    {"addBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_addBookmark), METH_VARARGS, nullptr},
    {"canBeModified", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_canBeModified), METH_O, nullptr},
    {"changeBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_changeBookmark), METH_O, nullptr},
    {"insertBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_insertBookmark), METH_VARARGS, nullptr},
    {"isBookmarked", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_isBookmarked), METH_O, nullptr},
    {"lastUsedFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_lastUsedFolder), METH_NOARGS, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_loadSettings), METH_NOARGS, nullptr},
    {"menuFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_menuFolder), METH_NOARGS, nullptr},
    {"model", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_model), METH_NOARGS, nullptr},
    {"removeBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_removeBookmark), METH_O, nullptr},
    {"rootItem", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_rootItem), METH_NOARGS, nullptr},
    {"searchBookmarks", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_searchBookmarks), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"searchKeyword", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_searchKeyword), METH_O, nullptr},
    {"setShowOnlyIconsInToolbar", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_setShowOnlyIconsInToolbar), METH_O, nullptr},
    {"setShowOnlyTextInToolbar", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_setShowOnlyTextInToolbar), METH_O, nullptr},
    {"showOnlyIconsInToolbar", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_showOnlyIconsInToolbar), METH_NOARGS, nullptr},
    {"showOnlyTextInToolbar", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_showOnlyTextInToolbar), METH_NOARGS, nullptr},
    {"toolbarFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_toolbarFolder), METH_NOARGS, nullptr},
    {"unsortedFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarksFunc_unsortedFolder), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_Bookmarks_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::Bookmarks *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<BookmarksWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Bookmarks_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_Bookmarks_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_Bookmarks_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Bookmarks_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Bookmarks_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Bookmarks_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Bookmarks_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Bookmarks_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_Bookmarks_spec = {
    "1:PyFalkon.Bookmarks",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_Bookmarks_slots
};

} //extern "C"

static void *Sbk_Bookmarks_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::Bookmarks *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Bookmarks_PythonToCpp_Bookmarks_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_Bookmarks_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Bookmarks_PythonToCpp_Bookmarks_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_Bookmarks_TypeF()))
        return Bookmarks_PythonToCpp_Bookmarks_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Bookmarks_PTR_CppToPython_Bookmarks(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::Bookmarks *>(const_cast<void *>(cppIn)), Sbk_Bookmarks_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *Bookmarks_SignatureStrings[] = {
    "PyFalkon.Bookmarks(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.Bookmarks.addBookmark(self,parent:PyFalkon.BookmarkItem,item:PyFalkon.BookmarkItem)",
    "PyFalkon.Bookmarks.canBeModified(self,item:PyFalkon.BookmarkItem)->bool",
    "PyFalkon.Bookmarks.changeBookmark(self,item:PyFalkon.BookmarkItem)",
    "PyFalkon.Bookmarks.insertBookmark(self,parent:PyFalkon.BookmarkItem,row:int,item:PyFalkon.BookmarkItem)",
    "PyFalkon.Bookmarks.isBookmarked(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->bool",
    "PyFalkon.Bookmarks.lastUsedFolder(self)->PyFalkon.BookmarkItem",
    "PyFalkon.Bookmarks.loadSettings(self)",
    "PyFalkon.Bookmarks.menuFolder(self)->PyFalkon.BookmarkItem",
    "PyFalkon.Bookmarks.model(self)->PyFalkon.BookmarksModel",
    "PyFalkon.Bookmarks.removeBookmark(self,item:PyFalkon.BookmarkItem)->bool",
    "PyFalkon.Bookmarks.rootItem(self)->PyFalkon.BookmarkItem",
    "1:PyFalkon.Bookmarks.searchBookmarks(self,string:QString,limit:int=-1,sensitive:PySide6.QtCore.Qt.CaseSensitivity=Qt.CaseInsensitive)->QList[PyFalkon.BookmarkItem]",
    "0:PyFalkon.Bookmarks.searchBookmarks(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->QList[PyFalkon.BookmarkItem]",
    "PyFalkon.Bookmarks.searchKeyword(self,keyword:QString)->QList[PyFalkon.BookmarkItem]",
    "PyFalkon.Bookmarks.setShowOnlyIconsInToolbar(self,state:bool)",
    "PyFalkon.Bookmarks.setShowOnlyTextInToolbar(self,state:bool)",
    "PyFalkon.Bookmarks.showOnlyIconsInToolbar(self)->bool",
    "PyFalkon.Bookmarks.showOnlyTextInToolbar(self)->bool",
    "PyFalkon.Bookmarks.toolbarFolder(self)->PyFalkon.BookmarkItem",
    "PyFalkon.Bookmarks.unsortedFolder(self)->PyFalkon.BookmarkItem",
    nullptr}; // Sentinel
#else
static constexpr size_t Bookmarks_SignatureByteSize = 379;
static constexpr uint8_t Bookmarks_SignatureBytes[379] = {
    0x78, 0xda, 0x9d, 0x53, 0x3b, 0x6f, 0xc2, 0x30, 0x10, 0xde, 0xfb, 0x2b, 0x3a, 0x16, 0x29, 0x44,
    0x65, 0xe9, 0x10, 0x89, 0x0e, 0x20, 0x21, 0xa1, 0x16, 0x41, 0x14, 0x98, 0x10, 0x83, 0x89, 0x0f,
    0x70, 0xe3, 0xdc, 0x21, 0xfb, 0x02, 0xcd, 0xbf, 0x6f, 0x02, 0xa4, 0x52, 0xc1, 0x49, 0x09, 0x4b,
    0x14, 0xfb, 0xee, 0x7b, 0xf8, 0x1e, 0xb3, 0x7c, 0x24, 0x74, 0x42, 0xe8, 0x0f, 0x88, 0x92, 0x54,
    0x98, 0xc4, 0xbe, 0x58, 0xd0, 0x1b, 0x6f, 0x2f, 0x0c, 0x20, 0x07, 0xb3, 0x3c, 0x52, 0x12, 0xde,
    0xfc, 0x90, 0x87, 0x64, 0xc0, 0x0f, 0xa7, 0xeb, 0x2f, 0x88, 0xb9, 0x8f, 0x99, 0xd6, 0x7b, 0x36,
    0x9d, 0xa7, 0xd9, 0x0d, 0xdc, 0x17, 0x52, 0x56, 0x87, 0x2b, 0xaa, 0xab, 0xd4, 0x31, 0x43, 0xea,
    0xa9, 0xe2, 0xe3, 0x0e, 0x39, 0xc9, 0x63, 0x81, 0x03, 0x98, 0x90, 0x54, 0x1b, 0x05, 0xf2, 0x4c,
    0xdf, 0xc0, 0xd0, 0x7d, 0x5f, 0x13, 0x69, 0x27, 0xcf, 0x4e, 0xe0, 0x16, 0xfe, 0xfa, 0x6c, 0x69,
    0x45, 0xa1, 0x05, 0xc3, 0x2d, 0x9e, 0x6a, 0xe8, 0x18, 0x28, 0xe4, 0xd6, 0x3a, 0xb6, 0xfa, 0xaf,
    0x5e, 0x9c, 0x19, 0x1d, 0x70, 0xbe, 0x57, 0xb8, 0xf5, 0x17, 0xa8, 0x08, 0x97, 0xd7, 0x5d, 0x5a,
    0x18, 0xed, 0x3d, 0x87, 0x11, 0x9b, 0x22, 0x65, 0xd5, 0x50, 0x05, 0x2d, 0x2c, 0x2f, 0x2c, 0xc8,
    0x11, 0x69, 0x09, 0xe6, 0x44, 0x5e, 0x64, 0x3b, 0xad, 0x39, 0xe1, 0x24, 0x64, 0x04, 0xcc, 0x85,
    0xca, 0x79, 0x6a, 0x9c, 0xfe, 0x53, 0xc0, 0xec, 0x41, 0x81, 0x94, 0x24, 0xe8, 0x5a, 0x94, 0x9d,
    0x94, 0x61, 0x17, 0xce, 0x40, 0x4a, 0x87, 0xfb, 0xbb, 0x5b, 0x5f, 0x20, 0x43, 0xc4, 0x65, 0x4a,
    0xb3, 0xf3, 0x5e, 0xe0, 0x80, 0x5a, 0x10, 0x26, 0xde, 0x5d, 0x6d, 0x95, 0x3d, 0xb5, 0x24, 0xb8,
    0xb4, 0xc6, 0xd3, 0x2a, 0x55, 0x5c, 0xce, 0x44, 0xbf, 0xdb, 0xf3, 0x2c, 0xa0, 0x55, 0xac, 0x0e,
    0x70, 0xb3, 0x74, 0xec, 0x0f, 0x85, 0x85, 0xe8, 0x12, 0x57, 0x9c, 0xf7, 0x2f, 0x57, 0x63, 0xfc,
    0x05, 0x15, 0xe6, 0xc2, 0x4f, 0x65, 0x79, 0xe9, 0xb4, 0xb8, 0x7a, 0x7a, 0xbd, 0xdb, 0x63, 0xeb,
    0xe9, 0x6a, 0xd4, 0xad, 0x55, 0xfd, 0x80, 0xfc, 0x48, 0xe6, 0x32, 0xd1, 0xc9, 0xf9, 0x50, 0x15,
    0xe6, 0x21, 0x52, 0x8e, 0x76, 0x74, 0x9c, 0xa2, 0xce, 0xc7, 0x31, 0xa1, 0x1d, 0xe3, 0xbc, 0xe8,
    0xe9, 0x5a, 0x98, 0xaa, 0xf0, 0x82, 0x21, 0x28, 0xdb, 0xdc, 0xf9, 0x07, 0x3d, 0x87, 0x6f, 0x6e,
    0x09, 0xae, 0xd7, 0x6d, 0x18, 0x2d, 0x5b, 0xab, 0xd7, 0x00, 0xe2, 0x73, 0xda, 0x83, 0xeb, 0x94,
    0xa1, 0x25, 0xc3, 0xf7, 0xad, 0xfb, 0x0f, 0xa1, 0x36, 0x43, 0x68
};
#endif

PyTypeObject *init_Bookmarks(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX].type;

    Shiboken::AutoDecRef Sbk_Bookmarks_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_Bookmarks_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Bookmarks",
        "Bookmarks*",
        &Sbk_Bookmarks_spec,
        &Shiboken::callCppDestructor< Bookmarks >,
        Sbk_Bookmarks_Type_bases.object(),
        0);
    auto *pyType = _Sbk_Bookmarks_Type; // references _Sbk_Bookmarks_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, Bookmarks_SignatureStrings);
#else
    InitSignatureBytes(pyType, Bookmarks_SignatureBytes, Bookmarks_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_Bookmarks_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Bookmarks_PythonToCpp_Bookmarks_PTR,
        is_Bookmarks_PythonToCpp_Bookmarks_PTR_Convertible,
        Bookmarks_PTR_CppToPython_Bookmarks);

    Shiboken::Conversions::registerConverterName(converter, "Bookmarks");
    Shiboken::Conversions::registerConverterName(converter, "Bookmarks*");
    Shiboken::Conversions::registerConverterName(converter, "Bookmarks&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Bookmarks).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(BookmarksWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_Bookmarks_TypeF(), &Sbk_Bookmarks_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::Bookmarks::staticMetaObject);
    BookmarksWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::Bookmarks::staticMetaObject, sizeof(BookmarksWrapper));

    return pyType;
}
