/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_header_format_crc = R"doc(Header formatter that includes the payload length, packet number, and a CRC check on the header.

Child class of header_format_base. This version's header format looks like:



Instead of duplicating the payload length, we only add it once and use the CRC8 to make sure it's correctly received.





Reimplements packet_header_default in the style of the header_format_base.

Constructor Specific Documentation:

Factory to create an async packet header formatter; returns an sptr to the object.

Args:
    len_key_name : 
    num_key_name : )doc";


static const char* __doc_gr_digital_header_format_crc_header_format_crc_0 = R"doc()doc";


static const char* __doc_gr_digital_header_format_crc_header_format_crc_1 = R"doc()doc";


static const char* __doc_gr_digital_header_format_crc_set_header_num = R"doc()doc";


static const char* __doc_gr_digital_header_format_crc_format = R"doc(Encodes the header information in the given tags into bits and places them into .

Uses the following header format:)doc";


static const char* __doc_gr_digital_header_format_crc_parse = R"doc(Parses a header. This function is overloaded in the child class, which knows how to convert the incoming hard bits (0's and 1's) back into a packet header.



MUST be overloaded.)doc";


static const char* __doc_gr_digital_header_format_crc_header_nbits = R"doc(Returns the length of the formatted header in bits.)doc";


static const char* __doc_gr_digital_header_format_crc_make = R"doc(Header formatter that includes the payload length, packet number, and a CRC check on the header.

Child class of header_format_base. This version's header format looks like:



Instead of duplicating the payload length, we only add it once and use the CRC8 to make sure it's correctly received.





Reimplements packet_header_default in the style of the header_format_base.

Constructor Specific Documentation:

Factory to create an async packet header formatter; returns an sptr to the object.

Args:
    len_key_name : 
    num_key_name : )doc";
