// ClientServer wrapper for vtkOSPRayRendererNode object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkOSPRayRendererNode.h"
#include "vtkSystemIncludes.h"
#include "vtkStdString.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkOSPRayRendererNodeClientServerNewCommand(void* /*ctx*/)
{
  return vtkOSPRayRendererNode::New();
}


static int vtkOSPRayRendererNodeCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkOSPRayRendererNode *op = vtkOSPRayRendererNode::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkOSPRayRendererNode.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkOSPRayRendererNode  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkOSPRayRendererNode::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkOSPRayRendererNode  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkOSPRayRendererNode::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkOSPRayRendererNode  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkOSPRayRendererNode::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("Build",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->Build(temp0);
      return 1;
      }
    }
  if (!strcmp("Render",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->Render(temp0);
      return 1;
      }
    }
  if (!strcmp("Invalidate",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->Invalidate(temp0);
      return 1;
      }
    }
  if (!strcmp("WriteLayer",method) && msg.GetNumberOfArguments(0) == 7)
    {
    vtkClientServerStreamDataArg<unsigned char   > temp0(msg, 0, 2);
    vtkClientServerStreamDataArg<float  > temp1(msg, 0, 3);
    int      temp2;
    int      temp3;
    int      temp4;
    if(temp0 &&
      temp1 &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      msg.GetArgument(0, 6, &temp4))
      {
      op->WriteLayer(temp0,temp1,temp2,temp3,temp4);
      return 1;
      }
    }
  if (!strcmp("SAMPLES_PER_PIXEL",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::SAMPLES_PER_PIXEL();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetSamplesPerPixel",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetSamplesPerPixel(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetSamplesPerPixel",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetSamplesPerPixel(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("MAX_CONTRIBUTION",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationDoubleKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::MAX_CONTRIBUTION();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetMaxContribution",method) && msg.GetNumberOfArguments(0) == 4)
    {
    double   temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetMaxContribution(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetMaxContribution",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetMaxContribution(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("MAX_DEPTH",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::MAX_DEPTH();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetMaxDepth",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetMaxDepth(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetMaxDepth",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetMaxDepth(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("MIN_CONTRIBUTION",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationDoubleKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::MIN_CONTRIBUTION();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetMinContribution",method) && msg.GetNumberOfArguments(0) == 4)
    {
    double   temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetMinContribution(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetMinContribution",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetMinContribution(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ROULETTE_DEPTH",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::ROULETTE_DEPTH();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetRouletteDepth",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetRouletteDepth(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetRouletteDepth",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetRouletteDepth(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("VARIANCE_THRESHOLD",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationDoubleKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::VARIANCE_THRESHOLD();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetVarianceThreshold",method) && msg.GetNumberOfArguments(0) == 4)
    {
    double   temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetVarianceThreshold(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetVarianceThreshold",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetVarianceThreshold(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("MAX_FRAMES",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::MAX_FRAMES();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetMaxFrames",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetMaxFrames(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetMaxFrames",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetMaxFrames(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RENDERER_TYPE",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationStringKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::RENDERER_TYPE();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetRendererType",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *  temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetRendererType(static_cast<std::string>(vtkStdString(temp0)),temp1);
      return 1;
      }
    }
  if (!strcmp("GetRendererType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    std::string   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetRendererType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AMBIENT_SAMPLES",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::AMBIENT_SAMPLES();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAmbientSamples",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetAmbientSamples(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetAmbientSamples",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetAmbientSamples(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("VOLUME_SAMPLING_RATE",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationDoubleKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::VOLUME_SAMPLING_RATE();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetVolumeSamplingRate",method) && msg.GetNumberOfArguments(0) == 4)
    {
    double   temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetVolumeSamplingRate(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetVolumeSamplingRate",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetVolumeSamplingRate(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("COMPOSITE_ON_GL",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::COMPOSITE_ON_GL();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetCompositeOnGL",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetCompositeOnGL(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetCompositeOnGL",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetCompositeOnGL(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NORTH_POLE",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationDoubleVectorKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::NORTH_POLE();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetNorthPole",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkClientServerStreamDataArg<double > temp0(msg, 0, 2);
    vtkRenderer  *temp1;
    if(temp0 &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetNorthPole(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("EAST_POLE",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationDoubleVectorKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::EAST_POLE();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetEastPole",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkClientServerStreamDataArg<double > temp0(msg, 0, 2);
    vtkRenderer  *temp1;
    if(temp0 &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetEastPole(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("MATERIAL_LIBRARY",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationObjectBaseKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::MATERIAL_LIBRARY();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetMaterialLibrary",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkOSPRayMaterialLibrary  *temp0;
    vtkRenderer  *temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkOSPRayMaterialLibrary") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetMaterialLibrary(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetMaterialLibrary",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    vtkOSPRayMaterialLibrary  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetMaterialLibrary(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("VIEW_TIME",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationDoubleKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::VIEW_TIME();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetViewTime",method) && msg.GetNumberOfArguments(0) == 4)
    {
    double   temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetViewTime(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetViewTime",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetViewTime(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TIME_CACHE_SIZE",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::TIME_CACHE_SIZE();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetTimeCacheSize",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetTimeCacheSize(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetTimeCacheSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetTimeCacheSize(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetColorBufferTextureGL",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetColorBufferTextureGL();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetDepthBufferTextureGL",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetDepthBufferTextureGL();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("Traverse",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->Traverse(temp0);
      return 1;
      }
    }
  if (!strcmp("GetRendererNode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkViewNode  *temp0;
    vtkOSPRayRendererNode  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkViewNode"))
      {
      temp20 = vtkOSPRayRendererNode::GetRendererNode(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetRenderer",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkRenderer  *temp20;
      {
      temp20 = (op)->GetRenderer();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("DENOISER_THRESHOLD",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::DENOISER_THRESHOLD();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetDenoiserThreshold",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetDenoiserThreshold(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetDenoiserThreshold",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetDenoiserThreshold(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ENABLE_DENOISER",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::ENABLE_DENOISER();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetEnableDenoiser",method) && msg.GetNumberOfArguments(0) == 4)
    {
    int      temp0;
    vtkRenderer  *temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkRenderer"))
      {
      vtkOSPRayRendererNode::SetEnableDenoiser(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetEnableDenoiser",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkRenderer  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkRenderer"))
      {
      temp20 = vtkOSPRayRendererNode::GetEnableDenoiser(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("BACKGROUND_MODE",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInformationIntegerKey  *temp20;
      {
      temp20 = vtkOSPRayRendererNode::BACKGROUND_MODE();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }

  {
    const char* commandName = "vtkRendererNode";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkOSPRayRendererNode, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkOSPRayRendererNode_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkOSPRayRendererNode", vtkOSPRayRendererNodeClientServerNewCommand);
    csi->AddCommandFunction("vtkOSPRayRendererNode", vtkOSPRayRendererNodeCommand);
    }
}
}
