// python wrapper for ttkCinemaDarkroomColorMapping
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkCinemaDarkroomColorMapping.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkCinemaDarkroomColorMapping(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkCinemaDarkroomColorMapping_ClassNew(); }

#ifndef DECLARED_PyttkCinemaDarkroomShader_ClassNew
extern "C" { PyObject *PyttkCinemaDarkroomShader_ClassNew(); }
#define DECLARED_PyttkCinemaDarkroomShader_ClassNew
#endif

static PyObject *
PyttkCinemaDarkroomColorMapping_SetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetValueRange(temp0, temp1);
    }
    else
    {
      op->ttkCinemaDarkroomColorMapping::SetValueRange(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaDarkroomColorMapping_SetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetValueRange(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomColorMapping::SetValueRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaDarkroomColorMapping_SetValueRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyttkCinemaDarkroomColorMapping_SetValueRange_s1(self, args);
    case 1:
      return PyttkCinemaDarkroomColorMapping_SetValueRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetValueRange");
  return nullptr;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_GetValueRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->ttkCinemaDarkroomColorMapping::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_SetColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColorMap(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomColorMapping::SetColorMap(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_GetColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetColorMap() :
      op->ttkCinemaDarkroomColorMapping::GetColorMap());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_SetManualColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetManualColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetManualColorMap(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomColorMapping::SetManualColorMap(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_GetManualColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetManualColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetManualColorMap() :
      op->ttkCinemaDarkroomColorMapping::GetManualColorMap());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_SetNANColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNANColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetNANColor(temp0, temp1, temp2);
    }
    else
    {
      op->ttkCinemaDarkroomColorMapping::SetNANColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaDarkroomColorMapping_SetNANColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNANColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetNANColor(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomColorMapping::SetNANColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaDarkroomColorMapping_SetNANColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyttkCinemaDarkroomColorMapping_SetNANColor_s1(self, args);
    case 1:
      return PyttkCinemaDarkroomColorMapping_SetNANColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetNANColor");
  return nullptr;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_GetNANColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNANColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetNANColor() :
      op->ttkCinemaDarkroomColorMapping::GetNANColor());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_SetSingleColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSingleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSingleColor(temp0, temp1, temp2);
    }
    else
    {
      op->ttkCinemaDarkroomColorMapping::SetSingleColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaDarkroomColorMapping_SetSingleColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSingleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSingleColor(temp0);
    }
    else
    {
      op->ttkCinemaDarkroomColorMapping::SetSingleColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaDarkroomColorMapping_SetSingleColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyttkCinemaDarkroomColorMapping_SetSingleColor_s1(self, args);
    case 1:
      return PyttkCinemaDarkroomColorMapping_SetSingleColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSingleColor");
  return nullptr;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_GetSingleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSingleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetSingleColor() :
      op->ttkCinemaDarkroomColorMapping::GetSingleColor());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkCinemaDarkroomColorMapping::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkCinemaDarkroomColorMapping::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkCinemaDarkroomColorMapping *tempr = ttkCinemaDarkroomColorMapping::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkCinemaDarkroomColorMapping *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkCinemaDarkroomColorMapping::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkCinemaDarkroomColorMapping::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaDarkroomColorMapping_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaDarkroomColorMapping *op = static_cast<ttkCinemaDarkroomColorMapping *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkCinemaDarkroomColorMapping::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkCinemaDarkroomColorMapping_Methods[] = {
  {"SetValueRange", PyttkCinemaDarkroomColorMapping_SetValueRange, METH_VARARGS,
   "SetValueRange(self, _arg1:float, _arg2:float) -> None\nC++: virtual void SetValueRange(double _arg1, double _arg2)\nSetValueRange(self, _arg:(float, float)) -> None\nC++: void SetValueRange(const double _arg[2])\n\n"},
  {"GetValueRange", PyttkCinemaDarkroomColorMapping_GetValueRange, METH_VARARGS,
   "GetValueRange(self) -> (float, float)\nC++: virtual double *GetValueRange()\n\n"},
  {"SetColorMap", PyttkCinemaDarkroomColorMapping_SetColorMap, METH_VARARGS,
   "SetColorMap(self, _arg:int) -> None\nC++: virtual void SetColorMap(int _arg)\n\n"},
  {"GetColorMap", PyttkCinemaDarkroomColorMapping_GetColorMap, METH_VARARGS,
   "GetColorMap(self) -> int\nC++: virtual int GetColorMap()\n\n"},
  {"SetManualColorMap", PyttkCinemaDarkroomColorMapping_SetManualColorMap, METH_VARARGS,
   "SetManualColorMap(self, _arg:str) -> None\nC++: virtual void SetManualColorMap(const std::string &_arg)\n\n"},
  {"GetManualColorMap", PyttkCinemaDarkroomColorMapping_GetManualColorMap, METH_VARARGS,
   "GetManualColorMap(self) -> str\nC++: virtual std::string GetManualColorMap()\n\n"},
  {"SetNANColor", PyttkCinemaDarkroomColorMapping_SetNANColor, METH_VARARGS,
   "SetNANColor(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetNANColor(double _arg1, double _arg2,\n    double _arg3)\nSetNANColor(self, _arg:(float, float, float)) -> None\nC++: virtual void SetNANColor(const double _arg[3])\n\n"},
  {"GetNANColor", PyttkCinemaDarkroomColorMapping_GetNANColor, METH_VARARGS,
   "GetNANColor(self) -> (float, float, float)\nC++: virtual double *GetNANColor()\n\n"},
  {"SetSingleColor", PyttkCinemaDarkroomColorMapping_SetSingleColor, METH_VARARGS,
   "SetSingleColor(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetSingleColor(double _arg1, double _arg2,\n    double _arg3)\nSetSingleColor(self, _arg:(float, float, float)) -> None\nC++: virtual void SetSingleColor(const double _arg[3])\n\n"},
  {"GetSingleColor", PyttkCinemaDarkroomColorMapping_GetSingleColor, METH_VARARGS,
   "GetSingleColor(self) -> (float, float, float)\nC++: virtual double *GetSingleColor()\n\n"},
  {"IsTypeOf", PyttkCinemaDarkroomColorMapping_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkCinemaDarkroomColorMapping_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkCinemaDarkroomColorMapping_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkCinemaDarkroomColorMapping\nC++: static ttkCinemaDarkroomColorMapping *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkCinemaDarkroomColorMapping_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkCinemaDarkroomColorMapping\nC++: ttkCinemaDarkroomColorMapping *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkCinemaDarkroomColorMapping_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkCinemaDarkroomColorMapping_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkCinemaDarkroomColorMapping_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomColorMapping_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomColorMapping_SetValueRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomColorMapping_SetValueRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetValueRange/SetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color_map"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomColorMapping_GetColorMap(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomColorMapping_SetColorMap(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomColorMapping_SetColorMap(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetColorMap/SetColorMap\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("manual_color_map"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomColorMapping_GetManualColorMap(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomColorMapping_SetManualColorMap(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomColorMapping_SetManualColorMap(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetManualColorMap/SetManualColorMap\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("nan_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomColorMapping_GetNANColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomColorMapping_SetNANColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomColorMapping_SetNANColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNANColor/SetNANColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("single_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaDarkroomColorMapping_GetSingleColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaDarkroomColorMapping_SetSingleColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaDarkroomColorMapping_SetSingleColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSingleColor/SetSingleColor\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkCinemaDarkroomColorMapping_Doc =
  "ttkCinemaDarkroomColorMapping - \\ingroup vtk\n\n"
  "Superclass: ttkCinemaDarkroomShader\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 01.11.2020\n\n"
  "Performs color mapping of a scalar field.\n\n"
  "\\param Input vtkImageData.\n"
  "\\param Output vtkImageData.\n\n"
  "This class maps each value of a scalar point data array to either a\n"
  "solid color, a predefined color map, or a manually defined color map.\n\n"
  "Related Publication: \"Cinema Database Specification - Dietrich Release\n"
  "v1.2\". D. Rogers, J. Woodring, J. Ahrens, J. Patchett, and J.\n"
  "Lukasczyk. Technical Report LA-UR-17-25072, Los Alamos National\n"
  "Laboratory, 2018.\n\n"
  "\\sa ttkCinemaDarkroomShader\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkCinemaDarkroomColorMapping_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkCinemaDarkroom.ttkCinemaDarkroomColorMapping", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkCinemaDarkroomColorMapping_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkCinemaDarkroomColorMapping_StaticNew()
{
  return ttkCinemaDarkroomColorMapping::New();
}

PyObject *PyttkCinemaDarkroomColorMapping_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkCinemaDarkroomColorMapping_Type, PyttkCinemaDarkroomColorMapping_Methods,
    "ttkCinemaDarkroomColorMapping",
 &PyttkCinemaDarkroomColorMapping_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyttkCinemaDarkroomShader_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkCinemaDarkroomColorMapping_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkCinemaDarkroomColorMapping(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkCinemaDarkroomColorMapping_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkCinemaDarkroomColorMapping", o) != 0)
  {
    Py_DECREF(o);
  }

}

