/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypeProviderWithCustomContext;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PyDocSignaturesHighlighterKt;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PyTypeRenderer;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationQuickInfoProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDocumentationProvider
implements DocumentationProvider {
    public static final String DOCUMENTATION_CONFIGURABLE_ID = "com.jetbrains.python.documentation.PythonDocumentationConfigurable";
    private static final int RETURN_TYPE_WRAPPING_THRESHOLD = 80;

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, @NotNull PsiElement originalElement) {
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(0);
        }
        PsiElement referenceElement = originalElement.getParent();
        for (PythonDocumentationQuickInfoProvider point : (PythonDocumentationQuickInfoProvider[])PythonDocumentationQuickInfoProvider.EP_NAME.getExtensions()) {
            String info = point.getQuickInfo(referenceElement);
            if (info == null) continue;
            return info;
        }
        TypeEvalContext context = TypeEvalContext.userInitiated((Project)referenceElement.getProject(), (PsiFile)referenceElement.getContainingFile());
        if (element instanceof PyFunction) {
            String clsName;
            PyFunction function = (PyFunction)element;
            HtmlBuilder result = new HtmlBuilder();
            PyClass cls = function.getContainingClass();
            if (cls != null && (clsName = cls.getName()) != null) {
                result.append(PyDocSignaturesHighlighterKt.styledSpan(PyPsiBundle.message("QDOC.class", new Object[0]), PyHighlighter.PY_KEYWORD));
                result.nbsp();
                result.append(PyDocSignaturesHighlighterKt.styledSpan(clsName, PyHighlighter.PY_CLASS_DEFINITION));
                result.br();
            }
            return result.append(PythonDocumentationProvider.describeDecorators((PyDecoratable)function, HtmlChunk.text((String)", "))).append(PythonDocumentationProvider.describeFunction(function, context, true)).toString();
        }
        if (element instanceof PyClass) {
            PyClass cls = (PyClass)element;
            HtmlBuilder result = new HtmlBuilder();
            return result.append(PythonDocumentationProvider.describeDecorators((PyDecoratable)cls, HtmlChunk.text((String)", "))).append(PythonDocumentationProvider.describeClass(cls, context)).toString();
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            return PyPsiBundle.message("QDOC.directory.name", directory.getName());
        }
        if (element instanceof PsiFile) {
            PsiFile file = (PsiFile)element;
            return PyPsiBundle.message("QDOC.file.name", file.getName());
        }
        if (element instanceof PyExpression) {
            return PythonDocumentationProvider.describeExpression((PyExpression)element, referenceElement, context);
        }
        if (element instanceof PyTypeParameter) {
            PyTypeParameter typeParameter = (PyTypeParameter)element;
            return PyPsiBundle.message("QDOC.type.parameter.name", PythonDocumentationProvider.describeTypeParameter(typeParameter, true, context));
        }
        if (element instanceof PyTypeAliasStatement) {
            PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)element;
            return PythonDocumentationProvider.describeTypeAlias(typeAliasStatement, context).toString();
        }
        return null;
    }

    @NotNull
    static HtmlChunk describeFunction(@NotNull PyFunction function, @NotNull TypeEvalContext context, boolean forTooltip) {
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(2);
        }
        HtmlChunk htmlChunk = HtmlChunk.raw((String)PythonDocumentationProvider.describeFunctionWithTypes(function, context, forTooltip));
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(3);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeTarget(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        if (target == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(5);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(PyDocSignaturesHighlighterKt.styledSpan(StringUtil.notNullize((String)target.getName()), DefaultLanguageHighlighterColors.IDENTIFIER));
        result.append(PyDocSignaturesHighlighterKt.styledSpan(": ", PyHighlighter.PY_OPERATION_SIGN));
        result.append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(context.getType((PyTypedElement)target), (PyTypedElement)target, (PsiElement)target, context), PyHighlighter.PY_ANNOTATION));
        PyExpression value = target.findAssignedValue();
        if (value != null) {
            result.append(PyDocSignaturesHighlighterKt.styledSpan(" = ", PyHighlighter.PY_OPERATION_SIGN));
            String initializerText = value.getText();
            int index = value.getText().indexOf("\n");
            if (index < 0) {
                result.append(PyDocSignaturesHighlighterKt.highlightExpressionText(initializerText, value));
            } else {
                result.append(PyDocSignaturesHighlighterKt.highlightExpressionText(initializerText.substring(0, index), value));
                result.append(PyDocSignaturesHighlighterKt.styledSpan("...", PyHighlighter.PY_DOT));
            }
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(6);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeParameter(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        if (parameter == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(8);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(PyDocSignaturesHighlighterKt.styledSpan(StringUtil.notNullize((String)parameter.getName()), PyDocSignaturesHighlighterKt.paramNameTextAttribute(parameter.isSelf())));
        result.append(PyDocSignaturesHighlighterKt.styledSpan(": ", PyHighlighter.PY_OPERATION_SIGN));
        result.append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(context.getType((PyTypedElement)parameter), (PyTypedElement)parameter, (PsiElement)parameter, context), PyHighlighter.PY_ANNOTATION));
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(9);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeTypeParameter(@NotNull PyTypeParameter typeParameter, boolean showKind, @NotNull TypeEvalContext context) {
        if (typeParameter == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(11);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(PyDocSignaturesHighlighterKt.styledSpan(StringUtil.notNullize((String)typeParameter.getName()), PyHighlighter.PY_TYPE_PARAMETER));
        PyExpression boundExpression = typeParameter.getBoundExpression();
        if (boundExpression != null && typeParameter.getBoundExpressionText() != null) {
            result.append(PyDocSignaturesHighlighterKt.styledSpan(": ", PyHighlighter.PY_OPERATION_SIGN));
            result.append(PyDocSignaturesHighlighterKt.highlightExpressionText(typeParameter.getBoundExpressionText(), typeParameter.getBoundExpression()));
        }
        if (showKind) {
            result.append(", ").append(PyPsiBundle.message("QDOC.type.parameter.kind", new Object[0])).append(" ").append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(context.getType((PyTypedElement)typeParameter), (PyTypedElement)typeParameter, (PsiElement)typeParameter, context), PyHighlighter.PY_ANNOTATION));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(12);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeTypeAlias(@NotNull PyTypeAliasStatement typeAliasStatement, @NotNull TypeEvalContext context) {
        PyExpression typeExpression;
        if (typeAliasStatement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(14);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(PyDocSignaturesHighlighterKt.styledSpan("type ", PyHighlighter.PY_KEYWORD));
        result.append(PyDocSignaturesHighlighterKt.styledSpan(StringUtil.notNullize((String)typeAliasStatement.getName()), DefaultLanguageHighlighterColors.IDENTIFIER));
        if (typeAliasStatement.getTypeParameterList() != null) {
            List typeParameters = typeAliasStatement.getTypeParameterList().getTypeParameters();
            result.append(PyDocSignaturesHighlighterKt.styledSpan("[", PyHighlighter.PY_BRACKETS));
            result.append((HtmlChunk)StreamEx.of((Collection)typeParameters).map(typeParameter -> PythonDocumentationProvider.describeTypeParameter(typeParameter, false, context)).collect(HtmlChunk.toFragment((HtmlChunk)PyDocSignaturesHighlighterKt.styledSpan(", ", PyHighlighter.PY_COMMA))));
            result.append(PyDocSignaturesHighlighterKt.styledSpan("]", PyHighlighter.PY_BRACKETS));
        }
        if ((typeExpression = typeAliasStatement.getTypeExpression()) != null) {
            result.append(PyDocSignaturesHighlighterKt.styledSpan(" = ", PyHighlighter.PY_OPERATION_SIGN));
            result.append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(context.getType((PyTypedElement)typeExpression), (PyTypedElement)typeExpression, (PsiElement)typeAliasStatement, context), PyHighlighter.PY_ANNOTATION));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(15);
        }
        return htmlChunk;
    }

    @NlsSafe
    @NotNull
    private static String describeFunctionWithTypes(@NotNull PyFunction function, @NotNull TypeEvalContext context, boolean forTooltip) {
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(17);
        }
        StringBuilder result = new StringBuilder();
        int firstParamOffset = 0;
        if (function.isAsync()) {
            result.append(PyDocSignaturesHighlighterKt.styledSpan("async ", PyHighlighter.PY_KEYWORD));
            firstParamOffset += "async ".length();
        }
        result.append(PyDocSignaturesHighlighterKt.styledSpan("def ", PyHighlighter.PY_KEYWORD));
        firstParamOffset += "def ".length();
        String funcName = StringUtil.notNullize((String)function.getName(), (String)"<unnamed>");
        firstParamOffset += funcName.length();
        result.append(PyDocSignaturesHighlighterKt.styledSpan(funcName, PyDocSignaturesHighlighterKt.functionNameTextAttribute(function, funcName)));
        result.append(PyDocSignaturesHighlighterKt.styledSpan("(", PyHighlighter.PY_PARENTHS));
        ++firstParamOffset;
        int lastLineOffset = 0;
        boolean first = true;
        boolean firstIsSelf = false;
        List parameters = function.getParameters(context);
        for (PyCallableParameter parameter : parameters) {
            String delimiter;
            String[] parts;
            String signature;
            boolean isSelf = parameter.isSelf();
            if (!first) {
                result.append(PyDocSignaturesHighlighterKt.styledSpan(",", PyHighlighter.PY_COMMA));
                if (forTooltip || firstIsSelf && parameters.size() == 2) {
                    result.append(" ");
                } else {
                    result.append("\n");
                    lastLineOffset = result.length();
                    StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)firstParamOffset);
                }
            } else {
                firstIsSelf = isSelf;
            }
            Object paramName = parameter.getName();
            PyType paramType = parameter.getType(context);
            PyNamedParameter named = PyUtil.as(parameter.getParameter(), PyNamedParameter.class);
            boolean showType = true;
            if (parameter.isPositionalContainer()) {
                paramName = "*" + StringUtil.notNullize((String)paramName, (String)"args");
                PyTupleType tupleType = PyUtil.as(paramType, PyTupleType.class);
                if (tupleType != null) {
                    paramType = tupleType.getIteratedItemType();
                }
            } else if (parameter.isKeywordContainer()) {
                paramName = "**" + StringUtil.notNullize((String)paramName, (String)"kwargs");
                PyCollectionType genericType = PyUtil.as(paramType, PyCollectionType.class);
                if (genericType != null && genericType.getPyClass() == PyBuiltinCache.getInstance((PsiElement)function).getClass("dict")) {
                    List<PyType> typeParams = genericType.getElementTypes();
                    paramType = typeParams.size() == 2 ? typeParams.get(1) : null;
                }
            } else if (parameter.getParameter() instanceof PySlashParameter) {
                paramName = "/";
                showType = false;
            } else if (parameter.getParameter() instanceof PySingleStarParameter) {
                paramName = "*";
                showType = false;
            } else {
                paramName = StringUtil.notNullize((String)paramName, (String)"<unnamed>");
                showType = !isSelf || named != null && ((PyTypeProviderWithCustomContext)new PyTypingTypeProvider()).getParameterType(named, function, context) != null;
            }
            result.append(PyDocSignaturesHighlighterKt.styledSpan((String)paramName, PyDocSignaturesHighlighterKt.paramNameTextAttribute(isSelf)));
            if (showType) {
                result.append(PyDocSignaturesHighlighterKt.styledSpan(": ", PyHighlighter.PY_OPERATION_SIGN)).append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(paramType, (PyTypedElement)named, (PsiElement)function, context), PyHighlighter.PY_ANNOTATION));
            }
            if ((signature = ParamHelper.getDefaultValuePartInSignature(parameter.getDefaultValueText(), showType)) != null && (parts = signature.split(delimiter = showType ? " = " : "=")).length == 2) {
                result.append(PyDocSignaturesHighlighterKt.styledSpan(delimiter, PyHighlighter.PY_OPERATION_SIGN));
                result.append(PyDocSignaturesHighlighterKt.highlightExpressionText(parts[1], parameter.getDefaultValue()));
            }
            first = false;
        }
        result.append(PyDocSignaturesHighlighterKt.styledSpan(")", PyHighlighter.PY_PARENTHS));
        if (!forTooltip && StringUtil.stripHtml((String)result.substring(lastLineOffset), (boolean)false).length() > 80) {
            result.append("\n ");
        }
        PyType returnType = context.getReturnType((PyCallable)function);
        result.append(HtmlChunk.text((String)" -> "));
        result.append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(returnType, (PyTypedElement)function, (PsiElement)function, context), PyHighlighter.PY_ANNOTATION));
        String string = result.toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    @Nls
    private static String describeExpression(@NotNull PyExpression expression, @NotNull PsiElement originalElement, @NotNull TypeEvalContext context) {
        String name;
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(19);
        }
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(21);
        }
        if ((name = expression.getName()) != null) {
            HtmlBuilder result = new HtmlBuilder();
            if (expression instanceof PyNamedParameter) {
                PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class);
                if (function != null) {
                    String functionName = function.getName();
                    if (function.getContainingClass() == null) {
                        result.append(PyPsiBundle.message("QDOC.parameter.of.function.name", name, functionName));
                    } else {
                        result.append(PyPsiBundle.message("QDOC.parameter.of.method.name", name, functionName));
                    }
                } else {
                    result.append(PyPsiBundle.message("QDOC.parameter.name", name));
                }
            } else {
                result.append(PyPsiBundle.message("QDOC.variable.name", name));
            }
            if (originalElement instanceof PyTypedElement) {
                PyTypedElement typedElement = (PyTypedElement)originalElement;
                PyType type = context.getType(typedElement);
                HtmlChunk formattedType = PythonDocumentationProvider.formatTypeWithLinks(type, typedElement, (PsiElement)typedElement, context);
                result.br().appendRaw(PyPsiBundle.message("QDOC.inferred.type.name", formattedType));
            }
            return result.toString();
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public static String getTypeName(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(22);
        }
        String string = ((HtmlChunk)PyTypeVisitor.visit((PyType)type, (PyTypeVisitor)new PyTypeRenderer.Documentation(context, EnumSet.noneOf(PyTypeRenderer.Feature.class)))).toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(23);
        }
        return string;
    }

    @ApiStatus.Experimental
    @NotNull
    @NlsSafe
    public static String getTypeName(@Nullable PyType type, @NotNull TypeEvalContext context, PyTypeRenderer.Feature ... features) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (features == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(25);
        }
        String string = ((HtmlChunk)PyTypeVisitor.visit((PyType)type, (PyTypeVisitor)new PyTypeRenderer.Documentation(context, EnumSet.copyOf(Arrays.asList(features))))).toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getTypeHint(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(27);
        }
        String string = ((HtmlChunk)PyTypeVisitor.visit((PyType)type, (PyTypeVisitor)new PyTypeRenderer.TypeHint(context, EnumSet.noneOf(PyTypeRenderer.Feature.class)))).toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(28);
        }
        return string;
    }

    @ApiStatus.Experimental
    @NotNull
    public static String getFullyQualifiedTypeHint(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(29);
        }
        String string = ((HtmlChunk)PyTypeVisitor.visit((PyType)type, (PyTypeVisitor)new PyTypeRenderer.TypeHint(context, EnumSet.of(PyTypeRenderer.Feature.USE_FQN)))).toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String getVerboseTypeName(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(31);
        }
        return PythonDocumentationProvider.getTypeName(type, context, PyTypeRenderer.Feature.TYPE_VAR_BOUNDS);
    }

    private static void describeTypeWithLinks(@Nullable PyType type, @Nullable PyTypedElement typeOwner, @NotNull TypeEvalContext context, @NotNull PsiElement anchor, @NotNull HtmlBuilder body) {
        PyAssignmentStatement assignment;
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(32);
        }
        if (anchor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(33);
        }
        if (body == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(34);
        }
        if (typeOwner instanceof PyTargetExpression && type == null && (assignment = PyUtil.as(typeOwner.getParent(), PyAssignmentStatement.class)) != null && PyTypingTypeProvider.isExplicitTypeAlias(assignment, context)) {
            body.append(PyDocSignaturesHighlighterKt.styledSpan("TypeAlias", PyHighlighter.PY_ANNOTATION));
            return;
        }
        body.append((HtmlChunk)PyTypeVisitor.visit((PyType)type, (PyTypeVisitor)new PyTypeRenderer.RichDocumentation(context, anchor)));
    }

    @NotNull
    static HtmlChunk describeDecorators(@NotNull PyDecoratable decoratable, @NotNull HtmlChunk separator) {
        if (decoratable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(35);
        }
        if (separator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(36);
        }
        HtmlBuilder result = new HtmlBuilder();
        PyDecoratorList decoratorList = decoratable.getDecoratorList();
        if (decoratorList != null) {
            boolean first = true;
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                if (!first) {
                    result.append(separator);
                }
                result.appendRaw(PythonDocumentationProvider.describeDecorator(decorator).toString());
                first = false;
            }
        }
        if (!result.isEmpty()) {
            result.br();
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(37);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeClass(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(38);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(39);
        }
        HtmlBuilder result = new HtmlBuilder();
        @NlsSafe String name = StringUtil.notNullize((String)cls.getName(), (String)"<unnamed>");
        result.append(PyDocSignaturesHighlighterKt.styledSpan("class ", PyHighlighter.PY_KEYWORD));
        result.append(PyDocSignaturesHighlighterKt.styledSpan(name, PyHighlighter.PY_CLASS_DEFINITION));
        PyExpression[] superClasses = cls.getSuperClassExpressions();
        if (superClasses.length > 0) {
            result.append(PyDocSignaturesHighlighterKt.styledSpan("(", PyHighlighter.PY_PARENTHS));
            boolean isNotFirst = false;
            for (PyExpression superClass : superClasses) {
                if (isNotFirst) {
                    result.append(PyDocSignaturesHighlighterKt.styledSpan(", ", PyHighlighter.PY_COMMA));
                } else {
                    isNotFirst = true;
                }
                result.append(PythonDocumentationProvider.describeSuperClass(superClass, context));
            }
            result.append(PyDocSignaturesHighlighterKt.styledSpan(")", PyHighlighter.PY_PARENTHS));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(40);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk describeSuperClass(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        PyCallExpression callExpression;
        PyExpression callee;
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(42);
        }
        @NlsSafe String expressionText = expression.getText();
        if (expression instanceof PyReferenceExpression) {
            PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
            if (!referenceExpression.isQualified()) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
                for (ResolveResult result : referenceExpression.getReference(resolveContext).multiResolve(false)) {
                    PyClass pyClass;
                    PsiElement psiElement = result.getElement();
                    if (!(psiElement instanceof PyClass) || (pyClass = (PyClass)psiElement).getQualifiedName() == null) continue;
                    HtmlChunk htmlChunk = PyDocSignaturesHighlighterKt.styledReference(PyDocumentationLink.toClass(pyClass, expressionText), (PsiElement)pyClass);
                    if (htmlChunk == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(43);
                    }
                    return htmlChunk;
                }
            }
        } else if (expression instanceof PySubscriptionExpression) {
            PyExpression operand = ((PySubscriptionExpression)expression).getOperand();
            PyExpression indexExpression = ((PySubscriptionExpression)expression).getIndexExpression();
            if (indexExpression != null) {
                HtmlChunk htmlChunk = new HtmlBuilder().append(PythonDocumentationProvider.describeSuperClass(operand, context)).append(PyDocSignaturesHighlighterKt.styledSpan("[", PyHighlighter.PY_BRACKETS)).append(PythonDocumentationProvider.describeSuperClass(indexExpression, context)).append(PyDocSignaturesHighlighterKt.styledSpan("]", PyHighlighter.PY_BRACKETS)).toFragment();
                if (htmlChunk == null) {
                    PythonDocumentationProvider.$$$reportNull$$$0(44);
                }
                return htmlChunk;
            }
        } else if (expression instanceof PyKeywordArgument) {
            String keyword = ((PyKeywordArgument)expression).getKeyword();
            PyExpression valueExpression = ((PyKeywordArgument)expression).getValueExpression();
            if ("metaclass".equals(keyword) && valueExpression != null) {
                HtmlChunk htmlChunk = new HtmlBuilder().append(PyDocSignaturesHighlighterKt.styledSpan("metaclass", PyHighlighter.PY_KEYWORD_ARGUMENT)).append(PyDocSignaturesHighlighterKt.styledSpan("=", PyHighlighter.PY_OPERATION_SIGN)).append(PythonDocumentationProvider.describeSuperClass(valueExpression, context)).toFragment();
                if (htmlChunk == null) {
                    PythonDocumentationProvider.$$$reportNull$$$0(45);
                }
                return htmlChunk;
            }
        } else if (PyClassImpl.isSixWithMetaclassCall(expression) && (callee = (callExpression = (PyCallExpression)expression).getCallee()) != null) {
            HtmlChunk htmlChunk = new HtmlBuilder().append(PyDocSignaturesHighlighterKt.styledSpan(callee.getText(), DefaultLanguageHighlighterColors.IDENTIFIER)).append(PyDocSignaturesHighlighterKt.styledSpan("(", PyHighlighter.PY_PARENTHS)).append((HtmlChunk)StreamEx.of((Object[])callExpression.getArguments()).map(argument -> PythonDocumentationProvider.describeSuperClass(argument, context)).collect(HtmlChunk.toFragment((HtmlChunk)PyDocSignaturesHighlighterKt.styledSpan(", ", PyHighlighter.PY_COMMA)))).append(PyDocSignaturesHighlighterKt.styledSpan(")", PyHighlighter.PY_PARENTHS)).toFragment();
            if (htmlChunk == null) {
                PythonDocumentationProvider.$$$reportNull$$$0(46);
            }
            return htmlChunk;
        }
        HtmlChunk htmlChunk = HtmlChunk.text((String)expressionText);
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(47);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk describeDecorator(@NotNull PyDecorator decorator) {
        if (decorator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(48);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(PyDocSignaturesHighlighterKt.styledSpan("@" + PyUtil.getReadableRepr((PsiElement)decorator.getCallee(), false), PyHighlighter.PY_DECORATOR));
        PyArgumentList argumentList = decorator.getArgumentList();
        if (argumentList != null) {
            result.append(PyDocSignaturesHighlighterKt.styledSpan("(", PyHighlighter.PY_PARENTHS));
            Object[] argumentsExpressions = argumentList.getArguments();
            HtmlChunk styledArgumentsList = (HtmlChunk)StreamEx.of((Object[])argumentsExpressions).map(argExpression -> {
                if (!(argExpression instanceof PyKeywordArgument)) {
                    return PyDocSignaturesHighlighterKt.highlightExpressionText(argExpression.getText(), argExpression);
                }
                PyKeywordArgument keywordArg = (PyKeywordArgument)argExpression;
                String argName = argExpression.getName();
                if (argName == null) {
                    return null;
                }
                PyExpression argValueExpression = keywordArg.getValueExpression();
                if (argValueExpression == null) {
                    return null;
                }
                return new HtmlBuilder().append(PyDocSignaturesHighlighterKt.styledSpan(argName, PyHighlighter.PY_KEYWORD_ARGUMENT)).append(PyDocSignaturesHighlighterKt.styledSpan("=", PyHighlighter.PY_OPERATION_SIGN)).append(PyDocSignaturesHighlighterKt.highlightExpressionText(argValueExpression.getText(), argValueExpression)).toFragment();
            }).nonNull().collect(HtmlChunk.toFragment((HtmlChunk)PyDocSignaturesHighlighterKt.styledSpan(", ", PyHighlighter.PY_COMMA)));
            result.append(styledArgumentsList);
            result.append(PyDocSignaturesHighlighterKt.styledSpan(")", PyHighlighter.PY_PARENTHS));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(49);
        }
        return htmlChunk;
    }

    @Nls
    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        PythonRuntimeService runtimeService;
        if (element == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(50);
        }
        if ((runtimeService = PythonRuntimeService.getInstance()).isInPydevConsole(element) || originalElement != null && runtimeService.isInPydevConsole(originalElement)) {
            return runtimeService.createPydevDoc(element, originalElement);
        }
        return new PyDocumentationBuilder(element, originalElement).build();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, @NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(51);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(52);
        }
        return PyDocumentationLink.elementForLink(link, context, TypeEvalContext.userInitiated((Project)context.getProject(), (PsiFile)context.getContainingFile()));
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String url = PythonDocumentationProvider.getOnlyUrlFor(element, originalElement);
        return url == null ? null : Collections.singletonList(url);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(53);
        }
        if (file == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(54);
        }
        if (contextElement != null) {
            PyDocStringOwner docstringOwner;
            PsiReference reference;
            PyExpression callee;
            PyExpression expression;
            IElementType elementType = contextElement.getNode().getElementType();
            if (PythonDialectsTokenSetProvider.getInstance().getKeywordTokens().contains(elementType)) {
                return contextElement;
            }
            PsiElement parent = contextElement.getParent();
            if (parent instanceof PyArgumentList && (PyTokenTypes.LPAR == elementType || PyTokenTypes.RPAR == elementType) && (expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyCallExpression.class)) != null && (callee = expression.getCallee()) != null && (reference = callee.getReference()) != null) {
                return reference.resolve();
            }
            expression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyExpression.class);
            if (expression != null && DocStringUtil.isDocStringExpression(expression) && (docstringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyDocStringOwner.class)) != null) {
                return docstringOwner;
            }
        }
        return null;
    }

    @NotNull
    private static HtmlChunk formatTypeWithLinks(@Nullable PyType type, @Nullable PyTypedElement typeOwner, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        if (anchor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(55);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(56);
        }
        HtmlBuilder builder = new HtmlBuilder();
        PythonDocumentationProvider.describeTypeWithLinks(type, typeOwner, context, anchor, builder);
        HtmlChunk htmlChunk = builder.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(57);
        }
        return htmlChunk;
    }

    @Nullable
    public static QualifiedName getFullQualifiedName(@Nullable PsiElement element) {
        String name;
        String string = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : (name = element != null ? element.getText() : null);
        if (name != null) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(element);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(element);
            if (owner instanceof PyClass) {
                QualifiedName importQName = QualifiedNameFinder.findCanonicalImportPath(element, element);
                if (importQName != null) {
                    return QualifiedName.fromDottedString((String)(String.valueOf(importQName) + "." + owner.getName() + "." + name));
                }
            } else if (PyUtil.isInitOrNewMethod((PsiElement)owner)) {
                QualifiedName importQName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)owner, element);
                PyClass containingClass = ((PyFunction)owner).getContainingClass();
                if (importQName != null && containingClass != null) {
                    return QualifiedName.fromDottedString((String)(String.valueOf(importQName) + "." + containingClass.getName() + "." + name));
                }
            } else if (owner instanceof PyFile) {
                QualifiedName fileQName;
                if (builtinCache.isBuiltin(element)) {
                    return QualifiedName.fromDottedString((String)name);
                }
                VirtualFile virtualFile = ((PyFile)owner).getVirtualFile();
                if (virtualFile != null && (fileQName = QualifiedNameFinder.findCanonicalImportPath(element, element)) != null) {
                    return QualifiedName.fromDottedString((String)(String.valueOf(fileQName) + "." + name));
                }
            } else if (element instanceof PyFile) {
                return QualifiedNameFinder.findCanonicalImportPath(element, element);
            }
        }
        return null;
    }

    @Nullable
    protected static PsiFileSystemItem getFile(PsiElement element) {
        PsiFileSystemItem file = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        return (PsiFileSystemItem)PyUtil.turnInitIntoDir((PsiElement)file);
    }

    @Nullable
    public static PsiNamedElement getNamedElement(@Nullable PsiElement element) {
        Object namedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
        PyClass containingClass = PyUtil.turnConstructorIntoClass(PyUtil.as(namedElement, PyFunction.class));
        namedElement = containingClass != null ? containingClass : (PsiNamedElement)PyUtil.turnInitIntoDir((PsiElement)namedElement);
        return namedElement;
    }

    @Nullable
    public static String getOnlyUrlFor(PsiElement element, PsiElement originalElement) {
        PsiFileSystemItem file = PythonDocumentationProvider.getFile(element);
        if (file == null) {
            return null;
        }
        Sdk sdk = PyBuiltinCache.findSdkForFile(file);
        if (sdk == null) {
            return null;
        }
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, originalElement);
        if (qName == null) {
            return null;
        }
        PythonDocumentationMap map = PythonDocumentationMap.getInstance();
        String pyVersion = PythonDocumentationProvider.pyVersion(sdk.getVersionString());
        PsiNamedElement namedElement = PythonDocumentationProvider.getNamedElement(element);
        String url = map.urlFor(qName, namedElement, pyVersion);
        if (url != null) {
            return url;
        }
        for (PythonDocumentationLinkProvider provider : PythonDocumentationLinkProvider.EP_NAME.getExtensionList()) {
            String providerUrl = provider.getExternalDocumentationUrl(element, originalElement);
            if (providerUrl == null) continue;
            return providerUrl;
        }
        return null;
    }

    @Nullable
    public static String pyVersion(@Nullable String versionString) {
        String version;
        int dot;
        String prefix = "Python ";
        if (versionString != null && versionString.startsWith("Python ") && (dot = (version = versionString.substring("Python ".length())).indexOf(46)) > 0) {
            if ((dot = version.indexOf(46, dot + 1)) > 0) {
                return version.substring(0, dot);
            }
            return version;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9, 12, 15, 18, 23, 26, 28, 30, 37, 40, 43, 44, 45, 46, 47, 49, 57 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 39: 
            case 42: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAliasStatement";
                break;
            }
            case 19: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 33: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTarget";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "describeParameter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTypeParameter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTypeAlias";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunctionWithTypes";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHint";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyQualifiedTypeHint";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorators";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "describeClass";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "describeSuperClass";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorator";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeWithLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "describeFunction";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 57: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "describeTarget";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "describeParameter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeParameter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeAlias";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "describeFunctionWithTypes";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "describeExpression";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFullyQualifiedTypeHint";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getVerboseTypeName";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeWithLinks";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorators";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "describeClass";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "describeSuperClass";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorator";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeWithLinks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 9, 12, 15, 18, 23, 26, 28, 30, 37, 40, 43, 44, 45, 46, 47, 49, 57 -> new IllegalStateException(string);
        };
    }
}

