/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyNamesKt;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.validation.PyAnnotationHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyParameterListAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    public PyParameterListAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyParameterListAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitPyParameterList(@NotNull PyParameterList paramlist) {
        if (paramlist == null) {
            PyParameterListAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        final LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)paramlist);
        ParamHelper.walkDownParamArray(paramlist.getParameters(), new ParamHelper.ParamVisitor(){
            final Set<String> parameterNames = new HashSet<String>();
            boolean hadPositionalContainer = false;
            boolean hadKeywordContainer = false;
            boolean hadDefaultValue = false;
            boolean hadKeyword = false;
            boolean hadSlash = false;
            boolean hadSingleStar = false;
            boolean hadParamsAfterSingleStar = false;
            int inTuple = 0;

            @Override
            public void visitNamedParameter(PyNamedParameter parameter, boolean first, boolean last) {
                String name = parameter.getName();
                if (!(this.hadKeyword || name == null || parameter.isSelf() || PyNamesKt.isPrivate((String)name))) {
                    this.hadKeyword = true;
                } else if (this.hadKeyword && !this.hadPositionalContainer && !this.hadSingleStar && name != null && !this.hadSlash && PyNamesKt.isPrivate((String)name)) {
                    PyParameterListAnnotatorVisitor.this.myHolder.newAnnotation(HighlightSeverity.WARNING, PyPsiBundle.message("ANN.positional.only.param.after.keyword", new Object[0])).range((PsiElement)parameter).create();
                }
                if (this.parameterNames.contains(parameter.getName())) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.duplicate.param.name", new Object[0]));
                }
                this.parameterNames.add(parameter.getName());
                if (parameter.isPositionalContainer()) {
                    if (this.hadKeywordContainer) {
                        PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.starred.param.after.kwparam", new Object[0]));
                    }
                    if (this.hadSingleStar) {
                        PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.multiple.args", new Object[0]));
                    }
                    if (this.hadPositionalContainer) {
                        PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.multiple.args", new Object[0]));
                    }
                    this.hadPositionalContainer = true;
                } else if (parameter.isKeywordContainer()) {
                    if (this.hadKeywordContainer) {
                        PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.multiple.kwargs", new Object[0]));
                    }
                    this.hadKeywordContainer = true;
                    if (this.hadSingleStar && !this.hadParamsAfterSingleStar) {
                        PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.named.parameters.after.star", new Object[0]));
                    }
                } else {
                    if (this.hadSingleStar) {
                        this.hadParamsAfterSingleStar = true;
                    }
                    if (this.hadPositionalContainer && languageLevel.isPython2()) {
                        PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.regular.param.after.vararg", new Object[0]));
                    } else if (this.hadKeywordContainer) {
                        PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.regular.param.after.keyword", new Object[0]));
                    }
                    if (parameter.hasDefaultValue()) {
                        this.hadDefaultValue = true;
                    } else if (this.hadDefaultValue && !this.hadSingleStar && (languageLevel.isPython2() || !this.hadPositionalContainer) && this.inTuple == 0) {
                        PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)parameter, PyPsiBundle.message("ANN.non.default.param.after.default", new Object[0]));
                    }
                }
            }

            @Override
            public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                ++this.inTuple;
                if (languageLevel.isPy3K()) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)param, PyPsiBundle.message("ANN.tuple.py3", new Object[0]));
                } else if (!param.hasDefaultValue() && this.hadDefaultValue) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)param, PyPsiBundle.message("ANN.non.default.param.after.default", new Object[0]));
                }
            }

            @Override
            public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                --this.inTuple;
            }

            @Override
            public void visitSlashParameter(@NotNull PySlashParameter param, boolean first, boolean last) {
                if (param == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.hadSlash) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)param, PyPsiBundle.message("ANN.multiple.slash", new Object[0]));
                }
                this.hadSlash = true;
                if (this.hadPositionalContainer) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)param, PyPsiBundle.message("ANN.slash.param.after.vararg", new Object[0]));
                } else if (this.hadKeywordContainer) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)param, PyPsiBundle.message("ANN.slash.param.after.keyword", new Object[0]));
                }
                if (first) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)param, PyPsiBundle.message("ANN.named.parameters.before.slash", new Object[0]));
                }
            }

            @Override
            public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
                if (this.hadPositionalContainer || this.hadSingleStar) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)param, PyPsiBundle.message("ANN.multiple.args", new Object[0]));
                }
                this.hadSingleStar = true;
                if (last) {
                    PyParameterListAnnotatorVisitor.this.myHolder.markError((PsiElement)param, PyPsiBundle.message("ANN.named.parameters.after.star", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/jetbrains/python/validation/PyParameterListAnnotatorVisitor$1", "visitSlashParameter"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramlist";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyParameterListAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyParameterList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

