
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in TopoShapePyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of TopoShapePy
PyTypeObject TopoShapePy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.TopoShape",     /*tp_name*/
    sizeof(TopoShapePy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "TopoShape is the OpenCasCade topological shape wrapper.\n"
    "Sub-elements such as vertices, edges or faces are accessible as:\n"
    "* Vertex#, where # is in range(1, number of vertices)\n"
    "* Edge#, where # is in range(1, number of edges)\n"
    "* Face#, where # is in range(1, number of faces)",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::TopoShapePy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::TopoShapePy::GetterSetter,                     /*tp_getset */
    &Data::ComplexGeoDataPy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::TopoShapePy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of TopoShapePy
PyMethodDef TopoShapePy::Methods[] = {
    {"dumps",
        reinterpret_cast<PyCFunction>( staticCallback_dumps ),
        METH_VARARGS,
        "Serialize the content of this shape to a string in BREP format."
    },
    {"loads",
        reinterpret_cast<PyCFunction>( staticCallback_loads ),
        METH_VARARGS,
        "Deserialize the content of this shape from a string in BREP format."
    },
    {"read",
        reinterpret_cast<PyCFunction>( staticCallback_read ),
        METH_VARARGS,
        "Read in an IGES, STEP or BREP file.\n"
        "read(filename)"
    },
    {"writeInventor",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_writeInventor )),
        METH_VARARGS|METH_KEYWORDS,
        "Write the mesh in OpenInventor format to a string.\n"
        "writeInventor() -> string"
    },
    {"exportIges",
        reinterpret_cast<PyCFunction>( staticCallback_exportIges ),
        METH_VARARGS,
        "Export the content of this shape to an IGES file.\n"
        "exportIges(filename)"
    },
    {"exportStep",
        reinterpret_cast<PyCFunction>( staticCallback_exportStep ),
        METH_VARARGS,
        "Export the content of this shape to an STEP file.\n"
        "exportStep(filename)"
    },
    {"exportBrep",
        reinterpret_cast<PyCFunction>( staticCallback_exportBrep ),
        METH_VARARGS,
        "Export the content of this shape to an BREP file.\n"
        "exportBrep(filename)\n"
        "--\n"
        "BREP is an OpenCasCade native format."
    },
    {"exportBinary",
        reinterpret_cast<PyCFunction>( staticCallback_exportBinary ),
        METH_VARARGS,
        "Export the content of this shape in binary format to a file.\n"
        "exportBinary(filename)"
    },
    {"exportBrepToString",
        reinterpret_cast<PyCFunction>( staticCallback_exportBrepToString ),
        METH_VARARGS,
        "Export the content of this shape to a string in BREP format.\n"
        "exportBrepToString() -> string\n"
        "--\n"
        "BREP is an OpenCasCade native format."
    },
    {"dumpToString",
        reinterpret_cast<PyCFunction>( staticCallback_dumpToString ),
        METH_VARARGS,
        "Dump information about the shape to a string.\n"
        "dumpToString() -> string"
    },
    {"exportStl",
        reinterpret_cast<PyCFunction>( staticCallback_exportStl ),
        METH_VARARGS,
        "Export the content of this shape to an STL mesh file.\n"
        "exportStl(filename)"
    },
    {"importBrep",
        reinterpret_cast<PyCFunction>( staticCallback_importBrep ),
        METH_VARARGS,
        "Load the shape from a file in BREP format.\n"
        "importBrep(filename)"
    },
    {"importBinary",
        reinterpret_cast<PyCFunction>( staticCallback_importBinary ),
        METH_VARARGS,
        "Import the content to this shape of a string in BREP format.\n"
        "importBinary(filename)"
    },
    {"importBrepFromString",
        reinterpret_cast<PyCFunction>( staticCallback_importBrepFromString ),
        METH_VARARGS,
        "Load the shape from a string that keeps the content in BREP format.\n"
        "importBrepFromString(string, [displayProgressBar=True])\n"
        "--\n"
        "importBrepFromString(str,False) to not display a progress bar."
    },
    {"extrude",
        reinterpret_cast<PyCFunction>( staticCallback_extrude ),
        METH_VARARGS,
        "Extrude the shape along a vector.\n"
        "extrude(vector) -> Shape\n"
        "--\n"
        "Shp2 = Shp1.extrude(App.Vector(0,0,10)) - extrude the shape 10 mm in the +Z direction."
    },
    {"revolve",
        reinterpret_cast<PyCFunction>( staticCallback_revolve ),
        METH_VARARGS,
        "Revolve the shape around an Axis to a given degree.\n"
        "revolve(base, direction, angle)\n"
        "--\n"
        "Part.revolve(App.Vector(0,0,0),App.Vector(0,0,1),360) - revolves the shape around the Z Axis 360 degree.\n"
        "\n"
        "Hints: Sometimes you want to create a rotation body out of a closed edge or wire.\n"
        "Example:\n"
        "from FreeCAD import Base\n"
        "import Part\n"
        "V=Base.Vector\n"
        "\n"
        "e=Part.Ellipse()\n"
        "s=e.toShape()\n"
        "r=s.revolve(V(0,0,0),V(0,1,0), 360)\n"
        "Part.show(r)\n"
        "\n"
        "However, you may possibly realize some rendering artifacts or that the mesh\n"
        "creation seems to hang. This is because this way the surface is created twice.\n"
        "Since the curve is a full ellipse it is sufficient to do a rotation of 180 degree\n"
        "only, i.e. r=s.revolve(V(0,0,0),V(0,1,0), 180)\n"
        "\n"
        "Now when rendering this object you may still see some artifacts at the poles. Now the\n"
        "problem seems to be that the meshing algorithm doesn't like to rotate around a point\n"
        "where there is no vertex.\n"
        "\n"
        "The idea to fix this issue is that you create only half of the ellipse so that its shape\n"
        "representation has vertexes at its start and end point.\n"
        "\n"
        "from FreeCAD import Base\n"
        "import Part\n"
        "V=Base.Vector\n"
        "\n"
        "e=Part.Ellipse()\n"
        "s=e.toShape(e.LastParameter/4,3*e.LastParameter/4)\n"
        "r=s.revolve(V(0,0,0),V(0,1,0), 360)\n"
        "Part.show(r)"
    },
    {"check",
        reinterpret_cast<PyCFunction>( staticCallback_check ),
        METH_VARARGS,
        "Checks the shape and report errors in the shape structure.\n"
        "check([runBopCheck = False])\n"
        "--\n"
        "This is a more detailed check as done in isValid().\n"
        "if runBopCheck is True, a BOPCheck analysis is also performed."
    },
    {"fuse",
        reinterpret_cast<PyCFunction>( staticCallback_fuse ),
        METH_VARARGS,
        "Union of this and a given (list of) topo shape.\n"
        "fuse(tool) -> Shape\n"
        "  or\n"
        "fuse((tool1,tool2,...),[tolerance=0.0]) -> Shape\n"
        "--\n"
        "Union of this and a given list of topo shapes.\n"
        "\n"
        "Supports (OCCT 6.9.0 and above):\n"
        "- Fuzzy Boolean operations (global tolerance for a Boolean operation)\n"
        "- Support of multiple arguments for a single Boolean operation\n"
        "- Parallelization of Boolean Operations algorithm\n"
        "\n"
        "Beginning from OCCT 6.8.1 a tolerance value can be specified."
    },
    {"multiFuse",
        reinterpret_cast<PyCFunction>( staticCallback_multiFuse ),
        METH_VARARGS,
        "Union of this and a given list of topo shapes.\n"
        "multiFuse((tool1,tool2,...),[tolerance=0.0]) -> Shape\n"
        "--\n"
        "Supports (OCCT 6.9.0 and above):\n"
        "- Fuzzy Boolean operations (global tolerance for a Boolean operation)\n"
        "- Support of multiple arguments for a single Boolean operation\n"
        "- Parallelization of Boolean Operations algorithm\n"
        "\n"
        "Beginning from OCCT 6.8.1 a tolerance value can be specified.\n"
        "Deprecated: use fuse() instead."
    },
    {"oldFuse",
        reinterpret_cast<PyCFunction>( staticCallback_oldFuse ),
        METH_VARARGS,
        "Union of this and a given topo shape (old algorithm).\n"
        "oldFuse(tool) -> Shape"
    },
    {"common",
        reinterpret_cast<PyCFunction>( staticCallback_common ),
        METH_VARARGS,
        "Intersection of this and a given (list of) topo shape.\n"
        "common(tool) -> Shape\n"
        "  or\n"
        "common((tool1,tool2,...),[tolerance=0.0]) -> Shape\n"
        "--\n"
        "Supports:\n"
        "- Fuzzy Boolean operations (global tolerance for a Boolean operation)\n"
        "- Support of multiple arguments for a single Boolean operation (s1 AND (s2 OR s3))\n"
        "- Parallelization of Boolean Operations algorithm\n"
        "\n"
        "OCC 6.9.0 or later is required."
    },
    {"section",
        reinterpret_cast<PyCFunction>( staticCallback_section ),
        METH_VARARGS,
        "Section of this with a given (list of) topo shape.\n"
        "section(tool,[approximation=False]) -> Shape\n"
        "  or\n"
        "section((tool1,tool2,...),[tolerance=0.0, approximation=False]) -> Shape\n"
        "--\n"
        "If approximation is True, section edges are approximated to a C1-continuous BSpline curve.\n"
        "\n"
        "Supports:\n"
        "- Fuzzy Boolean operations (global tolerance for a Boolean operation)\n"
        "- Support of multiple arguments for a single Boolean operation (s1 AND (s2 OR s3))\n"
        "- Parallelization of Boolean Operations algorithm\n"
        "\n"
        "OCC 6.9.0 or later is required."
    },
    {"slices",
        reinterpret_cast<PyCFunction>( staticCallback_slices ),
        METH_VARARGS,
        "Make slices of this shape.\n"
        "slices(direction, distancesList) --> Wires"
    },
    {"slice",
        reinterpret_cast<PyCFunction>( staticCallback_slice ),
        METH_VARARGS,
        "Make single slice of this shape.\n"
        "slice(direction, distance) --> Wires"
    },
    {"cut",
        reinterpret_cast<PyCFunction>( staticCallback_cut ),
        METH_VARARGS,
        "Difference of this and a given (list of) topo shape\n"
        "cut(tool) -> Shape\n"
        "  or\n"
        "cut((tool1,tool2,...),[tolerance=0.0]) -> Shape\n"
        "--\n"
        "Supports:\n"
        "- Fuzzy Boolean operations (global tolerance for a Boolean operation)\n"
        "- Support of multiple arguments for a single Boolean operation\n"
        "- Parallelization of Boolean Operations algorithm\n"
        "\n"
        "OCC 6.9.0 or later is required."
    },
    {"generalFuse",
        reinterpret_cast<PyCFunction>( staticCallback_generalFuse ),
        METH_VARARGS,
        "Run general fuse algorithm (GFA) between this and given shapes.\n"
        "generalFuse(list_of_other_shapes, [fuzzy_value = 0.0]) -> (result, map)\n"
        "--\n"
        "list_of_other_shapes: shapes to run the algorithm against (the list is\n"
        "effectively prepended by 'self').\n"
        "\n"
        "fuzzy_value: extra tolerance to apply when searching for interferences, in\n"
        "addition to tolerances of the input shapes.\n"
        "\n"
        "Returns a tuple of 2: (result, map).\n"
        "\n"
        "result is a compound containing all the pieces generated by the algorithm\n"
        "(e.g., for two spheres, the pieces are three touching solids). Pieces that\n"
        "touch share elements.\n"
        "\n"
        "map is a list of lists of shapes, providing the info on which children of\n"
        "result came from which argument. The length of list is equal to length of\n"
        "list_of_other_shapes + 1. First element is a list of pieces that came from\n"
        "shape of this, and the rest are those that come from corresponding shapes in\n"
        "list_of_other_shapes.\n"
        "hint: use isSame method to test shape equality\n"
        "\n"
        "Parallelization of Boolean Operations algorithm\n"
        "\n"
        "OCC 6.9.0 or later is required."
    },
    {"sewShape",
        reinterpret_cast<PyCFunction>( staticCallback_sewShape ),
        METH_VARARGS,
        "Sew the shape if there is a gap.\n"
        "sewShape()"
    },
    {"childShapes",
        reinterpret_cast<PyCFunction>( staticCallback_childShapes ),
        METH_VARARGS,
        "Return a list of sub-shapes that are direct children of this shape.\n"
        "childShapes([cumOri=True, cumLoc=True]) -> list\n"
        "--\n"
        " * If cumOri is true, the function composes all\n"
        "   sub-shapes with the orientation of this shape.\n"
        " * If cumLoc is true, the function multiplies all\n"
        "   sub-shapes by the location of this shape, i.e. it applies to\n"
        "   each sub-shape the transformation that is associated with this shape."
    },
    {"ancestorsOfType",
        reinterpret_cast<PyCFunction>( staticCallback_ancestorsOfType ),
        METH_VARARGS,
        "For a sub-shape of this shape get its ancestors of a type.\n"
        "ancestorsOfType(shape, shape type) -> list"
    },
    {"removeInternalWires",
        reinterpret_cast<PyCFunction>( staticCallback_removeInternalWires ),
        METH_VARARGS,
        "Removes internal wires (also holes) from the shape.\n"
        "removeInternalWires(minimalArea) -> bool"
    },
    {"mirror",
        reinterpret_cast<PyCFunction>( staticCallback_mirror ),
        METH_VARARGS,
        "Mirror this shape on a given plane.\n"
        "mirror(base, norm) -> Shape\n"
        "--\n"
        "The plane is given with its base point and its normal direction."
    },
    {"transformGeometry",
        reinterpret_cast<PyCFunction>( staticCallback_transformGeometry ),
        METH_VARARGS,
        "Apply geometric transformation on this or a copy the shape.\n"
        "transformGeometry(matrix) -> Shape\n"
        "--\n"
        "This method returns a new shape.\n"
        "The transformation to be applied is defined as a 4x4 matrix.\n"
        "The underlying geometry of the following shapes may change:\n"
        "- a curve which supports an edge of the shape, or\n"
        "- a surface which supports a face of the shape;\n"
        "\n"
        "For example, a circle may be transformed into an ellipse when\n"
        "applying an affinity transformation. It may also happen that\n"
        "the circle then is represented as a B-spline curve.\n"
        "\n"
        "The transformation is applied to:\n"
        "- all the curves which support edges of the shape, and\n"
        "- all the surfaces which support faces of the shape.\n"
        "\n"
        "Note: If you want to transform a shape without changing the\n"
        "underlying geometry then use the methods translate or rotate."
    },
    {"transformShape",
        reinterpret_cast<PyCFunction>( staticCallback_transformShape ),
        METH_VARARGS,
        "Apply transformation on a shape without changing the underlying geometry.\n"
        "transformShape(Matrix,[boolean copy=False, checkScale=False]) -> None\n"
        "--\n"
        "If checkScale is True, it will use transformGeometry if non-uniform\n"
        "scaling is detected."
    },
    {"transformed",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_transformed )),
        METH_VARARGS|METH_KEYWORDS,
        "Create a new transformed shape\n"
        "transformed(Matrix,copy=False,checkScale=False,op=None) -> shape"
    },
    {"translate",
        reinterpret_cast<PyCFunction>( staticCallback_translate ),
        METH_VARARGS,
        "Apply the translation to the current location of this shape.\n"
        "translate(vector)"
    },
    {"translated",
        reinterpret_cast<PyCFunction>( staticCallback_translated ),
        METH_VARARGS,
        "Create a new shape with translation\n"
        "translated(vector) -> shape"
    },
    {"rotate",
        reinterpret_cast<PyCFunction>( staticCallback_rotate ),
        METH_VARARGS,
        "Apply the rotation (base,dir,degree) to the current location of this shape\n"
        "rotate(base,dir,degree)\n"
        "--\n"
        "Shp.rotate(App.Vector(0,0,0),App.Vector(0,0,1),180) - rotate the shape around the Z Axis 180 degrees."
    },
    {"rotated",
        reinterpret_cast<PyCFunction>( staticCallback_rotated ),
        METH_VARARGS,
        "Create a new shape with rotation.\n"
        "rotated(base,dir,degree) -> shape"
    },
    {"scale",
        reinterpret_cast<PyCFunction>( staticCallback_scale ),
        METH_VARARGS,
        "Apply scaling with point and factor to this shape.\n"
        "scale(factor,[base=App.Vector(0,0,0)])"
    },
    {"scaled",
        reinterpret_cast<PyCFunction>( staticCallback_scaled ),
        METH_VARARGS,
        "Create a new shape with scale.\n"
        "scaled(factor,[base=App.Vector(0,0,0)]) -> shape"
    },
    {"makeFillet",
        reinterpret_cast<PyCFunction>( staticCallback_makeFillet ),
        METH_VARARGS,
        "Make fillet.\n"
        "makeFillet(radius,edgeList) -> Shape\n"
        "or\n"
        "makeFillet(radius1,radius2,edgeList) -> Shape"
    },
    {"makeChamfer",
        reinterpret_cast<PyCFunction>( staticCallback_makeChamfer ),
        METH_VARARGS,
        "Make chamfer.\n"
        "makeChamfer(radius,edgeList) -> Shape\n"
        "or\n"
        "makeChamfer(radius1,radius2,edgeList) -> Shape"
    },
    {"makeThickness",
        reinterpret_cast<PyCFunction>( staticCallback_makeThickness ),
        METH_VARARGS,
        "Hollow a solid according to given thickness and faces.\n"
        "makeThickness(List of faces, Offset (Float), Tolerance (Float)) -> Shape\n"
        "--\n"
        "A hollowed solid is built from an initial solid and a set of faces on this solid,\n"
        "which are to be removed. The remaining faces of the solid become the walls of\n"
        "the hollowed solid, their thickness defined at the time of construction."
    },
    {"makeOffsetShape",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_makeOffsetShape )),
        METH_VARARGS|METH_KEYWORDS,
        "makes an offset shape (3d offsetting).\n"
        "makeOffsetShape(offset, tolerance, [inter = False, self_inter = False,\n"
        "offsetMode = 0, join = 0, fill = False]) -> Shape\n"
        "--\n"
        "The function supports keyword arguments.\n"
        "\n"
        "* offset: distance to expand the shape by. Negative value will shrink the\n"
        "shape.\n"
        "\n"
        "* tolerance: precision of approximation.\n"
        "\n"
        "* inter: (parameter to OCC routine; not implemented)\n"
        "\n"
        "* self_inter: (parameter to OCC routine; not implemented)\n"
        "\n"
        "* offsetMode: 0 = skin; 1 = pipe; 2 = recto-verso\n"
        "\n"
        "* join: method of offsetting non-tangent joints. 0 = arcs, 1 = tangent, 2 =\n"
        "intersection\n"
        "\n"
        "* fill: if true, offsetting a shell is to yield a solid\n"
        "\n"
        "Returns: result of offsetting."
    },
    {"makeOffset2D",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_makeOffset2D )),
        METH_VARARGS|METH_KEYWORDS,
        "makes an offset shape (2d offsetting).\n"
        "makeOffset2D(offset, [join = 0, fill = False, openResult = false, intersection =\n"
        "false]) -> Shape\n"
        "--\n"
        "The function supports keyword\n"
        "arguments. Input shape (self) can be edge, wire, face, or a compound of those.\n"
        "\n"
        "* offset: distance to expand the shape by. Negative value will shrink the\n"
        "shape.\n"
        "\n"
        "* join: method of offsetting non-tangent joints. 0 = arcs, 1 = tangent, 2 =\n"
        "intersection\n"
        "\n"
        "* fill: if true, the output is a face filling the space covered by offset. If\n"
        "false, the output is a wire.\n"
        "\n"
        "* openResult: affects the way open wires are processed. If False, an open wire\n"
        "is made. If True, a closed wire is made from a double-sided offset, with rounds\n"
        "around open vertices.\n"
        "\n"
        "* intersection: affects the way compounds are processed. If False, all children\n"
        "are offset independently. If True, and children are edges/wires, the children\n"
        "are offset in a collective manner. If compounding is nested, collectiveness\n"
        "does not spread across compounds (only direct children of a compound are taken\n"
        "collectively).\n"
        "\n"
        "Returns: result of offsetting (wire or face or compound of those). Compounding\n"
        "structure follows that of source shape."
    },
    {"makeEvolved",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_makeEvolved )),
        METH_VARARGS|METH_KEYWORDS,
        "Profile along the spine"
    },
    {"makeWires",
        reinterpret_cast<PyCFunction>( staticCallback_makeWires ),
        METH_VARARGS,
        "make wire(s) using the edges of this shape\n"
        "makeWires([op=None])\n"
        "--\n"
        "The function will sort any edges inside the current shape, and connect them\n"
        "into wire. If more than one wire is found, then it will make a compound out of\n"
        "all found wires.\n"
        "\n"
        "This function is element mapping aware. If the input shape has non-zero Tag,\n"
        "it will map any edge and vertex element name inside the input shape into the\n"
        "itself.\n"
        "\n"
        "op: an optional string to be appended when auto generates element mapping."
    },
    {"reverse",
        reinterpret_cast<PyCFunction>( staticCallback_reverse ),
        METH_VARARGS,
        "Reverses the orientation of this shape.\n"
        "reverse()"
    },
    {"reversed",
        reinterpret_cast<PyCFunction>( staticCallback_reversed ),
        METH_VARARGS,
        "Reverses the orientation of a copy of this shape.\n"
        "reversed() -> Shape"
    },
    {"complement",
        reinterpret_cast<PyCFunction>( staticCallback_complement ),
        METH_VARARGS,
        "Computes the complement of the orientation of this shape,\n"
        "i.e. reverses the interior/exterior status of boundaries of this shape.\n"
        "complement()"
    },
    {"nullify",
        reinterpret_cast<PyCFunction>( staticCallback_nullify ),
        METH_VARARGS,
        "Destroys the reference to the underlying shape stored in this shape.\n"
        "As a result, this shape becomes null.\n"
        "nullify()"
    },
    {"isClosed",
        reinterpret_cast<PyCFunction>( staticCallback_isClosed ),
        METH_VARARGS,
        "Checks if the shape is closed.\n"
        "isClosed() -> bool\n"
        "--\n"
        "If the shape is a shell it returns True if it has no free boundaries (edges).\n"
        "If the shape is a wire it returns True if it has no free ends (vertices).\n"
        "(Internal and External sub-shepes are ignored in these checks)\n"
        "If the shape is an edge it returns True if its vertices are the same."
    },
    {"isPartner",
        reinterpret_cast<PyCFunction>( staticCallback_isPartner ),
        METH_VARARGS,
        "Checks if both shapes share the same geometry.\n"
        "Placement and orientation may differ.\n"
        "isPartner(shape) -> bool"
    },
    {"isSame",
        reinterpret_cast<PyCFunction>( staticCallback_isSame ),
        METH_VARARGS,
        "Checks if both shapes share the same geometry\n"
        "        and placement. Orientation may differ.\n"
        "isSame(shape) -> bool"
    },
    {"isEqual",
        reinterpret_cast<PyCFunction>( staticCallback_isEqual ),
        METH_VARARGS,
        "Checks if both shapes are equal.\n"
        "        This means geometry, placement and orientation are equal.\n"
        "isEqual(shape) -> bool"
    },
    {"isNull",
        reinterpret_cast<PyCFunction>( staticCallback_isNull ),
        METH_VARARGS,
        "Checks if the shape is null.\n"
        "isNull() -> bool"
    },
    {"isValid",
        reinterpret_cast<PyCFunction>( staticCallback_isValid ),
        METH_VARARGS,
        "Checks if the shape is valid, i.e. neither null, nor empty nor corrupted.\n"
        "isValid() -> bool"
    },
    {"isCoplanar",
        reinterpret_cast<PyCFunction>( staticCallback_isCoplanar ),
        METH_VARARGS,
        "Checks if this shape is coplanar with the given shape.\n"
        "isCoplanar(shape,tol=None) -> bool"
    },
    {"isInfinite",
        reinterpret_cast<PyCFunction>( staticCallback_isInfinite ),
        METH_VARARGS,
        "Checks if this shape has an infinite expansion.\n"
        "isInfinite() -> bool"
    },
    {"findPlane",
        reinterpret_cast<PyCFunction>( staticCallback_findPlane ),
        METH_VARARGS,
        "return a plane if the shape is planar\n"
        "findPlane(tol=None) -> Shape"
    },
    {"fix",
        reinterpret_cast<PyCFunction>( staticCallback_fix ),
        METH_VARARGS,
        "Tries to fix a broken shape.\n"
        "fix(working precision, minimum precision, maximum precision) -> bool\n"
        "--\n"
        "True is returned if the operation succeeded, False otherwise."
    },
    {"hashCode",
        reinterpret_cast<PyCFunction>( staticCallback_hashCode ),
        METH_VARARGS,
        "This value is computed from the value of the underlying shape reference and the location.\n"
        "hashCode() -> int\n"
        "--\n"
        "Orientation is not taken into account."
    },
    {"tessellate",
        reinterpret_cast<PyCFunction>( staticCallback_tessellate ),
        METH_VARARGS,
        "Tessellate the shape and return a list of vertices and face indices\n"
        "tessellate() -> (vertex,facets)"
    },
    {"project",
        reinterpret_cast<PyCFunction>( staticCallback_project ),
        METH_VARARGS,
        "Project a list of shapes on this shape\n"
        "project(shapeList) -> Shape"
    },
    {"makeParallelProjection",
        reinterpret_cast<PyCFunction>( staticCallback_makeParallelProjection ),
        METH_VARARGS,
        "Parallel projection of an edge or wire on this shape\n"
        "makeParallelProjection(shape, dir) -> Shape"
    },
    {"makePerspectiveProjection",
        reinterpret_cast<PyCFunction>( staticCallback_makePerspectiveProjection ),
        METH_VARARGS,
        "Perspective projection of an edge or wire on this shape\n"
        "makePerspectiveProjection(shape, pnt) -> Shape"
    },
    {"reflectLines",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_reflectLines )),
        METH_VARARGS|METH_KEYWORDS,
        "Build projection or reflect lines of a shape according to a view direction.\n"
        "reflectLines(ViewDir, [ViewPos, UpDir, EdgeType, Visible, OnShape]) -> Shape (Compound of edges)\n"
        "--\n"
        "This algorithm computes the projection of the shape in the ViewDir direction.\n"
        "If OnShape is False(default), the returned edges are flat on the XY plane defined by\n"
        "ViewPos(origin) and UpDir(up direction).\n"
        "If OnShape is True, the returned edges are the corresponding 3D reflect lines located on the shape.\n"
        "EdgeType is a string defining the type of result edges :\n"
        "- IsoLine : isoparametric line\n"
        "- OutLine : outline (silhouette) edge\n"
        "- Rg1Line : smooth edge of G1-continuity between two surfaces\n"
        "- RgNLine : sewn edge of CN-continuity on one surface\n"
        "- Sharp : sharp edge (of C0-continuity)\n"
        "If Visible is True (default), only visible edges are returned.\n"
        "If Visible is False, only invisible edges are returned."
    },
    {"makeShapeFromMesh",
        reinterpret_cast<PyCFunction>( staticCallback_makeShapeFromMesh ),
        METH_VARARGS,
        "Make a compound shape out of mesh data.\n"
        "makeShapeFromMesh((vertex,facets),tolerance) -> Shape\n"
        "--\n"
        "Note: This should be used for rather small meshes only."
    },
    {"toNurbs",
        reinterpret_cast<PyCFunction>( staticCallback_toNurbs ),
        METH_VARARGS,
        "Conversion of the complete geometry of a shape into NURBS geometry.\n"
        "toNurbs() -> Shape\n"
        "--\n"
        "For example, all curves supporting edges of the basis shape are converted\n"
        "into B-spline curves, and all surfaces supporting its faces are converted\n"
        "into B-spline surfaces."
    },
    {"copy",
        reinterpret_cast<PyCFunction>( staticCallback_copy ),
        METH_VARARGS,
        "Create a copy of this shape\n"
        "copy(copyGeom=True, copyMesh=False) -> Shape\n"
        "--\n"
        "If copyMesh is True, triangulation contained in original shape will be\n"
        "copied along with geometry.\n"
        "If copyGeom is False, only topological objects will be copied, while\n"
        "geometry and triangulation will be shared with original shape."
    },
    {"cleaned",
        reinterpret_cast<PyCFunction>( staticCallback_cleaned ),
        METH_VARARGS,
        "This creates a cleaned copy of the shape with the triangulation removed.\n"
        "clean()\n"
        "--\n"
        "This can be useful to reduce file size when exporting as a BREP file.\n"
        "Warning: Use the cleaned shape with care because certain algorithms may work incorrectly\n"
        "if the shape has no internal triangulation any more."
    },
    {"replaceShape",
        reinterpret_cast<PyCFunction>( staticCallback_replaceShape ),
        METH_VARARGS,
        "Replace a sub-shape with a new shape and return a new shape.\n"
        "replaceShape(tupleList) -> Shape\n"
        "--\n"
        "The parameter is in the form list of tuples with the two shapes."
    },
    {"removeShape",
        reinterpret_cast<PyCFunction>( staticCallback_removeShape ),
        METH_VARARGS,
        "Remove a sub-shape and return a new shape.\n"
        "removeShape(shapeList) -> Shape\n"
        "--\n"
        "The parameter is a list of shapes."
    },
    {"defeaturing",
        reinterpret_cast<PyCFunction>( staticCallback_defeaturing ),
        METH_VARARGS,
        "Remove a feature defined by supplied faces and return a new shape.\n"
        "defeaturing(shapeList) -> Shape\n"
        "--\n"
        "The parameter is a list of faces."
    },
    {"isInside",
        reinterpret_cast<PyCFunction>( staticCallback_isInside ),
        METH_VARARGS,
        "Checks whether a point is inside or outside the shape.\n"
        "isInside(point, tolerance, checkFace) => Boolean\n"
        "--\n"
        "checkFace indicates if the point lying directly on a face is considered to be inside or not"
    },
    {"removeSplitter",
        reinterpret_cast<PyCFunction>( staticCallback_removeSplitter ),
        METH_VARARGS,
        "Removes redundant edges from the B-REP model\n"
        "removeSplitter() -> Shape"
    },
    {"proximity",
        reinterpret_cast<PyCFunction>( staticCallback_proximity ),
        METH_VARARGS,
        "Returns two lists of Face indexes for the Faces involved in the intersection.\n"
        "proximity(shape,[tolerance]) -> (selfFaces, shapeFaces)"
    },
    {"distToShape",
        reinterpret_cast<PyCFunction>( staticCallback_distToShape ),
        METH_VARARGS,
        "Find the minimum distance to another shape.\n"
        "distToShape(shape, tol=1e-7) -> (dist, vectors, infos)\n"
        "--\n"
        "dist is the minimum distance, in mm (float value).\n"
        "\n"
        "vectors is a list of pairs of App.Vector. Each pair corresponds to solution.\n"
        "Example: [(App.Vector(2.0, -1.0, 2.0), App.Vector(2.0, 0.0, 2.0)),\n"
        "(App.Vector(2.0, -1.0, 2.0), App.Vector(2.0, -1.0, 3.0))]\n"
        "First vector is a point on self, second vector is a point on s.\n"
        "\n"
        "infos contains additional info on the solutions. It is a list of tuples:\n"
        "(topo1, index1, params1, topo2, index2, params2)\n"
        "\n"
        "    topo1, topo2 are strings identifying type of BREP element: 'Vertex',\n"
        "    'Edge', or 'Face'.\n"
        "\n"
        "    index1, index2 are indexes of the elements (zero-based).\n"
        "\n"
        "    params1, params2 are parameters of internal space of the elements. For\n"
        "    vertices, params is None. For edges, params is one float, u. For faces,\n"
        "    params is a tuple (u,v)."
    },
    {"getElement",
        reinterpret_cast<PyCFunction>( staticCallback_getElement ),
        METH_VARARGS,
        "Returns a SubElement\n"
        "getElement(elementName, [silent = False]) -> Face | Edge | Vertex\n"
        "elementName:  SubElement name - i.e. 'Edge1', 'Face3' etc. \n"
        "              Accepts TNP mitigation mapped names as well\n"
        "silent:  True to suppress the exception throw if the shape isn't found."
    },
    {"countElement",
        reinterpret_cast<PyCFunction>( staticCallback_countElement ),
        METH_VARARGS,
        "Returns the count of a type of element\n"
        "countElement(type) -> int"
    },
    {"mapSubElement",
        reinterpret_cast<PyCFunction>( staticCallback_mapSubElement ),
        METH_VARARGS,
        "mapSubElement(shape|[shape...], op='') - maps the sub element of other shape\n"
        "\n"
        "                  shape:  other shape or sequence of shapes to map the sub-elements\n"
        "                  op:     optional string prefix to append before the mapped sub element names"
    },
    {"mapShapes",
        reinterpret_cast<PyCFunction>( staticCallback_mapShapes ),
        METH_VARARGS,
        "mapShapes(generated, modified, op='')\n"
        "\n"
        "                  generate element names with user defined mapping\n"
        "\n"
        "                  generated: a list of tuple(src, dst) that indicating src shape or shapes\n"
        "                  generates dst shape or shapes. Note that the dst shape or shapes\n"
        "                  must be sub-shapes of this shape.\n"
        "                  modified: a list of tuple(src, dst) that indicating src shape or shapes\n"
        "                  modifies into dst shape or shapes. Note that the dst shape or\n"
        "                  shapes must be sub-shapes of this shape.\n"
        "                  op: optional string prefix to append before the mapped sub element names"
    },
    {"getElementHistory",
        reinterpret_cast<PyCFunction>( staticCallback_getElementHistory ),
        METH_VARARGS,
        "getElementHistory(name) - returns the element mapped name history\n"
        "\n"
        "                  name: mapped element name belonging to this shape\n"
        "\n"
        "                  Returns tuple(sourceShapeTag, sourceName, [intermediateNames...]),\n"
        "                  or None if no history."
    },
    {"getTolerance",
        reinterpret_cast<PyCFunction>( staticCallback_getTolerance ),
        METH_VARARGS,
        "Determines a tolerance from the ones stored in a shape\n"
        "getTolerance(mode, ShapeType=Shape) -> float\n"
        "--\n"
        "mode = 0 : returns the average value between sub-shapes,\n"
        "mode > 0 : returns the maximal found,\n"
        "mode < 0 : returns the minimal found.\n"
        "ShapeType defines what kinds of sub-shapes to consider:\n"
        "Shape (default) : all : Vertex, Edge, Face,\n"
        "Vertex : only vertices,\n"
        "Edge   : only edges,\n"
        "Face   : only faces,\n"
        "Shell  : combined Shell + Face, for each face (and containing\n"
        "         shell), also checks edge and Vertex"
    },
    {"overTolerance",
        reinterpret_cast<PyCFunction>( staticCallback_overTolerance ),
        METH_VARARGS,
        "Determines which shapes have a tolerance over the given value\n"
        "overTolerance(value, [ShapeType=Shape]) -> ShapeList\n"
        "--\n"
        "ShapeType is interpreted as in the method getTolerance"
    },
    {"inTolerance",
        reinterpret_cast<PyCFunction>( staticCallback_inTolerance ),
        METH_VARARGS,
        "Determines which shapes have a tolerance within a given interval\n"
        "inTolerance(value, [ShapeType=Shape]) -> ShapeList\n"
        "--\n"
        "ShapeType is interpreted as in the method getTolerance"
    },
    {"globalTolerance",
        reinterpret_cast<PyCFunction>( staticCallback_globalTolerance ),
        METH_VARARGS,
        "Returns the computed tolerance according to the mode\n"
        "globalTolerance(mode) -> float\n"
        "--\n"
        "mode = 0 : average\n"
        "mode > 0 : maximal\n"
        "mode < 0 : minimal"
    },
    {"fixTolerance",
        reinterpret_cast<PyCFunction>( staticCallback_fixTolerance ),
        METH_VARARGS,
        "Sets (enforces) tolerances in a shape to the given value\n"
        "fixTolerance(value, [ShapeType=Shape])\n"
        "--\n"
        "ShapeType = Vertex : only vertices are set\n"
        "ShapeType = Edge   : only edges are set\n"
        "ShapeType = Face   : only faces are set\n"
        "ShapeType = Wire   : to have edges and their vertices set\n"
        "ShapeType = other value : all (vertices,edges,faces) are set"
    },
    {"limitTolerance",
        reinterpret_cast<PyCFunction>( staticCallback_limitTolerance ),
        METH_VARARGS,
        "Limits tolerances in a shape\n"
        "limitTolerance(tmin, [tmax=0, ShapeType=Shape]) -> bool\n"
        "--\n"
        "tmin = tmax -> as fixTolerance (forces)\n"
        "tmin = 0   -> maximum tolerance will be tmax\n"
        "tmax = 0 or not given (more generally, tmax < tmin) ->\n"
        "tmax ignored, minimum will be tmin\n"
        "else, maximum will be max and minimum will be min\n"
        "ShapeType = Vertex : only vertices are set\n"
        "ShapeType = Edge   : only edges are set\n"
        "ShapeType = Face   : only faces are set\n"
        "ShapeType = Wire   : to have edges and their vertices set\n"
        "ShapeType = other value : all (vertices,edges,faces) are set\n"
        "Returns True if at least one tolerance of the sub-shape has been modified"
    },
    {"optimalBoundingBox",
        reinterpret_cast<PyCFunction>( staticCallback_optimalBoundingBox ),
        METH_VARARGS,
        "Get the optimal bounding box\n"
        "optimalBoundingBox([useTriangulation = True, useShapeTolerance = False]) -> bound box"
    },
    {"clearCache",
        reinterpret_cast<PyCFunction>( staticCallback_clearCache ),
        METH_VARARGS,
        "Clear internal sub-shape cache"
    },
    {"findSubShape",
        reinterpret_cast<PyCFunction>( staticCallback_findSubShape ),
        METH_VARARGS,
        "findSubShape(shape) -> (type_name, index)\n"
        "\n"
        "                  Find sub shape and return the shape type name and index. If not found,\n"
        "                  then return (None, 0)"
    },
    {"findSubShapesWithSharedVertex",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_findSubShapesWithSharedVertex )),
        METH_VARARGS|METH_KEYWORDS,
        "findSubShapesWithSharedVertex(shape, needName=False, checkGeometry=True, tol=1e-7, atol=1e-12) -> Shape\n"
        "\n"
        "                  shape: input elementary shape, currently only support Face, Edge, or Vertex\n"
        "\n"
        "                  needName: if True, return a list of tuple(name, shape), or else return a list\n"
        "                  of shapes.\n"
        "\n"
        "                  checkGeometry: whether to compare geometry\n"
        "\n"
        "                  tol: distance tolerance\n"
        "\n"
        "                  atol: angular tolerance\n"
        "\n"
        "                  Search sub shape by checking vertex coordinates and comparing the underlying\n"
        "                  geometries, This can find shapes that are copied. It currently only works with\n"
        "                  elementary shapes, Face, Edge, Vertex."
    },
    {"getChildShapes",
        reinterpret_cast<PyCFunction>( staticCallback_getChildShapes ),
        METH_VARARGS,
        "getChildShapes(shapetype, avoidtype='') -> list(Shape)\n"
        "\n"
        "                  Return a list of child sub-shapes of given type.\n"
        "\n"
        "                  shapetype: the type of requesting sub shapes\n"
        "                  avoidtype: optional shape type to skip when exploring"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of TopoShapePy
PyGetSetDef TopoShapePy::GetterSetter[] = {
    {"ShapeType",
        (getter) staticCallback_getShapeType,
        (setter) staticCallback_setShapeType,
        "Returns the type of the shape.",
        nullptr
    },
    {"Orientation",
        (getter) staticCallback_getOrientation,
        (setter) staticCallback_setOrientation,
        "Returns the orientation of the shape.",
        nullptr
    },
    {"Faces",
        (getter) staticCallback_getFaces,
        (setter) staticCallback_setFaces,
        "List of faces in this shape.",
        nullptr
    },
    {"Vertexes",
        (getter) staticCallback_getVertexes,
        (setter) staticCallback_setVertexes,
        "List of vertexes in this shape.",
        nullptr
    },
    {"Shells",
        (getter) staticCallback_getShells,
        (setter) staticCallback_setShells,
        "List of subsequent shapes in this shape.",
        nullptr
    },
    {"Solids",
        (getter) staticCallback_getSolids,
        (setter) staticCallback_setSolids,
        "List of subsequent shapes in this shape.",
        nullptr
    },
    {"CompSolids",
        (getter) staticCallback_getCompSolids,
        (setter) staticCallback_setCompSolids,
        "List of subsequent shapes in this shape.",
        nullptr
    },
    {"Edges",
        (getter) staticCallback_getEdges,
        (setter) staticCallback_setEdges,
        "List of Edges in this shape.",
        nullptr
    },
    {"Wires",
        (getter) staticCallback_getWires,
        (setter) staticCallback_setWires,
        "List of wires in this shape.",
        nullptr
    },
    {"Compounds",
        (getter) staticCallback_getCompounds,
        (setter) staticCallback_setCompounds,
        "List of compounds in this shape.",
        nullptr
    },
    {"SubShapes",
        (getter) staticCallback_getSubShapes,
        (setter) staticCallback_setSubShapes,
        "List of sub-shapes in this shape.",
        nullptr
    },
    {"Length",
        (getter) staticCallback_getLength,
        (setter) staticCallback_setLength,
        "Total length of the edges of the shape.",
        nullptr
    },
    {"Area",
        (getter) staticCallback_getArea,
        (setter) staticCallback_setArea,
        "Total area of the faces of the shape.",
        nullptr
    },
    {"Volume",
        (getter) staticCallback_getVolume,
        (setter) staticCallback_setVolume,
        "Total volume of the solids of the shape.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// dumps() callback and implementer
// PyObject*  TopoShapePy::dumps(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_dumps (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'dumps' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->dumps(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// loads() callback and implementer
// PyObject*  TopoShapePy::loads(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_loads (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'loads' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->loads(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// read() callback and implementer
// PyObject*  TopoShapePy::read(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_read (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'read' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->read(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// writeInventor() callback and implementer
// PyObject*  TopoShapePy::writeInventor(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_writeInventor (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'writeInventor' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->writeInventor(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exportIges() callback and implementer
// PyObject*  TopoShapePy::exportIges(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_exportIges (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exportIges' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->exportIges(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exportStep() callback and implementer
// PyObject*  TopoShapePy::exportStep(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_exportStep (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exportStep' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->exportStep(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exportBrep() callback and implementer
// PyObject*  TopoShapePy::exportBrep(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_exportBrep (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exportBrep' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->exportBrep(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exportBinary() callback and implementer
// PyObject*  TopoShapePy::exportBinary(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_exportBinary (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exportBinary' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->exportBinary(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exportBrepToString() callback and implementer
// PyObject*  TopoShapePy::exportBrepToString(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_exportBrepToString (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exportBrepToString' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->exportBrepToString(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// dumpToString() callback and implementer
// PyObject*  TopoShapePy::dumpToString(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_dumpToString (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'dumpToString' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->dumpToString(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exportStl() callback and implementer
// PyObject*  TopoShapePy::exportStl(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_exportStl (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exportStl' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->exportStl(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// importBrep() callback and implementer
// PyObject*  TopoShapePy::importBrep(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_importBrep (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'importBrep' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->importBrep(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// importBinary() callback and implementer
// PyObject*  TopoShapePy::importBinary(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_importBinary (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'importBinary' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->importBinary(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// importBrepFromString() callback and implementer
// PyObject*  TopoShapePy::importBrepFromString(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_importBrepFromString (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'importBrepFromString' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->importBrepFromString(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// extrude() callback and implementer
// PyObject*  TopoShapePy::extrude(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_extrude (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'extrude' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->extrude(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// revolve() callback and implementer
// PyObject*  TopoShapePy::revolve(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_revolve (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'revolve' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->revolve(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// check() callback and implementer
// PyObject*  TopoShapePy::check(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_check (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'check' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->check(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// fuse() callback and implementer
// PyObject*  TopoShapePy::fuse(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_fuse (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'fuse' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->fuse(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// multiFuse() callback and implementer
// PyObject*  TopoShapePy::multiFuse(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_multiFuse (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'multiFuse' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->multiFuse(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// oldFuse() callback and implementer
// PyObject*  TopoShapePy::oldFuse(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_oldFuse (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'oldFuse' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->oldFuse(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// common() callback and implementer
// PyObject*  TopoShapePy::common(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_common (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'common' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->common(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// section() callback and implementer
// PyObject*  TopoShapePy::section(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_section (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'section' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->section(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// slices() callback and implementer
// PyObject*  TopoShapePy::slices(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_slices (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'slices' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->slices(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// slice() callback and implementer
// PyObject*  TopoShapePy::slice(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_slice (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'slice' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->slice(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// cut() callback and implementer
// PyObject*  TopoShapePy::cut(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_cut (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'cut' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->cut(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// generalFuse() callback and implementer
// PyObject*  TopoShapePy::generalFuse(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_generalFuse (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'generalFuse' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->generalFuse(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// sewShape() callback and implementer
// PyObject*  TopoShapePy::sewShape(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_sewShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'sewShape' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->sewShape(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// childShapes() callback and implementer
// PyObject*  TopoShapePy::childShapes(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_childShapes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'childShapes' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->childShapes(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// ancestorsOfType() callback and implementer
// PyObject*  TopoShapePy::ancestorsOfType(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_ancestorsOfType (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'ancestorsOfType' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->ancestorsOfType(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeInternalWires() callback and implementer
// PyObject*  TopoShapePy::removeInternalWires(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_removeInternalWires (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeInternalWires' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->removeInternalWires(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// mirror() callback and implementer
// PyObject*  TopoShapePy::mirror(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_mirror (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'mirror' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->mirror(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// transformGeometry() callback and implementer
// PyObject*  TopoShapePy::transformGeometry(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_transformGeometry (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'transformGeometry' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->transformGeometry(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// transformShape() callback and implementer
// PyObject*  TopoShapePy::transformShape(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_transformShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'transformShape' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->transformShape(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// transformed() callback and implementer
// PyObject*  TopoShapePy::transformed(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_transformed (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'transformed' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->transformed(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// translate() callback and implementer
// PyObject*  TopoShapePy::translate(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_translate (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'translate' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->translate(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// translated() callback and implementer
// PyObject*  TopoShapePy::translated(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_translated (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'translated' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->translated(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// rotate() callback and implementer
// PyObject*  TopoShapePy::rotate(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_rotate (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'rotate' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->rotate(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// rotated() callback and implementer
// PyObject*  TopoShapePy::rotated(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_rotated (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'rotated' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->rotated(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// scale() callback and implementer
// PyObject*  TopoShapePy::scale(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_scale (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'scale' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->scale(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// scaled() callback and implementer
// PyObject*  TopoShapePy::scaled(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_scaled (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'scaled' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->scaled(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeFillet() callback and implementer
// PyObject*  TopoShapePy::makeFillet(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeFillet (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeFillet' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeFillet(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeChamfer() callback and implementer
// PyObject*  TopoShapePy::makeChamfer(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeChamfer (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeChamfer' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeChamfer(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeThickness() callback and implementer
// PyObject*  TopoShapePy::makeThickness(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeThickness (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeThickness' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeThickness(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeOffsetShape() callback and implementer
// PyObject*  TopoShapePy::makeOffsetShape(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeOffsetShape (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeOffsetShape' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeOffsetShape(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeOffset2D() callback and implementer
// PyObject*  TopoShapePy::makeOffset2D(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeOffset2D (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeOffset2D' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeOffset2D(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeEvolved() callback and implementer
// PyObject*  TopoShapePy::makeEvolved(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeEvolved (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeEvolved' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeEvolved(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeWires() callback and implementer
// PyObject*  TopoShapePy::makeWires(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeWires (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeWires' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeWires(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// reverse() callback and implementer
// PyObject*  TopoShapePy::reverse(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_reverse (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'reverse' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->reverse(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// reversed() callback and implementer
// PyObject*  TopoShapePy::reversed(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_reversed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'reversed' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->reversed(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// complement() callback and implementer
// PyObject*  TopoShapePy::complement(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_complement (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'complement' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->complement(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// nullify() callback and implementer
// PyObject*  TopoShapePy::nullify(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_nullify (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'nullify' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->nullify(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isClosed() callback and implementer
// PyObject*  TopoShapePy::isClosed(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isClosed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isClosed' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isClosed(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isPartner() callback and implementer
// PyObject*  TopoShapePy::isPartner(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isPartner (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isPartner' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isPartner(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isSame() callback and implementer
// PyObject*  TopoShapePy::isSame(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isSame (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isSame' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isSame(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isEqual() callback and implementer
// PyObject*  TopoShapePy::isEqual(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isEqual (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isEqual' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isEqual(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isNull() callback and implementer
// PyObject*  TopoShapePy::isNull(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isNull (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isNull' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isNull(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isValid() callback and implementer
// PyObject*  TopoShapePy::isValid(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isValid (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isValid' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isValid(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isCoplanar() callback and implementer
// PyObject*  TopoShapePy::isCoplanar(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isCoplanar (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isCoplanar' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isCoplanar(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isInfinite() callback and implementer
// PyObject*  TopoShapePy::isInfinite(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isInfinite (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isInfinite' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isInfinite(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// findPlane() callback and implementer
// PyObject*  TopoShapePy::findPlane(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_findPlane (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'findPlane' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->findPlane(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// fix() callback and implementer
// PyObject*  TopoShapePy::fix(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_fix (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'fix' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->fix(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hashCode() callback and implementer
// PyObject*  TopoShapePy::hashCode(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_hashCode (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hashCode' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->hashCode(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// tessellate() callback and implementer
// PyObject*  TopoShapePy::tessellate(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_tessellate (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'tessellate' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->tessellate(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// project() callback and implementer
// PyObject*  TopoShapePy::project(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_project (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'project' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->project(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeParallelProjection() callback and implementer
// PyObject*  TopoShapePy::makeParallelProjection(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeParallelProjection (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeParallelProjection' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeParallelProjection(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makePerspectiveProjection() callback and implementer
// PyObject*  TopoShapePy::makePerspectiveProjection(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makePerspectiveProjection (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makePerspectiveProjection' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makePerspectiveProjection(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// reflectLines() callback and implementer
// PyObject*  TopoShapePy::reflectLines(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_reflectLines (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'reflectLines' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->reflectLines(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeShapeFromMesh() callback and implementer
// PyObject*  TopoShapePy::makeShapeFromMesh(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_makeShapeFromMesh (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeShapeFromMesh' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->makeShapeFromMesh(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toNurbs() callback and implementer
// PyObject*  TopoShapePy::toNurbs(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_toNurbs (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toNurbs' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->toNurbs(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// copy() callback and implementer
// PyObject*  TopoShapePy::copy(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_copy (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'copy' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->copy(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// cleaned() callback and implementer
// PyObject*  TopoShapePy::cleaned(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_cleaned (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'cleaned' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->cleaned(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// replaceShape() callback and implementer
// PyObject*  TopoShapePy::replaceShape(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_replaceShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'replaceShape' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->replaceShape(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeShape() callback and implementer
// PyObject*  TopoShapePy::removeShape(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_removeShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeShape' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->removeShape(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// defeaturing() callback and implementer
// PyObject*  TopoShapePy::defeaturing(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_defeaturing (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'defeaturing' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->defeaturing(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isInside() callback and implementer
// PyObject*  TopoShapePy::isInside(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_isInside (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isInside' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->isInside(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeSplitter() callback and implementer
// PyObject*  TopoShapePy::removeSplitter(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_removeSplitter (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeSplitter' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->removeSplitter(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// proximity() callback and implementer
// PyObject*  TopoShapePy::proximity(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_proximity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'proximity' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->proximity(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// distToShape() callback and implementer
// PyObject*  TopoShapePy::distToShape(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_distToShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'distToShape' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->distToShape(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getElement() callback and implementer
// PyObject*  TopoShapePy::getElement(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getElement (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getElement' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->getElement(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// countElement() callback and implementer
// PyObject*  TopoShapePy::countElement(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_countElement (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'countElement' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->countElement(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// mapSubElement() callback and implementer
// PyObject*  TopoShapePy::mapSubElement(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_mapSubElement (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'mapSubElement' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->mapSubElement(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// mapShapes() callback and implementer
// PyObject*  TopoShapePy::mapShapes(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_mapShapes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'mapShapes' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->mapShapes(args);
        if (ret != nullptr)
            static_cast<TopoShapePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getElementHistory() callback and implementer
// PyObject*  TopoShapePy::getElementHistory(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getElementHistory (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getElementHistory' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->getElementHistory(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getTolerance() callback and implementer
// PyObject*  TopoShapePy::getTolerance(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getTolerance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getTolerance' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->getTolerance(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// overTolerance() callback and implementer
// PyObject*  TopoShapePy::overTolerance(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_overTolerance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'overTolerance' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->overTolerance(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// inTolerance() callback and implementer
// PyObject*  TopoShapePy::inTolerance(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_inTolerance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'inTolerance' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->inTolerance(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// globalTolerance() callback and implementer
// PyObject*  TopoShapePy::globalTolerance(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_globalTolerance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'globalTolerance' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->globalTolerance(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// fixTolerance() callback and implementer
// PyObject*  TopoShapePy::fixTolerance(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_fixTolerance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'fixTolerance' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->fixTolerance(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// limitTolerance() callback and implementer
// PyObject*  TopoShapePy::limitTolerance(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_limitTolerance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'limitTolerance' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->limitTolerance(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// optimalBoundingBox() callback and implementer
// PyObject*  TopoShapePy::optimalBoundingBox(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_optimalBoundingBox (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'optimalBoundingBox' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->optimalBoundingBox(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// clearCache() callback and implementer
// PyObject*  TopoShapePy::clearCache(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_clearCache (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'clearCache' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->clearCache(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// findSubShape() callback and implementer
// PyObject*  TopoShapePy::findSubShape(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_findSubShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'findSubShape' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->findSubShape(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// findSubShapesWithSharedVertex() callback and implementer
// PyObject*  TopoShapePy::findSubShapesWithSharedVertex(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_findSubShapesWithSharedVertex (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'findSubShapesWithSharedVertex' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->findSubShapesWithSharedVertex(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getChildShapes() callback and implementer
// PyObject*  TopoShapePy::getChildShapes(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getChildShapes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getChildShapes' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapePy*>(self)->getChildShapes(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// ShapeType() callback and implementer
// PyObject*  TopoShapePy::ShapeType(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getShapeType (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getShapeType());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ShapeType' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setShapeType (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ShapeType' of object 'TopoShape' is read-only");
    return -1;
}

// Orientation() callback and implementer
// PyObject*  TopoShapePy::Orientation(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getOrientation (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getOrientation());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Orientation' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setOrientation (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<TopoShapePy*>(self)->setOrientation(Py::String(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Orientation' of object 'TopoShape'");
        return -1;
    }
}

// Faces() callback and implementer
// PyObject*  TopoShapePy::Faces(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getFaces (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getFaces());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Faces' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setFaces (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Faces' of object 'TopoShape' is read-only");
    return -1;
}

// Vertexes() callback and implementer
// PyObject*  TopoShapePy::Vertexes(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getVertexes (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getVertexes());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Vertexes' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setVertexes (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Vertexes' of object 'TopoShape' is read-only");
    return -1;
}

// Shells() callback and implementer
// PyObject*  TopoShapePy::Shells(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getShells (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getShells());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Shells' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setShells (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Shells' of object 'TopoShape' is read-only");
    return -1;
}

// Solids() callback and implementer
// PyObject*  TopoShapePy::Solids(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getSolids (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getSolids());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Solids' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setSolids (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Solids' of object 'TopoShape' is read-only");
    return -1;
}

// CompSolids() callback and implementer
// PyObject*  TopoShapePy::CompSolids(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getCompSolids (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getCompSolids());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'CompSolids' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setCompSolids (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'CompSolids' of object 'TopoShape' is read-only");
    return -1;
}

// Edges() callback and implementer
// PyObject*  TopoShapePy::Edges(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getEdges (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getEdges());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Edges' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setEdges (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Edges' of object 'TopoShape' is read-only");
    return -1;
}

// Wires() callback and implementer
// PyObject*  TopoShapePy::Wires(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getWires (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getWires());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Wires' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setWires (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Wires' of object 'TopoShape' is read-only");
    return -1;
}

// Compounds() callback and implementer
// PyObject*  TopoShapePy::Compounds(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getCompounds (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getCompounds());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Compounds' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setCompounds (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Compounds' of object 'TopoShape' is read-only");
    return -1;
}

// SubShapes() callback and implementer
// PyObject*  TopoShapePy::SubShapes(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getSubShapes (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getSubShapes());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'SubShapes' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setSubShapes (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'SubShapes' of object 'TopoShape' is read-only");
    return -1;
}

// Length() callback and implementer
// PyObject*  TopoShapePy::Length(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getLength (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getLength());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Length' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setLength (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Length' of object 'TopoShape' is read-only");
    return -1;
}

// Area() callback and implementer
// PyObject*  TopoShapePy::Area(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getArea (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getArea());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Area' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setArea (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Area' of object 'TopoShape' is read-only");
    return -1;
}

// Volume() callback and implementer
// PyObject*  TopoShapePy::Volume(PyObject *args){};
// has to be implemented in TopoShapePyImp.cpp
PyObject * TopoShapePy::staticCallback_getVolume (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapePy*>(self)->getVolume());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Volume' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapePy::staticCallback_setVolume (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Volume' of object 'TopoShape' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
TopoShapePy::TopoShapePy(TopoShape *pcObject, PyTypeObject *T)
    : ComplexGeoDataPy(static_cast<ComplexGeoDataPy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
TopoShapePy::~TopoShapePy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// TopoShapePy representation
//--------------------------------------------------------------------------
PyObject *TopoShapePy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// TopoShapePy Attributes
//--------------------------------------------------------------------------
PyObject *TopoShapePy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return ComplexGeoDataPy::_getattr(attr);
}

int TopoShapePy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return ComplexGeoDataPy::_setattr(attr, value);
}

TopoShape *TopoShapePy::getTopoShapePtr() const
{
    return static_cast<TopoShape *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in TopoShapePyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *TopoShapePy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of TopoShapePy and the Twin object
    return new TopoShapePy(new TopoShape);
}

// constructor method
int TopoShapePy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string TopoShapePy::representation() const
{
    return {"<TopoShape object>"};
}

PyObject* TopoShapePy::dumps(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::loads(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::read(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::writeInventor(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::exportIges(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::exportStep(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::exportBrep(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::exportBinary(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::exportBrepToString(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::dumpToString(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::exportStl(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::importBrep(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::importBinary(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::importBrepFromString(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::extrude(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::revolve(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::check(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::fuse(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::multiFuse(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::oldFuse(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::common(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::section(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::slices(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::slice(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::cut(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::generalFuse(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::sewShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::childShapes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::ancestorsOfType(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::removeInternalWires(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::mirror(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::transformGeometry(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::transformShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::transformed(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::translate(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::translated(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::rotate(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::rotated(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::scale(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::scaled(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeFillet(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeChamfer(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeThickness(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeOffsetShape(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeOffset2D(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeEvolved(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeWires(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::reverse(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::reversed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::complement(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::nullify(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isClosed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isPartner(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isSame(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isEqual(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isNull(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isValid(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isCoplanar(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isInfinite(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::findPlane(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::fix(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::hashCode(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::tessellate(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::project(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeParallelProjection(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makePerspectiveProjection(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::reflectLines(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::makeShapeFromMesh(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::toNurbs(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::copy(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::cleaned(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::replaceShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::removeShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::defeaturing(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::isInside(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::removeSplitter(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::proximity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::distToShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::getElement(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::countElement(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::mapSubElement(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::mapShapes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::getElementHistory(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::getTolerance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::overTolerance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::inTolerance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::globalTolerance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::fixTolerance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::limitTolerance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::optimalBoundingBox(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::clearCache(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::findSubShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::findSubShapesWithSharedVertex(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapePy::getChildShapes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::String TopoShapePy::getShapeType() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String TopoShapePy::getOrientation() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

void  TopoShapePy::setOrientation(Py::String arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getFaces() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getVertexes() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getShells() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getSolids() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getCompSolids() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getEdges() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getWires() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getCompounds() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapePy::getSubShapes() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float TopoShapePy::getLength() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float TopoShapePy::getArea() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float TopoShapePy::getVolume() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *TopoShapePy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int TopoShapePy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



