/* Generated by wayland-scanner 1.24.0 */

#ifndef ORBITAL_AUTHORIZER_CLIENT_PROTOCOL_H
#define ORBITAL_AUTHORIZER_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_orbital_authorizer The orbital_authorizer protocol
 * @section page_ifaces_orbital_authorizer Interfaces
 * - @subpage page_iface_orbital_authorizer - authorize clients to use certain interfaces
 * - @subpage page_iface_orbital_authorizer_feedback - feedback for an authorization request
 */
struct orbital_authorizer;
struct orbital_authorizer_feedback;

#ifndef ORBITAL_AUTHORIZER_INTERFACE
#define ORBITAL_AUTHORIZER_INTERFACE
/**
 * @page page_iface_orbital_authorizer orbital_authorizer
 * @section page_iface_orbital_authorizer_desc Description
 *
 * The orbital_authorizer global interface allows clients to
 * ask the compositor the authorization to bind certain restricted
 * global interfaces.
 * Any client that aims to bind restricted interfaces should first
 * request the authorization by using this interface. Failing to do
 * so will result in the compositor sending a protocol error to the
 * client when it binds the restricted interface.
 *
 * The list of restricted interfaces is compositor dependant, but must
 * not include the core interfaces defined in wayland.xml.
 * @section page_iface_orbital_authorizer_api API
 * See @ref iface_orbital_authorizer.
 */
/**
 * @defgroup iface_orbital_authorizer The orbital_authorizer interface
 *
 * The orbital_authorizer global interface allows clients to
 * ask the compositor the authorization to bind certain restricted
 * global interfaces.
 * Any client that aims to bind restricted interfaces should first
 * request the authorization by using this interface. Failing to do
 * so will result in the compositor sending a protocol error to the
 * client when it binds the restricted interface.
 *
 * The list of restricted interfaces is compositor dependant, but must
 * not include the core interfaces defined in wayland.xml.
 */
extern const struct wl_interface orbital_authorizer_interface;
#endif
#ifndef ORBITAL_AUTHORIZER_FEEDBACK_INTERFACE
#define ORBITAL_AUTHORIZER_FEEDBACK_INTERFACE
/**
 * @page page_iface_orbital_authorizer_feedback orbital_authorizer_feedback
 * @section page_iface_orbital_authorizer_feedback_desc Description
 *
 * The orbital_authorizer_feedback interface is used by requesting
 * an authorization with the orbital_authorizer.authorize request.
 * The compositor will send either the granted or denied event based
 * on the system and user configuration. How the authorization process
 * works is compositor specific, but a compositor is allowed to ask
 * for user input, so the response for an authorization request may
 * come after some time.
 * @section page_iface_orbital_authorizer_feedback_api API
 * See @ref iface_orbital_authorizer_feedback.
 */
/**
 * @defgroup iface_orbital_authorizer_feedback The orbital_authorizer_feedback interface
 *
 * The orbital_authorizer_feedback interface is used by requesting
 * an authorization with the orbital_authorizer.authorize request.
 * The compositor will send either the granted or denied event based
 * on the system and user configuration. How the authorization process
 * works is compositor specific, but a compositor is allowed to ask
 * for user input, so the response for an authorization request may
 * come after some time.
 */
extern const struct wl_interface orbital_authorizer_feedback_interface;
#endif

#define ORBITAL_AUTHORIZER_DESTROY 0
#define ORBITAL_AUTHORIZER_AUTHORIZE 1


/**
 * @ingroup iface_orbital_authorizer
 */
#define ORBITAL_AUTHORIZER_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_orbital_authorizer
 */
#define ORBITAL_AUTHORIZER_AUTHORIZE_SINCE_VERSION 1

/** @ingroup iface_orbital_authorizer */
static inline void
orbital_authorizer_set_user_data(struct orbital_authorizer *orbital_authorizer, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) orbital_authorizer, user_data);
}

/** @ingroup iface_orbital_authorizer */
static inline void *
orbital_authorizer_get_user_data(struct orbital_authorizer *orbital_authorizer)
{
	return wl_proxy_get_user_data((struct wl_proxy *) orbital_authorizer);
}

static inline uint32_t
orbital_authorizer_get_version(struct orbital_authorizer *orbital_authorizer)
{
	return wl_proxy_get_version((struct wl_proxy *) orbital_authorizer);
}

/**
 * @ingroup iface_orbital_authorizer
 */
static inline void
orbital_authorizer_destroy(struct orbital_authorizer *orbital_authorizer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) orbital_authorizer,
			 ORBITAL_AUTHORIZER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) orbital_authorizer), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_orbital_authorizer
 *
 * The authorize request allows the client to ask the compositor the
 * authorization to bind a restricted global interface. The newly
 * created orbital_authorizer_feedback will be invalid after the
 * compositor send either the granted or denied event so the client
 * must destroy it immediately after.
 */
static inline struct orbital_authorizer_feedback *
orbital_authorizer_authorize(struct orbital_authorizer *orbital_authorizer, const char *global)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) orbital_authorizer,
			 ORBITAL_AUTHORIZER_AUTHORIZE, &orbital_authorizer_feedback_interface, wl_proxy_get_version((struct wl_proxy *) orbital_authorizer), 0, NULL, global);

	return (struct orbital_authorizer_feedback *) id;
}

/**
 * @ingroup iface_orbital_authorizer_feedback
 * @struct orbital_authorizer_feedback_listener
 */
struct orbital_authorizer_feedback_listener {
	/**
	 * the authorization was granted
	 *
	 * The authorization was granted. The client can now bind the
	 * restricted interface.
	 */
	void (*granted)(void *data,
			struct orbital_authorizer_feedback *orbital_authorizer_feedback);
	/**
	 * the authorization was denied
	 *
	 * The authorization was denied. The client is not allowed to
	 * bind the restricted interface and trying to do so will trigger a
	 * protocol error killing the client.
	 */
	void (*denied)(void *data,
		       struct orbital_authorizer_feedback *orbital_authorizer_feedback);
};

/**
 * @ingroup iface_orbital_authorizer_feedback
 */
static inline int
orbital_authorizer_feedback_add_listener(struct orbital_authorizer_feedback *orbital_authorizer_feedback,
					 const struct orbital_authorizer_feedback_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) orbital_authorizer_feedback,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_orbital_authorizer_feedback
 */
#define ORBITAL_AUTHORIZER_FEEDBACK_GRANTED_SINCE_VERSION 1
/**
 * @ingroup iface_orbital_authorizer_feedback
 */
#define ORBITAL_AUTHORIZER_FEEDBACK_DENIED_SINCE_VERSION 1


/** @ingroup iface_orbital_authorizer_feedback */
static inline void
orbital_authorizer_feedback_set_user_data(struct orbital_authorizer_feedback *orbital_authorizer_feedback, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) orbital_authorizer_feedback, user_data);
}

/** @ingroup iface_orbital_authorizer_feedback */
static inline void *
orbital_authorizer_feedback_get_user_data(struct orbital_authorizer_feedback *orbital_authorizer_feedback)
{
	return wl_proxy_get_user_data((struct wl_proxy *) orbital_authorizer_feedback);
}

static inline uint32_t
orbital_authorizer_feedback_get_version(struct orbital_authorizer_feedback *orbital_authorizer_feedback)
{
	return wl_proxy_get_version((struct wl_proxy *) orbital_authorizer_feedback);
}

/** @ingroup iface_orbital_authorizer_feedback */
static inline void
orbital_authorizer_feedback_destroy(struct orbital_authorizer_feedback *orbital_authorizer_feedback)
{
	wl_proxy_destroy((struct wl_proxy *) orbital_authorizer_feedback);
}

#ifdef  __cplusplus
}
#endif

#endif
