/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_packet_header_ofdm = R"doc(Header utility for OFDM signals.

Constructor Specific Documentation:



Args:
    occupied_carriers : See carrier allocator
    n_syms : The number of OFDM symbols the header should be (usually 1)
    len_tag_key : The tag key used for the packet length (number of bytes)
    frame_len_tag_key : The tag key used for the frame length (number of OFDM symbols, this is the tag key required for the frame equalizer etc.)
    num_tag_key : The tag key used for packet numbering.
    bits_per_header_sym : Bits per complex symbol in the header, e.g. 1 if the header is BPSK modulated, 2 if it's QPSK modulated etc.
    bits_per_payload_sym : Bits per complex symbol in the payload. This is required to figure out how many OFDM symbols are necessary to encode the given number of bytes.
    scramble_header : Set this to true to scramble the bits. This is highly recommended, as it reduces PAPR spikes.)doc";


static const char* __doc_gr_digital_packet_header_ofdm_packet_header_ofdm_0 = R"doc()doc";


static const char* __doc_gr_digital_packet_header_ofdm_packet_header_ofdm_1 = R"doc()doc";


static const char* __doc_gr_digital_packet_header_ofdm_header_formatter = R"doc(Header formatter.

Does the same as packet_header_default::header_formatter(), but optionally scrambles the bits (this is more important for OFDM to avoid PAPR spikes).)doc";


static const char* __doc_gr_digital_packet_header_ofdm_header_parser = R"doc(Inverse function to header_formatter().

Does the same as packet_header_default::header_parser(), but adds another tag that stores the number of OFDM symbols in the packet. Note that there is usually no linear connection between the number of OFDM symbols and the packet length because a packet might finish mid-OFDM-symbol.)doc";


static const char* __doc_gr_digital_packet_header_ofdm_make = R"doc(Header utility for OFDM signals.

Constructor Specific Documentation:



Args:
    occupied_carriers : See carrier allocator
    n_syms : The number of OFDM symbols the header should be (usually 1)
    len_tag_key : The tag key used for the packet length (number of bytes)
    frame_len_tag_key : The tag key used for the frame length (number of OFDM symbols, this is the tag key required for the frame equalizer etc.)
    num_tag_key : The tag key used for packet numbering.
    bits_per_header_sym : Bits per complex symbol in the header, e.g. 1 if the header is BPSK modulated, 2 if it's QPSK modulated etc.
    bits_per_payload_sym : Bits per complex symbol in the payload. This is required to figure out how many OFDM symbols are necessary to encode the given number of bytes.
    scramble_header : Set this to true to scramble the bits. This is highly recommended, as it reduces PAPR spikes.)doc";
