{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The client for a t'GI.Dbusmenu.Objects.Server.Server' creating a shared
-- 	object set of t'GI.Dbusmenu.Objects.Menuitem.Menuitem' objects.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Dbusmenu.Objects.Client
    ( 

-- * Exported types
    Client(..)                              ,
    IsClient                                ,
    toClient                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addTypeHandler]("GI.Dbusmenu.Objects.Client#g:method:addTypeHandler"), [addTypeHandlerFull]("GI.Dbusmenu.Objects.Client#g:method:addTypeHandlerFull"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getIconPaths]("GI.Dbusmenu.Objects.Client#g:method:getIconPaths"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRoot]("GI.Dbusmenu.Objects.Client#g:method:getRoot"), [getStatus]("GI.Dbusmenu.Objects.Client#g:method:getStatus"), [getTextDirection]("GI.Dbusmenu.Objects.Client#g:method:getTextDirection").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveClientMethod                     ,
#endif

-- ** addTypeHandler #method:addTypeHandler#

#if defined(ENABLE_OVERLOADING)
    ClientAddTypeHandlerMethodInfo          ,
#endif
    clientAddTypeHandler                    ,


-- ** addTypeHandlerFull #method:addTypeHandlerFull#

#if defined(ENABLE_OVERLOADING)
    ClientAddTypeHandlerFullMethodInfo      ,
#endif
    clientAddTypeHandlerFull                ,


-- ** getIconPaths #method:getIconPaths#

#if defined(ENABLE_OVERLOADING)
    ClientGetIconPathsMethodInfo            ,
#endif
    clientGetIconPaths                      ,


-- ** getRoot #method:getRoot#

#if defined(ENABLE_OVERLOADING)
    ClientGetRootMethodInfo                 ,
#endif
    clientGetRoot                           ,


-- ** getStatus #method:getStatus#

#if defined(ENABLE_OVERLOADING)
    ClientGetStatusMethodInfo               ,
#endif
    clientGetStatus                         ,


-- ** getTextDirection #method:getTextDirection#

#if defined(ENABLE_OVERLOADING)
    ClientGetTextDirectionMethodInfo        ,
#endif
    clientGetTextDirection                  ,


-- ** new #method:new#

    clientNew                               ,




 -- * Properties


-- ** dbusName #attr:dbusName#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ClientDbusNamePropertyInfo              ,
#endif
#if defined(ENABLE_OVERLOADING)
    clientDbusName                          ,
#endif
    constructClientDbusName                 ,
    getClientDbusName                       ,


-- ** dbusObject #attr:dbusObject#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ClientDbusObjectPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    clientDbusObject                        ,
#endif
    constructClientDbusObject               ,
    getClientDbusObject                     ,


-- ** groupEvents #attr:groupEvents#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ClientGroupEventsPropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    clientGroupEvents                       ,
#endif
    constructClientGroupEvents              ,
    getClientGroupEvents                    ,
    setClientGroupEvents                    ,




 -- * Signals


-- ** eventResult #signal:eventResult#

    ClientEventResultCallback               ,
#if defined(ENABLE_OVERLOADING)
    ClientEventResultSignalInfo             ,
#endif
    afterClientEventResult                  ,
    onClientEventResult                     ,


-- ** iconThemeDirsChanged #signal:iconThemeDirsChanged#

    ClientIconThemeDirsChangedCallback      ,
#if defined(ENABLE_OVERLOADING)
    ClientIconThemeDirsChangedSignalInfo    ,
#endif
    afterClientIconThemeDirsChanged         ,
    onClientIconThemeDirsChanged            ,


-- ** itemActivate #signal:itemActivate#

    ClientItemActivateCallback              ,
#if defined(ENABLE_OVERLOADING)
    ClientItemActivateSignalInfo            ,
#endif
    afterClientItemActivate                 ,
    onClientItemActivate                    ,


-- ** layoutUpdated #signal:layoutUpdated#

    ClientLayoutUpdatedCallback             ,
#if defined(ENABLE_OVERLOADING)
    ClientLayoutUpdatedSignalInfo           ,
#endif
    afterClientLayoutUpdated                ,
    onClientLayoutUpdated                   ,


-- ** newMenuitem #signal:newMenuitem#

    ClientNewMenuitemCallback               ,
#if defined(ENABLE_OVERLOADING)
    ClientNewMenuitemSignalInfo             ,
#endif
    afterClientNewMenuitem                  ,
    onClientNewMenuitem                     ,


-- ** rootChanged #signal:rootChanged#

    ClientRootChangedCallback               ,
#if defined(ENABLE_OVERLOADING)
    ClientRootChangedSignalInfo             ,
#endif
    afterClientRootChanged                  ,
    onClientRootChanged                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Dbusmenu.Callbacks as Dbusmenu.Callbacks
import {-# SOURCE #-} qualified GI.Dbusmenu.Enums as Dbusmenu.Enums
import {-# SOURCE #-} qualified GI.Dbusmenu.Objects.Menuitem as Dbusmenu.Menuitem
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.Dbusmenu.Callbacks as Dbusmenu.Callbacks
import {-# SOURCE #-} qualified GI.Dbusmenu.Enums as Dbusmenu.Enums
import {-# SOURCE #-} qualified GI.Dbusmenu.Objects.Menuitem as Dbusmenu.Menuitem
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Client = Client (SP.ManagedPtr Client)
    deriving (Eq)

instance SP.ManagedPtrNewtype Client where
    toManagedPtr (Client p) = p

foreign import ccall "dbusmenu_client_get_type"
    c_dbusmenu_client_get_type :: IO B.Types.GType

instance B.Types.TypedObject Client where
    glibType = c_dbusmenu_client_get_type

instance B.Types.GObject Client

-- | Type class for types which can be safely cast to t'Client', for instance with `toClient`.
class (SP.GObject o, O.IsDescendantOf Client o) => IsClient o
instance (SP.GObject o, O.IsDescendantOf Client o) => IsClient o

instance O.HasParentTypes Client
type instance O.ParentTypes Client = '[GObject.Object.Object]

-- | Cast to t'Client', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toClient :: (MIO.MonadIO m, IsClient o) => o -> m Client
toClient = MIO.liftIO . B.ManagedPtr.unsafeCastTo Client

-- | Convert t'Client' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Client) where
    gvalueGType_ = c_dbusmenu_client_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Client)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Client)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Client ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveClientMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveClientMethod "addTypeHandler" o = ClientAddTypeHandlerMethodInfo
    ResolveClientMethod "addTypeHandlerFull" o = ClientAddTypeHandlerFullMethodInfo
    ResolveClientMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveClientMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveClientMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveClientMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveClientMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveClientMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveClientMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveClientMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveClientMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveClientMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveClientMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveClientMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveClientMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveClientMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveClientMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveClientMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveClientMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveClientMethod "getIconPaths" o = ClientGetIconPathsMethodInfo
    ResolveClientMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveClientMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveClientMethod "getRoot" o = ClientGetRootMethodInfo
    ResolveClientMethod "getStatus" o = ClientGetStatusMethodInfo
    ResolveClientMethod "getTextDirection" o = ClientGetTextDirectionMethodInfo
    ResolveClientMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveClientMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveClientMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveClientMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveClientMethod t Client, O.OverloadedMethod info Client p) => OL.IsLabel t (Client -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveClientMethod t Client, O.OverloadedMethod info Client p, R.HasField t Client p) => R.HasField t Client p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveClientMethod t Client, O.OverloadedMethodInfo info Client) => OL.IsLabel t (O.MethodProxy info Client) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Client::event-result
-- | /No description available in the introspection data./
type ClientEventResultCallback =
    GObject.Object.Object
    -> T.Text
    -> GVariant
    -> Word32
    -> Ptr ()
    -> IO ()

type C_ClientEventResultCallback =
    Ptr Client ->                           -- object
    Ptr GObject.Object.Object ->
    CString ->
    Ptr GVariant ->
    Word32 ->
    Ptr () ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ClientEventResultCallback`.
foreign import ccall "wrapper"
    mk_ClientEventResultCallback :: C_ClientEventResultCallback -> IO (FunPtr C_ClientEventResultCallback)

wrap_ClientEventResultCallback :: 
    GObject a => (a -> ClientEventResultCallback) ->
    C_ClientEventResultCallback
wrap_ClientEventResultCallback gi'cb gi'selfPtr object p0 p1 p2 p3 _ = do
    object' <- (newObject GObject.Object.Object) object
    p0' <- cstringToText p0
    p1' <- B.GVariant.newGVariantFromPtr p1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  object' p0' p1' p2 p3


-- | Connect a signal handler for the [eventResult](#signal:eventResult) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' client #eventResult callback
-- @
-- 
-- 
onClientEventResult :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientEventResultCallback) -> m SignalHandlerId
onClientEventResult obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientEventResultCallback wrapped
    wrapped'' <- mk_ClientEventResultCallback wrapped'
    connectSignalFunPtr obj "event-result" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [eventResult](#signal:eventResult) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' client #eventResult callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterClientEventResult :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientEventResultCallback) -> m SignalHandlerId
afterClientEventResult obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientEventResultCallback wrapped
    wrapped'' <- mk_ClientEventResultCallback wrapped'
    connectSignalFunPtr obj "event-result" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ClientEventResultSignalInfo
instance SignalInfo ClientEventResultSignalInfo where
    type HaskellCallbackType ClientEventResultSignalInfo = ClientEventResultCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ClientEventResultCallback cb
        cb'' <- mk_ClientEventResultCallback cb'
        connectSignalFunPtr obj "event-result" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client::event-result"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:signal:eventResult"})

#endif

-- signal Client::icon-theme-dirs-changed
-- | Signaled when the theme directories are changed by the server.
type ClientIconThemeDirsChangedCallback =
    Ptr ()
    -- ^ /@arg1@/: A @/GStrv/@ of theme directories
    -> IO ()

type C_ClientIconThemeDirsChangedCallback =
    Ptr Client ->                           -- object
    Ptr () ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ClientIconThemeDirsChangedCallback`.
foreign import ccall "wrapper"
    mk_ClientIconThemeDirsChangedCallback :: C_ClientIconThemeDirsChangedCallback -> IO (FunPtr C_ClientIconThemeDirsChangedCallback)

wrap_ClientIconThemeDirsChangedCallback :: 
    GObject a => (a -> ClientIconThemeDirsChangedCallback) ->
    C_ClientIconThemeDirsChangedCallback
wrap_ClientIconThemeDirsChangedCallback gi'cb gi'selfPtr arg1 _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1


-- | Connect a signal handler for the [iconThemeDirsChanged](#signal:iconThemeDirsChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' client #iconThemeDirsChanged callback
-- @
-- 
-- 
onClientIconThemeDirsChanged :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientIconThemeDirsChangedCallback) -> m SignalHandlerId
onClientIconThemeDirsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientIconThemeDirsChangedCallback wrapped
    wrapped'' <- mk_ClientIconThemeDirsChangedCallback wrapped'
    connectSignalFunPtr obj "icon-theme-dirs-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [iconThemeDirsChanged](#signal:iconThemeDirsChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' client #iconThemeDirsChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterClientIconThemeDirsChanged :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientIconThemeDirsChangedCallback) -> m SignalHandlerId
afterClientIconThemeDirsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientIconThemeDirsChangedCallback wrapped
    wrapped'' <- mk_ClientIconThemeDirsChangedCallback wrapped'
    connectSignalFunPtr obj "icon-theme-dirs-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ClientIconThemeDirsChangedSignalInfo
instance SignalInfo ClientIconThemeDirsChangedSignalInfo where
    type HaskellCallbackType ClientIconThemeDirsChangedSignalInfo = ClientIconThemeDirsChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ClientIconThemeDirsChangedCallback cb
        cb'' <- mk_ClientIconThemeDirsChangedCallback cb'
        connectSignalFunPtr obj "icon-theme-dirs-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client::icon-theme-dirs-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:signal:iconThemeDirsChanged"})

#endif

-- signal Client::item-activate
-- | Signaled when the server wants to activate an item in
-- 		order to display the menu.
type ClientItemActivateCallback =
    GObject.Object.Object
    -- ^ /@arg1@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' activated
    -> Word32
    -- ^ /@arg2@/: A timestamp that the event happened at
    -> IO ()

type C_ClientItemActivateCallback =
    Ptr Client ->                           -- object
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ClientItemActivateCallback`.
foreign import ccall "wrapper"
    mk_ClientItemActivateCallback :: C_ClientItemActivateCallback -> IO (FunPtr C_ClientItemActivateCallback)

wrap_ClientItemActivateCallback :: 
    GObject a => (a -> ClientItemActivateCallback) ->
    C_ClientItemActivateCallback
wrap_ClientItemActivateCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    arg1' <- (newObject GObject.Object.Object) arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2


-- | Connect a signal handler for the [itemActivate](#signal:itemActivate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' client #itemActivate callback
-- @
-- 
-- 
onClientItemActivate :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientItemActivateCallback) -> m SignalHandlerId
onClientItemActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientItemActivateCallback wrapped
    wrapped'' <- mk_ClientItemActivateCallback wrapped'
    connectSignalFunPtr obj "item-activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [itemActivate](#signal:itemActivate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' client #itemActivate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterClientItemActivate :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientItemActivateCallback) -> m SignalHandlerId
afterClientItemActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientItemActivateCallback wrapped
    wrapped'' <- mk_ClientItemActivateCallback wrapped'
    connectSignalFunPtr obj "item-activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ClientItemActivateSignalInfo
instance SignalInfo ClientItemActivateSignalInfo where
    type HaskellCallbackType ClientItemActivateSignalInfo = ClientItemActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ClientItemActivateCallback cb
        cb'' <- mk_ClientItemActivateCallback cb'
        connectSignalFunPtr obj "item-activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client::item-activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:signal:itemActivate"})

#endif

-- signal Client::layout-updated
-- | /No description available in the introspection data./
type ClientLayoutUpdatedCallback =
    IO ()

type C_ClientLayoutUpdatedCallback =
    Ptr Client ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ClientLayoutUpdatedCallback`.
foreign import ccall "wrapper"
    mk_ClientLayoutUpdatedCallback :: C_ClientLayoutUpdatedCallback -> IO (FunPtr C_ClientLayoutUpdatedCallback)

wrap_ClientLayoutUpdatedCallback :: 
    GObject a => (a -> ClientLayoutUpdatedCallback) ->
    C_ClientLayoutUpdatedCallback
wrap_ClientLayoutUpdatedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [layoutUpdated](#signal:layoutUpdated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' client #layoutUpdated callback
-- @
-- 
-- 
onClientLayoutUpdated :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientLayoutUpdatedCallback) -> m SignalHandlerId
onClientLayoutUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientLayoutUpdatedCallback wrapped
    wrapped'' <- mk_ClientLayoutUpdatedCallback wrapped'
    connectSignalFunPtr obj "layout-updated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [layoutUpdated](#signal:layoutUpdated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' client #layoutUpdated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterClientLayoutUpdated :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientLayoutUpdatedCallback) -> m SignalHandlerId
afterClientLayoutUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientLayoutUpdatedCallback wrapped
    wrapped'' <- mk_ClientLayoutUpdatedCallback wrapped'
    connectSignalFunPtr obj "layout-updated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ClientLayoutUpdatedSignalInfo
instance SignalInfo ClientLayoutUpdatedSignalInfo where
    type HaskellCallbackType ClientLayoutUpdatedSignalInfo = ClientLayoutUpdatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ClientLayoutUpdatedCallback cb
        cb'' <- mk_ClientLayoutUpdatedCallback cb'
        connectSignalFunPtr obj "layout-updated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client::layout-updated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:signal:layoutUpdated"})

#endif

-- signal Client::new-menuitem
-- | Signaled when the client creates a new menuitem.  This
-- 		doesn\'t mean that it\'s placed anywhere.  The parent that
-- 		it\'s applied to will signal [Menuitem::childAdded]("GI.Dbusmenu.Objects.Menuitem#g:signal:childAdded")
-- 		when it gets parented.
type ClientNewMenuitemCallback =
    GObject.Object.Object
    -- ^ /@arg1@/: The new t'GI.Dbusmenu.Objects.Menuitem.Menuitem' created
    -> IO ()

type C_ClientNewMenuitemCallback =
    Ptr Client ->                           -- object
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ClientNewMenuitemCallback`.
foreign import ccall "wrapper"
    mk_ClientNewMenuitemCallback :: C_ClientNewMenuitemCallback -> IO (FunPtr C_ClientNewMenuitemCallback)

wrap_ClientNewMenuitemCallback :: 
    GObject a => (a -> ClientNewMenuitemCallback) ->
    C_ClientNewMenuitemCallback
wrap_ClientNewMenuitemCallback gi'cb gi'selfPtr arg1 _ = do
    arg1' <- (newObject GObject.Object.Object) arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1'


-- | Connect a signal handler for the [newMenuitem](#signal:newMenuitem) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' client #newMenuitem callback
-- @
-- 
-- 
onClientNewMenuitem :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientNewMenuitemCallback) -> m SignalHandlerId
onClientNewMenuitem obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientNewMenuitemCallback wrapped
    wrapped'' <- mk_ClientNewMenuitemCallback wrapped'
    connectSignalFunPtr obj "new-menuitem" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [newMenuitem](#signal:newMenuitem) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' client #newMenuitem callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterClientNewMenuitem :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientNewMenuitemCallback) -> m SignalHandlerId
afterClientNewMenuitem obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientNewMenuitemCallback wrapped
    wrapped'' <- mk_ClientNewMenuitemCallback wrapped'
    connectSignalFunPtr obj "new-menuitem" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ClientNewMenuitemSignalInfo
instance SignalInfo ClientNewMenuitemSignalInfo where
    type HaskellCallbackType ClientNewMenuitemSignalInfo = ClientNewMenuitemCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ClientNewMenuitemCallback cb
        cb'' <- mk_ClientNewMenuitemCallback cb'
        connectSignalFunPtr obj "new-menuitem" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client::new-menuitem"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:signal:newMenuitem"})

#endif

-- signal Client::root-changed
-- | The layout has changed in a way that can not be
-- 		represented by the individual items changing as the
-- 		root of this client has changed.
type ClientRootChangedCallback =
    GObject.Object.Object
    -- ^ /@arg1@/: The new root t'GI.Dbusmenu.Objects.Menuitem.Menuitem'
    -> IO ()

type C_ClientRootChangedCallback =
    Ptr Client ->                           -- object
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ClientRootChangedCallback`.
foreign import ccall "wrapper"
    mk_ClientRootChangedCallback :: C_ClientRootChangedCallback -> IO (FunPtr C_ClientRootChangedCallback)

wrap_ClientRootChangedCallback :: 
    GObject a => (a -> ClientRootChangedCallback) ->
    C_ClientRootChangedCallback
wrap_ClientRootChangedCallback gi'cb gi'selfPtr arg1 _ = do
    arg1' <- (newObject GObject.Object.Object) arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1'


-- | Connect a signal handler for the [rootChanged](#signal:rootChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' client #rootChanged callback
-- @
-- 
-- 
onClientRootChanged :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientRootChangedCallback) -> m SignalHandlerId
onClientRootChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientRootChangedCallback wrapped
    wrapped'' <- mk_ClientRootChangedCallback wrapped'
    connectSignalFunPtr obj "root-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [rootChanged](#signal:rootChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' client #rootChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterClientRootChanged :: (IsClient a, MonadIO m) => a -> ((?self :: a) => ClientRootChangedCallback) -> m SignalHandlerId
afterClientRootChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ClientRootChangedCallback wrapped
    wrapped'' <- mk_ClientRootChangedCallback wrapped'
    connectSignalFunPtr obj "root-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ClientRootChangedSignalInfo
instance SignalInfo ClientRootChangedSignalInfo where
    type HaskellCallbackType ClientRootChangedSignalInfo = ClientRootChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ClientRootChangedCallback cb
        cb'' <- mk_ClientRootChangedCallback cb'
        connectSignalFunPtr obj "root-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client::root-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:signal:rootChanged"})

#endif

-- VVV Prop "dbus-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@dbus-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' client #dbusName
-- @
getClientDbusName :: (MonadIO m, IsClient o) => o -> m (Maybe T.Text)
getClientDbusName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "dbus-name"

-- | Construct a t'GValueConstruct' with valid value for the “@dbus-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructClientDbusName :: (IsClient o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructClientDbusName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "dbus-name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ClientDbusNamePropertyInfo
instance AttrInfo ClientDbusNamePropertyInfo where
    type AttrAllowedOps ClientDbusNamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ClientDbusNamePropertyInfo = IsClient
    type AttrSetTypeConstraint ClientDbusNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ClientDbusNamePropertyInfo = (~) T.Text
    type AttrTransferType ClientDbusNamePropertyInfo = T.Text
    type AttrGetType ClientDbusNamePropertyInfo = (Maybe T.Text)
    type AttrLabel ClientDbusNamePropertyInfo = "dbus-name"
    type AttrOrigin ClientDbusNamePropertyInfo = Client
    attrGet = getClientDbusName
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructClientDbusName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.dbusName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:attr:dbusName"
        })
#endif

-- VVV Prop "dbus-object"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@dbus-object@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' client #dbusObject
-- @
getClientDbusObject :: (MonadIO m, IsClient o) => o -> m (Maybe T.Text)
getClientDbusObject obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "dbus-object"

-- | Construct a t'GValueConstruct' with valid value for the “@dbus-object@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructClientDbusObject :: (IsClient o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructClientDbusObject val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "dbus-object" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ClientDbusObjectPropertyInfo
instance AttrInfo ClientDbusObjectPropertyInfo where
    type AttrAllowedOps ClientDbusObjectPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ClientDbusObjectPropertyInfo = IsClient
    type AttrSetTypeConstraint ClientDbusObjectPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ClientDbusObjectPropertyInfo = (~) T.Text
    type AttrTransferType ClientDbusObjectPropertyInfo = T.Text
    type AttrGetType ClientDbusObjectPropertyInfo = (Maybe T.Text)
    type AttrLabel ClientDbusObjectPropertyInfo = "dbus-object"
    type AttrOrigin ClientDbusObjectPropertyInfo = Client
    attrGet = getClientDbusObject
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructClientDbusObject
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.dbusObject"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:attr:dbusObject"
        })
#endif

-- VVV Prop "group-events"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@group-events@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' client #groupEvents
-- @
getClientGroupEvents :: (MonadIO m, IsClient o) => o -> m Bool
getClientGroupEvents obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "group-events"

-- | Set the value of the “@group-events@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' client [ #groupEvents 'Data.GI.Base.Attributes.:=' value ]
-- @
setClientGroupEvents :: (MonadIO m, IsClient o) => o -> Bool -> m ()
setClientGroupEvents obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "group-events" val

-- | Construct a t'GValueConstruct' with valid value for the “@group-events@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructClientGroupEvents :: (IsClient o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructClientGroupEvents val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "group-events" val

#if defined(ENABLE_OVERLOADING)
data ClientGroupEventsPropertyInfo
instance AttrInfo ClientGroupEventsPropertyInfo where
    type AttrAllowedOps ClientGroupEventsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ClientGroupEventsPropertyInfo = IsClient
    type AttrSetTypeConstraint ClientGroupEventsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ClientGroupEventsPropertyInfo = (~) Bool
    type AttrTransferType ClientGroupEventsPropertyInfo = Bool
    type AttrGetType ClientGroupEventsPropertyInfo = Bool
    type AttrLabel ClientGroupEventsPropertyInfo = "group-events"
    type AttrOrigin ClientGroupEventsPropertyInfo = Client
    attrGet = getClientGroupEvents
    attrSet = setClientGroupEvents
    attrTransfer _ v = do
        return v
    attrConstruct = constructClientGroupEvents
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.groupEvents"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#g:attr:groupEvents"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Client
type instance O.AttributeList Client = ClientAttributeList
type ClientAttributeList = ('[ '("dbusName", ClientDbusNamePropertyInfo), '("dbusObject", ClientDbusObjectPropertyInfo), '("groupEvents", ClientGroupEventsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
clientDbusName :: AttrLabelProxy "dbusName"
clientDbusName = AttrLabelProxy

clientDbusObject :: AttrLabelProxy "dbusObject"
clientDbusObject = AttrLabelProxy

clientGroupEvents :: AttrLabelProxy "groupEvents"
clientGroupEvents = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Client = ClientSignalList
type ClientSignalList = ('[ '("eventResult", ClientEventResultSignalInfo), '("iconThemeDirsChanged", ClientIconThemeDirsChangedSignalInfo), '("itemActivate", ClientItemActivateSignalInfo), '("layoutUpdated", ClientLayoutUpdatedSignalInfo), '("newMenuitem", ClientNewMenuitemSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("rootChanged", ClientRootChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Client::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The DBus name for the server to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The object on the server to monitor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Dbusmenu" , name = "Client" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_client_new" dbusmenu_client_new :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- object : TBasicType TUTF8
    IO (Ptr Client)

-- | This function creates a new client that connects to a specific
-- server on DBus.  That server is at a specific location sharing
-- a known object.  The interface is assumed by the code to be
-- the DBus menu interface.  The newly created client will start
-- sending out events as it syncs up with the server.
clientNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: The DBus name for the server to connect to
    -> T.Text
    -- ^ /@object@/: The object on the server to monitor
    -> m Client
    -- ^ __Returns:__ A brand new t'GI.Dbusmenu.Objects.Client.Client'
clientNew name object = liftIO $ do
    name' <- textToCString name
    object' <- textToCString object
    result <- dbusmenu_client_new name' object'
    checkUnexpectedReturnNULL "clientNew" result
    result' <- (wrapObject Client) result
    freeMem name'
    freeMem object'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Client::add_type_handler
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Client where we're getting types coming in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A text string that will be matched with the 'type'\n    property on incoming menu items"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "newfunc"
--           , argType =
--               TInterface
--                 Name { namespace = "Dbusmenu" , name = "ClientTypeHandler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The function that will be executed with those new\n    items when they come in."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_client_add_type_handler" dbusmenu_client_add_type_handler :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "Dbusmenu", name = "Client"})
    CString ->                              -- type : TBasicType TUTF8
    FunPtr Dbusmenu.Callbacks.C_ClientTypeHandler -> -- newfunc : TInterface (Name {namespace = "Dbusmenu", name = "ClientTypeHandler"})
    IO CInt

-- | This function connects into the type handling of the t'GI.Dbusmenu.Objects.Client.Client'.
-- Every new menuitem that comes in immediately gets asked for its
-- properties.  When we get those properties we check the \'type\'
-- property and look to see if it matches a handler that is known
-- by the client.  If so, the /@newfunc@/ function is executed on that
-- t'GI.Dbusmenu.Objects.Menuitem.Menuitem'.  If not, then the DbusmenuClient[newMenuitem](#g:signal:newMenuitem)
-- signal is sent.
-- 
-- In the future the known types will be sent to the server so that it
-- can make choices about the menu item types availble.
clientAddTypeHandler ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a) =>
    a
    -- ^ /@client@/: Client where we\'re getting types coming in
    -> T.Text
    -- ^ /@type@/: A text string that will be matched with the \'type\'
    --     property on incoming menu items
    -> Dbusmenu.Callbacks.ClientTypeHandler
    -- ^ /@newfunc@/: The function that will be executed with those new
    --     items when they come in.
    -> m Bool
    -- ^ __Returns:__ If registering the new type was successful.
clientAddTypeHandler client type_ newfunc = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    type_' <- textToCString type_
    newfunc' <- Dbusmenu.Callbacks.mk_ClientTypeHandler (Dbusmenu.Callbacks.wrap_ClientTypeHandler Nothing (Dbusmenu.Callbacks.drop_closures_ClientTypeHandler newfunc))
    result <- dbusmenu_client_add_type_handler client' type_' newfunc'
    let result' = (/= 0) result
    touchManagedPtr client
    freeMem type_'
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientAddTypeHandlerMethodInfo
instance (signature ~ (T.Text -> Dbusmenu.Callbacks.ClientTypeHandler -> m Bool), MonadIO m, IsClient a) => O.OverloadedMethod ClientAddTypeHandlerMethodInfo a signature where
    overloadedMethod = clientAddTypeHandler

instance O.OverloadedMethodInfo ClientAddTypeHandlerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.clientAddTypeHandler",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#v:clientAddTypeHandler"
        })


#endif

-- method Client::add_type_handler_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Client where we're getting types coming in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A text string that will be matched with the 'type'\n    property on incoming menu items"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "newfunc"
--           , argType =
--               TInterface
--                 Name { namespace = "Dbusmenu" , name = "ClientTypeHandler" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The function that will be executed with those new\n    items when they come in."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Data passed to @newfunc when it is called"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A function that is called when the type handler is\n\tremoved (usually on client destruction) which will free\n\tthe resources in @user_data."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_client_add_type_handler_full" dbusmenu_client_add_type_handler_full :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "Dbusmenu", name = "Client"})
    CString ->                              -- type : TBasicType TUTF8
    FunPtr Dbusmenu.Callbacks.C_ClientTypeHandler -> -- newfunc : TInterface (Name {namespace = "Dbusmenu", name = "ClientTypeHandler"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO CInt

-- | This function connects into the type handling of the t'GI.Dbusmenu.Objects.Client.Client'.
-- Every new menuitem that comes in immediately gets asked for its
-- properties.  When we get those properties we check the \'type\'
-- property and look to see if it matches a handler that is known
-- by the client.  If so, the /@newfunc@/ function is executed on that
-- t'GI.Dbusmenu.Objects.Menuitem.Menuitem'.  If not, then the DbusmenuClient[newMenuitem](#g:signal:newMenuitem)
-- signal is sent.
-- 
-- In the future the known types will be sent to the server so that it
-- can make choices about the menu item types availble.
clientAddTypeHandlerFull ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a) =>
    a
    -- ^ /@client@/: Client where we\'re getting types coming in
    -> T.Text
    -- ^ /@type@/: A text string that will be matched with the \'type\'
    --     property on incoming menu items
    -> Dbusmenu.Callbacks.ClientTypeHandler
    -- ^ /@newfunc@/: The function that will be executed with those new
    --     items when they come in.
    -> m Bool
    -- ^ __Returns:__ If registering the new type was successful.
clientAddTypeHandlerFull client type_ newfunc = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    type_' <- textToCString type_
    newfunc' <- Dbusmenu.Callbacks.mk_ClientTypeHandler (Dbusmenu.Callbacks.wrap_ClientTypeHandler Nothing (Dbusmenu.Callbacks.drop_closures_ClientTypeHandler newfunc))
    let userData = castFunPtrToPtr newfunc'
    let destroyFunc = SP.safeFreeFunPtrPtr
    result <- dbusmenu_client_add_type_handler_full client' type_' newfunc' userData destroyFunc
    let result' = (/= 0) result
    touchManagedPtr client
    freeMem type_'
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientAddTypeHandlerFullMethodInfo
instance (signature ~ (T.Text -> Dbusmenu.Callbacks.ClientTypeHandler -> m Bool), MonadIO m, IsClient a) => O.OverloadedMethod ClientAddTypeHandlerFullMethodInfo a signature where
    overloadedMethod = clientAddTypeHandlerFull

instance O.OverloadedMethodInfo ClientAddTypeHandlerFullMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.clientAddTypeHandlerFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#v:clientAddTypeHandlerFull"
        })


#endif

-- method Client::get_icon_paths
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuClient to get the icon paths from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_client_get_icon_paths" dbusmenu_client_get_icon_paths :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "Dbusmenu", name = "Client"})
    IO (Ptr CString)

-- | Gets the stored and exported icon paths from the client.
clientGetIconPaths ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a) =>
    a
    -- ^ /@client@/: The t'GI.Dbusmenu.Objects.Client.Client' to get the icon paths from
    -> m [T.Text]
    -- ^ __Returns:__ A NULL-terminated list of icon paths with
    --   memory managed by the client.  Duplicate if you want
    --   to keep them.
clientGetIconPaths client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- dbusmenu_client_get_icon_paths client'
    checkUnexpectedReturnNULL "clientGetIconPaths" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientGetIconPathsMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsClient a) => O.OverloadedMethod ClientGetIconPathsMethodInfo a signature where
    overloadedMethod = clientGetIconPaths

instance O.OverloadedMethodInfo ClientGetIconPathsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.clientGetIconPaths",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#v:clientGetIconPaths"
        })


#endif

-- method Client::get_root
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuClient to get the root node from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_client_get_root" dbusmenu_client_get_root :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "Dbusmenu", name = "Client"})
    IO (Ptr Dbusmenu.Menuitem.Menuitem)

-- | Grabs the root node for the specified client /@client@/.  This
-- function may block.  It will block if there is currently a
-- call to update the layout, it will block on that layout
-- updated and then return the newly updated layout.  Chances
-- are that this update is in the queue for the mainloop as
-- it would have been requested some time ago, but in theory
-- it could block longer.
clientGetRoot ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a) =>
    a
    -- ^ /@client@/: The t'GI.Dbusmenu.Objects.Client.Client' to get the root node from
    -> m Dbusmenu.Menuitem.Menuitem
    -- ^ __Returns:__ A t'GI.Dbusmenu.Objects.Menuitem.Menuitem' representing the root of
    -- 	menu on the server.  If there is no server or there is
    -- 	an error receiving its layout it\'ll return @/NULL/@.
clientGetRoot client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- dbusmenu_client_get_root client'
    checkUnexpectedReturnNULL "clientGetRoot" result
    result' <- (newObject Dbusmenu.Menuitem.Menuitem) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientGetRootMethodInfo
instance (signature ~ (m Dbusmenu.Menuitem.Menuitem), MonadIO m, IsClient a) => O.OverloadedMethod ClientGetRootMethodInfo a signature where
    overloadedMethod = clientGetRoot

instance O.OverloadedMethodInfo ClientGetRootMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.clientGetRoot",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#v:clientGetRoot"
        })


#endif

-- method Client::get_status
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#DbusmenuClient to check the status on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Dbusmenu" , name = "Status" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_client_get_status" dbusmenu_client_get_status :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "Dbusmenu", name = "Client"})
    IO CUInt

-- | Gets the recommended current status that the server
-- 	is exporting for the menus.  In situtations where the
-- 	value is @/DBUSMENU_STATUS_NOTICE/@ it is recommended that
-- 	the client show the menus to the user an a more noticible
-- 	way.
-- 
-- 	Return value: Status being exported.
clientGetStatus ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a) =>
    a
    -- ^ /@client@/: t'GI.Dbusmenu.Objects.Client.Client' to check the status on
    -> m Dbusmenu.Enums.Status
clientGetStatus client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- dbusmenu_client_get_status client'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientGetStatusMethodInfo
instance (signature ~ (m Dbusmenu.Enums.Status), MonadIO m, IsClient a) => O.OverloadedMethod ClientGetStatusMethodInfo a signature where
    overloadedMethod = clientGetStatus

instance O.OverloadedMethodInfo ClientGetStatusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.clientGetStatus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#v:clientGetStatus"
        })


#endif

-- method Client::get_text_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Client" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#DbusmenuClient to check the text direction on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Dbusmenu" , name = "TextDirection" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_client_get_text_direction" dbusmenu_client_get_text_direction :: 
    Ptr Client ->                           -- client : TInterface (Name {namespace = "Dbusmenu", name = "Client"})
    IO CUInt

-- | Gets the text direction that the server is exporting.  If
-- 	the server is not exporting a direction then the value
-- 	@/DBUSMENU_TEXT_DIRECTION_NONE/@ will be returned.
-- 
-- 	Return value: Text direction being exported.
clientGetTextDirection ::
    (B.CallStack.HasCallStack, MonadIO m, IsClient a) =>
    a
    -- ^ /@client@/: t'GI.Dbusmenu.Objects.Client.Client' to check the text direction on
    -> m Dbusmenu.Enums.TextDirection
clientGetTextDirection client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- dbusmenu_client_get_text_direction client'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data ClientGetTextDirectionMethodInfo
instance (signature ~ (m Dbusmenu.Enums.TextDirection), MonadIO m, IsClient a) => O.OverloadedMethod ClientGetTextDirectionMethodInfo a signature where
    overloadedMethod = clientGetTextDirection

instance O.OverloadedMethodInfo ClientGetTextDirectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Client.clientGetTextDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Client.html#v:clientGetTextDirection"
        })


#endif


