//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: contrib/envoy/extensions/matching/input_matchers/hyperscan/v3alpha/hyperscan.proto

package v3alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Hyperscan with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Hyperscan) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Hyperscan with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HyperscanMultiError, or nil
// if none found.
func (m *Hyperscan) ValidateAll() error {
	return m.validate(true)
}

func (m *Hyperscan) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRegexes()) < 1 {
		err := HyperscanValidationError{
			field:  "Regexes",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRegexes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HyperscanValidationError{
						field:  fmt.Sprintf("Regexes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HyperscanValidationError{
						field:  fmt.Sprintf("Regexes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HyperscanValidationError{
					field:  fmt.Sprintf("Regexes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return HyperscanMultiError(errors)
	}

	return nil
}

// HyperscanMultiError is an error wrapping multiple validation errors returned
// by Hyperscan.ValidateAll() if the designated constraints aren't met.
type HyperscanMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HyperscanMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HyperscanMultiError) AllErrors() []error { return m }

// HyperscanValidationError is the validation error returned by
// Hyperscan.Validate if the designated constraints aren't met.
type HyperscanValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HyperscanValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HyperscanValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HyperscanValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HyperscanValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HyperscanValidationError) ErrorName() string { return "HyperscanValidationError" }

// Error satisfies the builtin error interface
func (e HyperscanValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHyperscan.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HyperscanValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HyperscanValidationError{}

// Validate checks the field values on Hyperscan_Regex with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *Hyperscan_Regex) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Hyperscan_Regex with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Hyperscan_RegexMultiError, or nil if none found.
func (m *Hyperscan_Regex) ValidateAll() error {
	return m.validate(true)
}

func (m *Hyperscan_Regex) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetRegex()) < 1 {
		err := Hyperscan_RegexValidationError{
			field:  "Regex",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Id

	// no validation rules for Caseless

	// no validation rules for DotAll

	// no validation rules for Multiline

	// no validation rules for AllowEmpty

	// no validation rules for Utf8

	// no validation rules for Ucp

	// no validation rules for Combination

	// no validation rules for Quiet

	if len(errors) > 0 {
		return Hyperscan_RegexMultiError(errors)
	}

	return nil
}

// Hyperscan_RegexMultiError is an error wrapping multiple validation errors
// returned by Hyperscan_Regex.ValidateAll() if the designated constraints
// aren't met.
type Hyperscan_RegexMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Hyperscan_RegexMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Hyperscan_RegexMultiError) AllErrors() []error { return m }

// Hyperscan_RegexValidationError is the validation error returned by
// Hyperscan_Regex.Validate if the designated constraints aren't met.
type Hyperscan_RegexValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Hyperscan_RegexValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Hyperscan_RegexValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Hyperscan_RegexValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Hyperscan_RegexValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Hyperscan_RegexValidationError) ErrorName() string { return "Hyperscan_RegexValidationError" }

// Error satisfies the builtin error interface
func (e Hyperscan_RegexValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHyperscan_Regex.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Hyperscan_RegexValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Hyperscan_RegexValidationError{}
