// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: envoy/config/core/v3/protocol.proto

package corev3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/cncf/xds/go/xds/annotations/v3"
	_ "github.com/envoyproxy/go-control-plane/envoy/annotations"
	v3 "github.com/envoyproxy/go-control-plane/envoy/type/matcher/v3"
	v31 "github.com/envoyproxy/go-control-plane/envoy/type/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Action to take when Envoy receives client request with header names containing underscore
// characters.
// Underscore character is allowed in header names by the RFC-7230 and this behavior is implemented
// as a security measure due to systems that treat '_' and '-' as interchangeable. Envoy by default allows client request headers with underscore
// characters.
type HttpProtocolOptions_HeadersWithUnderscoresAction int32

const (
	// Allow headers with underscores. This is the default behavior.
	HttpProtocolOptions_ALLOW HttpProtocolOptions_HeadersWithUnderscoresAction = 0
	// Reject client request. HTTP/1 requests are rejected with “HTTP 400“ status. HTTP/2 requests
	// end with the stream reset. The “httpN.requests_rejected_with_underscores_in_headers“ counter
	// is incremented for each rejected request.
	HttpProtocolOptions_REJECT_REQUEST HttpProtocolOptions_HeadersWithUnderscoresAction = 1
	// Drop the client header with name containing underscores. The header is dropped before the filter chain is
	// invoked and as such filters will not see dropped headers. The
	// “httpN.dropped_headers_with_underscores“ is incremented for each dropped header.
	HttpProtocolOptions_DROP_HEADER HttpProtocolOptions_HeadersWithUnderscoresAction = 2
)

// Enum value maps for HttpProtocolOptions_HeadersWithUnderscoresAction.
var (
	HttpProtocolOptions_HeadersWithUnderscoresAction_name = map[int32]string{
		0: "ALLOW",
		1: "REJECT_REQUEST",
		2: "DROP_HEADER",
	}
	HttpProtocolOptions_HeadersWithUnderscoresAction_value = map[string]int32{
		"ALLOW":          0,
		"REJECT_REQUEST": 1,
		"DROP_HEADER":    2,
	}
)

func (x HttpProtocolOptions_HeadersWithUnderscoresAction) Enum() *HttpProtocolOptions_HeadersWithUnderscoresAction {
	p := new(HttpProtocolOptions_HeadersWithUnderscoresAction)
	*p = x
	return p
}

func (x HttpProtocolOptions_HeadersWithUnderscoresAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpProtocolOptions_HeadersWithUnderscoresAction) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_core_v3_protocol_proto_enumTypes[0].Descriptor()
}

func (HttpProtocolOptions_HeadersWithUnderscoresAction) Type() protoreflect.EnumType {
	return &file_envoy_config_core_v3_protocol_proto_enumTypes[0]
}

func (x HttpProtocolOptions_HeadersWithUnderscoresAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpProtocolOptions_HeadersWithUnderscoresAction.Descriptor instead.
func (HttpProtocolOptions_HeadersWithUnderscoresAction) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{5, 0}
}

// [#not-implemented-hide:]
type TcpProtocolOptions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TcpProtocolOptions) Reset() {
	*x = TcpProtocolOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProtocolOptions) ProtoMessage() {}

func (x *TcpProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProtocolOptions.ProtoReflect.Descriptor instead.
func (*TcpProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{0}
}

// Config for keepalive probes in a QUIC connection.
//
// .. note::
//
//	QUIC keep-alive probing packets work differently from HTTP/2 keep-alive PINGs in a sense that the probing packet
//	itself doesn't timeout waiting for a probing response. QUIC has a shorter idle timeout than TCP, so it doesn't rely on such probing to discover dead connections. If the peer fails to respond, the connection will idle timeout eventually. Thus, they are configured differently from :ref:`connection_keepalive <envoy_v3_api_field_config.core.v3.Http2ProtocolOptions.connection_keepalive>`.
type QuicKeepAliveSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The max interval for a connection to send keep-alive probing packets (with “PING“ or “PATH_RESPONSE“). The value should be smaller than :ref:`connection idle_timeout <envoy_v3_api_field_config.listener.v3.QuicProtocolOptions.idle_timeout>` to prevent idle timeout while not less than “1s“ to avoid throttling the connection or flooding the peer with probes.
	//
	// If :ref:`initial_interval <envoy_v3_api_field_config.core.v3.QuicKeepAliveSettings.initial_interval>` is absent or zero, a client connection will use this value to start probing.
	//
	// If zero, disable keepalive probing.
	// If absent, use the QUICHE default interval to probe.
	MaxInterval *durationpb.Duration `protobuf:"bytes,1,opt,name=max_interval,json=maxInterval,proto3" json:"max_interval,omitempty"`
	// The interval to send the first few keep-alive probing packets to prevent connection from hitting the idle timeout. Subsequent probes will be sent, each one with an interval exponentially longer than previous one, till it reaches :ref:`max_interval <envoy_v3_api_field_config.core.v3.QuicKeepAliveSettings.max_interval>`. And the probes afterwards will always use :ref:`max_interval <envoy_v3_api_field_config.core.v3.QuicKeepAliveSettings.max_interval>`.
	//
	// The value should be smaller than :ref:`connection idle_timeout <envoy_v3_api_field_config.listener.v3.QuicProtocolOptions.idle_timeout>` to prevent idle timeout and smaller than max_interval to take effect.
	//
	// If absent, disable keepalive probing for a server connection. For a client connection, if :ref:`max_interval <envoy_v3_api_field_config.core.v3.QuicKeepAliveSettings.max_interval>` is zero, do not keepalive, otherwise use max_interval or QUICHE default to probe all the time.
	InitialInterval *durationpb.Duration `protobuf:"bytes,2,opt,name=initial_interval,json=initialInterval,proto3" json:"initial_interval,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *QuicKeepAliveSettings) Reset() {
	*x = QuicKeepAliveSettings{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuicKeepAliveSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuicKeepAliveSettings) ProtoMessage() {}

func (x *QuicKeepAliveSettings) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuicKeepAliveSettings.ProtoReflect.Descriptor instead.
func (*QuicKeepAliveSettings) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{1}
}

func (x *QuicKeepAliveSettings) GetMaxInterval() *durationpb.Duration {
	if x != nil {
		return x.MaxInterval
	}
	return nil
}

func (x *QuicKeepAliveSettings) GetInitialInterval() *durationpb.Duration {
	if x != nil {
		return x.InitialInterval
	}
	return nil
}

// QUIC protocol options which apply to both downstream and upstream connections.
// [#next-free-field: 12]
type QuicProtocolOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Maximum number of streams that the client can negotiate per connection. “100“
	// if not specified.
	MaxConcurrentStreams *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=max_concurrent_streams,json=maxConcurrentStreams,proto3" json:"max_concurrent_streams,omitempty"`
	// `Initial stream-level flow-control receive window
	// <https://tools.ietf.org/html/draft-ietf-quic-transport-34#section-4.1>`_ size. Valid values range from
	// “1“ to “16777216“ (“2^24“, maximum supported by QUICHE) and defaults to “16777216“ (“16 * 1024 * 1024“).
	//
	// .. note::
	//
	//	``16384`` (``2^14``) is the minimum window size supported in Google QUIC. If configured smaller than it, we will use
	//	``16384`` instead. QUICHE IETF QUIC implementation supports ``1`` byte window. We only support increasing the default
	//	window size now, so it's also the minimum.
	//
	// This field also acts as a soft limit on the number of bytes Envoy will buffer per-stream in the
	// QUIC stream send and receive buffers. Once the buffer reaches this pointer, watermark callbacks will fire to
	// stop the flow of data to the stream buffers.
	InitialStreamWindowSize *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=initial_stream_window_size,json=initialStreamWindowSize,proto3" json:"initial_stream_window_size,omitempty"`
	// Similar to “initial_stream_window_size“, but for connection-level
	// flow-control. Valid values range from “1“ to “25165824“ (“24MB“, maximum supported by QUICHE) and defaults
	// to “25165824“ (“24 * 1024 * 1024“).
	//
	// .. note::
	//
	//	``16384`` (``2^14``) is the minimum window size supported in Google QUIC. We only support increasing the default
	//	window size now, so it's also the minimum.
	InitialConnectionWindowSize *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=initial_connection_window_size,json=initialConnectionWindowSize,proto3" json:"initial_connection_window_size,omitempty"`
	// The number of timeouts that can occur before port migration is triggered for QUIC clients.
	// This defaults to “4“. If set to “0“, port migration will not occur on path degrading.
	// Timeout here refers to QUIC internal path degrading timeout mechanism, such as “PTO“.
	// This has no effect on server sessions.
	NumTimeoutsToTriggerPortMigration *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=num_timeouts_to_trigger_port_migration,json=numTimeoutsToTriggerPortMigration,proto3" json:"num_timeouts_to_trigger_port_migration,omitempty"`
	// Probes the peer at the configured interval to solicit traffic, i.e. “ACK“ or “PATH_RESPONSE“, from the peer to push back connection idle timeout.
	// If absent, use the default keepalive behavior of which a client connection sends “PING“s every “15s“, and a server connection doesn't do anything.
	ConnectionKeepalive *QuicKeepAliveSettings `protobuf:"bytes,5,opt,name=connection_keepalive,json=connectionKeepalive,proto3" json:"connection_keepalive,omitempty"`
	// A comma-separated list of strings representing QUIC connection options defined in
	// `QUICHE <https://github.com/google/quiche/blob/main/quiche/quic/core/crypto/crypto_protocol.h>`_ and to be sent by upstream connections.
	ConnectionOptions string `protobuf:"bytes,6,opt,name=connection_options,json=connectionOptions,proto3" json:"connection_options,omitempty"`
	// A comma-separated list of strings representing QUIC client connection options defined in
	// `QUICHE <https://github.com/google/quiche/blob/main/quiche/quic/core/crypto/crypto_protocol.h>`_ and to be sent by upstream connections.
	ClientConnectionOptions string `protobuf:"bytes,7,opt,name=client_connection_options,json=clientConnectionOptions,proto3" json:"client_connection_options,omitempty"`
	// The duration that a QUIC connection stays idle before it closes itself. If this field is not present, QUICHE
	// default “600s“ will be applied.
	// For internal corporate network, a long timeout is often fine.
	// But for client facing network, “30s“ is usually a good choice.
	// Do not add an upper bound here. A long idle timeout is useful for maintaining warm connections at non-front-line proxy for low QPS services.
	IdleNetworkTimeout *durationpb.Duration `protobuf:"bytes,8,opt,name=idle_network_timeout,json=idleNetworkTimeout,proto3" json:"idle_network_timeout,omitempty"`
	// Maximum packet length for QUIC connections. It refers to the largest size of a QUIC packet that can be transmitted over the connection.
	// If not specified, one of the `default values in QUICHE <https://github.com/google/quiche/blob/main/quiche/quic/core/quic_constants.h>`_ is used.
	MaxPacketLength *wrapperspb.UInt64Value `protobuf:"bytes,9,opt,name=max_packet_length,json=maxPacketLength,proto3" json:"max_packet_length,omitempty"`
	// A customized UDP socket and a QUIC packet writer using the socket for
	// client connections. i.e. Mobile uses its own implementation to interact
	// with platform socket APIs.
	// If not present, the default platform-independent socket and writer will be used.
	// [#extension-category: envoy.quic.client_packet_writer]
	ClientPacketWriter *TypedExtensionConfig `protobuf:"bytes,10,opt,name=client_packet_writer,json=clientPacketWriter,proto3" json:"client_packet_writer,omitempty"`
	// Enable QUIC `connection migration
	// <https://datatracker.ietf.org/doc/html/rfc9000#name-connection-migration>`
	// to a different network interface when the current network is degrading or
	// has become bad.
	// In order to use a different network interface other than the platform's default one,
	// a customized :ref:`client_packet_writer <envoy_v3_api_field_config.core.v3.QuicProtocolOptions.client_packet_writer>` needs to be configured to
	// create UDP sockets on non-default networks.
	// Only takes effect when runtime key “envoy.reloadable_features.use_migration_in_quiche“ is true.
	// If absent, the feature will be disabled.
	// [#not-implemented-hide:]
	ConnectionMigration *QuicProtocolOptions_ConnectionMigrationSettings `protobuf:"bytes,11,opt,name=connection_migration,json=connectionMigration,proto3" json:"connection_migration,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *QuicProtocolOptions) Reset() {
	*x = QuicProtocolOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuicProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuicProtocolOptions) ProtoMessage() {}

func (x *QuicProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuicProtocolOptions.ProtoReflect.Descriptor instead.
func (*QuicProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{2}
}

func (x *QuicProtocolOptions) GetMaxConcurrentStreams() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxConcurrentStreams
	}
	return nil
}

func (x *QuicProtocolOptions) GetInitialStreamWindowSize() *wrapperspb.UInt32Value {
	if x != nil {
		return x.InitialStreamWindowSize
	}
	return nil
}

func (x *QuicProtocolOptions) GetInitialConnectionWindowSize() *wrapperspb.UInt32Value {
	if x != nil {
		return x.InitialConnectionWindowSize
	}
	return nil
}

func (x *QuicProtocolOptions) GetNumTimeoutsToTriggerPortMigration() *wrapperspb.UInt32Value {
	if x != nil {
		return x.NumTimeoutsToTriggerPortMigration
	}
	return nil
}

func (x *QuicProtocolOptions) GetConnectionKeepalive() *QuicKeepAliveSettings {
	if x != nil {
		return x.ConnectionKeepalive
	}
	return nil
}

func (x *QuicProtocolOptions) GetConnectionOptions() string {
	if x != nil {
		return x.ConnectionOptions
	}
	return ""
}

func (x *QuicProtocolOptions) GetClientConnectionOptions() string {
	if x != nil {
		return x.ClientConnectionOptions
	}
	return ""
}

func (x *QuicProtocolOptions) GetIdleNetworkTimeout() *durationpb.Duration {
	if x != nil {
		return x.IdleNetworkTimeout
	}
	return nil
}

func (x *QuicProtocolOptions) GetMaxPacketLength() *wrapperspb.UInt64Value {
	if x != nil {
		return x.MaxPacketLength
	}
	return nil
}

func (x *QuicProtocolOptions) GetClientPacketWriter() *TypedExtensionConfig {
	if x != nil {
		return x.ClientPacketWriter
	}
	return nil
}

func (x *QuicProtocolOptions) GetConnectionMigration() *QuicProtocolOptions_ConnectionMigrationSettings {
	if x != nil {
		return x.ConnectionMigration
	}
	return nil
}

type UpstreamHttpProtocolOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Set transport socket `SNI <https://en.wikipedia.org/wiki/Server_Name_Indication>`_ for new
	// upstream connections based on the downstream HTTP host/authority header or any other arbitrary
	// header when :ref:`override_auto_sni_header <envoy_v3_api_field_config.core.v3.UpstreamHttpProtocolOptions.override_auto_sni_header>`
	// is set, as seen by the :ref:`router filter <config_http_filters_router>`.
	// Does nothing if a filter before the http router filter sets the corresponding metadata.
	//
	// See :ref:`SNI configuration <start_quick_start_securing_sni_client>` for details on how this
	// interacts with other validation options.
	AutoSni bool `protobuf:"varint,1,opt,name=auto_sni,json=autoSni,proto3" json:"auto_sni,omitempty"`
	// Automatic validate upstream presented certificate for new upstream connections based on the
	// downstream HTTP host/authority header or any other arbitrary header when :ref:`override_auto_sni_header <envoy_v3_api_field_config.core.v3.UpstreamHttpProtocolOptions.override_auto_sni_header>`
	// is set, as seen by the :ref:`router filter <config_http_filters_router>`.
	// This field is intended to be set with “auto_sni“ field.
	// Does nothing if a filter before the http router filter sets the corresponding metadata.
	//
	// See :ref:`validation configuration <start_quick_start_securing_validation>` for how this interacts with
	// other validation options.
	AutoSanValidation bool `protobuf:"varint,2,opt,name=auto_san_validation,json=autoSanValidation,proto3" json:"auto_san_validation,omitempty"`
	// An optional alternative to the host/authority header to be used for setting the SNI value.
	// It should be a valid downstream HTTP header, as seen by the
	// :ref:`router filter <config_http_filters_router>`.
	// If unset, host/authority header will be used for populating the SNI. If the specified header
	// is not found or the value is empty, host/authority header will be used instead.
	// This field is intended to be set with “auto_sni“ and/or “auto_san_validation“ fields.
	// If none of these fields are set then setting this would be a no-op.
	// Does nothing if a filter before the http router filter sets the corresponding metadata.
	OverrideAutoSniHeader string `protobuf:"bytes,3,opt,name=override_auto_sni_header,json=overrideAutoSniHeader,proto3" json:"override_auto_sni_header,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UpstreamHttpProtocolOptions) Reset() {
	*x = UpstreamHttpProtocolOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpstreamHttpProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamHttpProtocolOptions) ProtoMessage() {}

func (x *UpstreamHttpProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamHttpProtocolOptions.ProtoReflect.Descriptor instead.
func (*UpstreamHttpProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{3}
}

func (x *UpstreamHttpProtocolOptions) GetAutoSni() bool {
	if x != nil {
		return x.AutoSni
	}
	return false
}

func (x *UpstreamHttpProtocolOptions) GetAutoSanValidation() bool {
	if x != nil {
		return x.AutoSanValidation
	}
	return false
}

func (x *UpstreamHttpProtocolOptions) GetOverrideAutoSniHeader() string {
	if x != nil {
		return x.OverrideAutoSniHeader
	}
	return ""
}

// Configures the alternate protocols cache which tracks alternate protocols that can be used to
// make an HTTP connection to an origin server. See https://tools.ietf.org/html/rfc7838 for
// HTTP Alternative Services and https://datatracker.ietf.org/doc/html/draft-ietf-dnsop-svcb-https-04
// for the "HTTPS" DNS resource record.
// [#next-free-field: 6]
type AlternateProtocolsCacheOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the cache. Multiple named caches allow independent alternate protocols cache
	// configurations to operate within a single Envoy process using different configurations. All
	// alternate protocols cache options with the same name *must* be equal in all fields when
	// referenced from different configuration components. Configuration will fail to load if this is
	// not the case.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of entries that the cache will hold. If not specified defaults to “1024“.
	//
	// .. note::
	//
	//	The implementation is approximate and enforced independently on each worker thread, thus
	//	it is possible for the maximum entries in the cache to go slightly above the configured
	//	value depending on timing. This is similar to how other circuit breakers work.
	MaxEntries *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=max_entries,json=maxEntries,proto3" json:"max_entries,omitempty"`
	// Allows configuring a persistent
	// :ref:`key value store <envoy_v3_api_msg_config.common.key_value.v3.KeyValueStoreConfig>` to flush
	// alternate protocols entries to disk.
	// This function is currently only supported if concurrency is 1
	// Cached entries will take precedence over pre-populated entries below.
	KeyValueStoreConfig *TypedExtensionConfig `protobuf:"bytes,3,opt,name=key_value_store_config,json=keyValueStoreConfig,proto3" json:"key_value_store_config,omitempty"`
	// Allows pre-populating the cache with entries, as described above.
	PrepopulatedEntries []*AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry `protobuf:"bytes,4,rep,name=prepopulated_entries,json=prepopulatedEntries,proto3" json:"prepopulated_entries,omitempty"`
	// Optional list of hostnames suffixes for which Alt-Svc entries can be shared. For example, if
	// this list contained the value “.c.example.com“, then an Alt-Svc entry for “foo.c.example.com“
	// could be shared with “bar.c.example.com“ but would not be shared with “baz.example.com“. On
	// the other hand, if the list contained the value “.example.com“ then all three hosts could share
	// Alt-Svc entries. Each entry must start with “.“. If a hostname matches multiple suffixes, the
	// first listed suffix will be used.
	//
	// Since lookup in this list is O(n), it is recommended that the number of suffixes be limited.
	// [#not-implemented-hide:]
	CanonicalSuffixes []string `protobuf:"bytes,5,rep,name=canonical_suffixes,json=canonicalSuffixes,proto3" json:"canonical_suffixes,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *AlternateProtocolsCacheOptions) Reset() {
	*x = AlternateProtocolsCacheOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AlternateProtocolsCacheOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlternateProtocolsCacheOptions) ProtoMessage() {}

func (x *AlternateProtocolsCacheOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlternateProtocolsCacheOptions.ProtoReflect.Descriptor instead.
func (*AlternateProtocolsCacheOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{4}
}

func (x *AlternateProtocolsCacheOptions) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AlternateProtocolsCacheOptions) GetMaxEntries() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxEntries
	}
	return nil
}

func (x *AlternateProtocolsCacheOptions) GetKeyValueStoreConfig() *TypedExtensionConfig {
	if x != nil {
		return x.KeyValueStoreConfig
	}
	return nil
}

func (x *AlternateProtocolsCacheOptions) GetPrepopulatedEntries() []*AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry {
	if x != nil {
		return x.PrepopulatedEntries
	}
	return nil
}

func (x *AlternateProtocolsCacheOptions) GetCanonicalSuffixes() []string {
	if x != nil {
		return x.CanonicalSuffixes
	}
	return nil
}

// [#next-free-field: 8]
type HttpProtocolOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The idle timeout for connections. The idle timeout is defined as the
	// period in which there are no active requests. When the
	// idle timeout is reached the connection will be closed. If the connection is an HTTP/2
	// downstream connection a drain sequence will occur prior to closing the connection, see
	// :ref:`drain_timeout
	// <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.drain_timeout>`.
	//
	// .. note::
	//
	//	Request based timeouts mean that HTTP/2 PINGs will not keep the connection alive.
	//
	// If not specified, this defaults to “1 hour“. To disable idle timeouts explicitly set this to “0“.
	//
	// .. warning::
	//
	//	Disabling this timeout has a highly likelihood of yielding connection leaks due to lost TCP
	//	FIN packets, etc.
	//
	// If the :ref:`overload action <config_overload_manager_overload_actions>` "envoy.overload_actions.reduce_timeouts"
	// is configured, this timeout is scaled for downstream connections according to the value for
	// :ref:`HTTP_DOWNSTREAM_CONNECTION_IDLE <envoy_v3_api_enum_value_config.overload.v3.ScaleTimersOverloadActionConfig.TimerType.HTTP_DOWNSTREAM_CONNECTION_IDLE>`.
	IdleTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// The maximum duration of a connection. The duration is defined as a period since a connection
	// was established. If not set, there is no max duration. When max_connection_duration is reached,
	// the drain sequence will kick-in. The connection will be closed after the drain timeout period
	// if there are no active streams. See :ref:`drain_timeout
	// <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.drain_timeout>`.
	MaxConnectionDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=max_connection_duration,json=maxConnectionDuration,proto3" json:"max_connection_duration,omitempty"`
	// The maximum number of headers (request headers if configured on HttpConnectionManager,
	// response headers when configured on a cluster).
	// If unconfigured, the default maximum number of headers allowed is “100“.
	// The default value for requests can be overridden by setting runtime key “envoy.reloadable_features.max_request_headers_count“.
	// The default value for responses can be overridden by setting runtime key “envoy.reloadable_features.max_response_headers_count“.
	// Downstream requests that exceed this limit will receive a “HTTP 431“ response for HTTP/1.x and cause a stream
	// reset for HTTP/2.
	// Upstream responses that exceed this limit will result in a “HTTP 502“ response.
	MaxHeadersCount *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=max_headers_count,json=maxHeadersCount,proto3" json:"max_headers_count,omitempty"`
	// The maximum size of response headers.
	// If unconfigured, the default is “60 KiB“, except for HTTP/1 response headers which have a default
	// of “80 KiB“.
	// The default value can be overridden by setting runtime key “envoy.reloadable_features.max_response_headers_size_kb“.
	// Responses that exceed this limit will result in a “HTTP 503“ response.
	// In Envoy, this setting is only valid when configured on an upstream cluster, not on the
	// :ref:`HTTP Connection Manager
	// <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.common_http_protocol_options>`.
	//
	// .. note::
	//
	//	Currently some protocol codecs impose limits on the maximum size of a single header.
	//
	//	* HTTP/2 (when using ``nghttp2``) limits a single header to around ``100kb``.
	//	* HTTP/3 limits a single header to around ``1024kb``.
	MaxResponseHeadersKb *wrapperspb.UInt32Value `protobuf:"bytes,7,opt,name=max_response_headers_kb,json=maxResponseHeadersKb,proto3" json:"max_response_headers_kb,omitempty"`
	// Total duration to keep alive an HTTP request/response stream. If the time limit is reached the stream will be
	// reset independent of any other timeouts. If not specified, this value is not set.
	MaxStreamDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=max_stream_duration,json=maxStreamDuration,proto3" json:"max_stream_duration,omitempty"`
	// Action to take when a client request with a header name containing underscore characters is received.
	// If this setting is not specified, the value defaults to “ALLOW“.
	//
	// .. note::
	//
	//	Upstream responses are not affected by this setting.
	//
	// .. note::
	//
	//	This only affects client headers. It does not affect headers added by Envoy filters and does not have any
	//	impact if added to cluster config.
	HeadersWithUnderscoresAction HttpProtocolOptions_HeadersWithUnderscoresAction `protobuf:"varint,5,opt,name=headers_with_underscores_action,json=headersWithUnderscoresAction,proto3,enum=envoy.config.core.v3.HttpProtocolOptions_HeadersWithUnderscoresAction" json:"headers_with_underscores_action,omitempty"`
	// Optional maximum requests for both upstream and downstream connections.
	// If not specified, there is no limit.
	// Setting this parameter to “1“ will effectively disable keep alive.
	// For HTTP/2 and HTTP/3, due to concurrent stream processing, the limit is approximate.
	MaxRequestsPerConnection *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=max_requests_per_connection,json=maxRequestsPerConnection,proto3" json:"max_requests_per_connection,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *HttpProtocolOptions) Reset() {
	*x = HttpProtocolOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpProtocolOptions) ProtoMessage() {}

func (x *HttpProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpProtocolOptions.ProtoReflect.Descriptor instead.
func (*HttpProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{5}
}

func (x *HttpProtocolOptions) GetIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

func (x *HttpProtocolOptions) GetMaxConnectionDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxConnectionDuration
	}
	return nil
}

func (x *HttpProtocolOptions) GetMaxHeadersCount() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxHeadersCount
	}
	return nil
}

func (x *HttpProtocolOptions) GetMaxResponseHeadersKb() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxResponseHeadersKb
	}
	return nil
}

func (x *HttpProtocolOptions) GetMaxStreamDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxStreamDuration
	}
	return nil
}

func (x *HttpProtocolOptions) GetHeadersWithUnderscoresAction() HttpProtocolOptions_HeadersWithUnderscoresAction {
	if x != nil {
		return x.HeadersWithUnderscoresAction
	}
	return HttpProtocolOptions_ALLOW
}

func (x *HttpProtocolOptions) GetMaxRequestsPerConnection() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxRequestsPerConnection
	}
	return nil
}

// [#next-free-field: 12]
type Http1ProtocolOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Handle HTTP requests with absolute URLs in the requests. These requests
	// are generally sent by clients to forward/explicit proxies. This allows clients to configure
	// envoy as their HTTP proxy. In Unix, for example, this is typically done by setting the
	// “http_proxy“ environment variable.
	AllowAbsoluteUrl *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=allow_absolute_url,json=allowAbsoluteUrl,proto3" json:"allow_absolute_url,omitempty"`
	// Handle incoming HTTP/1.0 and HTTP/0.9 requests.
	// This is off by default, and not fully standards compliant. There is support for pre-HTTP/1.1
	// style connect logic, dechunking, and handling lack of client host iff
	// “default_host_for_http_10“ is configured.
	AcceptHttp_10 bool `protobuf:"varint,2,opt,name=accept_http_10,json=acceptHttp10,proto3" json:"accept_http_10,omitempty"`
	// A default host for HTTP/1.0 requests. This is highly suggested if “accept_http_10“ is true as
	// Envoy does not otherwise support HTTP/1.0 without a Host header.
	// This is a no-op if “accept_http_10“ is not true.
	DefaultHostForHttp_10 string `protobuf:"bytes,3,opt,name=default_host_for_http_10,json=defaultHostForHttp10,proto3" json:"default_host_for_http_10,omitempty"`
	// Describes how the keys for response headers should be formatted. By default, all header keys
	// are lower cased.
	HeaderKeyFormat *Http1ProtocolOptions_HeaderKeyFormat `protobuf:"bytes,4,opt,name=header_key_format,json=headerKeyFormat,proto3" json:"header_key_format,omitempty"`
	// Enables trailers for HTTP/1. By default the HTTP/1 codec drops proxied trailers.
	//
	// .. attention::
	//
	//	This only happens when Envoy is chunk encoding which occurs when:
	//	- The request is HTTP/1.1.
	//	- Is neither a ``HEAD`` only request nor a HTTP Upgrade.
	//	- Not a response to a ``HEAD`` request.
	//	- The ``Content-Length`` header is not present.
	EnableTrailers bool `protobuf:"varint,5,opt,name=enable_trailers,json=enableTrailers,proto3" json:"enable_trailers,omitempty"`
	// Allows Envoy to process requests/responses with both “Content-Length“ and “Transfer-Encoding“
	// headers set. By default such messages are rejected, but if option is enabled - Envoy will
	// remove “Content-Length“ header and process message.
	// See `RFC7230, sec. 3.3.3 <https://tools.ietf.org/html/rfc7230#section-3.3.3>`_ for details.
	//
	// .. attention::
	//
	//	Enabling this option might lead to request smuggling vulnerability, especially if traffic
	//	is proxied via multiple layers of proxies.
	//
	// [#comment:TODO: This field is ignored when the
	// :ref:`header validation configuration <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.typed_header_validation_config>`
	// is present.]
	AllowChunkedLength bool `protobuf:"varint,6,opt,name=allow_chunked_length,json=allowChunkedLength,proto3" json:"allow_chunked_length,omitempty"`
	// Allows invalid HTTP messaging. When this option is false, then Envoy will terminate
	// HTTP/1.1 connections upon receiving an invalid HTTP message. However,
	// when this option is true, then Envoy will leave the HTTP/1.1 connection
	// open where possible.
	// If set, this overrides any HCM :ref:`stream_error_on_invalid_http_messaging
	// <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.stream_error_on_invalid_http_message>`.
	OverrideStreamErrorOnInvalidHttpMessage *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=override_stream_error_on_invalid_http_message,json=overrideStreamErrorOnInvalidHttpMessage,proto3" json:"override_stream_error_on_invalid_http_message,omitempty"`
	// Allows sending fully qualified URLs when proxying the first line of the
	// response. By default, Envoy will only send the path components in the first line.
	// If this is true, Envoy will create a fully qualified URI composing scheme
	// (inferred if not present), host (from the host/:authority header) and path
	// (from first line or :path header).
	SendFullyQualifiedUrl bool `protobuf:"varint,8,opt,name=send_fully_qualified_url,json=sendFullyQualifiedUrl,proto3" json:"send_fully_qualified_url,omitempty"`
	// [#not-implemented-hide:] Hiding so that field can be removed after BalsaParser is rolled out.
	// If set, force HTTP/1 parser: BalsaParser if true, http-parser if false.
	// If unset, HTTP/1 parser is selected based on
	// envoy.reloadable_features.http1_use_balsa_parser.
	// See issue #21245.
	//
	// Deprecated: Marked as deprecated in envoy/config/core/v3/protocol.proto.
	UseBalsaParser *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=use_balsa_parser,json=useBalsaParser,proto3" json:"use_balsa_parser,omitempty"`
	// [#not-implemented-hide:] Hiding so that field can be removed.
	// If true, and BalsaParser is used (either `use_balsa_parser` above is true,
	// or `envoy.reloadable_features.http1_use_balsa_parser` is true and
	// `use_balsa_parser` is unset), then every non-empty method with only valid
	// characters is accepted. Otherwise, methods not on the hard-coded list are
	// rejected.
	// Once UHV is enabled, this field should be removed, and BalsaParser should
	// allow any method. UHV validates the method, rejecting empty string or
	// invalid characters, and provides :ref:`restrict_http_methods
	// <envoy_v3_api_field_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.restrict_http_methods>`
	// to reject custom methods.
	AllowCustomMethods bool `protobuf:"varint,10,opt,name=allow_custom_methods,json=allowCustomMethods,proto3" json:"allow_custom_methods,omitempty"`
	// Ignore HTTP/1.1 upgrade values matching any of the supplied matchers.
	//
	// .. note::
	//
	//	``h2c`` upgrades are always removed for backwards compatibility, regardless of the
	//	value in this setting.
	IgnoreHttp_11Upgrade []*v3.StringMatcher `protobuf:"bytes,11,rep,name=ignore_http_11_upgrade,json=ignoreHttp11Upgrade,proto3" json:"ignore_http_11_upgrade,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Http1ProtocolOptions) Reset() {
	*x = Http1ProtocolOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Http1ProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http1ProtocolOptions) ProtoMessage() {}

func (x *Http1ProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http1ProtocolOptions.ProtoReflect.Descriptor instead.
func (*Http1ProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{6}
}

func (x *Http1ProtocolOptions) GetAllowAbsoluteUrl() *wrapperspb.BoolValue {
	if x != nil {
		return x.AllowAbsoluteUrl
	}
	return nil
}

func (x *Http1ProtocolOptions) GetAcceptHttp_10() bool {
	if x != nil {
		return x.AcceptHttp_10
	}
	return false
}

func (x *Http1ProtocolOptions) GetDefaultHostForHttp_10() string {
	if x != nil {
		return x.DefaultHostForHttp_10
	}
	return ""
}

func (x *Http1ProtocolOptions) GetHeaderKeyFormat() *Http1ProtocolOptions_HeaderKeyFormat {
	if x != nil {
		return x.HeaderKeyFormat
	}
	return nil
}

func (x *Http1ProtocolOptions) GetEnableTrailers() bool {
	if x != nil {
		return x.EnableTrailers
	}
	return false
}

func (x *Http1ProtocolOptions) GetAllowChunkedLength() bool {
	if x != nil {
		return x.AllowChunkedLength
	}
	return false
}

func (x *Http1ProtocolOptions) GetOverrideStreamErrorOnInvalidHttpMessage() *wrapperspb.BoolValue {
	if x != nil {
		return x.OverrideStreamErrorOnInvalidHttpMessage
	}
	return nil
}

func (x *Http1ProtocolOptions) GetSendFullyQualifiedUrl() bool {
	if x != nil {
		return x.SendFullyQualifiedUrl
	}
	return false
}

// Deprecated: Marked as deprecated in envoy/config/core/v3/protocol.proto.
func (x *Http1ProtocolOptions) GetUseBalsaParser() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseBalsaParser
	}
	return nil
}

func (x *Http1ProtocolOptions) GetAllowCustomMethods() bool {
	if x != nil {
		return x.AllowCustomMethods
	}
	return false
}

func (x *Http1ProtocolOptions) GetIgnoreHttp_11Upgrade() []*v3.StringMatcher {
	if x != nil {
		return x.IgnoreHttp_11Upgrade
	}
	return nil
}

type KeepaliveSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Send HTTP/2 PING frames at this period, in order to test that the connection is still alive.
	// If this is zero, interval PINGs will not be sent.
	Interval *durationpb.Duration `protobuf:"bytes,1,opt,name=interval,proto3" json:"interval,omitempty"`
	// How long to wait for a response to a keepalive PING. If a response is not received within this
	// time period, the connection will be aborted.
	//
	// .. note::
	//
	//	In order to prevent the influence of Head-of-line (HOL) blocking the timeout period is extended when *any* frame is received on
	//	the connection, under the assumption that if a frame is received the connection is healthy.
	Timeout *durationpb.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// A random jitter amount as a percentage of interval that will be added to each interval.
	// A value of zero means there will be no jitter.
	// The default value is “15%“.
	IntervalJitter *v31.Percent `protobuf:"bytes,3,opt,name=interval_jitter,json=intervalJitter,proto3" json:"interval_jitter,omitempty"`
	// If the connection has been idle for this duration, send a HTTP/2 ping ahead
	// of new stream creation, to quickly detect dead connections.
	// If this is zero, this type of PING will not be sent.
	// If an interval ping is outstanding, a second ping will not be sent as the
	// interval ping will determine if the connection is dead.
	//
	// The same feature for HTTP/3 is given by inheritance from QUICHE which uses :ref:`connection idle_timeout <envoy_v3_api_field_config.listener.v3.QuicProtocolOptions.idle_timeout>` and the current PTO of the connection to decide whether to probe before sending a new request.
	ConnectionIdleInterval *durationpb.Duration `protobuf:"bytes,4,opt,name=connection_idle_interval,json=connectionIdleInterval,proto3" json:"connection_idle_interval,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *KeepaliveSettings) Reset() {
	*x = KeepaliveSettings{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeepaliveSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeepaliveSettings) ProtoMessage() {}

func (x *KeepaliveSettings) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeepaliveSettings.ProtoReflect.Descriptor instead.
func (*KeepaliveSettings) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{7}
}

func (x *KeepaliveSettings) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *KeepaliveSettings) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *KeepaliveSettings) GetIntervalJitter() *v31.Percent {
	if x != nil {
		return x.IntervalJitter
	}
	return nil
}

func (x *KeepaliveSettings) GetConnectionIdleInterval() *durationpb.Duration {
	if x != nil {
		return x.ConnectionIdleInterval
	}
	return nil
}

// [#next-free-field: 19]
type Http2ProtocolOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// `Maximum table size <https://httpwg.org/specs/rfc7541.html#rfc.section.4.2>`_
	// (in octets) that the encoder is permitted to use for the dynamic HPACK table. Valid values
	// range from “0“ to “4294967295“ (“2^32 - 1“) and defaults to “4096“. “0“ effectively disables header
	// compression.
	HpackTableSize *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=hpack_table_size,json=hpackTableSize,proto3" json:"hpack_table_size,omitempty"`
	// `Maximum concurrent streams <https://httpwg.org/specs/rfc7540.html#rfc.section.5.1.2>`_
	// allowed for peer on one HTTP/2 connection. Valid values range from “1“ to “2147483647“ (“2^31 - 1“)
	// and defaults to “1024“ for safety and should be sufficient for most use cases.
	//
	// For upstream connections, this also limits how many streams Envoy will initiate concurrently
	// on a single connection. If the limit is reached, Envoy may queue requests or establish
	// additional connections (as allowed per circuit breaker limits).
	//
	// This acts as an upper bound: Envoy will lower the max concurrent streams allowed on a given
	// connection based on upstream settings. Config dumps will reflect the configured upper bound,
	// not the per-connection negotiated limits.
	MaxConcurrentStreams *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=max_concurrent_streams,json=maxConcurrentStreams,proto3" json:"max_concurrent_streams,omitempty"`
	// `Initial stream-level flow-control window
	// <https://httpwg.org/specs/rfc7540.html#rfc.section.6.9.2>`_ size. Valid values range from “65535“
	// (“2^16 - 1“, HTTP/2 default) to “2147483647“ (“2^31 - 1“, HTTP/2 maximum) and defaults to
	// “16MiB“ (“16 * 1024 * 1024“).
	//
	// .. note::
	//
	//	``65535`` is the initial window size from HTTP/2 spec. We only support increasing the default window size now,
	//	so it's also the minimum.
	//
	// This field also acts as a soft limit on the number of bytes Envoy will buffer per-stream in the
	// HTTP/2 codec buffers. Once the buffer reaches this pointer, watermark callbacks will fire to
	// stop the flow of data to the codec buffers.
	InitialStreamWindowSize *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=initial_stream_window_size,json=initialStreamWindowSize,proto3" json:"initial_stream_window_size,omitempty"`
	// Similar to “initial_stream_window_size“, but for connection-level flow-control
	// window. The default is “24MiB“ (“24 * 1024 * 1024“).
	InitialConnectionWindowSize *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=initial_connection_window_size,json=initialConnectionWindowSize,proto3" json:"initial_connection_window_size,omitempty"`
	// Allows proxying Websocket and other upgrades over H2 connect.
	AllowConnect bool `protobuf:"varint,5,opt,name=allow_connect,json=allowConnect,proto3" json:"allow_connect,omitempty"`
	// [#not-implemented-hide:] Hiding until Envoy has full metadata support.
	// Still under implementation. DO NOT USE.
	//
	// Allows sending and receiving HTTP/2 METADATA frames. See [metadata
	// docs](https://github.com/envoyproxy/envoy/blob/main/source/docs/h2_metadata.md) for more
	// information.
	AllowMetadata bool `protobuf:"varint,6,opt,name=allow_metadata,json=allowMetadata,proto3" json:"allow_metadata,omitempty"`
	// Limit the number of pending outbound downstream frames of all types (frames that are waiting to
	// be written into the socket). Exceeding this limit triggers flood mitigation and connection is
	// terminated. The “http2.outbound_flood“ stat tracks the number of terminated connections due
	// to flood mitigation. The default limit is “10000“.
	MaxOutboundFrames *wrapperspb.UInt32Value `protobuf:"bytes,7,opt,name=max_outbound_frames,json=maxOutboundFrames,proto3" json:"max_outbound_frames,omitempty"`
	// Limit the number of pending outbound downstream frames of types “PING“, “SETTINGS“ and “RST_STREAM“,
	// preventing high memory utilization when receiving continuous stream of these frames. Exceeding
	// this limit triggers flood mitigation and connection is terminated. The
	// “http2.outbound_control_flood“ stat tracks the number of terminated connections due to flood
	// mitigation. The default limit is “1000“.
	MaxOutboundControlFrames *wrapperspb.UInt32Value `protobuf:"bytes,8,opt,name=max_outbound_control_frames,json=maxOutboundControlFrames,proto3" json:"max_outbound_control_frames,omitempty"`
	// Limit the number of consecutive inbound frames of types “HEADERS“, “CONTINUATION“ and “DATA“ with an
	// empty payload and no end stream flag. Those frames have no legitimate use and are abusive, but
	// might be a result of a broken HTTP/2 implementation. The “http2.inbound_empty_frames_flood“
	// stat tracks the number of connections terminated due to flood mitigation.
	// Setting this to “0“ will terminate connection upon receiving first frame with an empty payload
	// and no end stream flag. The default limit is “1“.
	MaxConsecutiveInboundFramesWithEmptyPayload *wrapperspb.UInt32Value `protobuf:"bytes,9,opt,name=max_consecutive_inbound_frames_with_empty_payload,json=maxConsecutiveInboundFramesWithEmptyPayload,proto3" json:"max_consecutive_inbound_frames_with_empty_payload,omitempty"`
	// Limit the number of inbound “PRIORITY“ frames allowed per each opened stream. If the number
	// of “PRIORITY“ frames received over the lifetime of connection exceeds the value calculated
	// using this formula::
	//
	//	``max_inbound_priority_frames_per_stream`` * (1 + ``opened_streams``)
	//
	// the connection is terminated. For downstream connections the “opened_streams“ is incremented when
	// Envoy receives complete response headers from the upstream server. For upstream connection the
	// “opened_streams“ is incremented when Envoy sends the “HEADERS“ frame for a new stream. The
	// “http2.inbound_priority_frames_flood“ stat tracks
	// the number of connections terminated due to flood mitigation. The default limit is “100“.
	MaxInboundPriorityFramesPerStream *wrapperspb.UInt32Value `protobuf:"bytes,10,opt,name=max_inbound_priority_frames_per_stream,json=maxInboundPriorityFramesPerStream,proto3" json:"max_inbound_priority_frames_per_stream,omitempty"`
	// Limit the number of inbound “WINDOW_UPDATE“ frames allowed per “DATA“ frame sent. If the number
	// of “WINDOW_UPDATE“ frames received over the lifetime of connection exceeds the value calculated
	// using this formula::
	//
	//	``5 + 2 * (opened_streams +
	//	         max_inbound_window_update_frames_per_data_frame_sent * outbound_data_frames)``
	//
	// the connection is terminated. For downstream connections the “opened_streams“ is incremented when
	// Envoy receives complete response headers from the upstream server. For upstream connections the
	// “opened_streams“ is incremented when Envoy sends the “HEADERS“ frame for a new stream. The
	// “http2.inbound_priority_frames_flood“ stat tracks the number of connections terminated due to
	// flood mitigation. The default “max_inbound_window_update_frames_per_data_frame_sent“ value is “10“.
	// Setting this to “1“ should be enough to support HTTP/2 implementations with basic flow control,
	// but more complex implementations that try to estimate available bandwidth require at least “2“.
	MaxInboundWindowUpdateFramesPerDataFrameSent *wrapperspb.UInt32Value `protobuf:"bytes,11,opt,name=max_inbound_window_update_frames_per_data_frame_sent,json=maxInboundWindowUpdateFramesPerDataFrameSent,proto3" json:"max_inbound_window_update_frames_per_data_frame_sent,omitempty"`
	// Allows invalid HTTP messaging and headers. When this option is disabled (default), then
	// the whole HTTP/2 connection is terminated upon receiving invalid HEADERS frame. However,
	// when this option is enabled, only the offending stream is terminated.
	//
	// This is overridden by HCM :ref:`stream_error_on_invalid_http_messaging
	// <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.stream_error_on_invalid_http_message>`
	// iff present.
	//
	// This is deprecated in favor of :ref:`override_stream_error_on_invalid_http_message
	// <envoy_v3_api_field_config.core.v3.Http2ProtocolOptions.override_stream_error_on_invalid_http_message>`
	//
	// See `RFC7540, sec. 8.1 <https://tools.ietf.org/html/rfc7540#section-8.1>`_ for details.
	//
	// Deprecated: Marked as deprecated in envoy/config/core/v3/protocol.proto.
	StreamErrorOnInvalidHttpMessaging bool `protobuf:"varint,12,opt,name=stream_error_on_invalid_http_messaging,json=streamErrorOnInvalidHttpMessaging,proto3" json:"stream_error_on_invalid_http_messaging,omitempty"`
	// Allows invalid HTTP messaging and headers. When this option is disabled (default), then
	// the whole HTTP/2 connection is terminated upon receiving invalid HEADERS frame. However,
	// when this option is enabled, only the offending stream is terminated.
	//
	// This overrides any HCM :ref:`stream_error_on_invalid_http_messaging
	// <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.stream_error_on_invalid_http_message>`
	//
	// See `RFC7540, sec. 8.1 <https://tools.ietf.org/html/rfc7540#section-8.1>`_ for details.
	OverrideStreamErrorOnInvalidHttpMessage *wrapperspb.BoolValue `protobuf:"bytes,14,opt,name=override_stream_error_on_invalid_http_message,json=overrideStreamErrorOnInvalidHttpMessage,proto3" json:"override_stream_error_on_invalid_http_message,omitempty"`
	// [#not-implemented-hide:]
	// Specifies SETTINGS frame parameters to be sent to the peer, with two exceptions:
	//
	// 1. SETTINGS_ENABLE_PUSH (0x2) is not configurable as HTTP/2 server push is not supported by
	// Envoy.
	//
	// 2. SETTINGS_ENABLE_CONNECT_PROTOCOL (0x8) is only configurable through the named field
	// 'allow_connect'.
	//
	// .. note::
	//
	//	Custom parameters specified through this field can not also be set in the
	//	corresponding named parameters:
	//
	// .. code-block:: text
	//
	//	ID    Field Name
	//	----------------
	//	0x1   hpack_table_size
	//	0x3   max_concurrent_streams
	//	0x4   initial_stream_window_size
	//
	// Collisions will trigger config validation failure on load/update. Likewise, inconsistencies
	// between custom parameters with the same identifier will trigger a failure.
	//
	// See `IANA HTTP/2 Settings
	// <https://www.iana.org/assignments/http2-parameters/http2-parameters.xhtml#settings>`_ for
	// standardized identifiers.
	CustomSettingsParameters []*Http2ProtocolOptions_SettingsParameter `protobuf:"bytes,13,rep,name=custom_settings_parameters,json=customSettingsParameters,proto3" json:"custom_settings_parameters,omitempty"`
	// Send HTTP/2 PING frames to verify that the connection is still healthy. If the remote peer
	// does not respond within the configured timeout, the connection will be aborted.
	ConnectionKeepalive *KeepaliveSettings `protobuf:"bytes,15,opt,name=connection_keepalive,json=connectionKeepalive,proto3" json:"connection_keepalive,omitempty"`
	// [#not-implemented-hide:] Hiding so that the field can be removed after oghttp2 is rolled out.
	// If set, force use of a particular HTTP/2 codec: oghttp2 if true, nghttp2 if false.
	// If unset, HTTP/2 codec is selected based on envoy.reloadable_features.http2_use_oghttp2.
	UseOghttp2Codec *wrapperspb.BoolValue `protobuf:"bytes,16,opt,name=use_oghttp2_codec,json=useOghttp2Codec,proto3" json:"use_oghttp2_codec,omitempty"`
	// Configure the maximum amount of metadata than can be handled per stream. Defaults to “1 MB“.
	MaxMetadataSize *wrapperspb.UInt64Value `protobuf:"bytes,17,opt,name=max_metadata_size,json=maxMetadataSize,proto3" json:"max_metadata_size,omitempty"`
	// Controls whether to encode headers using huffman encoding.
	// This can be useful in cases where the cpu spent encoding the headers isn't
	// worth the network bandwidth saved e.g. for localhost.
	// If unset, uses the data plane's default value.
	EnableHuffmanEncoding *wrapperspb.BoolValue `protobuf:"bytes,18,opt,name=enable_huffman_encoding,json=enableHuffmanEncoding,proto3" json:"enable_huffman_encoding,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Http2ProtocolOptions) Reset() {
	*x = Http2ProtocolOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Http2ProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http2ProtocolOptions) ProtoMessage() {}

func (x *Http2ProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http2ProtocolOptions.ProtoReflect.Descriptor instead.
func (*Http2ProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{8}
}

func (x *Http2ProtocolOptions) GetHpackTableSize() *wrapperspb.UInt32Value {
	if x != nil {
		return x.HpackTableSize
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxConcurrentStreams() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxConcurrentStreams
	}
	return nil
}

func (x *Http2ProtocolOptions) GetInitialStreamWindowSize() *wrapperspb.UInt32Value {
	if x != nil {
		return x.InitialStreamWindowSize
	}
	return nil
}

func (x *Http2ProtocolOptions) GetInitialConnectionWindowSize() *wrapperspb.UInt32Value {
	if x != nil {
		return x.InitialConnectionWindowSize
	}
	return nil
}

func (x *Http2ProtocolOptions) GetAllowConnect() bool {
	if x != nil {
		return x.AllowConnect
	}
	return false
}

func (x *Http2ProtocolOptions) GetAllowMetadata() bool {
	if x != nil {
		return x.AllowMetadata
	}
	return false
}

func (x *Http2ProtocolOptions) GetMaxOutboundFrames() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxOutboundFrames
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxOutboundControlFrames() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxOutboundControlFrames
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxConsecutiveInboundFramesWithEmptyPayload() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxConsecutiveInboundFramesWithEmptyPayload
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxInboundPriorityFramesPerStream() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxInboundPriorityFramesPerStream
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxInboundWindowUpdateFramesPerDataFrameSent() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxInboundWindowUpdateFramesPerDataFrameSent
	}
	return nil
}

// Deprecated: Marked as deprecated in envoy/config/core/v3/protocol.proto.
func (x *Http2ProtocolOptions) GetStreamErrorOnInvalidHttpMessaging() bool {
	if x != nil {
		return x.StreamErrorOnInvalidHttpMessaging
	}
	return false
}

func (x *Http2ProtocolOptions) GetOverrideStreamErrorOnInvalidHttpMessage() *wrapperspb.BoolValue {
	if x != nil {
		return x.OverrideStreamErrorOnInvalidHttpMessage
	}
	return nil
}

func (x *Http2ProtocolOptions) GetCustomSettingsParameters() []*Http2ProtocolOptions_SettingsParameter {
	if x != nil {
		return x.CustomSettingsParameters
	}
	return nil
}

func (x *Http2ProtocolOptions) GetConnectionKeepalive() *KeepaliveSettings {
	if x != nil {
		return x.ConnectionKeepalive
	}
	return nil
}

func (x *Http2ProtocolOptions) GetUseOghttp2Codec() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseOghttp2Codec
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxMetadataSize() *wrapperspb.UInt64Value {
	if x != nil {
		return x.MaxMetadataSize
	}
	return nil
}

func (x *Http2ProtocolOptions) GetEnableHuffmanEncoding() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableHuffmanEncoding
	}
	return nil
}

// [#not-implemented-hide:]
type GrpcProtocolOptions struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Http2ProtocolOptions *Http2ProtocolOptions  `protobuf:"bytes,1,opt,name=http2_protocol_options,json=http2ProtocolOptions,proto3" json:"http2_protocol_options,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GrpcProtocolOptions) Reset() {
	*x = GrpcProtocolOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GrpcProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcProtocolOptions) ProtoMessage() {}

func (x *GrpcProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcProtocolOptions.ProtoReflect.Descriptor instead.
func (*GrpcProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{9}
}

func (x *GrpcProtocolOptions) GetHttp2ProtocolOptions() *Http2ProtocolOptions {
	if x != nil {
		return x.Http2ProtocolOptions
	}
	return nil
}

// A message which allows using HTTP/3.
// [#next-free-field: 9]
type Http3ProtocolOptions struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	QuicProtocolOptions *QuicProtocolOptions   `protobuf:"bytes,1,opt,name=quic_protocol_options,json=quicProtocolOptions,proto3" json:"quic_protocol_options,omitempty"`
	// Allows invalid HTTP messaging and headers. When this option is disabled (default), then
	// the whole HTTP/3 connection is terminated upon receiving invalid HEADERS frame. However,
	// when this option is enabled, only the offending stream is terminated.
	//
	// If set, this overrides any HCM :ref:`stream_error_on_invalid_http_messaging
	// <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.stream_error_on_invalid_http_message>`.
	OverrideStreamErrorOnInvalidHttpMessage *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=override_stream_error_on_invalid_http_message,json=overrideStreamErrorOnInvalidHttpMessage,proto3" json:"override_stream_error_on_invalid_http_message,omitempty"`
	// Allows proxying Websocket and other upgrades over HTTP/3 CONNECT using
	// the header mechanisms from the `HTTP/2 extended connect RFC
	// <https://datatracker.ietf.org/doc/html/rfc8441>`_
	// and settings `proposed for HTTP/3
	// <https://datatracker.ietf.org/doc/draft-ietf-httpbis-h3-websockets/>`_
	//
	// .. note::
	//
	//	HTTP/3 CONNECT is not yet an RFC.
	AllowExtendedConnect bool `protobuf:"varint,5,opt,name=allow_extended_connect,json=allowExtendedConnect,proto3" json:"allow_extended_connect,omitempty"`
	// [#not-implemented-hide:] Hiding until Envoy has full metadata support.
	// Still under implementation. DO NOT USE.
	//
	// Allows sending and receiving HTTP/3 METADATA frames. See [metadata
	// docs](https://github.com/envoyproxy/envoy/blob/main/source/docs/h2_metadata.md) for more
	// information.
	AllowMetadata bool `protobuf:"varint,6,opt,name=allow_metadata,json=allowMetadata,proto3" json:"allow_metadata,omitempty"`
	// [#not-implemented-hide:] Hiding until Envoy has full HTTP/3 upstream support.
	// Still under implementation. DO NOT USE.
	//
	// Disables QPACK compression related features for HTTP/3 including:
	// No huffman encoding, zero dynamic table capacity and no cookie crumbling.
	// This can be useful for trading off CPU vs bandwidth when an upstream HTTP/3 connection multiplexes multiple downstream connections.
	DisableQpack bool `protobuf:"varint,7,opt,name=disable_qpack,json=disableQpack,proto3" json:"disable_qpack,omitempty"`
	// Disables connection level flow control for HTTP/3 streams. This is useful in situations where the streams share the same connection
	// but originate from different end-clients, so that each stream can make progress independently at non-front-line proxies.
	DisableConnectionFlowControlForStreams bool `protobuf:"varint,8,opt,name=disable_connection_flow_control_for_streams,json=disableConnectionFlowControlForStreams,proto3" json:"disable_connection_flow_control_for_streams,omitempty"`
	unknownFields                          protoimpl.UnknownFields
	sizeCache                              protoimpl.SizeCache
}

func (x *Http3ProtocolOptions) Reset() {
	*x = Http3ProtocolOptions{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Http3ProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http3ProtocolOptions) ProtoMessage() {}

func (x *Http3ProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http3ProtocolOptions.ProtoReflect.Descriptor instead.
func (*Http3ProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{10}
}

func (x *Http3ProtocolOptions) GetQuicProtocolOptions() *QuicProtocolOptions {
	if x != nil {
		return x.QuicProtocolOptions
	}
	return nil
}

func (x *Http3ProtocolOptions) GetOverrideStreamErrorOnInvalidHttpMessage() *wrapperspb.BoolValue {
	if x != nil {
		return x.OverrideStreamErrorOnInvalidHttpMessage
	}
	return nil
}

func (x *Http3ProtocolOptions) GetAllowExtendedConnect() bool {
	if x != nil {
		return x.AllowExtendedConnect
	}
	return false
}

func (x *Http3ProtocolOptions) GetAllowMetadata() bool {
	if x != nil {
		return x.AllowMetadata
	}
	return false
}

func (x *Http3ProtocolOptions) GetDisableQpack() bool {
	if x != nil {
		return x.DisableQpack
	}
	return false
}

func (x *Http3ProtocolOptions) GetDisableConnectionFlowControlForStreams() bool {
	if x != nil {
		return x.DisableConnectionFlowControlForStreams
	}
	return false
}

// A message to control transformations to the :scheme header
type SchemeHeaderTransformation struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Transformation:
	//
	//	*SchemeHeaderTransformation_SchemeToOverwrite
	Transformation isSchemeHeaderTransformation_Transformation `protobuf_oneof:"transformation"`
	// Set the Scheme header to match the upstream transport protocol. For example, should a
	// request be sent to the upstream over TLS, the scheme header will be set to “"https"“. Should the
	// request be sent over plaintext, the scheme header will be set to “"http"“.
	// If “scheme_to_overwrite“ is set, this field is not used.
	MatchUpstream bool `protobuf:"varint,2,opt,name=match_upstream,json=matchUpstream,proto3" json:"match_upstream,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SchemeHeaderTransformation) Reset() {
	*x = SchemeHeaderTransformation{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchemeHeaderTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemeHeaderTransformation) ProtoMessage() {}

func (x *SchemeHeaderTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemeHeaderTransformation.ProtoReflect.Descriptor instead.
func (*SchemeHeaderTransformation) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{11}
}

func (x *SchemeHeaderTransformation) GetTransformation() isSchemeHeaderTransformation_Transformation {
	if x != nil {
		return x.Transformation
	}
	return nil
}

func (x *SchemeHeaderTransformation) GetSchemeToOverwrite() string {
	if x != nil {
		if x, ok := x.Transformation.(*SchemeHeaderTransformation_SchemeToOverwrite); ok {
			return x.SchemeToOverwrite
		}
	}
	return ""
}

func (x *SchemeHeaderTransformation) GetMatchUpstream() bool {
	if x != nil {
		return x.MatchUpstream
	}
	return false
}

type isSchemeHeaderTransformation_Transformation interface {
	isSchemeHeaderTransformation_Transformation()
}

type SchemeHeaderTransformation_SchemeToOverwrite struct {
	// Overwrite any Scheme header with the contents of this string.
	// If set, takes precedence over “match_upstream“.
	SchemeToOverwrite string `protobuf:"bytes,1,opt,name=scheme_to_overwrite,json=schemeToOverwrite,proto3,oneof"`
}

func (*SchemeHeaderTransformation_SchemeToOverwrite) isSchemeHeaderTransformation_Transformation() {}

// Config for QUIC connection migration across network interfaces, i.e. cellular to WIFI, upon
// network change events from the platform, i.e. the current network gets
// disconnected, or upon the QUIC detecting a bad connection. After migration, the
// connection may be on a different network other than the default network
// picked by the platform. Both iOS and Android will use a default network to interact with the internet, usually prefer unmetered network (WIFI)
// over metered ones (cellular). And users can specify which network to be used as the default. A connection on non-default network is only allowed to
// serve new requests for a certain period of time before being drained, and
// meanwhile, QUIC will try to migrate to the default network if possible.
type QuicProtocolOptions_ConnectionMigrationSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Config whether and how to migrate idle connections.
	// If absent, idle connections will not be migrated but be closed upon
	// migration signals.
	MigrateIdleConnections *QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings `protobuf:"bytes,1,opt,name=migrate_idle_connections,json=migrateIdleConnections,proto3" json:"migrate_idle_connections,omitempty"`
	// After migrating to a non-default network interface, the connection will
	// only be allowed to stay on that network for up to this period of time before
	// being drained unless it migrates to the default network or that network
	// gets picked as the default by the device by then.
	// Default to 128s.
	MaxTimeOnNonDefaultNetwork *durationpb.Duration `protobuf:"bytes,2,opt,name=max_time_on_non_default_network,json=maxTimeOnNonDefaultNetwork,proto3" json:"max_time_on_non_default_network,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *QuicProtocolOptions_ConnectionMigrationSettings) Reset() {
	*x = QuicProtocolOptions_ConnectionMigrationSettings{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuicProtocolOptions_ConnectionMigrationSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuicProtocolOptions_ConnectionMigrationSettings) ProtoMessage() {}

func (x *QuicProtocolOptions_ConnectionMigrationSettings) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuicProtocolOptions_ConnectionMigrationSettings.ProtoReflect.Descriptor instead.
func (*QuicProtocolOptions_ConnectionMigrationSettings) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{2, 0}
}

func (x *QuicProtocolOptions_ConnectionMigrationSettings) GetMigrateIdleConnections() *QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings {
	if x != nil {
		return x.MigrateIdleConnections
	}
	return nil
}

func (x *QuicProtocolOptions_ConnectionMigrationSettings) GetMaxTimeOnNonDefaultNetwork() *durationpb.Duration {
	if x != nil {
		return x.MaxTimeOnNonDefaultNetwork
	}
	return nil
}

// Config for options to migrate idle connections which aren't serving any requests.
type QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If idle connections are allowed to be migrated, only migrate the connection
	// if it hasn't been idle for longer than this idle period. Otherwise, the
	// connection will be closed instead.
	// Default to 30s.
	MaxIdleTimeBeforeMigration *durationpb.Duration `protobuf:"bytes,1,opt,name=max_idle_time_before_migration,json=maxIdleTimeBeforeMigration,proto3" json:"max_idle_time_before_migration,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings) Reset() {
	*x = QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings) ProtoMessage() {
}

func (x *QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings.ProtoReflect.Descriptor instead.
func (*QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings) GetMaxIdleTimeBeforeMigration() *durationpb.Duration {
	if x != nil {
		return x.MaxIdleTimeBeforeMigration
	}
	return nil
}

// Allows pre-populating the cache with HTTP/3 alternate protocols entries with a 7 day lifetime.
// This will cause Envoy to attempt HTTP/3 to those upstreams, even if the upstreams have not
// advertised HTTP/3 support. These entries will be overwritten by alt-svc
// response headers or cached values.
// As with regular cached entries, if the origin response would result in clearing an existing
// alternate protocol cache entry, pre-populated entries will also be cleared.
// Adding a cache entry with hostname=foo.com port=123 is the equivalent of getting
// response headers
// alt-svc: h3=:"123"; ma=86400" in a response to a request to foo.com:123
type AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The host name for the alternate protocol entry.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// The port for the alternate protocol entry.
	Port          uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry) Reset() {
	*x = AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry) ProtoMessage() {}

func (x *AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry.ProtoReflect.Descriptor instead.
func (*AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{4, 0}
}

func (x *AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// [#next-free-field: 9]
type Http1ProtocolOptions_HeaderKeyFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to HeaderFormat:
	//
	//	*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_
	//	*Http1ProtocolOptions_HeaderKeyFormat_StatefulFormatter
	HeaderFormat  isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat `protobuf_oneof:"header_format"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Http1ProtocolOptions_HeaderKeyFormat) Reset() {
	*x = Http1ProtocolOptions_HeaderKeyFormat{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Http1ProtocolOptions_HeaderKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http1ProtocolOptions_HeaderKeyFormat) ProtoMessage() {}

func (x *Http1ProtocolOptions_HeaderKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http1ProtocolOptions_HeaderKeyFormat.ProtoReflect.Descriptor instead.
func (*Http1ProtocolOptions_HeaderKeyFormat) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Http1ProtocolOptions_HeaderKeyFormat) GetHeaderFormat() isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat {
	if x != nil {
		return x.HeaderFormat
	}
	return nil
}

func (x *Http1ProtocolOptions_HeaderKeyFormat) GetProperCaseWords() *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords {
	if x != nil {
		if x, ok := x.HeaderFormat.(*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_); ok {
			return x.ProperCaseWords
		}
	}
	return nil
}

func (x *Http1ProtocolOptions_HeaderKeyFormat) GetStatefulFormatter() *TypedExtensionConfig {
	if x != nil {
		if x, ok := x.HeaderFormat.(*Http1ProtocolOptions_HeaderKeyFormat_StatefulFormatter); ok {
			return x.StatefulFormatter
		}
	}
	return nil
}

type isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat interface {
	isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat()
}

type Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_ struct {
	// Formats the header by proper casing words: the first character and any character following
	// a special character will be capitalized if it's an alpha character. For example,
	// “"content-type"“ becomes “"Content-Type"“, and “"foo$b#$are"“ becomes “"Foo$B#$Are"“.
	//
	// .. note::
	//
	//	While this results in most headers following conventional casing, certain headers
	//	are not covered. For example, the ``"TE"`` header will be formatted as ``"Te"``.
	ProperCaseWords *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords `protobuf:"bytes,1,opt,name=proper_case_words,json=properCaseWords,proto3,oneof"`
}

type Http1ProtocolOptions_HeaderKeyFormat_StatefulFormatter struct {
	// Configuration for stateful formatter extensions that allow using received headers to
	// affect the output of encoding headers. E.g., preserving case during proxying.
	// [#extension-category: envoy.http.stateful_header_formatters]
	StatefulFormatter *TypedExtensionConfig `protobuf:"bytes,8,opt,name=stateful_formatter,json=statefulFormatter,proto3,oneof"`
}

func (*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_) isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat() {
}

func (*Http1ProtocolOptions_HeaderKeyFormat_StatefulFormatter) isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat() {
}

type Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) Reset() {
	*x = Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) ProtoMessage() {}

func (x *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords.ProtoReflect.Descriptor instead.
func (*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{6, 0, 0}
}

// Defines a parameter to be sent in the SETTINGS frame.
// See `RFC7540, sec. 6.5.1 <https://tools.ietf.org/html/rfc7540#section-6.5.1>`_ for details.
type Http2ProtocolOptions_SettingsParameter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The 16 bit parameter identifier.
	Identifier *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=identifier,proto3" json:"identifier,omitempty"`
	// The 32 bit parameter value.
	Value         *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Http2ProtocolOptions_SettingsParameter) Reset() {
	*x = Http2ProtocolOptions_SettingsParameter{}
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Http2ProtocolOptions_SettingsParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http2ProtocolOptions_SettingsParameter) ProtoMessage() {}

func (x *Http2ProtocolOptions_SettingsParameter) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_core_v3_protocol_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http2ProtocolOptions_SettingsParameter.ProtoReflect.Descriptor instead.
func (*Http2ProtocolOptions_SettingsParameter) Descriptor() ([]byte, []int) {
	return file_envoy_config_core_v3_protocol_proto_rawDescGZIP(), []int{8, 0}
}

func (x *Http2ProtocolOptions_SettingsParameter) GetIdentifier() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Identifier
	}
	return nil
}

func (x *Http2ProtocolOptions_SettingsParameter) GetValue() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Value
	}
	return nil
}

var File_envoy_config_core_v3_protocol_proto protoreflect.FileDescriptor

const file_envoy_config_core_v3_protocol_proto_rawDesc = "" +
	"\n" +
	"#envoy/config/core/v3/protocol.proto\x12\x14envoy.config.core.v3\x1a$envoy/config/core/v3/extension.proto\x1a\"envoy/type/matcher/v3/string.proto\x1a\x1benvoy/type/v3/percent.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1fxds/annotations/v3/status.proto\x1a#envoy/annotations/deprecation.proto\x1a\x1dudpa/annotations/status.proto\x1a!udpa/annotations/versioning.proto\x1a\x17validate/validate.proto\"A\n" +
	"\x12TcpProtocolOptions:+\x9aň\x1e&\n" +
	"$envoy.api.v2.core.TcpProtocolOptions\"\xab\x01\n" +
	"\x15QuicKeepAliveSettings\x12<\n" +
	"\fmax_interval\x18\x01 \x01(\v2\x19.google.protobuf.DurationR\vmaxInterval\x12T\n" +
	"\x10initial_interval\x18\x02 \x01(\v2\x19.google.protobuf.DurationB\x0e\xfaB\v\xaa\x01\b\"\x002\x04\x10\xc0\x84=R\x0finitialInterval\"\xc7\v\n" +
	"\x13QuicProtocolOptions\x12[\n" +
	"\x16max_concurrent_streams\x18\x01 \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\xfaB\x04*\x02(\x01R\x14maxConcurrentStreams\x12g\n" +
	"\x1ainitial_stream_window_size\x18\x02 \x01(\v2\x1c.google.protobuf.UInt32ValueB\f\xfaB\t*\a\x18\x80\x80\x80\b(\x01R\x17initialStreamWindowSize\x12o\n" +
	"\x1einitial_connection_window_size\x18\x03 \x01(\v2\x1c.google.protobuf.UInt32ValueB\f\xfaB\t*\a\x18\x80\x80\x80\f(\x01R\x1binitialConnectionWindowSize\x12z\n" +
	"&num_timeouts_to_trigger_port_migration\x18\x04 \x01(\v2\x1c.google.protobuf.UInt32ValueB\t\xfaB\x06*\x04\x18\x05(\x00R!numTimeoutsToTriggerPortMigration\x12^\n" +
	"\x14connection_keepalive\x18\x05 \x01(\v2+.envoy.config.core.v3.QuicKeepAliveSettingsR\x13connectionKeepalive\x12-\n" +
	"\x12connection_options\x18\x06 \x01(\tR\x11connectionOptions\x12:\n" +
	"\x19client_connection_options\x18\a \x01(\tR\x17clientConnectionOptions\x12W\n" +
	"\x14idle_network_timeout\x18\b \x01(\v2\x19.google.protobuf.DurationB\n" +
	"\xfaB\a\xaa\x01\x042\x02\b\x01R\x12idleNetworkTimeout\x12H\n" +
	"\x11max_packet_length\x18\t \x01(\v2\x1c.google.protobuf.UInt64ValueR\x0fmaxPacketLength\x12\\\n" +
	"\x14client_packet_writer\x18\n" +
	" \x01(\v2*.envoy.config.core.v3.TypedExtensionConfigR\x12clientPacketWriter\x12x\n" +
	"\x14connection_migration\x18\v \x01(\v2E.envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettingsR\x13connectionMigration\x1a\xb6\x03\n" +
	"\x1bConnectionMigrationSettings\x12\x9d\x01\n" +
	"\x18migrate_idle_connections\x18\x01 \x01(\v2c.envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettings.MigrateIdleConnectionSettingsR\x16migrateIdleConnections\x12j\n" +
	"\x1fmax_time_on_non_default_network\x18\x02 \x01(\v2\x19.google.protobuf.DurationB\n" +
	"\xfaB\a\xaa\x01\x042\x02\b\x01R\x1amaxTimeOnNonDefaultNetwork\x1a\x8a\x01\n" +
	"\x1dMigrateIdleConnectionSettings\x12i\n" +
	"\x1emax_idle_time_before_migration\x18\x01 \x01(\v2\x19.google.protobuf.DurationB\n" +
	"\xfaB\a\xaa\x01\x042\x02\b\x01R\x1amaxIdleTimeBeforeMigration\"\xe4\x01\n" +
	"\x1bUpstreamHttpProtocolOptions\x12\x19\n" +
	"\bauto_sni\x18\x01 \x01(\bR\aautoSni\x12.\n" +
	"\x13auto_san_validation\x18\x02 \x01(\bR\x11autoSanValidation\x12D\n" +
	"\x18override_auto_sni_header\x18\x03 \x01(\tB\v\xfaB\br\x06\xd0\x01\x01\xc0\x01\x01R\x15overrideAutoSniHeader:4\x9aň\x1e/\n" +
	"-envoy.api.v2.core.UpstreamHttpProtocolOptions\"\x86\x04\n" +
	"\x1eAlternateProtocolsCacheOptions\x12\x1b\n" +
	"\x04name\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\x04name\x12F\n" +
	"\vmax_entries\x18\x02 \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\xfaB\x04*\x02 \x00R\n" +
	"maxEntries\x12_\n" +
	"\x16key_value_store_config\x18\x03 \x01(\v2*.envoy.config.core.v3.TypedExtensionConfigR\x13keyValueStoreConfig\x12\x84\x01\n" +
	"\x14prepopulated_entries\x18\x04 \x03(\v2Q.envoy.config.core.v3.AlternateProtocolsCacheOptions.AlternateProtocolsCacheEntryR\x13prepopulatedEntries\x12-\n" +
	"\x12canonical_suffixes\x18\x05 \x03(\tR\x11canonicalSuffixes\x1ah\n" +
	"\x1cAlternateProtocolsCacheEntry\x12'\n" +
	"\bhostname\x18\x01 \x01(\tB\v\xfaB\br\x06\xd0\x01\x01\xc0\x01\x01R\bhostname\x12\x1f\n" +
	"\x04port\x18\x02 \x01(\rB\v\xfaB\b*\x06\x10\xff\xff\x03 \x00R\x04port\"\x90\x06\n" +
	"\x13HttpProtocolOptions\x12<\n" +
	"\fidle_timeout\x18\x01 \x01(\v2\x19.google.protobuf.DurationR\vidleTimeout\x12Q\n" +
	"\x17max_connection_duration\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\x15maxConnectionDuration\x12Q\n" +
	"\x11max_headers_count\x18\x02 \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\xfaB\x04*\x02(\x01R\x0fmaxHeadersCount\x12_\n" +
	"\x17max_response_headers_kb\x18\a \x01(\v2\x1c.google.protobuf.UInt32ValueB\n" +
	"\xfaB\a*\x05\x18\x80@ \x00R\x14maxResponseHeadersKb\x12I\n" +
	"\x13max_stream_duration\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\x11maxStreamDuration\x12\x8d\x01\n" +
	"\x1fheaders_with_underscores_action\x18\x05 \x01(\x0e2F.envoy.config.core.v3.HttpProtocolOptions.HeadersWithUnderscoresActionR\x1cheadersWithUnderscoresAction\x12[\n" +
	"\x1bmax_requests_per_connection\x18\x06 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x18maxRequestsPerConnection\"N\n" +
	"\x1cHeadersWithUnderscoresAction\x12\t\n" +
	"\x05ALLOW\x10\x00\x12\x12\n" +
	"\x0eREJECT_REQUEST\x10\x01\x12\x0f\n" +
	"\vDROP_HEADER\x10\x02:,\x9aň\x1e'\n" +
	"%envoy.api.v2.core.HttpProtocolOptions\"\xf1\t\n" +
	"\x14Http1ProtocolOptions\x12H\n" +
	"\x12allow_absolute_url\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\x10allowAbsoluteUrl\x12$\n" +
	"\x0eaccept_http_10\x18\x02 \x01(\bR\facceptHttp10\x126\n" +
	"\x18default_host_for_http_10\x18\x03 \x01(\tR\x14defaultHostForHttp10\x12f\n" +
	"\x11header_key_format\x18\x04 \x01(\v2:.envoy.config.core.v3.Http1ProtocolOptions.HeaderKeyFormatR\x0fheaderKeyFormat\x12'\n" +
	"\x0fenable_trailers\x18\x05 \x01(\bR\x0eenableTrailers\x120\n" +
	"\x14allow_chunked_length\x18\x06 \x01(\bR\x12allowChunkedLength\x12z\n" +
	"-override_stream_error_on_invalid_http_message\x18\a \x01(\v2\x1a.google.protobuf.BoolValueR'overrideStreamErrorOnInvalidHttpMessage\x127\n" +
	"\x18send_fully_qualified_url\x18\b \x01(\bR\x15sendFullyQualifiedUrl\x12Q\n" +
	"\x10use_balsa_parser\x18\t \x01(\v2\x1a.google.protobuf.BoolValueB\v\x92ǆ\xd8\x04\x033.0\x18\x01R\x0euseBalsaParser\x12:\n" +
	"\x14allow_custom_methods\x18\n" +
	" \x01(\bB\b\xd2Ƥ\xe1\x06\x02\b\x01R\x12allowCustomMethods\x12Y\n" +
	"\x16ignore_http_11_upgrade\x18\v \x03(\v2$.envoy.type.matcher.v3.StringMatcherR\x13ignoreHttp11Upgrade\x1a\x9f\x03\n" +
	"\x0fHeaderKeyFormat\x12x\n" +
	"\x11proper_case_words\x18\x01 \x01(\v2J.envoy.config.core.v3.Http1ProtocolOptions.HeaderKeyFormat.ProperCaseWordsH\x00R\x0fproperCaseWords\x12[\n" +
	"\x12stateful_formatter\x18\b \x01(\v2*.envoy.config.core.v3.TypedExtensionConfigH\x00R\x11statefulFormatter\x1a`\n" +
	"\x0fProperCaseWords:M\x9aň\x1eH\n" +
	"Fenvoy.api.v2.core.Http1ProtocolOptions.HeaderKeyFormat.ProperCaseWords:=\x9aň\x1e8\n" +
	"6envoy.api.v2.core.Http1ProtocolOptions.HeaderKeyFormatB\x14\n" +
	"\rheader_format\x12\x03\xf8B\x01:-\x9aň\x1e(\n" +
	"&envoy.api.v2.core.Http1ProtocolOptions\"\xc1\x02\n" +
	"\x11KeepaliveSettings\x12C\n" +
	"\binterval\x18\x01 \x01(\v2\x19.google.protobuf.DurationB\f\xfaB\t\xaa\x01\x062\x04\x10\xc0\x84=R\binterval\x12C\n" +
	"\atimeout\x18\x02 \x01(\v2\x19.google.protobuf.DurationB\x0e\xfaB\v\xaa\x01\b\b\x012\x04\x10\xc0\x84=R\atimeout\x12?\n" +
	"\x0finterval_jitter\x18\x03 \x01(\v2\x16.envoy.type.v3.PercentR\x0eintervalJitter\x12a\n" +
	"\x18connection_idle_interval\x18\x04 \x01(\v2\x19.google.protobuf.DurationB\f\xfaB\t\xaa\x01\x062\x04\x10\xc0\x84=R\x16connectionIdleInterval\"\xee\x0f\n" +
	"\x14Http2ProtocolOptions\x12F\n" +
	"\x10hpack_table_size\x18\x01 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x0ehpackTableSize\x12a\n" +
	"\x16max_concurrent_streams\x18\x02 \x01(\v2\x1c.google.protobuf.UInt32ValueB\r\xfaB\n" +
	"*\b\x18\xff\xff\xff\xff\a(\x01R\x14maxConcurrentStreams\x12j\n" +
	"\x1ainitial_stream_window_size\x18\x03 \x01(\v2\x1c.google.protobuf.UInt32ValueB\x0f\xfaB\f*\n" +
	"\x18\xff\xff\xff\xff\a(\xff\xff\x03R\x17initialStreamWindowSize\x12r\n" +
	"\x1einitial_connection_window_size\x18\x04 \x01(\v2\x1c.google.protobuf.UInt32ValueB\x0f\xfaB\f*\n" +
	"\x18\xff\xff\xff\xff\a(\xff\xff\x03R\x1binitialConnectionWindowSize\x12#\n" +
	"\rallow_connect\x18\x05 \x01(\bR\fallowConnect\x12%\n" +
	"\x0eallow_metadata\x18\x06 \x01(\bR\rallowMetadata\x12U\n" +
	"\x13max_outbound_frames\x18\a \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\xfaB\x04*\x02(\x01R\x11maxOutboundFrames\x12d\n" +
	"\x1bmax_outbound_control_frames\x18\b \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\xfaB\x04*\x02(\x01R\x18maxOutboundControlFrames\x12\x84\x01\n" +
	"1max_consecutive_inbound_frames_with_empty_payload\x18\t \x01(\v2\x1c.google.protobuf.UInt32ValueR+maxConsecutiveInboundFramesWithEmptyPayload\x12o\n" +
	"&max_inbound_priority_frames_per_stream\x18\n" +
	" \x01(\v2\x1c.google.protobuf.UInt32ValueR!maxInboundPriorityFramesPerStream\x12\x91\x01\n" +
	"4max_inbound_window_update_frames_per_data_frame_sent\x18\v \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\xfaB\x04*\x02(\x01R,maxInboundWindowUpdateFramesPerDataFrameSent\x12^\n" +
	"&stream_error_on_invalid_http_messaging\x18\f \x01(\bB\v\x92ǆ\xd8\x04\x033.0\x18\x01R!streamErrorOnInvalidHttpMessaging\x12z\n" +
	"-override_stream_error_on_invalid_http_message\x18\x0e \x01(\v2\x1a.google.protobuf.BoolValueR'overrideStreamErrorOnInvalidHttpMessage\x12z\n" +
	"\x1acustom_settings_parameters\x18\r \x03(\v2<.envoy.config.core.v3.Http2ProtocolOptions.SettingsParameterR\x18customSettingsParameters\x12Z\n" +
	"\x14connection_keepalive\x18\x0f \x01(\v2'.envoy.config.core.v3.KeepaliveSettingsR\x13connectionKeepalive\x12P\n" +
	"\x11use_oghttp2_codec\x18\x10 \x01(\v2\x1a.google.protobuf.BoolValueB\b\xd2Ƥ\xe1\x06\x02\b\x01R\x0fuseOghttp2Codec\x12H\n" +
	"\x11max_metadata_size\x18\x11 \x01(\v2\x1c.google.protobuf.UInt64ValueR\x0fmaxMetadataSize\x12R\n" +
	"\x17enable_huffman_encoding\x18\x12 \x01(\v2\x1a.google.protobuf.BoolValueR\x15enableHuffmanEncoding\x1a\xe2\x01\n" +
	"\x11SettingsParameter\x12N\n" +
	"\n" +
	"identifier\x18\x01 \x01(\v2\x1c.google.protobuf.UInt32ValueB\x10\xfaB\r\x8a\x01\x02\x10\x01*\x06\x18\xff\xff\x03(\x00R\n" +
	"identifier\x12<\n" +
	"\x05value\x18\x02 \x01(\v2\x1c.google.protobuf.UInt32ValueB\b\xfaB\x05\x8a\x01\x02\x10\x01R\x05value:?\x9aň\x1e:\n" +
	"8envoy.api.v2.core.Http2ProtocolOptions.SettingsParameter:-\x9aň\x1e(\n" +
	"&envoy.api.v2.core.Http2ProtocolOptions\"\xa5\x01\n" +
	"\x13GrpcProtocolOptions\x12`\n" +
	"\x16http2_protocol_options\x18\x01 \x01(\v2*.envoy.config.core.v3.Http2ProtocolOptionsR\x14http2ProtocolOptions:,\x9aň\x1e'\n" +
	"%envoy.api.v2.core.GrpcProtocolOptions\"\xda\x03\n" +
	"\x14Http3ProtocolOptions\x12]\n" +
	"\x15quic_protocol_options\x18\x01 \x01(\v2).envoy.config.core.v3.QuicProtocolOptionsR\x13quicProtocolOptions\x12z\n" +
	"-override_stream_error_on_invalid_http_message\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR'overrideStreamErrorOnInvalidHttpMessage\x12>\n" +
	"\x16allow_extended_connect\x18\x05 \x01(\bB\b\xd2Ƥ\xe1\x06\x02\b\x01R\x14allowExtendedConnect\x12%\n" +
	"\x0eallow_metadata\x18\x06 \x01(\bR\rallowMetadata\x12#\n" +
	"\rdisable_qpack\x18\a \x01(\bR\fdisableQpack\x12[\n" +
	"+disable_connection_flow_control_for_streams\x18\b \x01(\bR&disableConnectionFlowControlForStreams\"\x9b\x01\n" +
	"\x1aSchemeHeaderTransformation\x12D\n" +
	"\x13scheme_to_overwrite\x18\x01 \x01(\tB\x12\xfaB\x0fr\rR\x04httpR\x05httpsH\x00R\x11schemeToOverwrite\x12%\n" +
	"\x0ematch_upstream\x18\x02 \x01(\bR\rmatchUpstreamB\x10\n" +
	"\x0etransformationB\x81\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\n" +
	"\"io.envoyproxy.envoy.config.core.v3B\rProtocolProtoP\x01ZBgithub.com/envoyproxy/go-control-plane/envoy/config/core/v3;corev3b\x06proto3"

var (
	file_envoy_config_core_v3_protocol_proto_rawDescOnce sync.Once
	file_envoy_config_core_v3_protocol_proto_rawDescData []byte
)

func file_envoy_config_core_v3_protocol_proto_rawDescGZIP() []byte {
	file_envoy_config_core_v3_protocol_proto_rawDescOnce.Do(func() {
		file_envoy_config_core_v3_protocol_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_config_core_v3_protocol_proto_rawDesc), len(file_envoy_config_core_v3_protocol_proto_rawDesc)))
	})
	return file_envoy_config_core_v3_protocol_proto_rawDescData
}

var file_envoy_config_core_v3_protocol_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_envoy_config_core_v3_protocol_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_envoy_config_core_v3_protocol_proto_goTypes = []any{
	(HttpProtocolOptions_HeadersWithUnderscoresAction)(0),   // 0: envoy.config.core.v3.HttpProtocolOptions.HeadersWithUnderscoresAction
	(*TcpProtocolOptions)(nil),                              // 1: envoy.config.core.v3.TcpProtocolOptions
	(*QuicKeepAliveSettings)(nil),                           // 2: envoy.config.core.v3.QuicKeepAliveSettings
	(*QuicProtocolOptions)(nil),                             // 3: envoy.config.core.v3.QuicProtocolOptions
	(*UpstreamHttpProtocolOptions)(nil),                     // 4: envoy.config.core.v3.UpstreamHttpProtocolOptions
	(*AlternateProtocolsCacheOptions)(nil),                  // 5: envoy.config.core.v3.AlternateProtocolsCacheOptions
	(*HttpProtocolOptions)(nil),                             // 6: envoy.config.core.v3.HttpProtocolOptions
	(*Http1ProtocolOptions)(nil),                            // 7: envoy.config.core.v3.Http1ProtocolOptions
	(*KeepaliveSettings)(nil),                               // 8: envoy.config.core.v3.KeepaliveSettings
	(*Http2ProtocolOptions)(nil),                            // 9: envoy.config.core.v3.Http2ProtocolOptions
	(*GrpcProtocolOptions)(nil),                             // 10: envoy.config.core.v3.GrpcProtocolOptions
	(*Http3ProtocolOptions)(nil),                            // 11: envoy.config.core.v3.Http3ProtocolOptions
	(*SchemeHeaderTransformation)(nil),                      // 12: envoy.config.core.v3.SchemeHeaderTransformation
	(*QuicProtocolOptions_ConnectionMigrationSettings)(nil), // 13: envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettings
	(*QuicProtocolOptions_ConnectionMigrationSettings_MigrateIdleConnectionSettings)(nil), // 14: envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettings.MigrateIdleConnectionSettings
	(*AlternateProtocolsCacheOptions_AlternateProtocolsCacheEntry)(nil),                   // 15: envoy.config.core.v3.AlternateProtocolsCacheOptions.AlternateProtocolsCacheEntry
	(*Http1ProtocolOptions_HeaderKeyFormat)(nil),                                          // 16: envoy.config.core.v3.Http1ProtocolOptions.HeaderKeyFormat
	(*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords)(nil),                          // 17: envoy.config.core.v3.Http1ProtocolOptions.HeaderKeyFormat.ProperCaseWords
	(*Http2ProtocolOptions_SettingsParameter)(nil),                                        // 18: envoy.config.core.v3.Http2ProtocolOptions.SettingsParameter
	(*durationpb.Duration)(nil),                                                           // 19: google.protobuf.Duration
	(*wrapperspb.UInt32Value)(nil),                                                        // 20: google.protobuf.UInt32Value
	(*wrapperspb.UInt64Value)(nil),                                                        // 21: google.protobuf.UInt64Value
	(*TypedExtensionConfig)(nil),                                                          // 22: envoy.config.core.v3.TypedExtensionConfig
	(*wrapperspb.BoolValue)(nil),                                                          // 23: google.protobuf.BoolValue
	(*v3.StringMatcher)(nil),                                                              // 24: envoy.type.matcher.v3.StringMatcher
	(*v31.Percent)(nil),                                                                   // 25: envoy.type.v3.Percent
}
var file_envoy_config_core_v3_protocol_proto_depIdxs = []int32{
	19, // 0: envoy.config.core.v3.QuicKeepAliveSettings.max_interval:type_name -> google.protobuf.Duration
	19, // 1: envoy.config.core.v3.QuicKeepAliveSettings.initial_interval:type_name -> google.protobuf.Duration
	20, // 2: envoy.config.core.v3.QuicProtocolOptions.max_concurrent_streams:type_name -> google.protobuf.UInt32Value
	20, // 3: envoy.config.core.v3.QuicProtocolOptions.initial_stream_window_size:type_name -> google.protobuf.UInt32Value
	20, // 4: envoy.config.core.v3.QuicProtocolOptions.initial_connection_window_size:type_name -> google.protobuf.UInt32Value
	20, // 5: envoy.config.core.v3.QuicProtocolOptions.num_timeouts_to_trigger_port_migration:type_name -> google.protobuf.UInt32Value
	2,  // 6: envoy.config.core.v3.QuicProtocolOptions.connection_keepalive:type_name -> envoy.config.core.v3.QuicKeepAliveSettings
	19, // 7: envoy.config.core.v3.QuicProtocolOptions.idle_network_timeout:type_name -> google.protobuf.Duration
	21, // 8: envoy.config.core.v3.QuicProtocolOptions.max_packet_length:type_name -> google.protobuf.UInt64Value
	22, // 9: envoy.config.core.v3.QuicProtocolOptions.client_packet_writer:type_name -> envoy.config.core.v3.TypedExtensionConfig
	13, // 10: envoy.config.core.v3.QuicProtocolOptions.connection_migration:type_name -> envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettings
	20, // 11: envoy.config.core.v3.AlternateProtocolsCacheOptions.max_entries:type_name -> google.protobuf.UInt32Value
	22, // 12: envoy.config.core.v3.AlternateProtocolsCacheOptions.key_value_store_config:type_name -> envoy.config.core.v3.TypedExtensionConfig
	15, // 13: envoy.config.core.v3.AlternateProtocolsCacheOptions.prepopulated_entries:type_name -> envoy.config.core.v3.AlternateProtocolsCacheOptions.AlternateProtocolsCacheEntry
	19, // 14: envoy.config.core.v3.HttpProtocolOptions.idle_timeout:type_name -> google.protobuf.Duration
	19, // 15: envoy.config.core.v3.HttpProtocolOptions.max_connection_duration:type_name -> google.protobuf.Duration
	20, // 16: envoy.config.core.v3.HttpProtocolOptions.max_headers_count:type_name -> google.protobuf.UInt32Value
	20, // 17: envoy.config.core.v3.HttpProtocolOptions.max_response_headers_kb:type_name -> google.protobuf.UInt32Value
	19, // 18: envoy.config.core.v3.HttpProtocolOptions.max_stream_duration:type_name -> google.protobuf.Duration
	0,  // 19: envoy.config.core.v3.HttpProtocolOptions.headers_with_underscores_action:type_name -> envoy.config.core.v3.HttpProtocolOptions.HeadersWithUnderscoresAction
	20, // 20: envoy.config.core.v3.HttpProtocolOptions.max_requests_per_connection:type_name -> google.protobuf.UInt32Value
	23, // 21: envoy.config.core.v3.Http1ProtocolOptions.allow_absolute_url:type_name -> google.protobuf.BoolValue
	16, // 22: envoy.config.core.v3.Http1ProtocolOptions.header_key_format:type_name -> envoy.config.core.v3.Http1ProtocolOptions.HeaderKeyFormat
	23, // 23: envoy.config.core.v3.Http1ProtocolOptions.override_stream_error_on_invalid_http_message:type_name -> google.protobuf.BoolValue
	23, // 24: envoy.config.core.v3.Http1ProtocolOptions.use_balsa_parser:type_name -> google.protobuf.BoolValue
	24, // 25: envoy.config.core.v3.Http1ProtocolOptions.ignore_http_11_upgrade:type_name -> envoy.type.matcher.v3.StringMatcher
	19, // 26: envoy.config.core.v3.KeepaliveSettings.interval:type_name -> google.protobuf.Duration
	19, // 27: envoy.config.core.v3.KeepaliveSettings.timeout:type_name -> google.protobuf.Duration
	25, // 28: envoy.config.core.v3.KeepaliveSettings.interval_jitter:type_name -> envoy.type.v3.Percent
	19, // 29: envoy.config.core.v3.KeepaliveSettings.connection_idle_interval:type_name -> google.protobuf.Duration
	20, // 30: envoy.config.core.v3.Http2ProtocolOptions.hpack_table_size:type_name -> google.protobuf.UInt32Value
	20, // 31: envoy.config.core.v3.Http2ProtocolOptions.max_concurrent_streams:type_name -> google.protobuf.UInt32Value
	20, // 32: envoy.config.core.v3.Http2ProtocolOptions.initial_stream_window_size:type_name -> google.protobuf.UInt32Value
	20, // 33: envoy.config.core.v3.Http2ProtocolOptions.initial_connection_window_size:type_name -> google.protobuf.UInt32Value
	20, // 34: envoy.config.core.v3.Http2ProtocolOptions.max_outbound_frames:type_name -> google.protobuf.UInt32Value
	20, // 35: envoy.config.core.v3.Http2ProtocolOptions.max_outbound_control_frames:type_name -> google.protobuf.UInt32Value
	20, // 36: envoy.config.core.v3.Http2ProtocolOptions.max_consecutive_inbound_frames_with_empty_payload:type_name -> google.protobuf.UInt32Value
	20, // 37: envoy.config.core.v3.Http2ProtocolOptions.max_inbound_priority_frames_per_stream:type_name -> google.protobuf.UInt32Value
	20, // 38: envoy.config.core.v3.Http2ProtocolOptions.max_inbound_window_update_frames_per_data_frame_sent:type_name -> google.protobuf.UInt32Value
	23, // 39: envoy.config.core.v3.Http2ProtocolOptions.override_stream_error_on_invalid_http_message:type_name -> google.protobuf.BoolValue
	18, // 40: envoy.config.core.v3.Http2ProtocolOptions.custom_settings_parameters:type_name -> envoy.config.core.v3.Http2ProtocolOptions.SettingsParameter
	8,  // 41: envoy.config.core.v3.Http2ProtocolOptions.connection_keepalive:type_name -> envoy.config.core.v3.KeepaliveSettings
	23, // 42: envoy.config.core.v3.Http2ProtocolOptions.use_oghttp2_codec:type_name -> google.protobuf.BoolValue
	21, // 43: envoy.config.core.v3.Http2ProtocolOptions.max_metadata_size:type_name -> google.protobuf.UInt64Value
	23, // 44: envoy.config.core.v3.Http2ProtocolOptions.enable_huffman_encoding:type_name -> google.protobuf.BoolValue
	9,  // 45: envoy.config.core.v3.GrpcProtocolOptions.http2_protocol_options:type_name -> envoy.config.core.v3.Http2ProtocolOptions
	3,  // 46: envoy.config.core.v3.Http3ProtocolOptions.quic_protocol_options:type_name -> envoy.config.core.v3.QuicProtocolOptions
	23, // 47: envoy.config.core.v3.Http3ProtocolOptions.override_stream_error_on_invalid_http_message:type_name -> google.protobuf.BoolValue
	14, // 48: envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettings.migrate_idle_connections:type_name -> envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettings.MigrateIdleConnectionSettings
	19, // 49: envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettings.max_time_on_non_default_network:type_name -> google.protobuf.Duration
	19, // 50: envoy.config.core.v3.QuicProtocolOptions.ConnectionMigrationSettings.MigrateIdleConnectionSettings.max_idle_time_before_migration:type_name -> google.protobuf.Duration
	17, // 51: envoy.config.core.v3.Http1ProtocolOptions.HeaderKeyFormat.proper_case_words:type_name -> envoy.config.core.v3.Http1ProtocolOptions.HeaderKeyFormat.ProperCaseWords
	22, // 52: envoy.config.core.v3.Http1ProtocolOptions.HeaderKeyFormat.stateful_formatter:type_name -> envoy.config.core.v3.TypedExtensionConfig
	20, // 53: envoy.config.core.v3.Http2ProtocolOptions.SettingsParameter.identifier:type_name -> google.protobuf.UInt32Value
	20, // 54: envoy.config.core.v3.Http2ProtocolOptions.SettingsParameter.value:type_name -> google.protobuf.UInt32Value
	55, // [55:55] is the sub-list for method output_type
	55, // [55:55] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_envoy_config_core_v3_protocol_proto_init() }
func file_envoy_config_core_v3_protocol_proto_init() {
	if File_envoy_config_core_v3_protocol_proto != nil {
		return
	}
	file_envoy_config_core_v3_extension_proto_init()
	file_envoy_config_core_v3_protocol_proto_msgTypes[11].OneofWrappers = []any{
		(*SchemeHeaderTransformation_SchemeToOverwrite)(nil),
	}
	file_envoy_config_core_v3_protocol_proto_msgTypes[15].OneofWrappers = []any{
		(*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_)(nil),
		(*Http1ProtocolOptions_HeaderKeyFormat_StatefulFormatter)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_config_core_v3_protocol_proto_rawDesc), len(file_envoy_config_core_v3_protocol_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_config_core_v3_protocol_proto_goTypes,
		DependencyIndexes: file_envoy_config_core_v3_protocol_proto_depIdxs,
		EnumInfos:         file_envoy_config_core_v3_protocol_proto_enumTypes,
		MessageInfos:      file_envoy_config_core_v3_protocol_proto_msgTypes,
	}.Build()
	File_envoy_config_core_v3_protocol_proto = out.File
	file_envoy_config_core_v3_protocol_proto_goTypes = nil
	file_envoy_config_core_v3_protocol_proto_depIdxs = nil
}
