//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/rate_limit_quota/v3/rate_limit_quota.proto

package rate_limit_quotav3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on RateLimitQuotaFilterConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimitQuotaFilterConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimitQuotaFilterConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimitQuotaFilterConfigMultiError, or nil if none found.
func (m *RateLimitQuotaFilterConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaFilterConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetRlqsServer() == nil {
		err := RateLimitQuotaFilterConfigValidationError{
			field:  "RlqsServer",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRlqsServer()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaFilterConfigValidationError{
					field:  "RlqsServer",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaFilterConfigValidationError{
					field:  "RlqsServer",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRlqsServer()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaFilterConfigValidationError{
				field:  "RlqsServer",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetDomain()) < 1 {
		err := RateLimitQuotaFilterConfigValidationError{
			field:  "Domain",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetBucketMatchers() == nil {
		err := RateLimitQuotaFilterConfigValidationError{
			field:  "BucketMatchers",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetBucketMatchers()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaFilterConfigValidationError{
					field:  "BucketMatchers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaFilterConfigValidationError{
					field:  "BucketMatchers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBucketMatchers()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaFilterConfigValidationError{
				field:  "BucketMatchers",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetFilterEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaFilterConfigValidationError{
					field:  "FilterEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaFilterConfigValidationError{
					field:  "FilterEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilterEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaFilterConfigValidationError{
				field:  "FilterEnabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetFilterEnforced()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaFilterConfigValidationError{
					field:  "FilterEnforced",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaFilterConfigValidationError{
					field:  "FilterEnforced",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilterEnforced()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaFilterConfigValidationError{
				field:  "FilterEnforced",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetRequestHeadersToAddWhenNotEnforced()) > 10 {
		err := RateLimitQuotaFilterConfigValidationError{
			field:  "RequestHeadersToAddWhenNotEnforced",
			reason: "value must contain no more than 10 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRequestHeadersToAddWhenNotEnforced() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimitQuotaFilterConfigValidationError{
						field:  fmt.Sprintf("RequestHeadersToAddWhenNotEnforced[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimitQuotaFilterConfigValidationError{
						field:  fmt.Sprintf("RequestHeadersToAddWhenNotEnforced[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitQuotaFilterConfigValidationError{
					field:  fmt.Sprintf("RequestHeadersToAddWhenNotEnforced[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RateLimitQuotaFilterConfigMultiError(errors)
	}

	return nil
}

// RateLimitQuotaFilterConfigMultiError is an error wrapping multiple
// validation errors returned by RateLimitQuotaFilterConfig.ValidateAll() if
// the designated constraints aren't met.
type RateLimitQuotaFilterConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaFilterConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaFilterConfigMultiError) AllErrors() []error { return m }

// RateLimitQuotaFilterConfigValidationError is the validation error returned
// by RateLimitQuotaFilterConfig.Validate if the designated constraints aren't met.
type RateLimitQuotaFilterConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaFilterConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimitQuotaFilterConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimitQuotaFilterConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimitQuotaFilterConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimitQuotaFilterConfigValidationError) ErrorName() string {
	return "RateLimitQuotaFilterConfigValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaFilterConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaFilterConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaFilterConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaFilterConfigValidationError{}

// Validate checks the field values on RateLimitQuotaOverride with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimitQuotaOverride) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimitQuotaOverride with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimitQuotaOverrideMultiError, or nil if none found.
func (m *RateLimitQuotaOverride) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaOverride) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Domain

	if all {
		switch v := interface{}(m.GetBucketMatchers()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaOverrideValidationError{
					field:  "BucketMatchers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaOverrideValidationError{
					field:  "BucketMatchers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBucketMatchers()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaOverrideValidationError{
				field:  "BucketMatchers",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RateLimitQuotaOverrideMultiError(errors)
	}

	return nil
}

// RateLimitQuotaOverrideMultiError is an error wrapping multiple validation
// errors returned by RateLimitQuotaOverride.ValidateAll() if the designated
// constraints aren't met.
type RateLimitQuotaOverrideMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaOverrideMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaOverrideMultiError) AllErrors() []error { return m }

// RateLimitQuotaOverrideValidationError is the validation error returned by
// RateLimitQuotaOverride.Validate if the designated constraints aren't met.
type RateLimitQuotaOverrideValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaOverrideValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimitQuotaOverrideValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimitQuotaOverrideValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimitQuotaOverrideValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimitQuotaOverrideValidationError) ErrorName() string {
	return "RateLimitQuotaOverrideValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaOverrideValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaOverride.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaOverrideValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaOverrideValidationError{}

// Validate checks the field values on RateLimitQuotaBucketSettings with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimitQuotaBucketSettings) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimitQuotaBucketSettings with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimitQuotaBucketSettingsMultiError, or nil if none found.
func (m *RateLimitQuotaBucketSettings) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaBucketSettings) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetBucketIdBuilder()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettingsValidationError{
					field:  "BucketIdBuilder",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettingsValidationError{
					field:  "BucketIdBuilder",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBucketIdBuilder()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaBucketSettingsValidationError{
				field:  "BucketIdBuilder",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetReportingInterval() == nil {
		err := RateLimitQuotaBucketSettingsValidationError{
			field:  "ReportingInterval",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if d := m.GetReportingInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RateLimitQuotaBucketSettingsValidationError{
				field:  "ReportingInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 100000000*time.Nanosecond)

			if dur <= gt {
				err := RateLimitQuotaBucketSettingsValidationError{
					field:  "ReportingInterval",
					reason: "value must be greater than 100ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetDenyResponseSettings()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettingsValidationError{
					field:  "DenyResponseSettings",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettingsValidationError{
					field:  "DenyResponseSettings",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDenyResponseSettings()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaBucketSettingsValidationError{
				field:  "DenyResponseSettings",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetNoAssignmentBehavior()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettingsValidationError{
					field:  "NoAssignmentBehavior",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettingsValidationError{
					field:  "NoAssignmentBehavior",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetNoAssignmentBehavior()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaBucketSettingsValidationError{
				field:  "NoAssignmentBehavior",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetExpiredAssignmentBehavior()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettingsValidationError{
					field:  "ExpiredAssignmentBehavior",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettingsValidationError{
					field:  "ExpiredAssignmentBehavior",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetExpiredAssignmentBehavior()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaBucketSettingsValidationError{
				field:  "ExpiredAssignmentBehavior",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RateLimitQuotaBucketSettingsMultiError(errors)
	}

	return nil
}

// RateLimitQuotaBucketSettingsMultiError is an error wrapping multiple
// validation errors returned by RateLimitQuotaBucketSettings.ValidateAll() if
// the designated constraints aren't met.
type RateLimitQuotaBucketSettingsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaBucketSettingsMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaBucketSettingsMultiError) AllErrors() []error { return m }

// RateLimitQuotaBucketSettingsValidationError is the validation error returned
// by RateLimitQuotaBucketSettings.Validate if the designated constraints
// aren't met.
type RateLimitQuotaBucketSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaBucketSettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimitQuotaBucketSettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimitQuotaBucketSettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimitQuotaBucketSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimitQuotaBucketSettingsValidationError) ErrorName() string {
	return "RateLimitQuotaBucketSettingsValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaBucketSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaBucketSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaBucketSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaBucketSettingsValidationError{}

// Validate checks the field values on
// RateLimitQuotaBucketSettings_NoAssignmentBehavior with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RateLimitQuotaBucketSettings_NoAssignmentBehavior) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RateLimitQuotaBucketSettings_NoAssignmentBehavior with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// RateLimitQuotaBucketSettings_NoAssignmentBehaviorMultiError, or nil if none found.
func (m *RateLimitQuotaBucketSettings_NoAssignmentBehavior) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaBucketSettings_NoAssignmentBehavior) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofNoAssignmentBehaviorPresent := false
	switch v := m.NoAssignmentBehavior.(type) {
	case *RateLimitQuotaBucketSettings_NoAssignmentBehavior_FallbackRateLimit:
		if v == nil {
			err := RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError{
				field:  "NoAssignmentBehavior",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofNoAssignmentBehaviorPresent = true

		if all {
			switch v := interface{}(m.GetFallbackRateLimit()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError{
						field:  "FallbackRateLimit",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError{
						field:  "FallbackRateLimit",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetFallbackRateLimit()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError{
					field:  "FallbackRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofNoAssignmentBehaviorPresent {
		err := RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError{
			field:  "NoAssignmentBehavior",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RateLimitQuotaBucketSettings_NoAssignmentBehaviorMultiError(errors)
	}

	return nil
}

// RateLimitQuotaBucketSettings_NoAssignmentBehaviorMultiError is an error
// wrapping multiple validation errors returned by
// RateLimitQuotaBucketSettings_NoAssignmentBehavior.ValidateAll() if the
// designated constraints aren't met.
type RateLimitQuotaBucketSettings_NoAssignmentBehaviorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaBucketSettings_NoAssignmentBehaviorMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaBucketSettings_NoAssignmentBehaviorMultiError) AllErrors() []error { return m }

// RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError is the
// validation error returned by
// RateLimitQuotaBucketSettings_NoAssignmentBehavior.Validate if the
// designated constraints aren't met.
type RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError) ErrorName() string {
	return "RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaBucketSettings_NoAssignmentBehavior.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaBucketSettings_NoAssignmentBehaviorValidationError{}

// Validate checks the field values on
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorMultiError, or nil if
// none found.
func (m *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetExpiredAssignmentBehaviorTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
				field:  "ExpiredAssignmentBehaviorTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
					field:  "ExpiredAssignmentBehaviorTimeout",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	oneofExpiredAssignmentBehaviorPresent := false
	switch v := m.ExpiredAssignmentBehavior.(type) {
	case *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_FallbackRateLimit:
		if v == nil {
			err := RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
				field:  "ExpiredAssignmentBehavior",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofExpiredAssignmentBehaviorPresent = true

		if all {
			switch v := interface{}(m.GetFallbackRateLimit()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
						field:  "FallbackRateLimit",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
						field:  "FallbackRateLimit",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetFallbackRateLimit()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
					field:  "FallbackRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment_:
		if v == nil {
			err := RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
				field:  "ExpiredAssignmentBehavior",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofExpiredAssignmentBehaviorPresent = true

		if all {
			switch v := interface{}(m.GetReuseLastAssignment()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
						field:  "ReuseLastAssignment",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
						field:  "ReuseLastAssignment",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetReuseLastAssignment()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
					field:  "ReuseLastAssignment",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofExpiredAssignmentBehaviorPresent {
		err := RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{
			field:  "ExpiredAssignmentBehavior",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorMultiError(errors)
	}

	return nil
}

// RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorMultiError is an error
// wrapping multiple validation errors returned by
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior.ValidateAll() if the
// designated constraints aren't met.
type RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorMultiError) AllErrors() []error {
	return m
}

// RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError is the
// validation error returned by
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior.Validate if the
// designated constraints aren't met.
type RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError) ErrorName() string {
	return "RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaBucketSettings_ExpiredAssignmentBehavior.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaBucketSettings_ExpiredAssignmentBehaviorValidationError{}

// Validate checks the field values on
// RateLimitQuotaBucketSettings_DenyResponseSettings with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RateLimitQuotaBucketSettings_DenyResponseSettings) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RateLimitQuotaBucketSettings_DenyResponseSettings with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// RateLimitQuotaBucketSettings_DenyResponseSettingsMultiError, or nil if none found.
func (m *RateLimitQuotaBucketSettings_DenyResponseSettings) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaBucketSettings_DenyResponseSettings) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetHttpStatus()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
					field:  "HttpStatus",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
					field:  "HttpStatus",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttpStatus()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
				field:  "HttpStatus",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHttpBody()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
					field:  "HttpBody",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
					field:  "HttpBody",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttpBody()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
				field:  "HttpBody",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGrpcStatus()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
					field:  "GrpcStatus",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
					field:  "GrpcStatus",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcStatus()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
				field:  "GrpcStatus",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetResponseHeadersToAdd()) > 10 {
		err := RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
			field:  "ResponseHeadersToAdd",
			reason: "value must contain no more than 10 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{
					field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RateLimitQuotaBucketSettings_DenyResponseSettingsMultiError(errors)
	}

	return nil
}

// RateLimitQuotaBucketSettings_DenyResponseSettingsMultiError is an error
// wrapping multiple validation errors returned by
// RateLimitQuotaBucketSettings_DenyResponseSettings.ValidateAll() if the
// designated constraints aren't met.
type RateLimitQuotaBucketSettings_DenyResponseSettingsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaBucketSettings_DenyResponseSettingsMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaBucketSettings_DenyResponseSettingsMultiError) AllErrors() []error { return m }

// RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError is the
// validation error returned by
// RateLimitQuotaBucketSettings_DenyResponseSettings.Validate if the
// designated constraints aren't met.
type RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError) ErrorName() string {
	return "RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaBucketSettings_DenyResponseSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaBucketSettings_DenyResponseSettingsValidationError{}

// Validate checks the field values on
// RateLimitQuotaBucketSettings_BucketIdBuilder with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RateLimitQuotaBucketSettings_BucketIdBuilder) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RateLimitQuotaBucketSettings_BucketIdBuilder with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// RateLimitQuotaBucketSettings_BucketIdBuilderMultiError, or nil if none found.
func (m *RateLimitQuotaBucketSettings_BucketIdBuilder) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaBucketSettings_BucketIdBuilder) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetBucketIdBuilder()) < 1 {
		err := RateLimitQuotaBucketSettings_BucketIdBuilderValidationError{
			field:  "BucketIdBuilder",
			reason: "value must contain at least 1 pair(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	{
		sorted_keys := make([]string, len(m.GetBucketIdBuilder()))
		i := 0
		for key := range m.GetBucketIdBuilder() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetBucketIdBuilder()[key]
			_ = val

			// no validation rules for BucketIdBuilder[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, RateLimitQuotaBucketSettings_BucketIdBuilderValidationError{
							field:  fmt.Sprintf("BucketIdBuilder[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, RateLimitQuotaBucketSettings_BucketIdBuilderValidationError{
							field:  fmt.Sprintf("BucketIdBuilder[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return RateLimitQuotaBucketSettings_BucketIdBuilderValidationError{
						field:  fmt.Sprintf("BucketIdBuilder[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return RateLimitQuotaBucketSettings_BucketIdBuilderMultiError(errors)
	}

	return nil
}

// RateLimitQuotaBucketSettings_BucketIdBuilderMultiError is an error wrapping
// multiple validation errors returned by
// RateLimitQuotaBucketSettings_BucketIdBuilder.ValidateAll() if the
// designated constraints aren't met.
type RateLimitQuotaBucketSettings_BucketIdBuilderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaBucketSettings_BucketIdBuilderMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaBucketSettings_BucketIdBuilderMultiError) AllErrors() []error { return m }

// RateLimitQuotaBucketSettings_BucketIdBuilderValidationError is the
// validation error returned by
// RateLimitQuotaBucketSettings_BucketIdBuilder.Validate if the designated
// constraints aren't met.
type RateLimitQuotaBucketSettings_BucketIdBuilderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaBucketSettings_BucketIdBuilderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimitQuotaBucketSettings_BucketIdBuilderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimitQuotaBucketSettings_BucketIdBuilderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimitQuotaBucketSettings_BucketIdBuilderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimitQuotaBucketSettings_BucketIdBuilderValidationError) ErrorName() string {
	return "RateLimitQuotaBucketSettings_BucketIdBuilderValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaBucketSettings_BucketIdBuilderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaBucketSettings_BucketIdBuilder.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaBucketSettings_BucketIdBuilderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaBucketSettings_BucketIdBuilderValidationError{}

// Validate checks the field values on
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentMultiError,
// or nil if none found.
func (m *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentMultiError(errors)
	}

	return nil
}

// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentMultiError
// is an error wrapping multiple validation errors returned by
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment.ValidateAll()
// if the designated constraints aren't met.
type RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentMultiError) AllErrors() []error {
	return m
}

// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError
// is the validation error returned by
// RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment.Validate
// if the designated constraints aren't met.
type RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError) ErrorName() string {
	return "RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignmentValidationError{}

// Validate checks the field values on
// RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderMultiError, or nil
// if none found.
func (m *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofValueSpecifierPresent := false
	switch v := m.ValueSpecifier.(type) {
	case *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_StringValue:
		if v == nil {
			err := RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError{
				field:  "ValueSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofValueSpecifierPresent = true
		// no validation rules for StringValue
	case *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_CustomValue:
		if v == nil {
			err := RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError{
				field:  "ValueSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofValueSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetCustomValue()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError{
						field:  "CustomValue",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError{
						field:  "CustomValue",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetCustomValue()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError{
					field:  "CustomValue",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofValueSpecifierPresent {
		err := RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError{
			field:  "ValueSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderMultiError(errors)
	}

	return nil
}

// RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderMultiError is an
// error wrapping multiple validation errors returned by
// RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder.ValidateAll() if
// the designated constraints aren't met.
type RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderMultiError) AllErrors() []error {
	return m
}

// RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError is
// the validation error returned by
// RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder.Validate if the
// designated constraints aren't met.
type RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError) ErrorName() string {
	return "RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilderValidationError{}
