// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: envoy/extensions/filters/network/redis_proxy/v3/redis_proxy.proto

package redis_proxyv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/envoyproxy/go-control-plane/envoy/annotations"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v31 "github.com/envoyproxy/go-control-plane/envoy/extensions/common/aws/v3"
	v32 "github.com/envoyproxy/go-control-plane/envoy/extensions/common/dynamic_forward_proxy/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ReadPolicy controls how Envoy routes read commands to Redis nodes. This is currently
// supported for Redis Cluster. All ReadPolicy settings except MASTER may return stale data
// because replication is asynchronous and requires some delay. You need to ensure that your
// application can tolerate stale data.
type RedisProxy_ConnPoolSettings_ReadPolicy int32

const (
	// Default mode. Read from the current primary node.
	RedisProxy_ConnPoolSettings_MASTER RedisProxy_ConnPoolSettings_ReadPolicy = 0
	// Read from the primary, but if it is unavailable, read from replica nodes.
	RedisProxy_ConnPoolSettings_PREFER_MASTER RedisProxy_ConnPoolSettings_ReadPolicy = 1
	// Read from replica nodes. If multiple replica nodes are present within a shard, a random
	// node is selected. Healthy nodes have precedent over unhealthy nodes.
	RedisProxy_ConnPoolSettings_REPLICA RedisProxy_ConnPoolSettings_ReadPolicy = 2
	// Read from the replica nodes (similar to REPLICA), but if all replicas are unavailable (not
	// present or unhealthy), read from the primary.
	RedisProxy_ConnPoolSettings_PREFER_REPLICA RedisProxy_ConnPoolSettings_ReadPolicy = 3
	// Read from any node of the cluster. A random node is selected among the primary and
	// replicas, healthy nodes have precedent over unhealthy nodes.
	RedisProxy_ConnPoolSettings_ANY RedisProxy_ConnPoolSettings_ReadPolicy = 4
)

// Enum value maps for RedisProxy_ConnPoolSettings_ReadPolicy.
var (
	RedisProxy_ConnPoolSettings_ReadPolicy_name = map[int32]string{
		0: "MASTER",
		1: "PREFER_MASTER",
		2: "REPLICA",
		3: "PREFER_REPLICA",
		4: "ANY",
	}
	RedisProxy_ConnPoolSettings_ReadPolicy_value = map[string]int32{
		"MASTER":         0,
		"PREFER_MASTER":  1,
		"REPLICA":        2,
		"PREFER_REPLICA": 3,
		"ANY":            4,
	}
)

func (x RedisProxy_ConnPoolSettings_ReadPolicy) Enum() *RedisProxy_ConnPoolSettings_ReadPolicy {
	p := new(RedisProxy_ConnPoolSettings_ReadPolicy)
	*p = x
	return p
}

func (x RedisProxy_ConnPoolSettings_ReadPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RedisProxy_ConnPoolSettings_ReadPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes[0].Descriptor()
}

func (RedisProxy_ConnPoolSettings_ReadPolicy) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes[0]
}

func (x RedisProxy_ConnPoolSettings_ReadPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RedisProxy_ConnPoolSettings_ReadPolicy.Descriptor instead.
func (RedisProxy_ConnPoolSettings_ReadPolicy) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 0, 0}
}

type RedisProxy_RedisFault_RedisFaultType int32

const (
	// Delays requests. This is the base fault; other faults can have delays added.
	RedisProxy_RedisFault_DELAY RedisProxy_RedisFault_RedisFaultType = 0
	// Returns errors on requests.
	RedisProxy_RedisFault_ERROR RedisProxy_RedisFault_RedisFaultType = 1
)

// Enum value maps for RedisProxy_RedisFault_RedisFaultType.
var (
	RedisProxy_RedisFault_RedisFaultType_name = map[int32]string{
		0: "DELAY",
		1: "ERROR",
	}
	RedisProxy_RedisFault_RedisFaultType_value = map[string]int32{
		"DELAY": 0,
		"ERROR": 1,
	}
)

func (x RedisProxy_RedisFault_RedisFaultType) Enum() *RedisProxy_RedisFault_RedisFaultType {
	p := new(RedisProxy_RedisFault_RedisFaultType)
	*p = x
	return p
}

func (x RedisProxy_RedisFault_RedisFaultType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RedisProxy_RedisFault_RedisFaultType) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes[1].Descriptor()
}

func (RedisProxy_RedisFault_RedisFaultType) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes[1]
}

func (x RedisProxy_RedisFault_RedisFaultType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RedisProxy_RedisFault_RedisFaultType.Descriptor instead.
func (RedisProxy_RedisFault_RedisFaultType) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 2, 0}
}

// [#next-free-field: 12]
type RedisProxy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The prefix to use when emitting :ref:`statistics <config_network_filters_redis_proxy_stats>`.
	StatPrefix string `protobuf:"bytes,1,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Network settings for the connection pool to the upstream clusters.
	Settings *RedisProxy_ConnPoolSettings `protobuf:"bytes,3,opt,name=settings,proto3" json:"settings,omitempty"`
	// Indicates that latency stat should be computed in microseconds. By default it is computed in
	// milliseconds. This does not apply to upstream command stats currently.
	LatencyInMicros bool `protobuf:"varint,4,opt,name=latency_in_micros,json=latencyInMicros,proto3" json:"latency_in_micros,omitempty"`
	// List of **unique** prefixes used to separate keys from different workloads to different
	// clusters. Envoy will always favor the longest match first in case of overlap. A catch-all
	// cluster can be used to forward commands when there is no match. Time complexity of the
	// lookups are in O(min(longest key prefix, key length)).
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//	prefix_routes:
	//	  routes:
	//	    - prefix: "ab"
	//	      cluster: "cluster_a"
	//	    - prefix: "abc"
	//	      cluster: "cluster_b"
	//
	// When using the above routes, the following prefixes would be sent to:
	//
	//   - “get abc:users“ would retrieve the key 'abc:users' from cluster_b.
	//   - “get ab:users“ would retrieve the key 'ab:users' from cluster_a.
	//   - “get z:users“ would return a NoUpstreamHost error. A :ref:`catch-all
	//     route<envoy_v3_api_field_extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.catch_all_route>`
	//     would have retrieved the key from that cluster instead.
	//
	// See the :ref:`configuration section
	// <arch_overview_redis_configuration>` of the architecture overview for recommendations on
	// configuring the backing clusters.
	PrefixRoutes *RedisProxy_PrefixRoutes `protobuf:"bytes,5,opt,name=prefix_routes,json=prefixRoutes,proto3" json:"prefix_routes,omitempty"`
	// Authenticate Redis client connections locally by forcing downstream clients to issue a `Redis
	// AUTH command <https://redis.io/commands/auth>`_ with this password before enabling any other
	// command. If an AUTH command's password matches this password, an "OK" response will be returned
	// to the client. If the AUTH command password does not match this password, then an "ERR invalid
	// password" error will be returned. If any other command is received before AUTH when this
	// password is set, then a "NOAUTH Authentication required." error response will be sent to the
	// client. If an AUTH command is received when the password is not set, then an "ERR Client sent
	// AUTH, but no password is set" error will be returned.
	//
	// .. attention::
	//
	//	This field is deprecated. Use :ref:`downstream_auth_passwords
	//	<envoy_v3_api_field_extensions.filters.network.redis_proxy.v3.RedisProxy.downstream_auth_passwords>`.
	//
	// Deprecated: Marked as deprecated in envoy/extensions/filters/network/redis_proxy/v3/redis_proxy.proto.
	DownstreamAuthPassword *v3.DataSource `protobuf:"bytes,6,opt,name=downstream_auth_password,json=downstreamAuthPassword,proto3" json:"downstream_auth_password,omitempty"`
	// Authenticate Redis client connections locally by forcing downstream clients to issue a `Redis
	// AUTH command <https://redis.io/commands/auth>`_ with one of these passwords before enabling any other
	// command. If an AUTH command's password matches one of these passwords, an "OK" response will be returned
	// to the client. If the AUTH command password does not match, then an "ERR invalid
	// password" error will be returned. If any other command is received before AUTH when the
	// password(s) are set, then a "NOAUTH Authentication required." error response will be sent to the
	// client. If an AUTH command is received when the password is not set, then an "ERR Client sent
	// AUTH, but no password is set" error will be returned.
	DownstreamAuthPasswords []*v3.DataSource `protobuf:"bytes,9,rep,name=downstream_auth_passwords,json=downstreamAuthPasswords,proto3" json:"downstream_auth_passwords,omitempty"`
	// List of faults to inject. Faults currently come in two flavors:
	// - Delay, which delays a request.
	// - Error, which responds to a request with an error. Errors can also have delays attached.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//	faults:
	//	- fault_type: ERROR
	//	  fault_enabled:
	//	    default_value:
	//	      numerator: 10
	//	      denominator: HUNDRED
	//	    runtime_key: "bogus_key"
	//	    commands:
	//	    - GET
	//	  - fault_type: DELAY
	//	    fault_enabled:
	//	      default_value:
	//	        numerator: 10
	//	        denominator: HUNDRED
	//	      runtime_key: "bogus_key"
	//	    delay: 2s
	//
	// See the :ref:`fault injection section
	// <config_network_filters_redis_proxy_fault_injection>` for more information on how to configure this.
	Faults []*RedisProxy_RedisFault `protobuf:"bytes,8,rep,name=faults,proto3" json:"faults,omitempty"`
	// If a username is provided an ACL style AUTH command will be required with a username and password.
	// Authenticate Redis client connections locally by forcing downstream clients to issue a `Redis
	// AUTH command <https://redis.io/commands/auth>`_ with this username and the “downstream_auth_password“
	// before enabling any other command. If an AUTH command's username and password matches this username
	// and the “downstream_auth_password“ , an "OK" response will be returned to the client. If the AUTH
	// command username or password does not match this username or the “downstream_auth_password“, then an
	// "WRONGPASS invalid username-password pair" error will be returned. If any other command is received before AUTH when this
	// password is set, then a "NOAUTH Authentication required." error response will be sent to the
	// client. If an AUTH command is received when the password is not set, then an "ERR Client sent
	// AUTH, but no ACL is set" error will be returned.
	DownstreamAuthUsername *v3.DataSource `protobuf:"bytes,7,opt,name=downstream_auth_username,json=downstreamAuthUsername,proto3" json:"downstream_auth_username,omitempty"`
	// External authentication configuration. If set, instead of validating username and password against “downstream_auth_username“ and “downstream_auth_password“,
	// the filter will call an external gRPC service to authenticate the client.
	// A typical usage of this feature is for situations where the password is a one-time token that needs to be validated against a remote service, like a sidecar.
	// Expiration is also supported, which will disable any further commands from the client after the expiration time, unless a new AUTH command is received and the external auth service returns a new expiration time.
	// If the external auth service returns an error, authentication is considered failed.
	// If this setting is set together with “downstream_auth_username“ and “downstream_auth_password“, the external auth service will be source of truth, but those fields will still be used for downstream authentication to the cluster.
	// The API is defined by :ref:`RedisProxyExternalAuthRequest <envoy_v3_api_msg_service.redis_auth.v3.RedisProxyExternalAuthRequest>`.
	ExternalAuthProvider *RedisExternalAuthProvider `protobuf:"bytes,10,opt,name=external_auth_provider,json=externalAuthProvider,proto3" json:"external_auth_provider,omitempty"`
	// Optional configure redis custom commands for the proxy, eg -> ["my_custom_cmd1", "my_custom_cmd2"]
	//
	// .. note::
	//
	//	The is to support redis's feature wherein new commands can be added using redis' modules api:
	//	https://redis.io/docs/latest/develop/reference/modules/
	CustomCommands []string `protobuf:"bytes,11,rep,name=custom_commands,json=customCommands,proto3" json:"custom_commands,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *RedisProxy) Reset() {
	*x = RedisProxy{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProxy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy) ProtoMessage() {}

func (x *RedisProxy) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy.ProtoReflect.Descriptor instead.
func (*RedisProxy) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0}
}

func (x *RedisProxy) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *RedisProxy) GetSettings() *RedisProxy_ConnPoolSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *RedisProxy) GetLatencyInMicros() bool {
	if x != nil {
		return x.LatencyInMicros
	}
	return false
}

func (x *RedisProxy) GetPrefixRoutes() *RedisProxy_PrefixRoutes {
	if x != nil {
		return x.PrefixRoutes
	}
	return nil
}

// Deprecated: Marked as deprecated in envoy/extensions/filters/network/redis_proxy/v3/redis_proxy.proto.
func (x *RedisProxy) GetDownstreamAuthPassword() *v3.DataSource {
	if x != nil {
		return x.DownstreamAuthPassword
	}
	return nil
}

func (x *RedisProxy) GetDownstreamAuthPasswords() []*v3.DataSource {
	if x != nil {
		return x.DownstreamAuthPasswords
	}
	return nil
}

func (x *RedisProxy) GetFaults() []*RedisProxy_RedisFault {
	if x != nil {
		return x.Faults
	}
	return nil
}

func (x *RedisProxy) GetDownstreamAuthUsername() *v3.DataSource {
	if x != nil {
		return x.DownstreamAuthUsername
	}
	return nil
}

func (x *RedisProxy) GetExternalAuthProvider() *RedisExternalAuthProvider {
	if x != nil {
		return x.ExternalAuthProvider
	}
	return nil
}

func (x *RedisProxy) GetCustomCommands() []string {
	if x != nil {
		return x.CustomCommands
	}
	return nil
}

// RedisProtocolOptions specifies Redis upstream protocol options. This object is used in
// :ref:`typed_extension_protocol_options<envoy_v3_api_field_config.cluster.v3.Cluster.typed_extension_protocol_options>`,
// keyed by the name “envoy.filters.network.redis_proxy“.
type RedisProtocolOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Upstream server password as defined by the “requirepass“ directive
	// `<https://redis.io/topics/config>`_ in the server's configuration file.
	// If “aws_iam“ is set, this field is ignored.
	AuthPassword *v3.DataSource `protobuf:"bytes,1,opt,name=auth_password,json=authPassword,proto3" json:"auth_password,omitempty"`
	// Upstream server username as defined by the “user“ directive
	// `<https://redis.io/topics/acl>`_ in the server's configuration file.
	// If “aws_iam``` is set, this field will be used as the authenticating user for redis IAM authentication.
	// See “Create a new IAM-enabled user“ under `Setup <https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/auth-iam.html#auth-iam-setup>`_ for more details.
	AuthUsername *v3.DataSource `protobuf:"bytes,2,opt,name=auth_username,json=authUsername,proto3" json:"auth_username,omitempty"`
	// The cluster level configuration for AWS IAM authentication
	AwsIam *AwsIam `protobuf:"bytes,3,opt,name=aws_iam,json=awsIam,proto3" json:"aws_iam,omitempty"`
	// If specified, these credentials are used when connecting to upstream endpoints. Which
	// credential is used is determined by matching the resolved “address“ field here with each
	// endpoint's resolved “address“ field. The first entry for a given “address“ here takes precedence.
	// If no entry in “credentials“ matches, then the “auth_password“ and “auth_username“ fields
	// are used as defaults.
	Credentials   []*RedisProtocolOptions_Credential `protobuf:"bytes,4,rep,name=credentials,proto3" json:"credentials,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedisProtocolOptions) Reset() {
	*x = RedisProtocolOptions{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProtocolOptions) ProtoMessage() {}

func (x *RedisProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProtocolOptions.ProtoReflect.Descriptor instead.
func (*RedisProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{1}
}

func (x *RedisProtocolOptions) GetAuthPassword() *v3.DataSource {
	if x != nil {
		return x.AuthPassword
	}
	return nil
}

func (x *RedisProtocolOptions) GetAuthUsername() *v3.DataSource {
	if x != nil {
		return x.AuthUsername
	}
	return nil
}

func (x *RedisProtocolOptions) GetAwsIam() *AwsIam {
	if x != nil {
		return x.AwsIam
	}
	return nil
}

func (x *RedisProtocolOptions) GetCredentials() []*RedisProtocolOptions_Credential {
	if x != nil {
		return x.Credentials
	}
	return nil
}

// [#next-free-field: 6]
type AwsIam struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// An AwsCredentialProvider, allowing the use of a specific credential provider chain or specific provider settings
	CredentialProvider *v31.AwsCredentialProvider `protobuf:"bytes,1,opt,name=credential_provider,json=credentialProvider,proto3" json:"credential_provider,omitempty"`
	// The name of the cache, used when generating the authentication token.
	CacheName string `protobuf:"bytes,2,opt,name=cache_name,json=cacheName,proto3" json:"cache_name,omitempty"`
	// The optional service name to be used in AWS IAM authentication. If not provided, the service name will be set to “elasticache“. For Amazon MemoryDB
	// the service name should be set to “memorydb“.
	ServiceName string `protobuf:"bytes,3,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The optional AWS region that your cache is located in. If not provided, the region will be deduced using the region provider chain
	// as described in :ref:`config_http_filters_aws_request_signing_region`.
	Region string `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
	// Number of seconds before the IAM authentication token will expire. If not set, defaults to 60s (1 minute). Maximum of 900s (15 minutes)
	// Expiration of the current authentication token will automatically trigger generation of a new token.
	// As envoy will automatically continue to generate new tokens as required, there is no substantial benefit to using a long expiration value here.
	ExpirationTime *durationpb.Duration `protobuf:"bytes,5,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *AwsIam) Reset() {
	*x = AwsIam{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsIam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsIam) ProtoMessage() {}

func (x *AwsIam) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsIam.ProtoReflect.Descriptor instead.
func (*AwsIam) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{2}
}

func (x *AwsIam) GetCredentialProvider() *v31.AwsCredentialProvider {
	if x != nil {
		return x.CredentialProvider
	}
	return nil
}

func (x *AwsIam) GetCacheName() string {
	if x != nil {
		return x.CacheName
	}
	return ""
}

func (x *AwsIam) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *AwsIam) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AwsIam) GetExpirationTime() *durationpb.Duration {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

// RedisExternalAuthProvider specifies a gRPC service that can be used to authenticate Redis clients.
// This service will be called every time an AUTH command is received from a client.
// If the service returns an error, authentication is considered failed.
// If the service returns a success, the client is considered authenticated.
// The service can also return an expiration timestamp, which will be used to disable any further
// commands from the client after it passes, unless a new AUTH command is received and the
// external auth service returns a new expiration timestamp.
type RedisExternalAuthProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// External auth gRPC service configuration.
	// It will be called every time an AUTH command is received from a client.
	GrpcService *v3.GrpcService `protobuf:"bytes,1,opt,name=grpc_service,json=grpcService,proto3" json:"grpc_service,omitempty"`
	// If set to true, the filter will expect an expiration timestamp in the response from the external
	// auth service. This timestamp will be used to disable any further commands from the client after
	// the expiration time, unless a new AUTH command is received and the external auth service returns
	// a new expiration timestamp.
	EnableAuthExpiration bool `protobuf:"varint,2,opt,name=enable_auth_expiration,json=enableAuthExpiration,proto3" json:"enable_auth_expiration,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *RedisExternalAuthProvider) Reset() {
	*x = RedisExternalAuthProvider{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisExternalAuthProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisExternalAuthProvider) ProtoMessage() {}

func (x *RedisExternalAuthProvider) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisExternalAuthProvider.ProtoReflect.Descriptor instead.
func (*RedisExternalAuthProvider) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{3}
}

func (x *RedisExternalAuthProvider) GetGrpcService() *v3.GrpcService {
	if x != nil {
		return x.GrpcService
	}
	return nil
}

func (x *RedisExternalAuthProvider) GetEnableAuthExpiration() bool {
	if x != nil {
		return x.EnableAuthExpiration
	}
	return false
}

// Redis connection pool settings.
// [#next-free-field: 11]
type RedisProxy_ConnPoolSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Per-operation timeout in milliseconds. The timer starts when the first
	// command of a pipeline is written to the backend connection. Each response received from Redis
	// resets the timer since it signifies that the next command is being processed by the backend.
	// The only exception to this behavior is when a connection to a backend is not yet established.
	// In that case, the connect timeout on the cluster will govern the timeout until the connection
	// is ready.
	OpTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=op_timeout,json=opTimeout,proto3" json:"op_timeout,omitempty"`
	// Use hash tagging on every redis key to guarantee that keys with the same hash tag will be
	// forwarded to the same upstream. The hash key used for determining the upstream in a
	// consistent hash ring configuration will be computed from the hash tagged key instead of the
	// whole key. The algorithm used to compute the hash tag is identical to the `redis-cluster
	// implementation <https://redis.io/topics/cluster-spec#keys-hash-tags>`_.
	//
	// Examples:
	//
	// * '{user1000}.following' and '{user1000}.followers' **will** be sent to the same upstream
	// * '{user1000}.following' and '{user1001}.following' **might** be sent to the same upstream
	EnableHashtagging bool `protobuf:"varint,2,opt,name=enable_hashtagging,json=enableHashtagging,proto3" json:"enable_hashtagging,omitempty"`
	// Accept `moved and ask redirection
	// <https://redis.io/topics/cluster-spec#redirection-and-resharding>`_ errors from upstream
	// redis servers, and retry commands to the specified target server. The target server does not
	// need to be known to the cluster manager. If the command cannot be redirected, then the
	// original error is passed downstream unchanged. By default, this support is not enabled.
	EnableRedirection bool `protobuf:"varint,3,opt,name=enable_redirection,json=enableRedirection,proto3" json:"enable_redirection,omitempty"`
	// If “enable_redirection“ is set to true this option configures the DNS cache that the
	// connection pool will use to resolve hostnames that are returned with MOVED and ASK responses.
	// If no configuration is provided, DNS lookups will not be performed (and thus the MOVED/ASK errors
	// will be propagated verbatim to the user).
	DnsCacheConfig *v32.DnsCacheConfig `protobuf:"bytes,9,opt,name=dns_cache_config,json=dnsCacheConfig,proto3" json:"dns_cache_config,omitempty"`
	// Maximum size of encoded request buffer before flush is triggered and encoded requests
	// are sent upstream. If this is unset, the buffer flushes whenever it receives data
	// and performs no batching.
	// This feature makes it possible for multiple clients to send requests to Envoy and have
	// them batched- for example if one is running several worker processes, each with its own
	// Redis connection. There is no benefit to using this with a single downstream process.
	// Recommended size (if enabled) is 1024 bytes.
	MaxBufferSizeBeforeFlush uint32 `protobuf:"varint,4,opt,name=max_buffer_size_before_flush,json=maxBufferSizeBeforeFlush,proto3" json:"max_buffer_size_before_flush,omitempty"`
	// The encoded request buffer is flushed N milliseconds after the first request has been
	// encoded, unless the buffer size has already exceeded “max_buffer_size_before_flush“.
	// If “max_buffer_size_before_flush“ is not set, this flush timer is not used. Otherwise,
	// the timer should be set according to the number of clients, overall request rate and
	// desired maximum latency for a single command. For example, if there are many requests
	// being batched together at a high rate, the buffer will likely be filled before the timer
	// fires. Alternatively, if the request rate is lower the buffer will not be filled as often
	// before the timer fires.
	// If “max_buffer_size_before_flush“ is set, but “buffer_flush_timeout“ is not, the latter
	// defaults to 3ms.
	BufferFlushTimeout *durationpb.Duration `protobuf:"bytes,5,opt,name=buffer_flush_timeout,json=bufferFlushTimeout,proto3" json:"buffer_flush_timeout,omitempty"`
	// “max_upstream_unknown_connections“ controls how many upstream connections to unknown hosts
	// can be created at any given time by any given worker thread (see “enable_redirection“ for
	// more details). If the host is unknown and a connection cannot be created due to enforcing
	// this limit, then redirection will fail and the original redirection error will be passed
	// downstream unchanged. This limit defaults to 100.
	MaxUpstreamUnknownConnections *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=max_upstream_unknown_connections,json=maxUpstreamUnknownConnections,proto3" json:"max_upstream_unknown_connections,omitempty"`
	// Enable per-command statistics per upstream cluster, in addition to the filter level aggregate
	// count. These commands are measured in microseconds.
	EnableCommandStats bool `protobuf:"varint,8,opt,name=enable_command_stats,json=enableCommandStats,proto3" json:"enable_command_stats,omitempty"`
	// Read policy. The default is to read from the primary.
	ReadPolicy RedisProxy_ConnPoolSettings_ReadPolicy `protobuf:"varint,7,opt,name=read_policy,json=readPolicy,proto3,enum=envoy.extensions.filters.network.redis_proxy.v3.RedisProxy_ConnPoolSettings_ReadPolicy" json:"read_policy,omitempty"`
	// Ops or connection timeout triggers reconnection to redis server which could result in reconnection
	// storm to busy redis server. This config is a protection to rate limit reconnection rate.
	// If not set, there will be no rate limiting on the reconnection.
	ConnectionRateLimit *RedisProxy_ConnectionRateLimit `protobuf:"bytes,10,opt,name=connection_rate_limit,json=connectionRateLimit,proto3" json:"connection_rate_limit,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *RedisProxy_ConnPoolSettings) Reset() {
	*x = RedisProxy_ConnPoolSettings{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProxy_ConnPoolSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_ConnPoolSettings) ProtoMessage() {}

func (x *RedisProxy_ConnPoolSettings) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_ConnPoolSettings.ProtoReflect.Descriptor instead.
func (*RedisProxy_ConnPoolSettings) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 0}
}

func (x *RedisProxy_ConnPoolSettings) GetOpTimeout() *durationpb.Duration {
	if x != nil {
		return x.OpTimeout
	}
	return nil
}

func (x *RedisProxy_ConnPoolSettings) GetEnableHashtagging() bool {
	if x != nil {
		return x.EnableHashtagging
	}
	return false
}

func (x *RedisProxy_ConnPoolSettings) GetEnableRedirection() bool {
	if x != nil {
		return x.EnableRedirection
	}
	return false
}

func (x *RedisProxy_ConnPoolSettings) GetDnsCacheConfig() *v32.DnsCacheConfig {
	if x != nil {
		return x.DnsCacheConfig
	}
	return nil
}

func (x *RedisProxy_ConnPoolSettings) GetMaxBufferSizeBeforeFlush() uint32 {
	if x != nil {
		return x.MaxBufferSizeBeforeFlush
	}
	return 0
}

func (x *RedisProxy_ConnPoolSettings) GetBufferFlushTimeout() *durationpb.Duration {
	if x != nil {
		return x.BufferFlushTimeout
	}
	return nil
}

func (x *RedisProxy_ConnPoolSettings) GetMaxUpstreamUnknownConnections() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxUpstreamUnknownConnections
	}
	return nil
}

func (x *RedisProxy_ConnPoolSettings) GetEnableCommandStats() bool {
	if x != nil {
		return x.EnableCommandStats
	}
	return false
}

func (x *RedisProxy_ConnPoolSettings) GetReadPolicy() RedisProxy_ConnPoolSettings_ReadPolicy {
	if x != nil {
		return x.ReadPolicy
	}
	return RedisProxy_ConnPoolSettings_MASTER
}

func (x *RedisProxy_ConnPoolSettings) GetConnectionRateLimit() *RedisProxy_ConnectionRateLimit {
	if x != nil {
		return x.ConnectionRateLimit
	}
	return nil
}

type RedisProxy_PrefixRoutes struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of prefix routes.
	Routes []*RedisProxy_PrefixRoutes_Route `protobuf:"bytes,1,rep,name=routes,proto3" json:"routes,omitempty"`
	// Indicates that prefix matching should be case insensitive.
	CaseInsensitive bool `protobuf:"varint,2,opt,name=case_insensitive,json=caseInsensitive,proto3" json:"case_insensitive,omitempty"`
	// Optional catch-all route to forward commands that doesn't match any of the routes. The
	// catch-all route becomes required when no routes are specified.
	CatchAllRoute *RedisProxy_PrefixRoutes_Route `protobuf:"bytes,4,opt,name=catch_all_route,json=catchAllRoute,proto3" json:"catch_all_route,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedisProxy_PrefixRoutes) Reset() {
	*x = RedisProxy_PrefixRoutes{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProxy_PrefixRoutes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_PrefixRoutes) ProtoMessage() {}

func (x *RedisProxy_PrefixRoutes) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_PrefixRoutes.ProtoReflect.Descriptor instead.
func (*RedisProxy_PrefixRoutes) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 1}
}

func (x *RedisProxy_PrefixRoutes) GetRoutes() []*RedisProxy_PrefixRoutes_Route {
	if x != nil {
		return x.Routes
	}
	return nil
}

func (x *RedisProxy_PrefixRoutes) GetCaseInsensitive() bool {
	if x != nil {
		return x.CaseInsensitive
	}
	return false
}

func (x *RedisProxy_PrefixRoutes) GetCatchAllRoute() *RedisProxy_PrefixRoutes_Route {
	if x != nil {
		return x.CatchAllRoute
	}
	return nil
}

// RedisFault defines faults used for fault injection.
type RedisProxy_RedisFault struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fault type.
	FaultType RedisProxy_RedisFault_RedisFaultType `protobuf:"varint,1,opt,name=fault_type,json=faultType,proto3,enum=envoy.extensions.filters.network.redis_proxy.v3.RedisProxy_RedisFault_RedisFaultType" json:"fault_type,omitempty"`
	// Percentage of requests fault applies to.
	FaultEnabled *v3.RuntimeFractionalPercent `protobuf:"bytes,2,opt,name=fault_enabled,json=faultEnabled,proto3" json:"fault_enabled,omitempty"`
	// Delay for all faults. If not set, defaults to zero
	Delay *durationpb.Duration `protobuf:"bytes,3,opt,name=delay,proto3" json:"delay,omitempty"`
	// Commands fault is restricted to, if any. If not set, fault applies to all commands
	// other than auth and ping (due to special handling of those commands in Envoy).
	Commands      []string `protobuf:"bytes,4,rep,name=commands,proto3" json:"commands,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedisProxy_RedisFault) Reset() {
	*x = RedisProxy_RedisFault{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProxy_RedisFault) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_RedisFault) ProtoMessage() {}

func (x *RedisProxy_RedisFault) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_RedisFault.ProtoReflect.Descriptor instead.
func (*RedisProxy_RedisFault) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 2}
}

func (x *RedisProxy_RedisFault) GetFaultType() RedisProxy_RedisFault_RedisFaultType {
	if x != nil {
		return x.FaultType
	}
	return RedisProxy_RedisFault_DELAY
}

func (x *RedisProxy_RedisFault) GetFaultEnabled() *v3.RuntimeFractionalPercent {
	if x != nil {
		return x.FaultEnabled
	}
	return nil
}

func (x *RedisProxy_RedisFault) GetDelay() *durationpb.Duration {
	if x != nil {
		return x.Delay
	}
	return nil
}

func (x *RedisProxy_RedisFault) GetCommands() []string {
	if x != nil {
		return x.Commands
	}
	return nil
}

// Configuration to limit reconnection rate to redis server to protect redis server
// from client reconnection storm.
type RedisProxy_ConnectionRateLimit struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Reconnection rate per sec. Rate limiting is implemented with TokenBucket.
	ConnectionRateLimitPerSec uint32 `protobuf:"varint,1,opt,name=connection_rate_limit_per_sec,json=connectionRateLimitPerSec,proto3" json:"connection_rate_limit_per_sec,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *RedisProxy_ConnectionRateLimit) Reset() {
	*x = RedisProxy_ConnectionRateLimit{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProxy_ConnectionRateLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_ConnectionRateLimit) ProtoMessage() {}

func (x *RedisProxy_ConnectionRateLimit) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_ConnectionRateLimit.ProtoReflect.Descriptor instead.
func (*RedisProxy_ConnectionRateLimit) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 3}
}

func (x *RedisProxy_ConnectionRateLimit) GetConnectionRateLimitPerSec() uint32 {
	if x != nil {
		return x.ConnectionRateLimitPerSec
	}
	return 0
}

// [#next-free-field: 7]
type RedisProxy_PrefixRoutes_Route struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// String prefix that must match the beginning of the keys. Envoy will always favor the
	// longest match.
	Prefix string `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Indicates if the prefix needs to be removed from the key when forwarded.
	RemovePrefix bool `protobuf:"varint,2,opt,name=remove_prefix,json=removePrefix,proto3" json:"remove_prefix,omitempty"`
	// Upstream cluster to forward the command to.
	Cluster string `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Indicates that the route has a request mirroring policy.
	RequestMirrorPolicy []*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy `protobuf:"bytes,4,rep,name=request_mirror_policy,json=requestMirrorPolicy,proto3" json:"request_mirror_policy,omitempty"`
	// Indicates how redis key should be formatted. To substitute redis key into the formatting
	// expression, use %KEY% as a string replacement command.
	KeyFormatter string `protobuf:"bytes,5,opt,name=key_formatter,json=keyFormatter,proto3" json:"key_formatter,omitempty"`
	// Indicates that the route has a read command policy
	ReadCommandPolicy *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy `protobuf:"bytes,6,opt,name=read_command_policy,json=readCommandPolicy,proto3" json:"read_command_policy,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *RedisProxy_PrefixRoutes_Route) Reset() {
	*x = RedisProxy_PrefixRoutes_Route{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProxy_PrefixRoutes_Route) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_PrefixRoutes_Route) ProtoMessage() {}

func (x *RedisProxy_PrefixRoutes_Route) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_PrefixRoutes_Route.ProtoReflect.Descriptor instead.
func (*RedisProxy_PrefixRoutes_Route) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *RedisProxy_PrefixRoutes_Route) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *RedisProxy_PrefixRoutes_Route) GetRemovePrefix() bool {
	if x != nil {
		return x.RemovePrefix
	}
	return false
}

func (x *RedisProxy_PrefixRoutes_Route) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *RedisProxy_PrefixRoutes_Route) GetRequestMirrorPolicy() []*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy {
	if x != nil {
		return x.RequestMirrorPolicy
	}
	return nil
}

func (x *RedisProxy_PrefixRoutes_Route) GetKeyFormatter() string {
	if x != nil {
		return x.KeyFormatter
	}
	return ""
}

func (x *RedisProxy_PrefixRoutes_Route) GetReadCommandPolicy() *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy {
	if x != nil {
		return x.ReadCommandPolicy
	}
	return nil
}

// The router is capable of shadowing traffic from one cluster to another. The current
// implementation is "fire and forget," meaning Envoy will not wait for the shadow cluster to
// respond before returning the response from the primary cluster. All normal statistics are
// collected for the shadow cluster making this feature useful for testing.
type RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the cluster that requests will be mirrored to. The cluster must
	// exist in the cluster manager configuration.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// If not specified or the runtime key is not present, all requests to the target cluster
	// will be mirrored.
	//
	// If specified, Envoy will lookup the runtime key to get the percentage of requests to the
	// mirror.
	RuntimeFraction *v3.RuntimeFractionalPercent `protobuf:"bytes,2,opt,name=runtime_fraction,json=runtimeFraction,proto3" json:"runtime_fraction,omitempty"`
	// Set this to TRUE to only mirror write commands, this is effectively replicating the
	// writes in a "fire and forget" manner.
	ExcludeReadCommands bool `protobuf:"varint,3,opt,name=exclude_read_commands,json=excludeReadCommands,proto3" json:"exclude_read_commands,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Reset() {
	*x = RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) ProtoMessage() {}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy.ProtoReflect.Descriptor instead.
func (*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetRuntimeFraction() *v3.RuntimeFractionalPercent {
	if x != nil {
		return x.RuntimeFraction
	}
	return nil
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetExcludeReadCommands() bool {
	if x != nil {
		return x.ExcludeReadCommands
	}
	return false
}

// ReadCommandPolicy specifies that Envoy should route read commands to another cluster.
type RedisProxy_PrefixRoutes_Route_ReadCommandPolicy struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Cluster       string                 `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) Reset() {
	*x = RedisProxy_PrefixRoutes_Route_ReadCommandPolicy{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) ProtoMessage() {}

func (x *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_PrefixRoutes_Route_ReadCommandPolicy.ProtoReflect.Descriptor instead.
func (*RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 1, 0, 1}
}

func (x *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

type RedisProtocolOptions_Credential struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The address to which this username and password applies.
	Address *v3.Address `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Upstream server password as defined by the “requirepass“ directive
	// `<https://redis.io/topics/config>`_ in the server's configuration file.
	AuthPassword *v3.DataSource `protobuf:"bytes,2,opt,name=auth_password,json=authPassword,proto3" json:"auth_password,omitempty"`
	// Upstream server username as defined by the “user“ directive
	// `<https://redis.io/topics/acl>`_ in the server's configuration file.
	AuthUsername  *v3.DataSource `protobuf:"bytes,3,opt,name=auth_username,json=authUsername,proto3" json:"auth_username,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RedisProtocolOptions_Credential) Reset() {
	*x = RedisProtocolOptions_Credential{}
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisProtocolOptions_Credential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProtocolOptions_Credential) ProtoMessage() {}

func (x *RedisProtocolOptions_Credential) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProtocolOptions_Credential.ProtoReflect.Descriptor instead.
func (*RedisProtocolOptions_Credential) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{1, 0}
}

func (x *RedisProtocolOptions_Credential) GetAddress() *v3.Address {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *RedisProtocolOptions_Credential) GetAuthPassword() *v3.DataSource {
	if x != nil {
		return x.AuthPassword
	}
	return nil
}

func (x *RedisProtocolOptions_Credential) GetAuthUsername() *v3.DataSource {
	if x != nil {
		return x.AuthUsername
	}
	return nil
}

var File_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto protoreflect.FileDescriptor

const file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc = "" +
	"\n" +
	"Aenvoy/extensions/filters/network/redis_proxy/v3/redis_proxy.proto\x12/envoy.extensions.filters.network.redis_proxy.v3\x1a\"envoy/config/core/v3/address.proto\x1a\x1fenvoy/config/core/v3/base.proto\x1a'envoy/config/core/v3/grpc_service.proto\x1a8envoy/extensions/common/aws/v3/credential_provider.proto\x1a@envoy/extensions/common/dynamic_forward_proxy/v3/dns_cache.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a#envoy/annotations/deprecation.proto\x1a\x1eudpa/annotations/migrate.proto\x1a udpa/annotations/sensitive.proto\x1a\x1dudpa/annotations/status.proto\x1a!udpa/annotations/versioning.proto\x1a\x17validate/validate.proto\"\xbc\x1d\n" +
	"\n" +
	"RedisProxy\x12(\n" +
	"\vstat_prefix\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\n" +
	"statPrefix\x12r\n" +
	"\bsettings\x18\x03 \x01(\v2L.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettingsB\b\xfaB\x05\x8a\x01\x02\x10\x01R\bsettings\x12*\n" +
	"\x11latency_in_micros\x18\x04 \x01(\bR\x0flatencyInMicros\x12m\n" +
	"\rprefix_routes\x18\x05 \x01(\v2H.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutesR\fprefixRoutes\x12m\n" +
	"\x18downstream_auth_password\x18\x06 \x01(\v2 .envoy.config.core.v3.DataSourceB\x11\xb8\xb7\x8b\xa4\x02\x01\x92ǆ\xd8\x04\x033.0\x18\x01R\x16downstreamAuthPassword\x12d\n" +
	"\x19downstream_auth_passwords\x18\t \x03(\v2 .envoy.config.core.v3.DataSourceB\x06\xb8\xb7\x8b\xa4\x02\x01R\x17downstreamAuthPasswords\x12^\n" +
	"\x06faults\x18\b \x03(\v2F.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFaultR\x06faults\x12b\n" +
	"\x18downstream_auth_username\x18\a \x01(\v2 .envoy.config.core.v3.DataSourceB\x06\xb8\xb7\x8b\xa4\x02\x01R\x16downstreamAuthUsername\x12\x80\x01\n" +
	"\x16external_auth_provider\x18\n" +
	" \x01(\v2J.envoy.extensions.filters.network.redis_proxy.v3.RedisExternalAuthProviderR\x14externalAuthProvider\x12'\n" +
	"\x0fcustom_commands\x18\v \x03(\tR\x0ecustomCommands\x1a\xa0\b\n" +
	"\x10ConnPoolSettings\x12B\n" +
	"\n" +
	"op_timeout\x18\x01 \x01(\v2\x19.google.protobuf.DurationB\b\xfaB\x05\xaa\x01\x02\b\x01R\topTimeout\x12-\n" +
	"\x12enable_hashtagging\x18\x02 \x01(\bR\x11enableHashtagging\x12-\n" +
	"\x12enable_redirection\x18\x03 \x01(\bR\x11enableRedirection\x12j\n" +
	"\x10dns_cache_config\x18\t \x01(\v2@.envoy.extensions.common.dynamic_forward_proxy.v3.DnsCacheConfigR\x0ednsCacheConfig\x12>\n" +
	"\x1cmax_buffer_size_before_flush\x18\x04 \x01(\rR\x18maxBufferSizeBeforeFlush\x12K\n" +
	"\x14buffer_flush_timeout\x18\x05 \x01(\v2\x19.google.protobuf.DurationR\x12bufferFlushTimeout\x12e\n" +
	" max_upstream_unknown_connections\x18\x06 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x1dmaxUpstreamUnknownConnections\x120\n" +
	"\x14enable_command_stats\x18\b \x01(\bR\x12enableCommandStats\x12\x82\x01\n" +
	"\vread_policy\x18\a \x01(\x0e2W.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.ReadPolicyB\b\xfaB\x05\x82\x01\x02\x10\x01R\n" +
	"readPolicy\x12\x83\x01\n" +
	"\x15connection_rate_limit\x18\n" +
	" \x01(\v2O.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnectionRateLimitR\x13connectionRateLimit\"~\n" +
	"\n" +
	"ReadPolicy\x12\x1b\n" +
	"\x06MASTER\x10\x00\x1a\x0f\xf2\x98\xfe\x8f\x05\t\n" +
	"\aPRIMARY\x12)\n" +
	"\rPREFER_MASTER\x10\x01\x1a\x16\xf2\x98\xfe\x8f\x05\x10\n" +
	"\x0ePREFER_PRIMARY\x12\v\n" +
	"\aREPLICA\x10\x02\x12\x12\n" +
	"\x0ePREFER_REPLICA\x10\x03\x12\a\n" +
	"\x03ANY\x10\x04:M\x9aň\x1eH\n" +
	"Fenvoy.config.filter.network.redis_proxy.v2.RedisProxy.ConnPoolSettings\x1a\xfa\t\n" +
	"\fPrefixRoutes\x12f\n" +
	"\x06routes\x18\x01 \x03(\v2N.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.RouteR\x06routes\x12)\n" +
	"\x10case_insensitive\x18\x02 \x01(\bR\x0fcaseInsensitive\x12v\n" +
	"\x0fcatch_all_route\x18\x04 \x01(\v2N.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.RouteR\rcatchAllRoute\x1a\xfa\x06\n" +
	"\x05Route\x12 \n" +
	"\x06prefix\x18\x01 \x01(\tB\b\xfaB\x05r\x03(\xe8\aR\x06prefix\x12#\n" +
	"\rremove_prefix\x18\x02 \x01(\bR\fremovePrefix\x12!\n" +
	"\acluster\x18\x03 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\acluster\x12\x96\x01\n" +
	"\x15request_mirror_policy\x18\x04 \x03(\v2b.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicyR\x13requestMirrorPolicy\x12#\n" +
	"\rkey_formatter\x18\x05 \x01(\tR\fkeyFormatter\x12\x90\x01\n" +
	"\x13read_command_policy\x18\x06 \x01(\v2`.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.ReadCommandPolicyR\x11readCommandPolicy\x1a\xac\x02\n" +
	"\x13RequestMirrorPolicy\x12!\n" +
	"\acluster\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\acluster\x12Y\n" +
	"\x10runtime_fraction\x18\x02 \x01(\v2..envoy.config.core.v3.RuntimeFractionalPercentR\x0fruntimeFraction\x122\n" +
	"\x15exclude_read_commands\x18\x03 \x01(\bR\x13excludeReadCommands:c\x9aň\x1e^\n" +
	"\\envoy.config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicy\x1a6\n" +
	"\x11ReadCommandPolicy\x12!\n" +
	"\acluster\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\acluster:O\x9aň\x1eJ\n" +
	"Henvoy.config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutes.Route:I\x9aň\x1eD\n" +
	"Benvoy.config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutesJ\x04\b\x03\x10\x04R\x11catch_all_cluster\x1a\xe0\x02\n" +
	"\n" +
	"RedisFault\x12~\n" +
	"\n" +
	"fault_type\x18\x01 \x01(\x0e2U.envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.RedisFaultTypeB\b\xfaB\x05\x82\x01\x02\x10\x01R\tfaultType\x12]\n" +
	"\rfault_enabled\x18\x02 \x01(\v2..envoy.config.core.v3.RuntimeFractionalPercentB\b\xfaB\x05\x8a\x01\x02\x10\x01R\ffaultEnabled\x12/\n" +
	"\x05delay\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\x05delay\x12\x1a\n" +
	"\bcommands\x18\x04 \x03(\tR\bcommands\"&\n" +
	"\x0eRedisFaultType\x12\t\n" +
	"\x05DELAY\x10\x00\x12\t\n" +
	"\x05ERROR\x10\x01\x1a`\n" +
	"\x13ConnectionRateLimit\x12I\n" +
	"\x1dconnection_rate_limit_per_sec\x18\x01 \x01(\rB\a\xfaB\x04*\x02 \x00R\x19connectionRateLimitPerSec:<\x9aň\x1e7\n" +
	"5envoy.config.filter.network.redis_proxy.v2.RedisProxyJ\x04\b\x02\x10\x03R\acluster\"\xa8\x05\n" +
	"\x14RedisProtocolOptions\x12M\n" +
	"\rauth_password\x18\x01 \x01(\v2 .envoy.config.core.v3.DataSourceB\x06\xb8\xb7\x8b\xa4\x02\x01R\fauthPassword\x12M\n" +
	"\rauth_username\x18\x02 \x01(\v2 .envoy.config.core.v3.DataSourceB\x06\xb8\xb7\x8b\xa4\x02\x01R\fauthUsername\x12P\n" +
	"\aaws_iam\x18\x03 \x01(\v27.envoy.extensions.filters.network.redis_proxy.v3.AwsIamR\x06awsIam\x12r\n" +
	"\vcredentials\x18\x04 \x03(\v2P.envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.CredentialR\vcredentials\x1a\xe3\x01\n" +
	"\n" +
	"Credential\x127\n" +
	"\aaddress\x18\x01 \x01(\v2\x1d.envoy.config.core.v3.AddressR\aaddress\x12M\n" +
	"\rauth_password\x18\x02 \x01(\v2 .envoy.config.core.v3.DataSourceB\x06\xb8\xb7\x8b\xa4\x02\x01R\fauthPassword\x12M\n" +
	"\rauth_username\x18\x03 \x01(\v2 .envoy.config.core.v3.DataSourceB\x06\xb8\xb7\x8b\xa4\x02\x01R\fauthUsername:F\x9aň\x1eA\n" +
	"?envoy.config.filter.network.redis_proxy.v2.RedisProtocolOptions\"\xa6\x02\n" +
	"\x06AwsIam\x12f\n" +
	"\x13credential_provider\x18\x01 \x01(\v25.envoy.extensions.common.aws.v3.AwsCredentialProviderR\x12credentialProvider\x12&\n" +
	"\n" +
	"cache_name\x18\x02 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\tcacheName\x12!\n" +
	"\fservice_name\x18\x03 \x01(\tR\vserviceName\x12\x16\n" +
	"\x06region\x18\x04 \x01(\tR\x06region\x12Q\n" +
	"\x0fexpiration_time\x18\x05 \x01(\v2\x19.google.protobuf.DurationB\r\xfaB\n" +
	"\xaa\x01\a\"\x03\b\x84\a2\x00R\x0eexpirationTime\"\x97\x01\n" +
	"\x19RedisExternalAuthProvider\x12D\n" +
	"\fgrpc_service\x18\x01 \x01(\v2!.envoy.config.core.v3.GrpcServiceR\vgrpcService\x124\n" +
	"\x16enable_auth_expiration\x18\x02 \x01(\bR\x14enableAuthExpirationB\xc0\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\n" +
	"=io.envoyproxy.envoy.extensions.filters.network.redis_proxy.v3B\x0fRedisProxyProtoP\x01Zdgithub.com/envoyproxy/go-control-plane/envoy/extensions/filters/network/redis_proxy/v3;redis_proxyv3b\x06proto3"

var (
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescData []byte
)

func file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc), len(file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc)))
	})
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescData
}

var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_goTypes = []any{
	(RedisProxy_ConnPoolSettings_ReadPolicy)(0),               // 0: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.ReadPolicy
	(RedisProxy_RedisFault_RedisFaultType)(0),                 // 1: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.RedisFaultType
	(*RedisProxy)(nil),                                        // 2: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy
	(*RedisProtocolOptions)(nil),                              // 3: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions
	(*AwsIam)(nil),                                            // 4: envoy.extensions.filters.network.redis_proxy.v3.AwsIam
	(*RedisExternalAuthProvider)(nil),                         // 5: envoy.extensions.filters.network.redis_proxy.v3.RedisExternalAuthProvider
	(*RedisProxy_ConnPoolSettings)(nil),                       // 6: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings
	(*RedisProxy_PrefixRoutes)(nil),                           // 7: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes
	(*RedisProxy_RedisFault)(nil),                             // 8: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault
	(*RedisProxy_ConnectionRateLimit)(nil),                    // 9: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnectionRateLimit
	(*RedisProxy_PrefixRoutes_Route)(nil),                     // 10: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route
	(*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy)(nil), // 11: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicy
	(*RedisProxy_PrefixRoutes_Route_ReadCommandPolicy)(nil),   // 12: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.ReadCommandPolicy
	(*RedisProtocolOptions_Credential)(nil),                   // 13: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.Credential
	(*v3.DataSource)(nil),                                     // 14: envoy.config.core.v3.DataSource
	(*v31.AwsCredentialProvider)(nil),                         // 15: envoy.extensions.common.aws.v3.AwsCredentialProvider
	(*durationpb.Duration)(nil),                               // 16: google.protobuf.Duration
	(*v3.GrpcService)(nil),                                    // 17: envoy.config.core.v3.GrpcService
	(*v32.DnsCacheConfig)(nil),                                // 18: envoy.extensions.common.dynamic_forward_proxy.v3.DnsCacheConfig
	(*wrapperspb.UInt32Value)(nil),                            // 19: google.protobuf.UInt32Value
	(*v3.RuntimeFractionalPercent)(nil),                       // 20: envoy.config.core.v3.RuntimeFractionalPercent
	(*v3.Address)(nil),                                        // 21: envoy.config.core.v3.Address
}
var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_depIdxs = []int32{
	6,  // 0: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.settings:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings
	7,  // 1: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.prefix_routes:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes
	14, // 2: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.downstream_auth_password:type_name -> envoy.config.core.v3.DataSource
	14, // 3: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.downstream_auth_passwords:type_name -> envoy.config.core.v3.DataSource
	8,  // 4: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.faults:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault
	14, // 5: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.downstream_auth_username:type_name -> envoy.config.core.v3.DataSource
	5,  // 6: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.external_auth_provider:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisExternalAuthProvider
	14, // 7: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.auth_password:type_name -> envoy.config.core.v3.DataSource
	14, // 8: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.auth_username:type_name -> envoy.config.core.v3.DataSource
	4,  // 9: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.aws_iam:type_name -> envoy.extensions.filters.network.redis_proxy.v3.AwsIam
	13, // 10: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.credentials:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.Credential
	15, // 11: envoy.extensions.filters.network.redis_proxy.v3.AwsIam.credential_provider:type_name -> envoy.extensions.common.aws.v3.AwsCredentialProvider
	16, // 12: envoy.extensions.filters.network.redis_proxy.v3.AwsIam.expiration_time:type_name -> google.protobuf.Duration
	17, // 13: envoy.extensions.filters.network.redis_proxy.v3.RedisExternalAuthProvider.grpc_service:type_name -> envoy.config.core.v3.GrpcService
	16, // 14: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.op_timeout:type_name -> google.protobuf.Duration
	18, // 15: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.dns_cache_config:type_name -> envoy.extensions.common.dynamic_forward_proxy.v3.DnsCacheConfig
	16, // 16: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.buffer_flush_timeout:type_name -> google.protobuf.Duration
	19, // 17: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.max_upstream_unknown_connections:type_name -> google.protobuf.UInt32Value
	0,  // 18: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.read_policy:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.ReadPolicy
	9,  // 19: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.connection_rate_limit:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnectionRateLimit
	10, // 20: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.routes:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route
	10, // 21: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.catch_all_route:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route
	1,  // 22: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.fault_type:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.RedisFaultType
	20, // 23: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.fault_enabled:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	16, // 24: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.delay:type_name -> google.protobuf.Duration
	11, // 25: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.request_mirror_policy:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicy
	12, // 26: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.read_command_policy:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.ReadCommandPolicy
	20, // 27: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicy.runtime_fraction:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	21, // 28: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.Credential.address:type_name -> envoy.config.core.v3.Address
	14, // 29: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.Credential.auth_password:type_name -> envoy.config.core.v3.DataSource
	14, // 30: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.Credential.auth_username:type_name -> envoy.config.core.v3.DataSource
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_init() }
func file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_init() {
	if File_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc), len(file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_depIdxs,
		EnumInfos:         file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes,
		MessageInfos:      file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto = out.File
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_goTypes = nil
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_depIdxs = nil
}
