// Copyright 2020 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: networking/v1alpha3/workload_entry.proto

// $schema: istio.networking.v1alpha3.WorkloadEntry
// $title: Workload Entry
// $description: Configuration affecting VMs onboarded into the mesh.
// $location: https://istio.io/docs/reference/config/networking/workload-entry.html
// $aliases: [/docs/reference/config/networking/v1alpha3/workload-entry]

// `WorkloadEntry` enables operators to describe the properties of a
// single non-Kubernetes workload such as a VM or a bare metal server
// as it is onboarded into the mesh. A `WorkloadEntry` must be
// accompanied by an Istio `ServiceEntry` that selects the workload
// through the appropriate labels and provides the service definition
// for a `MESH_INTERNAL` service (hostnames, port properties, etc.). A
// `ServiceEntry` object can select multiple workload entries as well
// as Kubernetes pods based on the label selector specified in the
// service entry.
//
// When a workload connects to `istiod`, the status field in the
// custom resource will be updated to indicate the health of the
// workload along with other details, similar to how Kubernetes
// updates the status of a pod.
//
// The following example declares a workload entry representing a VM
// for the `details.bookinfo.com` service. This VM has sidecar
// installed and bootstrapped using the `details-legacy` service
// account. The service is exposed on port 80 to applications in the
// mesh. The HTTP traffic to this service is wrapped in Istio mutual
// TLS and sent to sidecars on VMs on target port 8080, that in turn
// forward it to the application on localhost on the same port.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: WorkloadEntry
// metadata:
//   name: details-svc
// spec:
//   # use of the service account indicates that the workload has a
//   # sidecar proxy bootstrapped with this service account. Pods with
//   # sidecars will automatically communicate with the workload using
//   # istio mutual TLS.
//   serviceAccount: details-legacy
//   address: 2.2.2.2
//   labels:
//     app: details-legacy
//     instance-id: vm1
// ```
//
// and the associated service entry
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: details-svc
// spec:
//   hosts:
//   - details.bookinfo.com
//   location: MESH_INTERNAL
//   ports:
//   - number: 80
//     name: http
//     protocol: HTTP
//     targetPort: 8080
//   resolution: STATIC
//   workloadSelector:
//     labels:
//       app: details-legacy
// ```
//
//
// The following example declares the same VM workload using
// its fully qualified DNS name. The service entry's resolution
// mode should be changed to DNS to indicate that the client-side
// sidecars should dynamically resolve the DNS name at runtime before
// forwarding the request.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: WorkloadEntry
// metadata:
//   name: details-svc
// spec:
//   # use of the service account indicates that the workload has a
//   # sidecar proxy bootstrapped with this service account. Pods with
//   # sidecars will automatically communicate with the workload using
//   # istio mutual TLS.
//   serviceAccount: details-legacy
//   address: vm1.vpc01.corp.net
//   labels:
//     app: details-legacy
//     instance-id: vm1
// ```
//
// and the associated service entry
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: details-svc
// spec:
//   hosts:
//   - details.bookinfo.com
//   location: MESH_INTERNAL
//   ports:
//   - number: 80
//     name: http
//     protocol: HTTP
//     targetPort: 8080
//   resolution: DNS
//   workloadSelector:
//     labels:
//       app: details-legacy
// ```
//
// The following example declares a VM workload without an address.
// An alternative to having istiod read from remote API servers is
// to write a `WorkloadEntry` in the local cluster that represents
// the Workload(s) in the remote network with the given labels. A
// single `WorkloadEntry` with weights represent the aggregate of all
// the actual workloads in a given remote network.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: WorkloadEntry
// metadata:
//   name: foo-workloads-cluster-2
// spec:
//   serviceAccount: foo
//   network: cluster-2-network
//   labels:
//     app: foo
// ```

package v1alpha3

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// WorkloadEntry enables specifying the properties of a single non-Kubernetes workload such a VM or a bare metal services that can be referred to by service entries.
//
// <!-- crd generation tags
// +cue-gen:WorkloadEntry:groupName:networking.istio.io
// +cue-gen:WorkloadEntry:versions:v1,v1beta1,v1alpha3
// +cue-gen:WorkloadEntry:annotations:helm.sh/resource-policy=keep
// +cue-gen:WorkloadEntry:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:WorkloadEntry:subresource:status
// +cue-gen:WorkloadEntry:scope:Namespaced
// +cue-gen:WorkloadEntry:resource:categories=istio-io,networking-istio-io,shortNames=we,plural=workloadentries
// +cue-gen:WorkloadEntry:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// +cue-gen:WorkloadEntry:printerColumn:name=Address,type=string,JSONPath=.spec.address,description="Address associated with the network endpoint."
// +cue-gen:WorkloadEntry:preserveUnknownFields:false
// +cue-gen:WorkloadEntry:spec:required
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
// +kubebuilder:validation:XValidation:message="Address is required",rule="has(self.address) || has(self.network)"
// +kubebuilder:validation:XValidation:message="UDS may not include ports",rule="(default(self.address, "").startsWith('unix://')) ? !has(self.ports) : true"
type WorkloadEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Address associated with the network endpoint without the
	// port.  Domain names can be used if and only if the resolution is set
	// to DNS, and must be fully-qualified without wildcards. Use the form
	// unix:///absolute/path/to/socket for Unix domain socket endpoints.
	// If address is empty, network must be specified.
	// +kubebuilder:validation:XValidation:message="UDS must be an absolute path or abstract socket",rule="self.startsWith('unix://') ? (self.substring(7,8) == '/' || self.substring(7,8) == '@') : true"
	// +kubebuilder:validation:XValidation:message="UDS may not be a dir",rule="self.startsWith('unix://') ? !self.endsWith('/') : true"
	// +kubebuilder:validation:MaxLength=256
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Set of ports associated with the endpoint. If the port map is
	// specified, it must be a map of servicePortName to this endpoint's
	// port, such that traffic to the service port will be forwarded to
	// the endpoint port that maps to the service's portName. If
	// omitted, and the targetPort is specified as part of the service's
	// port specification, traffic to the service port will be forwarded
	// to one of the endpoints on the specified `targetPort`. If both
	// the targetPort and endpoint's port map are not specified, traffic
	// to a service port will be forwarded to one of the endpoints on
	// the same port.
	//
	// **NOTE 1:** Do not use for `unix://` addresses.
	//
	// **NOTE 2:** endpoint port map takes precedence over targetPort.
	// +protoc-gen-crd:map-value-validation:XValidation:message="port must be between 1-65535",rule="0 < self && self <= 65535"
	// +kubebuilder:validation:MaxProperties=128
	// +kubebuilder:validation:XValidation:message="port name must be valid",rule="self.all(key, size(key) < 63 && key.matches('^[a-zA-Z0-9](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?$'))"
	Ports map[string]uint32 `protobuf:"bytes,2,rep,name=ports,proto3" json:"ports,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	// One or more labels associated with the endpoint.
	// +kubebuilder:validation:MaxProperties=256
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Network enables Istio to group endpoints resident in the same L3
	// domain/network. All endpoints in the same network are assumed to be
	// directly reachable from one another. When endpoints in different
	// networks cannot reach each other directly, an Istio Gateway can be
	// used to establish connectivity (usually using the
	// `AUTO_PASSTHROUGH` mode in a Gateway Server). This is
	// an advanced configuration used typically for spanning an Istio mesh
	// over multiple clusters. Required if address is not provided.
	// +kubebuilder:validation:MaxLength=2048
	Network string `protobuf:"bytes,4,opt,name=network,proto3" json:"network,omitempty"`
	// The locality associated with the endpoint. A locality corresponds
	// to a failure domain (e.g., country/region/zone). Arbitrary failure
	// domain hierarchies can be represented by separating each
	// encapsulating failure domain by /. For example, the locality of an
	// an endpoint in US, in US-East-1 region, within availability zone
	// az-1, in data center rack r11 can be represented as
	// us/us-east-1/az-1/r11. Istio will configure the sidecar to route to
	// endpoints within the same locality as the sidecar. If none of the
	// endpoints in the locality are available, endpoints parent locality
	// (but within the same network ID) will be chosen. For example, if
	// there are two endpoints in same network (networkID "n1"), say e1
	// with locality us/us-east-1/az-1/r11 and e2 with locality
	// us/us-east-1/az-2/r12, a sidecar from us/us-east-1/az-1/r11 locality
	// will prefer e1 from the same locality over e2 from a different
	// locality. Endpoint e2 could be the IP associated with a gateway
	// (that bridges networks n1 and n2), or the IP associated with a
	// standard service endpoint.
	// +kubebuilder:validation:MaxLength=2048
	Locality string `protobuf:"bytes,5,opt,name=locality,proto3" json:"locality,omitempty"`
	// The load balancing weight associated with the endpoint. Endpoints
	// with higher weights will receive proportionally higher traffic.
	Weight uint32 `protobuf:"varint,6,opt,name=weight,proto3" json:"weight,omitempty"`
	// The service account associated with the workload if a sidecar
	// is present in the workload. The service account must be present
	// in the same namespace as the configuration ( WorkloadEntry or a
	// ServiceEntry)
	// +kubebuilder:validation:MaxLength=253
	ServiceAccount string `protobuf:"bytes,7,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *WorkloadEntry) Reset() {
	*x = WorkloadEntry{}
	mi := &file_networking_v1alpha3_workload_entry_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadEntry) ProtoMessage() {}

func (x *WorkloadEntry) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_entry_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadEntry.ProtoReflect.Descriptor instead.
func (*WorkloadEntry) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_entry_proto_rawDescGZIP(), []int{0}
}

func (x *WorkloadEntry) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *WorkloadEntry) GetPorts() map[string]uint32 {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *WorkloadEntry) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *WorkloadEntry) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *WorkloadEntry) GetLocality() string {
	if x != nil {
		return x.Locality
	}
	return ""
}

func (x *WorkloadEntry) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *WorkloadEntry) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

var File_networking_v1alpha3_workload_entry_proto protoreflect.FileDescriptor

const file_networking_v1alpha3_workload_entry_proto_rawDesc = "" +
	"\n" +
	"(networking/v1alpha3/workload_entry.proto\x12\x19istio.networking.v1alpha3\"\xae\x03\n" +
	"\rWorkloadEntry\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x12I\n" +
	"\x05ports\x18\x02 \x03(\v23.istio.networking.v1alpha3.WorkloadEntry.PortsEntryR\x05ports\x12L\n" +
	"\x06labels\x18\x03 \x03(\v24.istio.networking.v1alpha3.WorkloadEntry.LabelsEntryR\x06labels\x12\x18\n" +
	"\anetwork\x18\x04 \x01(\tR\anetwork\x12\x1a\n" +
	"\blocality\x18\x05 \x01(\tR\blocality\x12\x16\n" +
	"\x06weight\x18\x06 \x01(\rR\x06weight\x12'\n" +
	"\x0fservice_account\x18\a \x01(\tR\x0eserviceAccount\x1a8\n" +
	"\n" +
	"PortsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\rR\x05value:\x028\x01\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\"Z istio.io/api/networking/v1alpha3b\x06proto3"

var (
	file_networking_v1alpha3_workload_entry_proto_rawDescOnce sync.Once
	file_networking_v1alpha3_workload_entry_proto_rawDescData []byte
)

func file_networking_v1alpha3_workload_entry_proto_rawDescGZIP() []byte {
	file_networking_v1alpha3_workload_entry_proto_rawDescOnce.Do(func() {
		file_networking_v1alpha3_workload_entry_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_workload_entry_proto_rawDesc), len(file_networking_v1alpha3_workload_entry_proto_rawDesc)))
	})
	return file_networking_v1alpha3_workload_entry_proto_rawDescData
}

var file_networking_v1alpha3_workload_entry_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_networking_v1alpha3_workload_entry_proto_goTypes = []any{
	(*WorkloadEntry)(nil), // 0: istio.networking.v1alpha3.WorkloadEntry
	nil,                   // 1: istio.networking.v1alpha3.WorkloadEntry.PortsEntry
	nil,                   // 2: istio.networking.v1alpha3.WorkloadEntry.LabelsEntry
}
var file_networking_v1alpha3_workload_entry_proto_depIdxs = []int32{
	1, // 0: istio.networking.v1alpha3.WorkloadEntry.ports:type_name -> istio.networking.v1alpha3.WorkloadEntry.PortsEntry
	2, // 1: istio.networking.v1alpha3.WorkloadEntry.labels:type_name -> istio.networking.v1alpha3.WorkloadEntry.LabelsEntry
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_networking_v1alpha3_workload_entry_proto_init() }
func file_networking_v1alpha3_workload_entry_proto_init() {
	if File_networking_v1alpha3_workload_entry_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_workload_entry_proto_rawDesc), len(file_networking_v1alpha3_workload_entry_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_networking_v1alpha3_workload_entry_proto_goTypes,
		DependencyIndexes: file_networking_v1alpha3_workload_entry_proto_depIdxs,
		MessageInfos:      file_networking_v1alpha3_workload_entry_proto_msgTypes,
	}.Build()
	File_networking_v1alpha3_workload_entry_proto = out.File
	file_networking_v1alpha3_workload_entry_proto_goTypes = nil
	file_networking_v1alpha3_workload_entry_proto_depIdxs = nil
}
