#ifndef itkImageFileReaderSwigInterface_h
#define itkImageFileReaderSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkPhasedArray3DSpecialCoordinatesImage.h"
#include "itkImageFileReader.h"

using itkImageFileReaderIULL2 = itk::ImageFileReader< itk::Image< unsigned long long,2 > >;
using itkImageFileReaderIULL2_Pointer = itk::ImageFileReader< itk::Image< unsigned long long,2 > >::Pointer;
using itkImageFileReaderIULL3 = itk::ImageFileReader< itk::Image< unsigned long long,3 > >;
using itkImageFileReaderIULL3_Pointer = itk::ImageFileReader< itk::Image< unsigned long long,3 > >::Pointer;
using itkImageFileReaderIULL4 = itk::ImageFileReader< itk::Image< unsigned long long,4 > >;
using itkImageFileReaderIULL4_Pointer = itk::ImageFileReader< itk::Image< unsigned long long,4 > >::Pointer;
using itkImageFileReaderISI2 = itk::ImageFileReader< itk::Image< signed int,2 > >;
using itkImageFileReaderISI2_Pointer = itk::ImageFileReader< itk::Image< signed int,2 > >::Pointer;
using itkImageFileReaderISI3 = itk::ImageFileReader< itk::Image< signed int,3 > >;
using itkImageFileReaderISI3_Pointer = itk::ImageFileReader< itk::Image< signed int,3 > >::Pointer;
using itkImageFileReaderISI4 = itk::ImageFileReader< itk::Image< signed int,4 > >;
using itkImageFileReaderISI4_Pointer = itk::ImageFileReader< itk::Image< signed int,4 > >::Pointer;
using itkImageFileReaderIUI2 = itk::ImageFileReader< itk::Image< unsigned int,2 > >;
using itkImageFileReaderIUI2_Pointer = itk::ImageFileReader< itk::Image< unsigned int,2 > >::Pointer;
using itkImageFileReaderIUI3 = itk::ImageFileReader< itk::Image< unsigned int,3 > >;
using itkImageFileReaderIUI3_Pointer = itk::ImageFileReader< itk::Image< unsigned int,3 > >::Pointer;
using itkImageFileReaderIUI4 = itk::ImageFileReader< itk::Image< unsigned int,4 > >;
using itkImageFileReaderIUI4_Pointer = itk::ImageFileReader< itk::Image< unsigned int,4 > >::Pointer;
using itkImageFileReaderIUC2 = itk::ImageFileReader< itk::Image< unsigned char,2 > >;
using itkImageFileReaderIUC2_Pointer = itk::ImageFileReader< itk::Image< unsigned char,2 > >::Pointer;
using itkImageFileReaderIUC3 = itk::ImageFileReader< itk::Image< unsigned char,3 > >;
using itkImageFileReaderIUC3_Pointer = itk::ImageFileReader< itk::Image< unsigned char,3 > >::Pointer;
using itkImageFileReaderIUC4 = itk::ImageFileReader< itk::Image< unsigned char,4 > >;
using itkImageFileReaderIUC4_Pointer = itk::ImageFileReader< itk::Image< unsigned char,4 > >::Pointer;
using itkImageFileReaderIRGBUC2 = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkImageFileReaderIRGBUC2_Pointer = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkImageFileReaderIRGBUC3 = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkImageFileReaderIRGBUC3_Pointer = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned char >,3 > >::Pointer;
using itkImageFileReaderIRGBUC4 = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkImageFileReaderIRGBUC4_Pointer = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned char >,4 > >::Pointer;
using itkImageFileReaderIRGBUS2 = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkImageFileReaderIRGBUS2_Pointer = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkImageFileReaderIRGBUS3 = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkImageFileReaderIRGBUS3_Pointer = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned short >,3 > >::Pointer;
using itkImageFileReaderIRGBUS4 = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkImageFileReaderIRGBUS4_Pointer = itk::ImageFileReader< itk::Image< itk::RGBPixel< unsigned short >,4 > >::Pointer;
using itkImageFileReaderIRGBAUC2 = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkImageFileReaderIRGBAUC2_Pointer = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned char >,2 > >::Pointer;
using itkImageFileReaderIRGBAUC3 = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkImageFileReaderIRGBAUC3_Pointer = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned char >,3 > >::Pointer;
using itkImageFileReaderIRGBAUC4 = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkImageFileReaderIRGBAUC4_Pointer = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned char >,4 > >::Pointer;
using itkImageFileReaderIRGBAUS2 = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkImageFileReaderIRGBAUS2_Pointer = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned short >,2 > >::Pointer;
using itkImageFileReaderIRGBAUS3 = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkImageFileReaderIRGBAUS3_Pointer = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned short >,3 > >::Pointer;
using itkImageFileReaderIRGBAUS4 = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkImageFileReaderIRGBAUS4_Pointer = itk::ImageFileReader< itk::Image< itk::RGBAPixel< unsigned short >,4 > >::Pointer;
using itkImageFileReaderIVD22 = itk::ImageFileReader< itk::Image< itk::Vector< double,2 >,2 > >;
using itkImageFileReaderIVD22_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,2 >,2 > >::Pointer;
using itkImageFileReaderIVD23 = itk::ImageFileReader< itk::Image< itk::Vector< double,2 >,3 > >;
using itkImageFileReaderIVD23_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,2 >,3 > >::Pointer;
using itkImageFileReaderIVD24 = itk::ImageFileReader< itk::Image< itk::Vector< double,2 >,4 > >;
using itkImageFileReaderIVD24_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,2 >,4 > >::Pointer;
using itkImageFileReaderIVD32 = itk::ImageFileReader< itk::Image< itk::Vector< double,3 >,2 > >;
using itkImageFileReaderIVD32_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,3 >,2 > >::Pointer;
using itkImageFileReaderIVD33 = itk::ImageFileReader< itk::Image< itk::Vector< double,3 >,3 > >;
using itkImageFileReaderIVD33_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,3 >,3 > >::Pointer;
using itkImageFileReaderIVD34 = itk::ImageFileReader< itk::Image< itk::Vector< double,3 >,4 > >;
using itkImageFileReaderIVD34_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,3 >,4 > >::Pointer;
using itkImageFileReaderIVD42 = itk::ImageFileReader< itk::Image< itk::Vector< double,4 >,2 > >;
using itkImageFileReaderIVD42_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,4 >,2 > >::Pointer;
using itkImageFileReaderIVD43 = itk::ImageFileReader< itk::Image< itk::Vector< double,4 >,3 > >;
using itkImageFileReaderIVD43_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,4 >,3 > >::Pointer;
using itkImageFileReaderIVD44 = itk::ImageFileReader< itk::Image< itk::Vector< double,4 >,4 > >;
using itkImageFileReaderIVD44_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< double,4 >,4 > >::Pointer;
using itkImageFileReaderIVF22 = itk::ImageFileReader< itk::Image< itk::Vector< float,2 >,2 > >;
using itkImageFileReaderIVF22_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,2 >,2 > >::Pointer;
using itkImageFileReaderIVF23 = itk::ImageFileReader< itk::Image< itk::Vector< float,2 >,3 > >;
using itkImageFileReaderIVF23_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,2 >,3 > >::Pointer;
using itkImageFileReaderIVF24 = itk::ImageFileReader< itk::Image< itk::Vector< float,2 >,4 > >;
using itkImageFileReaderIVF24_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,2 >,4 > >::Pointer;
using itkImageFileReaderIVF32 = itk::ImageFileReader< itk::Image< itk::Vector< float,3 >,2 > >;
using itkImageFileReaderIVF32_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,3 >,2 > >::Pointer;
using itkImageFileReaderIVF33 = itk::ImageFileReader< itk::Image< itk::Vector< float,3 >,3 > >;
using itkImageFileReaderIVF33_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,3 >,3 > >::Pointer;
using itkImageFileReaderIVF34 = itk::ImageFileReader< itk::Image< itk::Vector< float,3 >,4 > >;
using itkImageFileReaderIVF34_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,3 >,4 > >::Pointer;
using itkImageFileReaderIVF42 = itk::ImageFileReader< itk::Image< itk::Vector< float,4 >,2 > >;
using itkImageFileReaderIVF42_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,4 >,2 > >::Pointer;
using itkImageFileReaderIVF43 = itk::ImageFileReader< itk::Image< itk::Vector< float,4 >,3 > >;
using itkImageFileReaderIVF43_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,4 >,3 > >::Pointer;
using itkImageFileReaderIVF44 = itk::ImageFileReader< itk::Image< itk::Vector< float,4 >,4 > >;
using itkImageFileReaderIVF44_Pointer = itk::ImageFileReader< itk::Image< itk::Vector< float,4 >,4 > >::Pointer;
using itkImageFileReaderICVD22 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkImageFileReaderICVD22_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,2 >,2 > >::Pointer;
using itkImageFileReaderICVD23 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkImageFileReaderICVD23_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,2 >,3 > >::Pointer;
using itkImageFileReaderICVD24 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkImageFileReaderICVD24_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,2 >,4 > >::Pointer;
using itkImageFileReaderICVD32 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkImageFileReaderICVD32_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,3 >,2 > >::Pointer;
using itkImageFileReaderICVD33 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkImageFileReaderICVD33_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,3 >,3 > >::Pointer;
using itkImageFileReaderICVD34 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkImageFileReaderICVD34_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,3 >,4 > >::Pointer;
using itkImageFileReaderICVD42 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkImageFileReaderICVD42_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,4 >,2 > >::Pointer;
using itkImageFileReaderICVD43 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkImageFileReaderICVD43_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,4 >,3 > >::Pointer;
using itkImageFileReaderICVD44 = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkImageFileReaderICVD44_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< double,4 >,4 > >::Pointer;
using itkImageFileReaderICVF22 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkImageFileReaderICVF22_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,2 >,2 > >::Pointer;
using itkImageFileReaderICVF23 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkImageFileReaderICVF23_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,2 >,3 > >::Pointer;
using itkImageFileReaderICVF24 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkImageFileReaderICVF24_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,2 >,4 > >::Pointer;
using itkImageFileReaderICVF32 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkImageFileReaderICVF32_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,3 >,2 > >::Pointer;
using itkImageFileReaderICVF33 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkImageFileReaderICVF33_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,3 >,3 > >::Pointer;
using itkImageFileReaderICVF34 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkImageFileReaderICVF34_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,3 >,4 > >::Pointer;
using itkImageFileReaderICVF42 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkImageFileReaderICVF42_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,4 >,2 > >::Pointer;
using itkImageFileReaderICVF43 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkImageFileReaderICVF43_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,4 >,3 > >::Pointer;
using itkImageFileReaderICVF44 = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkImageFileReaderICVF44_Pointer = itk::ImageFileReader< itk::Image< itk::CovariantVector< float,4 >,4 > >::Pointer;
using itkImageFileReaderISC2 = itk::ImageFileReader< itk::Image< signed char,2 > >;
using itkImageFileReaderISC2_Pointer = itk::ImageFileReader< itk::Image< signed char,2 > >::Pointer;
using itkImageFileReaderISC3 = itk::ImageFileReader< itk::Image< signed char,3 > >;
using itkImageFileReaderISC3_Pointer = itk::ImageFileReader< itk::Image< signed char,3 > >::Pointer;
using itkImageFileReaderISC4 = itk::ImageFileReader< itk::Image< signed char,4 > >;
using itkImageFileReaderISC4_Pointer = itk::ImageFileReader< itk::Image< signed char,4 > >::Pointer;
using itkImageFileReaderISS2 = itk::ImageFileReader< itk::Image< signed short,2 > >;
using itkImageFileReaderISS2_Pointer = itk::ImageFileReader< itk::Image< signed short,2 > >::Pointer;
using itkImageFileReaderISS3 = itk::ImageFileReader< itk::Image< signed short,3 > >;
using itkImageFileReaderISS3_Pointer = itk::ImageFileReader< itk::Image< signed short,3 > >::Pointer;
using itkImageFileReaderISS4 = itk::ImageFileReader< itk::Image< signed short,4 > >;
using itkImageFileReaderISS4_Pointer = itk::ImageFileReader< itk::Image< signed short,4 > >::Pointer;
using itkImageFileReaderIUS2 = itk::ImageFileReader< itk::Image< unsigned short,2 > >;
using itkImageFileReaderIUS2_Pointer = itk::ImageFileReader< itk::Image< unsigned short,2 > >::Pointer;
using itkImageFileReaderIUS3 = itk::ImageFileReader< itk::Image< unsigned short,3 > >;
using itkImageFileReaderIUS3_Pointer = itk::ImageFileReader< itk::Image< unsigned short,3 > >::Pointer;
using itkImageFileReaderIUS4 = itk::ImageFileReader< itk::Image< unsigned short,4 > >;
using itkImageFileReaderIUS4_Pointer = itk::ImageFileReader< itk::Image< unsigned short,4 > >::Pointer;
using itkImageFileReaderIF2 = itk::ImageFileReader< itk::Image< float,2 > >;
using itkImageFileReaderIF2_Pointer = itk::ImageFileReader< itk::Image< float,2 > >::Pointer;
using itkImageFileReaderIF3 = itk::ImageFileReader< itk::Image< float,3 > >;
using itkImageFileReaderIF3_Pointer = itk::ImageFileReader< itk::Image< float,3 > >::Pointer;
using itkImageFileReaderIF4 = itk::ImageFileReader< itk::Image< float,4 > >;
using itkImageFileReaderIF4_Pointer = itk::ImageFileReader< itk::Image< float,4 > >::Pointer;
using itkImageFileReaderID2 = itk::ImageFileReader< itk::Image< double,2 > >;
using itkImageFileReaderID2_Pointer = itk::ImageFileReader< itk::Image< double,2 > >::Pointer;
using itkImageFileReaderID3 = itk::ImageFileReader< itk::Image< double,3 > >;
using itkImageFileReaderID3_Pointer = itk::ImageFileReader< itk::Image< double,3 > >::Pointer;
using itkImageFileReaderID4 = itk::ImageFileReader< itk::Image< double,4 > >;
using itkImageFileReaderID4_Pointer = itk::ImageFileReader< itk::Image< double,4 > >::Pointer;
using itkImageFileReaderICD2 = itk::ImageFileReader< itk::Image< std::complex< double >,2 > >;
using itkImageFileReaderICD2_Pointer = itk::ImageFileReader< itk::Image< std::complex< double >,2 > >::Pointer;
using itkImageFileReaderICD3 = itk::ImageFileReader< itk::Image< std::complex< double >,3 > >;
using itkImageFileReaderICD3_Pointer = itk::ImageFileReader< itk::Image< std::complex< double >,3 > >::Pointer;
using itkImageFileReaderICD4 = itk::ImageFileReader< itk::Image< std::complex< double >,4 > >;
using itkImageFileReaderICD4_Pointer = itk::ImageFileReader< itk::Image< std::complex< double >,4 > >::Pointer;
using itkImageFileReaderICF2 = itk::ImageFileReader< itk::Image< std::complex< float >,2 > >;
using itkImageFileReaderICF2_Pointer = itk::ImageFileReader< itk::Image< std::complex< float >,2 > >::Pointer;
using itkImageFileReaderICF3 = itk::ImageFileReader< itk::Image< std::complex< float >,3 > >;
using itkImageFileReaderICF3_Pointer = itk::ImageFileReader< itk::Image< std::complex< float >,3 > >::Pointer;
using itkImageFileReaderICF4 = itk::ImageFileReader< itk::Image< std::complex< float >,4 > >;
using itkImageFileReaderICF4_Pointer = itk::ImageFileReader< itk::Image< std::complex< float >,4 > >::Pointer;
using itkImageFileReaderVISC2 = itk::ImageFileReader< itk::VectorImage< signed char,2 > >;
using itkImageFileReaderVISC2_Pointer = itk::ImageFileReader< itk::VectorImage< signed char,2 > >::Pointer;
using itkImageFileReaderVISS2 = itk::ImageFileReader< itk::VectorImage< signed short,2 > >;
using itkImageFileReaderVISS2_Pointer = itk::ImageFileReader< itk::VectorImage< signed short,2 > >::Pointer;
using itkImageFileReaderVIUC2 = itk::ImageFileReader< itk::VectorImage< unsigned char,2 > >;
using itkImageFileReaderVIUC2_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned char,2 > >::Pointer;
using itkImageFileReaderVIULL2 = itk::ImageFileReader< itk::VectorImage< unsigned long long,2 > >;
using itkImageFileReaderVIULL2_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned long long,2 > >::Pointer;
using itkImageFileReaderVIUS2 = itk::ImageFileReader< itk::VectorImage< unsigned short,2 > >;
using itkImageFileReaderVIUS2_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned short,2 > >::Pointer;
using itkImageFileReaderVIF2 = itk::ImageFileReader< itk::VectorImage< float,2 > >;
using itkImageFileReaderVIF2_Pointer = itk::ImageFileReader< itk::VectorImage< float,2 > >::Pointer;
using itkImageFileReaderVID2 = itk::ImageFileReader< itk::VectorImage< double,2 > >;
using itkImageFileReaderVID2_Pointer = itk::ImageFileReader< itk::VectorImage< double,2 > >::Pointer;
using itkImageFileReaderVISC3 = itk::ImageFileReader< itk::VectorImage< signed char,3 > >;
using itkImageFileReaderVISC3_Pointer = itk::ImageFileReader< itk::VectorImage< signed char,3 > >::Pointer;
using itkImageFileReaderVISS3 = itk::ImageFileReader< itk::VectorImage< signed short,3 > >;
using itkImageFileReaderVISS3_Pointer = itk::ImageFileReader< itk::VectorImage< signed short,3 > >::Pointer;
using itkImageFileReaderVIUC3 = itk::ImageFileReader< itk::VectorImage< unsigned char,3 > >;
using itkImageFileReaderVIUC3_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned char,3 > >::Pointer;
using itkImageFileReaderVIULL3 = itk::ImageFileReader< itk::VectorImage< unsigned long long,3 > >;
using itkImageFileReaderVIULL3_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned long long,3 > >::Pointer;
using itkImageFileReaderVIUS3 = itk::ImageFileReader< itk::VectorImage< unsigned short,3 > >;
using itkImageFileReaderVIUS3_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned short,3 > >::Pointer;
using itkImageFileReaderVIF3 = itk::ImageFileReader< itk::VectorImage< float,3 > >;
using itkImageFileReaderVIF3_Pointer = itk::ImageFileReader< itk::VectorImage< float,3 > >::Pointer;
using itkImageFileReaderVID3 = itk::ImageFileReader< itk::VectorImage< double,3 > >;
using itkImageFileReaderVID3_Pointer = itk::ImageFileReader< itk::VectorImage< double,3 > >::Pointer;
using itkImageFileReaderVISC4 = itk::ImageFileReader< itk::VectorImage< signed char,4 > >;
using itkImageFileReaderVISC4_Pointer = itk::ImageFileReader< itk::VectorImage< signed char,4 > >::Pointer;
using itkImageFileReaderVISS4 = itk::ImageFileReader< itk::VectorImage< signed short,4 > >;
using itkImageFileReaderVISS4_Pointer = itk::ImageFileReader< itk::VectorImage< signed short,4 > >::Pointer;
using itkImageFileReaderVIUC4 = itk::ImageFileReader< itk::VectorImage< unsigned char,4 > >;
using itkImageFileReaderVIUC4_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned char,4 > >::Pointer;
using itkImageFileReaderVIULL4 = itk::ImageFileReader< itk::VectorImage< unsigned long long,4 > >;
using itkImageFileReaderVIULL4_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned long long,4 > >::Pointer;
using itkImageFileReaderVIUS4 = itk::ImageFileReader< itk::VectorImage< unsigned short,4 > >;
using itkImageFileReaderVIUS4_Pointer = itk::ImageFileReader< itk::VectorImage< unsigned short,4 > >::Pointer;
using itkImageFileReaderVIF4 = itk::ImageFileReader< itk::VectorImage< float,4 > >;
using itkImageFileReaderVIF4_Pointer = itk::ImageFileReader< itk::VectorImage< float,4 > >::Pointer;
using itkImageFileReaderVID4 = itk::ImageFileReader< itk::VectorImage< double,4 > >;
using itkImageFileReaderVID4_Pointer = itk::ImageFileReader< itk::VectorImage< double,4 > >::Pointer;
using itkImageFileReaderPA3DSCISC = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< signed char > >;
using itkImageFileReaderPA3DSCISC_Pointer = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< signed char > >::Pointer;
using itkImageFileReaderPA3DSCISS = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< signed short > >;
using itkImageFileReaderPA3DSCISS_Pointer = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< signed short > >::Pointer;
using itkImageFileReaderPA3DSCIUC = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char > >;
using itkImageFileReaderPA3DSCIUC_Pointer = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char > >::Pointer;
using itkImageFileReaderPA3DSCIULL = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< unsigned long long > >;
using itkImageFileReaderPA3DSCIULL_Pointer = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< unsigned long long > >::Pointer;
using itkImageFileReaderPA3DSCIUS = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< unsigned short > >;
using itkImageFileReaderPA3DSCIUS_Pointer = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< unsigned short > >::Pointer;
using itkImageFileReaderPA3DSCIF = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< float > >;
using itkImageFileReaderPA3DSCIF_Pointer = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< float > >::Pointer;
using itkImageFileReaderPA3DSCID = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< double > >;
using itkImageFileReaderPA3DSCID_Pointer = itk::ImageFileReader< itk::PhasedArray3DSpecialCoordinatesImage< double > >::Pointer;


#include "ITKCommonBaseSwigInterface.h"
#include "itkImageFileReaderSwigInterface.h"
#include "itkSimpleDataObjectDecoratorSwigInterface.h"
#include "itkImageSourceSwigInterface.h"
#include "ITKIOImageBaseBaseSwigInterface.h"
#endif
