#ifndef itkNumericTraitsSwigInterface_h
#define itkNumericTraitsSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsRGBPixel.h"
#include "itkNumericTraitsRGBAPixel.h"
#include "itkNumericTraitsTensorPixel.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkNumericTraitsFixedArrayPixel.h"
#include "itkNumericTraitsVectorPixel.h"
#include "itkNumericTraitsCovariantVectorPixel.h"

using stdnumeric_limitsUC = std::numeric_limits< unsigned char >;
using stdnumeric_limitsUS = std::numeric_limits< unsigned short >;
using stdnumeric_limitsUI = std::numeric_limits< unsigned int >;
using stdnumeric_limitsUL = std::numeric_limits< unsigned long >;
using stdnumeric_limitsULL = std::numeric_limits< unsigned long long >;
using stdnumeric_limitsSC = std::numeric_limits< signed char >;
using stdnumeric_limitsSS = std::numeric_limits< signed short >;
using stdnumeric_limitsSI = std::numeric_limits< signed int >;
using stdnumeric_limitsSL = std::numeric_limits< signed long >;
using stdnumeric_limitsF = std::numeric_limits< float >;
using stdnumeric_limitsD = std::numeric_limits< double >;
using stdnumeric_limitsLD = std::numeric_limits< long double >;
using stdnumeric_limitsB = std::numeric_limits< bool >;
using itkNumericTraitsUC = itk::NumericTraits< unsigned char >;
using itkNumericTraitsUS = itk::NumericTraits< unsigned short >;
using itkNumericTraitsUI = itk::NumericTraits< unsigned int >;
using itkNumericTraitsUL = itk::NumericTraits< unsigned long >;
using itkNumericTraitsULL = itk::NumericTraits< unsigned long long >;
using itkNumericTraitsSC = itk::NumericTraits< signed char >;
using itkNumericTraitsSS = itk::NumericTraits< signed short >;
using itkNumericTraitsSI = itk::NumericTraits< signed int >;
using itkNumericTraitsSL = itk::NumericTraits< signed long >;
using itkNumericTraitsF = itk::NumericTraits< float >;
using itkNumericTraitsD = itk::NumericTraits< double >;
using itkNumericTraitsLD = itk::NumericTraits< long double >;
using itkNumericTraitsB = itk::NumericTraits< bool >;
using itkNumericTraitsCD = itk::NumericTraits< std::complex< double > >;
using itkNumericTraitsCF = itk::NumericTraits< std::complex< float > >;
using itkNumericTraitsRGBUC = itk::NumericTraits< itk::RGBPixel< unsigned char > >;
using itkNumericTraitsRGBUS = itk::NumericTraits< itk::RGBPixel< unsigned short > >;
using itkNumericTraitsRGBAUC = itk::NumericTraits< itk::RGBAPixel< unsigned char > >;
using itkNumericTraitsRGBAUS = itk::NumericTraits< itk::RGBAPixel< unsigned short > >;
using itkNumericTraitsCVD2 = itk::NumericTraits< itk::CovariantVector< double,2 > >;
using itkNumericTraitsCVF2 = itk::NumericTraits< itk::CovariantVector< float,2 > >;
using itkNumericTraitsCVD3 = itk::NumericTraits< itk::CovariantVector< double,3 > >;
using itkNumericTraitsCVF3 = itk::NumericTraits< itk::CovariantVector< float,3 > >;
using itkNumericTraitsCVD4 = itk::NumericTraits< itk::CovariantVector< double,4 > >;
using itkNumericTraitsCVF4 = itk::NumericTraits< itk::CovariantVector< float,4 > >;
using itkNumericTraitsVUC1 = itk::NumericTraits< itk::Vector< unsigned char,1 > >;
using itkNumericTraitsVF1 = itk::NumericTraits< itk::Vector< float,1 > >;
using itkNumericTraitsVD1 = itk::NumericTraits< itk::Vector< double,1 > >;
using itkNumericTraitsVSC1 = itk::NumericTraits< itk::Vector< signed char,1 > >;
using itkNumericTraitsVSS1 = itk::NumericTraits< itk::Vector< signed short,1 > >;
using itkNumericTraitsVULL1 = itk::NumericTraits< itk::Vector< unsigned long long,1 > >;
using itkNumericTraitsVUS1 = itk::NumericTraits< itk::Vector< unsigned short,1 > >;
using itkNumericTraitsVUC2 = itk::NumericTraits< itk::Vector< unsigned char,2 > >;
using itkNumericTraitsVF2 = itk::NumericTraits< itk::Vector< float,2 > >;
using itkNumericTraitsVD2 = itk::NumericTraits< itk::Vector< double,2 > >;
using itkNumericTraitsVSC2 = itk::NumericTraits< itk::Vector< signed char,2 > >;
using itkNumericTraitsVSS2 = itk::NumericTraits< itk::Vector< signed short,2 > >;
using itkNumericTraitsVULL2 = itk::NumericTraits< itk::Vector< unsigned long long,2 > >;
using itkNumericTraitsVUS2 = itk::NumericTraits< itk::Vector< unsigned short,2 > >;
using itkNumericTraitsVUC3 = itk::NumericTraits< itk::Vector< unsigned char,3 > >;
using itkNumericTraitsVF3 = itk::NumericTraits< itk::Vector< float,3 > >;
using itkNumericTraitsVD3 = itk::NumericTraits< itk::Vector< double,3 > >;
using itkNumericTraitsVSC3 = itk::NumericTraits< itk::Vector< signed char,3 > >;
using itkNumericTraitsVSS3 = itk::NumericTraits< itk::Vector< signed short,3 > >;
using itkNumericTraitsVULL3 = itk::NumericTraits< itk::Vector< unsigned long long,3 > >;
using itkNumericTraitsVUS3 = itk::NumericTraits< itk::Vector< unsigned short,3 > >;
using itkNumericTraitsVUC4 = itk::NumericTraits< itk::Vector< unsigned char,4 > >;
using itkNumericTraitsVF4 = itk::NumericTraits< itk::Vector< float,4 > >;
using itkNumericTraitsVD4 = itk::NumericTraits< itk::Vector< double,4 > >;
using itkNumericTraitsVSC4 = itk::NumericTraits< itk::Vector< signed char,4 > >;
using itkNumericTraitsVSS4 = itk::NumericTraits< itk::Vector< signed short,4 > >;
using itkNumericTraitsVULL4 = itk::NumericTraits< itk::Vector< unsigned long long,4 > >;
using itkNumericTraitsVUS4 = itk::NumericTraits< itk::Vector< unsigned short,4 > >;
using itkNumericTraitsVUC6 = itk::NumericTraits< itk::Vector< unsigned char,6 > >;
using itkNumericTraitsVF6 = itk::NumericTraits< itk::Vector< float,6 > >;
using itkNumericTraitsVD6 = itk::NumericTraits< itk::Vector< double,6 > >;
using itkNumericTraitsVSC6 = itk::NumericTraits< itk::Vector< signed char,6 > >;
using itkNumericTraitsVSS6 = itk::NumericTraits< itk::Vector< signed short,6 > >;
using itkNumericTraitsVULL6 = itk::NumericTraits< itk::Vector< unsigned long long,6 > >;
using itkNumericTraitsVUS6 = itk::NumericTraits< itk::Vector< unsigned short,6 > >;
using itkNumericTraitsFAD2 = itk::NumericTraits< itk::FixedArray< double,2 > >;
using itkNumericTraitsFAF2 = itk::NumericTraits< itk::FixedArray< float,2 > >;
using itkNumericTraitsFAUL2 = itk::NumericTraits< itk::FixedArray< unsigned long,2 > >;
using itkNumericTraitsFAUS2 = itk::NumericTraits< itk::FixedArray< unsigned short,2 > >;
using itkNumericTraitsFAUC2 = itk::NumericTraits< itk::FixedArray< unsigned char,2 > >;
using itkNumericTraitsFAUI2 = itk::NumericTraits< itk::FixedArray< unsigned int,2 > >;
using itkNumericTraitsFASL2 = itk::NumericTraits< itk::FixedArray< signed long,2 > >;
using itkNumericTraitsFASS2 = itk::NumericTraits< itk::FixedArray< signed short,2 > >;
using itkNumericTraitsFASC2 = itk::NumericTraits< itk::FixedArray< signed char,2 > >;
using itkNumericTraitsFAD3 = itk::NumericTraits< itk::FixedArray< double,3 > >;
using itkNumericTraitsFAF3 = itk::NumericTraits< itk::FixedArray< float,3 > >;
using itkNumericTraitsFAUL3 = itk::NumericTraits< itk::FixedArray< unsigned long,3 > >;
using itkNumericTraitsFAUS3 = itk::NumericTraits< itk::FixedArray< unsigned short,3 > >;
using itkNumericTraitsFAUC3 = itk::NumericTraits< itk::FixedArray< unsigned char,3 > >;
using itkNumericTraitsFAUI3 = itk::NumericTraits< itk::FixedArray< unsigned int,3 > >;
using itkNumericTraitsFASL3 = itk::NumericTraits< itk::FixedArray< signed long,3 > >;
using itkNumericTraitsFASS3 = itk::NumericTraits< itk::FixedArray< signed short,3 > >;
using itkNumericTraitsFASC3 = itk::NumericTraits< itk::FixedArray< signed char,3 > >;
using itkNumericTraitsFAD4 = itk::NumericTraits< itk::FixedArray< double,4 > >;
using itkNumericTraitsFAF4 = itk::NumericTraits< itk::FixedArray< float,4 > >;
using itkNumericTraitsFAUL4 = itk::NumericTraits< itk::FixedArray< unsigned long,4 > >;
using itkNumericTraitsFAUS4 = itk::NumericTraits< itk::FixedArray< unsigned short,4 > >;
using itkNumericTraitsFAUC4 = itk::NumericTraits< itk::FixedArray< unsigned char,4 > >;
using itkNumericTraitsFAUI4 = itk::NumericTraits< itk::FixedArray< unsigned int,4 > >;
using itkNumericTraitsFASL4 = itk::NumericTraits< itk::FixedArray< signed long,4 > >;
using itkNumericTraitsFASS4 = itk::NumericTraits< itk::FixedArray< signed short,4 > >;
using itkNumericTraitsFASC4 = itk::NumericTraits< itk::FixedArray< signed char,4 > >;
using itkNumericTraitsFAD6 = itk::NumericTraits< itk::FixedArray< double,6 > >;
using itkNumericTraitsFAF6 = itk::NumericTraits< itk::FixedArray< float,6 > >;
using itkNumericTraitsFAUL6 = itk::NumericTraits< itk::FixedArray< unsigned long,6 > >;
using itkNumericTraitsFAUS6 = itk::NumericTraits< itk::FixedArray< unsigned short,6 > >;
using itkNumericTraitsFAUC6 = itk::NumericTraits< itk::FixedArray< unsigned char,6 > >;
using itkNumericTraitsFAUI6 = itk::NumericTraits< itk::FixedArray< unsigned int,6 > >;
using itkNumericTraitsFASL6 = itk::NumericTraits< itk::FixedArray< signed long,6 > >;
using itkNumericTraitsFASS6 = itk::NumericTraits< itk::FixedArray< signed short,6 > >;
using itkNumericTraitsFASC6 = itk::NumericTraits< itk::FixedArray< signed char,6 > >;
using itkNumericTraitsFAD8 = itk::NumericTraits< itk::FixedArray< double,8 > >;
using itkNumericTraitsFAF8 = itk::NumericTraits< itk::FixedArray< float,8 > >;
using itkNumericTraitsFAUL8 = itk::NumericTraits< itk::FixedArray< unsigned long,8 > >;
using itkNumericTraitsFAUS8 = itk::NumericTraits< itk::FixedArray< unsigned short,8 > >;
using itkNumericTraitsFAUC8 = itk::NumericTraits< itk::FixedArray< unsigned char,8 > >;
using itkNumericTraitsFAUI8 = itk::NumericTraits< itk::FixedArray< unsigned int,8 > >;
using itkNumericTraitsFASL8 = itk::NumericTraits< itk::FixedArray< signed long,8 > >;
using itkNumericTraitsFASS8 = itk::NumericTraits< itk::FixedArray< signed short,8 > >;
using itkNumericTraitsFASC8 = itk::NumericTraits< itk::FixedArray< signed char,8 > >;
using itkNumericTraitsFAD10 = itk::NumericTraits< itk::FixedArray< double,10 > >;
using itkNumericTraitsFAF10 = itk::NumericTraits< itk::FixedArray< float,10 > >;
using itkNumericTraitsFAUL10 = itk::NumericTraits< itk::FixedArray< unsigned long,10 > >;
using itkNumericTraitsFAUS10 = itk::NumericTraits< itk::FixedArray< unsigned short,10 > >;
using itkNumericTraitsFAUC10 = itk::NumericTraits< itk::FixedArray< unsigned char,10 > >;
using itkNumericTraitsFAUI10 = itk::NumericTraits< itk::FixedArray< unsigned int,10 > >;
using itkNumericTraitsFASL10 = itk::NumericTraits< itk::FixedArray< signed long,10 > >;
using itkNumericTraitsFASS10 = itk::NumericTraits< itk::FixedArray< signed short,10 > >;
using itkNumericTraitsFASC10 = itk::NumericTraits< itk::FixedArray< signed char,10 > >;
using itkNumericTraitsFAD1 = itk::NumericTraits< itk::FixedArray< double,1 > >;
using itkNumericTraitsFAF1 = itk::NumericTraits< itk::FixedArray< float,1 > >;
using itkNumericTraitsFAUL1 = itk::NumericTraits< itk::FixedArray< unsigned long,1 > >;
using itkNumericTraitsFAUS1 = itk::NumericTraits< itk::FixedArray< unsigned short,1 > >;
using itkNumericTraitsFAUC1 = itk::NumericTraits< itk::FixedArray< unsigned char,1 > >;
using itkNumericTraitsFAUI1 = itk::NumericTraits< itk::FixedArray< unsigned int,1 > >;
using itkNumericTraitsFASL1 = itk::NumericTraits< itk::FixedArray< signed long,1 > >;
using itkNumericTraitsFASS1 = itk::NumericTraits< itk::FixedArray< signed short,1 > >;
using itkNumericTraitsFASC1 = itk::NumericTraits< itk::FixedArray< signed char,1 > >;
using itkNumericTraitsVLVSC = itk::NumericTraits< itk::VariableLengthVector< signed char > >;
using itkNumericTraitsVLVSS = itk::NumericTraits< itk::VariableLengthVector< signed short > >;
using itkNumericTraitsVLVUC = itk::NumericTraits< itk::VariableLengthVector< unsigned char > >;
using itkNumericTraitsVLVULL = itk::NumericTraits< itk::VariableLengthVector< unsigned long long > >;
using itkNumericTraitsVLVUS = itk::NumericTraits< itk::VariableLengthVector< unsigned short > >;
using itkNumericTraitsVLVF = itk::NumericTraits< itk::VariableLengthVector< float > >;
using itkNumericTraitsVLVD = itk::NumericTraits< itk::VariableLengthVector< double > >;


#include "itkVariableLengthVectorSwigInterface.h"
#include "stdcomplexSwigInterface.h"
#include "itkFixedArraySwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkNumericTraitsSwigInterface.h"
#include "itkRGBPixelSwigInterface.h"
#include "itkCovariantVectorSwigInterface.h"
#include "itkRGBAPixelSwigInterface.h"
#endif
