#ifndef itkScanlineFilterCommonSwigInterface_h
#define itkScanlineFilterCommonSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkScanlineFilterCommon.h"

using itkScanlineFilterCommonIF2IF2 = itk::ScanlineFilterCommon< itk::Image< float,2 >, itk::Image< float,2 > >;
using itkScanlineFilterCommonIF2IF2_Pointer = itk::ScanlineFilterCommon< itk::Image< float,2 >, itk::Image< float,2 > >::Pointer;
using itkScanlineFilterCommonIF3IF3 = itk::ScanlineFilterCommon< itk::Image< float,3 >, itk::Image< float,3 > >;
using itkScanlineFilterCommonIF3IF3_Pointer = itk::ScanlineFilterCommon< itk::Image< float,3 >, itk::Image< float,3 > >::Pointer;
using itkScanlineFilterCommonIF4IF4 = itk::ScanlineFilterCommon< itk::Image< float,4 >, itk::Image< float,4 > >;
using itkScanlineFilterCommonIF4IF4_Pointer = itk::ScanlineFilterCommon< itk::Image< float,4 >, itk::Image< float,4 > >::Pointer;
using itkScanlineFilterCommonID2ID2 = itk::ScanlineFilterCommon< itk::Image< double,2 >, itk::Image< double,2 > >;
using itkScanlineFilterCommonID2ID2_Pointer = itk::ScanlineFilterCommon< itk::Image< double,2 >, itk::Image< double,2 > >::Pointer;
using itkScanlineFilterCommonID3ID3 = itk::ScanlineFilterCommon< itk::Image< double,3 >, itk::Image< double,3 > >;
using itkScanlineFilterCommonID3ID3_Pointer = itk::ScanlineFilterCommon< itk::Image< double,3 >, itk::Image< double,3 > >::Pointer;
using itkScanlineFilterCommonID4ID4 = itk::ScanlineFilterCommon< itk::Image< double,4 >, itk::Image< double,4 > >;
using itkScanlineFilterCommonID4ID4_Pointer = itk::ScanlineFilterCommon< itk::Image< double,4 >, itk::Image< double,4 > >::Pointer;
using itkScanlineFilterCommonISC2IUL2 = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< unsigned long,2 > >;
using itkScanlineFilterCommonISC2IUL2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< unsigned long,2 > >::Pointer;
using itkScanlineFilterCommonISC3IUL3 = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< unsigned long,3 > >;
using itkScanlineFilterCommonISC3IUL3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< unsigned long,3 > >::Pointer;
using itkScanlineFilterCommonISC4IUL4 = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< unsigned long,4 > >;
using itkScanlineFilterCommonISC4IUL4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< unsigned long,4 > >::Pointer;
using itkScanlineFilterCommonISC2ISC2 = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonISC2ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonISC3ISC3 = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonISC3ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonISC4ISC4 = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonISC4ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonISC2ISS2 = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonISC2ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonISC3ISS3 = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonISC3ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonISC4ISS4 = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonISC4ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonISC2IUC2 = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonISC2IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonISC3IUC3 = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonISC3IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonISC4IUC4 = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonISC4IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonISC2IULL2 = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonISC2IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonISC3IULL3 = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonISC3IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonISC4IULL4 = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonISC4IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonISC2IUS2 = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonISC2IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonISC3IUS3 = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonISC3IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonISC4IUS4 = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonISC4IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed char,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonISS2IUL2 = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< unsigned long,2 > >;
using itkScanlineFilterCommonISS2IUL2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< unsigned long,2 > >::Pointer;
using itkScanlineFilterCommonISS3IUL3 = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< unsigned long,3 > >;
using itkScanlineFilterCommonISS3IUL3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< unsigned long,3 > >::Pointer;
using itkScanlineFilterCommonISS4IUL4 = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< unsigned long,4 > >;
using itkScanlineFilterCommonISS4IUL4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< unsigned long,4 > >::Pointer;
using itkScanlineFilterCommonISS2ISC2 = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonISS2ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonISS3ISC3 = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonISS3ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonISS4ISC4 = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonISS4ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonISS2ISS2 = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonISS2ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonISS3ISS3 = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonISS3ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonISS4ISS4 = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonISS4ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonISS2IUC2 = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonISS2IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonISS3IUC3 = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonISS3IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonISS4IUC4 = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonISS4IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonISS2IULL2 = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonISS2IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonISS3IULL3 = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonISS3IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonISS4IULL4 = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonISS4IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonISS2IUS2 = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonISS2IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonISS3IUS3 = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonISS3IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonISS4IUS4 = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonISS4IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< signed short,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIUC2IUL2 = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< unsigned long,2 > >;
using itkScanlineFilterCommonIUC2IUL2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< unsigned long,2 > >::Pointer;
using itkScanlineFilterCommonIUC3IUL3 = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< unsigned long,3 > >;
using itkScanlineFilterCommonIUC3IUL3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< unsigned long,3 > >::Pointer;
using itkScanlineFilterCommonIUC4IUL4 = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< unsigned long,4 > >;
using itkScanlineFilterCommonIUC4IUL4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< unsigned long,4 > >::Pointer;
using itkScanlineFilterCommonIUC2ISC2 = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIUC2ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIUC3ISC3 = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIUC3ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIUC4ISC4 = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIUC4ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIUC2ISS2 = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIUC2ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIUC3ISS3 = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIUC3ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIUC4ISS4 = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIUC4ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIUC2IUC2 = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIUC2IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIUC3IUC3 = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIUC3IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIUC4IUC4 = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIUC4IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIUC2IULL2 = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIUC2IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIUC3IULL3 = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIUC3IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIUC4IULL4 = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIUC4IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIUC2IUS2 = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIUC2IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIUC3IUS3 = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIUC3IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIUC4IUS4 = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIUC4IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned char,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIULL2IUL2 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< unsigned long,2 > >;
using itkScanlineFilterCommonIULL2IUL2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< unsigned long,2 > >::Pointer;
using itkScanlineFilterCommonIULL3IUL3 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< unsigned long,3 > >;
using itkScanlineFilterCommonIULL3IUL3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< unsigned long,3 > >::Pointer;
using itkScanlineFilterCommonIULL4IUL4 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< unsigned long,4 > >;
using itkScanlineFilterCommonIULL4IUL4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< unsigned long,4 > >::Pointer;
using itkScanlineFilterCommonIULL2ISC2 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIULL2ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIULL3ISC3 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIULL3ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIULL4ISC4 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIULL4ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIULL2ISS2 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIULL2ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIULL3ISS3 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIULL3ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIULL4ISS4 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIULL4ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIULL2IUC2 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIULL2IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIULL3IUC3 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIULL3IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIULL4IUC4 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIULL4IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIULL2IULL2 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIULL2IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIULL3IULL3 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIULL3IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIULL4IULL4 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIULL4IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIULL2IUS2 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIULL2IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIULL3IUS3 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIULL3IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIULL4IUS4 = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIULL4IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned long long,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIUS2IUL2 = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< unsigned long,2 > >;
using itkScanlineFilterCommonIUS2IUL2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< unsigned long,2 > >::Pointer;
using itkScanlineFilterCommonIUS3IUL3 = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< unsigned long,3 > >;
using itkScanlineFilterCommonIUS3IUL3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< unsigned long,3 > >::Pointer;
using itkScanlineFilterCommonIUS4IUL4 = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< unsigned long,4 > >;
using itkScanlineFilterCommonIUS4IUL4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< unsigned long,4 > >::Pointer;
using itkScanlineFilterCommonIUS2ISC2 = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIUS2ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIUS3ISC3 = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIUS3ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIUS4ISC4 = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIUS4ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIUS2ISS2 = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIUS2ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIUS3ISS3 = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIUS3ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIUS4ISS4 = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIUS4ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIUS2IUC2 = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIUS2IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIUS3IUC3 = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIUS3IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIUS4IUC4 = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIUS4IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIUS2IULL2 = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIUS2IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIUS3IULL3 = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIUS3IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIUS4IULL4 = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIUS4IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIUS2IUS2 = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIUS2IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIUS3IUS3 = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIUS3IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIUS4IUS4 = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIUS4IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< unsigned short,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIVD22ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIVD22ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIVD23ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIVD23ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIVD24ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIVD24ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIVD32ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIVD32ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIVD33ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIVD33ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIVD34ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIVD34ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIVD42ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIVD42ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIVD43ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIVD43ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIVD44ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIVD44ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIVD22ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIVD22ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIVD23ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIVD23ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIVD24ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIVD24ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIVD32ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIVD32ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIVD33ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIVD33ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIVD34ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIVD34ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIVD42ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIVD42ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIVD43ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIVD43ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIVD44ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIVD44ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIVD22IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIVD22IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIVD23IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIVD23IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIVD24IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIVD24IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIVD32IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIVD32IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIVD33IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIVD33IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIVD34IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIVD34IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIVD42IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIVD42IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIVD43IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIVD43IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIVD44IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIVD44IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIVD22IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIVD22IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIVD23IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIVD23IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIVD24IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIVD24IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIVD32IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIVD32IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIVD33IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIVD33IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIVD34IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIVD34IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIVD42IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIVD42IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIVD43IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIVD43IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIVD44IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIVD44IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIVD22IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIVD22IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIVD23IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIVD23IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIVD24IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIVD24IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIVD32IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIVD32IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIVD33IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIVD33IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIVD34IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIVD34IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIVD42IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIVD42IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIVD43IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIVD43IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIVD44IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIVD44IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIVF22ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIVF22ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIVF23ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIVF23ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIVF24ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIVF24ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIVF32ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIVF32ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIVF33ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIVF33ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIVF34ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIVF34ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIVF42ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonIVF42ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonIVF43ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonIVF43ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonIVF44ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonIVF44ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonIVF22ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIVF22ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIVF23ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIVF23ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIVF24ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIVF24ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIVF32ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIVF32ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIVF33ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIVF33ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIVF34ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIVF34ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIVF42ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonIVF42ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonIVF43ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonIVF43ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonIVF44ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonIVF44ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonIVF22IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIVF22IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIVF23IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIVF23IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIVF24IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIVF24IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIVF32IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIVF32IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIVF33IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIVF33IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIVF34IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIVF34IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIVF42IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonIVF42IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonIVF43IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonIVF43IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonIVF44IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonIVF44IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonIVF22IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIVF22IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIVF23IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIVF23IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIVF24IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIVF24IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIVF32IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIVF32IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIVF33IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIVF33IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIVF34IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIVF34IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIVF42IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonIVF42IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonIVF43IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonIVF43IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonIVF44IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonIVF44IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonIVF22IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIVF22IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIVF23IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIVF23IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIVF24IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIVF24IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIVF32IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIVF32IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIVF33IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIVF33IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIVF34IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIVF34IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonIVF42IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonIVF42IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonIVF43IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonIVF43IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonIVF44IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonIVF44IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonICVD22ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonICVD22ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonICVD23ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonICVD23ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonICVD24ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonICVD24ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonICVD32ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonICVD32ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonICVD33ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonICVD33ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonICVD34ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonICVD34ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonICVD42ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonICVD42ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonICVD43ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonICVD43ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonICVD44ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonICVD44ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonICVD22ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonICVD22ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonICVD23ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonICVD23ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonICVD24ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonICVD24ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonICVD32ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonICVD32ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonICVD33ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonICVD33ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonICVD34ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonICVD34ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonICVD42ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonICVD42ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonICVD43ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonICVD43ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonICVD44ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonICVD44ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonICVD22IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonICVD22IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonICVD23IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonICVD23IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonICVD24IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonICVD24IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonICVD32IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonICVD32IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonICVD33IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonICVD33IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonICVD34IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonICVD34IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonICVD42IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonICVD42IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonICVD43IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonICVD43IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonICVD44IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonICVD44IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonICVD22IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonICVD22IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonICVD23IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonICVD23IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonICVD24IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonICVD24IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonICVD32IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonICVD32IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonICVD33IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonICVD33IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonICVD34IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonICVD34IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonICVD42IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonICVD42IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonICVD43IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonICVD43IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonICVD44IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonICVD44IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonICVD22IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonICVD22IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonICVD23IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonICVD23IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonICVD24IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonICVD24IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonICVD32IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonICVD32IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonICVD33IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonICVD33IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonICVD34IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonICVD34IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonICVD42IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonICVD42IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonICVD43IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonICVD43IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonICVD44IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonICVD44IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonICVF22ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonICVF22ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonICVF23ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonICVF23ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonICVF24ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonICVF24ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonICVF32ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonICVF32ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonICVF33ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonICVF33ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonICVF34ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonICVF34ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonICVF42ISC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< signed char,2 > >;
using itkScanlineFilterCommonICVF42ISC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< signed char,2 > >::Pointer;
using itkScanlineFilterCommonICVF43ISC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< signed char,3 > >;
using itkScanlineFilterCommonICVF43ISC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< signed char,3 > >::Pointer;
using itkScanlineFilterCommonICVF44ISC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< signed char,4 > >;
using itkScanlineFilterCommonICVF44ISC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< signed char,4 > >::Pointer;
using itkScanlineFilterCommonICVF22ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonICVF22ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonICVF23ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonICVF23ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonICVF24ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonICVF24ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonICVF32ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonICVF32ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonICVF33ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonICVF33ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonICVF34ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonICVF34ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonICVF42ISS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< signed short,2 > >;
using itkScanlineFilterCommonICVF42ISS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< signed short,2 > >::Pointer;
using itkScanlineFilterCommonICVF43ISS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< signed short,3 > >;
using itkScanlineFilterCommonICVF43ISS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< signed short,3 > >::Pointer;
using itkScanlineFilterCommonICVF44ISS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< signed short,4 > >;
using itkScanlineFilterCommonICVF44ISS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< signed short,4 > >::Pointer;
using itkScanlineFilterCommonICVF22IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonICVF22IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonICVF23IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonICVF23IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonICVF24IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonICVF24IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonICVF32IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonICVF32IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonICVF33IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonICVF33IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonICVF34IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonICVF34IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonICVF42IUC2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< unsigned char,2 > >;
using itkScanlineFilterCommonICVF42IUC2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkScanlineFilterCommonICVF43IUC3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< unsigned char,3 > >;
using itkScanlineFilterCommonICVF43IUC3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkScanlineFilterCommonICVF44IUC4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< unsigned char,4 > >;
using itkScanlineFilterCommonICVF44IUC4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkScanlineFilterCommonICVF22IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonICVF22IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonICVF23IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonICVF23IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonICVF24IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonICVF24IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonICVF32IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonICVF32IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonICVF33IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonICVF33IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonICVF34IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonICVF34IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonICVF42IULL2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< unsigned long long,2 > >;
using itkScanlineFilterCommonICVF42IULL2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkScanlineFilterCommonICVF43IULL3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< unsigned long long,3 > >;
using itkScanlineFilterCommonICVF43IULL3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkScanlineFilterCommonICVF44IULL4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< unsigned long long,4 > >;
using itkScanlineFilterCommonICVF44IULL4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkScanlineFilterCommonICVF22IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonICVF22IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonICVF23IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonICVF23IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonICVF24IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonICVF24IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonICVF32IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonICVF32IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonICVF33IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonICVF33IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonICVF34IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonICVF34IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkScanlineFilterCommonICVF42IUS2 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< unsigned short,2 > >;
using itkScanlineFilterCommonICVF42IUS2_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkScanlineFilterCommonICVF43IUS3 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< unsigned short,3 > >;
using itkScanlineFilterCommonICVF43IUS3_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkScanlineFilterCommonICVF44IUS4 = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< unsigned short,4 > >;
using itkScanlineFilterCommonICVF44IUS4_Pointer = itk::ScanlineFilterCommon< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< unsigned short,4 > >::Pointer;


#include "itkScanlineFilterCommonSwigInterface.h"
#include "itkImageToImageFilterBSwigInterface.h"
#include "itkImageToImageFilterASwigInterface.h"
#include "itkImageRegionSwigInterface.h"
#include "itkIndexSwigInterface.h"
#endif
