#ifndef itkSpecialCoordinatesImageSwigInterface_h
#define itkSpecialCoordinatesImageSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkSpecialCoordinatesImage.h"

using itkSpecialCoordinatesImageSC2 = itk::SpecialCoordinatesImage< signed char, 2 >;
using itkSpecialCoordinatesImageSC2_Pointer = itk::SpecialCoordinatesImage< signed char, 2 >::Pointer;
using itkSpecialCoordinatesImageSS2 = itk::SpecialCoordinatesImage< signed short, 2 >;
using itkSpecialCoordinatesImageSS2_Pointer = itk::SpecialCoordinatesImage< signed short, 2 >::Pointer;
using itkSpecialCoordinatesImageUC2 = itk::SpecialCoordinatesImage< unsigned char, 2 >;
using itkSpecialCoordinatesImageUC2_Pointer = itk::SpecialCoordinatesImage< unsigned char, 2 >::Pointer;
using itkSpecialCoordinatesImageULL2 = itk::SpecialCoordinatesImage< unsigned long long, 2 >;
using itkSpecialCoordinatesImageULL2_Pointer = itk::SpecialCoordinatesImage< unsigned long long, 2 >::Pointer;
using itkSpecialCoordinatesImageUS2 = itk::SpecialCoordinatesImage< unsigned short, 2 >;
using itkSpecialCoordinatesImageUS2_Pointer = itk::SpecialCoordinatesImage< unsigned short, 2 >::Pointer;
using itkSpecialCoordinatesImageF2 = itk::SpecialCoordinatesImage< float, 2 >;
using itkSpecialCoordinatesImageF2_Pointer = itk::SpecialCoordinatesImage< float, 2 >::Pointer;
using itkSpecialCoordinatesImageD2 = itk::SpecialCoordinatesImage< double, 2 >;
using itkSpecialCoordinatesImageD2_Pointer = itk::SpecialCoordinatesImage< double, 2 >::Pointer;
using itkSpecialCoordinatesImageCD2 = itk::SpecialCoordinatesImage< std::complex< double >, 2 >;
using itkSpecialCoordinatesImageCD2_Pointer = itk::SpecialCoordinatesImage< std::complex< double >, 2 >::Pointer;
using itkSpecialCoordinatesImageCF2 = itk::SpecialCoordinatesImage< std::complex< float >, 2 >;
using itkSpecialCoordinatesImageCF2_Pointer = itk::SpecialCoordinatesImage< std::complex< float >, 2 >::Pointer;
using itkSpecialCoordinatesImageSC3 = itk::SpecialCoordinatesImage< signed char, 3 >;
using itkSpecialCoordinatesImageSC3_Pointer = itk::SpecialCoordinatesImage< signed char, 3 >::Pointer;
using itkSpecialCoordinatesImageSS3 = itk::SpecialCoordinatesImage< signed short, 3 >;
using itkSpecialCoordinatesImageSS3_Pointer = itk::SpecialCoordinatesImage< signed short, 3 >::Pointer;
using itkSpecialCoordinatesImageUC3 = itk::SpecialCoordinatesImage< unsigned char, 3 >;
using itkSpecialCoordinatesImageUC3_Pointer = itk::SpecialCoordinatesImage< unsigned char, 3 >::Pointer;
using itkSpecialCoordinatesImageULL3 = itk::SpecialCoordinatesImage< unsigned long long, 3 >;
using itkSpecialCoordinatesImageULL3_Pointer = itk::SpecialCoordinatesImage< unsigned long long, 3 >::Pointer;
using itkSpecialCoordinatesImageUS3 = itk::SpecialCoordinatesImage< unsigned short, 3 >;
using itkSpecialCoordinatesImageUS3_Pointer = itk::SpecialCoordinatesImage< unsigned short, 3 >::Pointer;
using itkSpecialCoordinatesImageF3 = itk::SpecialCoordinatesImage< float, 3 >;
using itkSpecialCoordinatesImageF3_Pointer = itk::SpecialCoordinatesImage< float, 3 >::Pointer;
using itkSpecialCoordinatesImageD3 = itk::SpecialCoordinatesImage< double, 3 >;
using itkSpecialCoordinatesImageD3_Pointer = itk::SpecialCoordinatesImage< double, 3 >::Pointer;
using itkSpecialCoordinatesImageCD3 = itk::SpecialCoordinatesImage< std::complex< double >, 3 >;
using itkSpecialCoordinatesImageCD3_Pointer = itk::SpecialCoordinatesImage< std::complex< double >, 3 >::Pointer;
using itkSpecialCoordinatesImageCF3 = itk::SpecialCoordinatesImage< std::complex< float >, 3 >;
using itkSpecialCoordinatesImageCF3_Pointer = itk::SpecialCoordinatesImage< std::complex< float >, 3 >::Pointer;
using itkSpecialCoordinatesImageSC4 = itk::SpecialCoordinatesImage< signed char, 4 >;
using itkSpecialCoordinatesImageSC4_Pointer = itk::SpecialCoordinatesImage< signed char, 4 >::Pointer;
using itkSpecialCoordinatesImageSS4 = itk::SpecialCoordinatesImage< signed short, 4 >;
using itkSpecialCoordinatesImageSS4_Pointer = itk::SpecialCoordinatesImage< signed short, 4 >::Pointer;
using itkSpecialCoordinatesImageUC4 = itk::SpecialCoordinatesImage< unsigned char, 4 >;
using itkSpecialCoordinatesImageUC4_Pointer = itk::SpecialCoordinatesImage< unsigned char, 4 >::Pointer;
using itkSpecialCoordinatesImageULL4 = itk::SpecialCoordinatesImage< unsigned long long, 4 >;
using itkSpecialCoordinatesImageULL4_Pointer = itk::SpecialCoordinatesImage< unsigned long long, 4 >::Pointer;
using itkSpecialCoordinatesImageUS4 = itk::SpecialCoordinatesImage< unsigned short, 4 >;
using itkSpecialCoordinatesImageUS4_Pointer = itk::SpecialCoordinatesImage< unsigned short, 4 >::Pointer;
using itkSpecialCoordinatesImageF4 = itk::SpecialCoordinatesImage< float, 4 >;
using itkSpecialCoordinatesImageF4_Pointer = itk::SpecialCoordinatesImage< float, 4 >::Pointer;
using itkSpecialCoordinatesImageD4 = itk::SpecialCoordinatesImage< double, 4 >;
using itkSpecialCoordinatesImageD4_Pointer = itk::SpecialCoordinatesImage< double, 4 >::Pointer;
using itkSpecialCoordinatesImageCD4 = itk::SpecialCoordinatesImage< std::complex< double >, 4 >;
using itkSpecialCoordinatesImageCD4_Pointer = itk::SpecialCoordinatesImage< std::complex< double >, 4 >::Pointer;
using itkSpecialCoordinatesImageCF4 = itk::SpecialCoordinatesImage< std::complex< float >, 4 >;
using itkSpecialCoordinatesImageCF4_Pointer = itk::SpecialCoordinatesImage< std::complex< float >, 4 >::Pointer;


#include "stdcomplexSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkSpecialCoordinatesImageSwigInterface.h"
#include "itkPointSwigInterface.h"
#include "itkIndexSwigInterface.h"
#endif
