#ifndef itkWindowedSincInterpolateImageFunctionSwigInterface_h
#define itkWindowedSincInterpolateImageFunctionSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkWindowedSincInterpolateImageFunction.h"
#include "itkPhasedArray3DSpecialCoordinatesImage.h"

using itkHammingWindowFunction2 = itk::Function::HammingWindowFunction< 2 >;
using itkHammingWindowFunction3 = itk::Function::HammingWindowFunction< 3 >;
using itkCosineWindowFunction2 = itk::Function::CosineWindowFunction< 2 >;
using itkCosineWindowFunction3 = itk::Function::CosineWindowFunction< 3 >;
using itkWelchWindowFunction2 = itk::Function::WelchWindowFunction< 2 >;
using itkWelchWindowFunction3 = itk::Function::WelchWindowFunction< 3 >;
using itkLanczosWindowFunction2 = itk::Function::LanczosWindowFunction< 2 >;
using itkLanczosWindowFunction3 = itk::Function::LanczosWindowFunction< 3 >;
using itkWindowedSincInterpolateImageFunctionISC22Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC22Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC22Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC22Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC22Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC22Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC22Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC22Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC23Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC23Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC23Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC23Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC23Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC23Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC23Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC23Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS22Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS22Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS22Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS22Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS22Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS22Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS22Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS22Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS23Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS23Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS23Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS23Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS23Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS23Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS23Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS23Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC22Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC22Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC22Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC22Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC22Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC22Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC22Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC22Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC23Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC23Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC23Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC23Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC23Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC23Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC23Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC23Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL22Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL22Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL22Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL22Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL22Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL22Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL22Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL22Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL23Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL23Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL23Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL23Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL23Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL23Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL23Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL23Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS22Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS22Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS22Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS22Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS22Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS22Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS22Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS22Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS23Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS23Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS23Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS23Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS23Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS23Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS23Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS23Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF22Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF22Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF22Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF22Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF22Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF22Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF22Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF22Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF23Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF23Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF23Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF23Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF23Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF23Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF23Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF23Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID22Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID22Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID22Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID22Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID22Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID22Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID22Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID22Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID23Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID23Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID23Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID23Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID23Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID23Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID23Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID23Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,2 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC32Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC32Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC32Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC32Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC32Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC32Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC32Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC32Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC33Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC33Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC33Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC33Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC33Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC33Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC33Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC33Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS32Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS32Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS32Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS32Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS32Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS32Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS32Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS32Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS33Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS33Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS33Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS33Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS33Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS33Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS33Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS33Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC32Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC32Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC32Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC32Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC32Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC32Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC32Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC32Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC33Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC33Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC33Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC33Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC33Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC33Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC33Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC33Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL32Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL32Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL32Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL32Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL32Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL32Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL32Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL32Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL33Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL33Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL33Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL33Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL33Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL33Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL33Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL33Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS32Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS32Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS32Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS32Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS32Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS32Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS32Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS32Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS33Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS33Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS33Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS33Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS33Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS33Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS33Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS33Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF32Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF32Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF32Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF32Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF32Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF32Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF32Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF32Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF33Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF33Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF33Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF33Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF33Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF33Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF33Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF33Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID32Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID32Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID32Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID32Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID32Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID32Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID32Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID32Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID33Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID33Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID33Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID33Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID33Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID33Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID33Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID33Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,3 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC42Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC42Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC42Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC42Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC42Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC42Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC42Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISC42Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC43Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC43Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC43Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC43Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC43Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC43Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISC43Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISC43Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed char,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS42Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS42Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS42Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS42Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS42Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS42Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS42Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionISS42Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS43Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS43Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS43Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS43Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS43Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS43Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionISS43Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionISS43Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< signed short,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC42Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC42Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC42Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC42Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC42Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC42Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC42Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUC42Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC43Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC43Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC43Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC43Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC43Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC43Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUC43Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUC43Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned char,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL42Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL42Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL42Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL42Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL42Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL42Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL42Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIULL42Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL43Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL43Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL43Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL43Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL43Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL43Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIULL43Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIULL43Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned long long,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS42Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS42Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS42Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS42Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS42Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS42Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS42Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIUS42Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS43Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS43Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS43Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS43Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS43Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS43Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIUS43Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIUS43Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< unsigned short,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF42Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF42Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF42Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF42Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF42Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF42Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF42Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionIF42Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF43Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF43Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF43Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF43Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF43Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF43Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionIF43Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionIF43Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< float,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID42Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID42Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID42Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID42Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID42Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID42Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID42Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionID42Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID43Hamming = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID43Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID43Cosine = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID43Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID43Welch = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID43Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionID43Lanczos = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionID43Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::Image< double,4 >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF2Hamming = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF2Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF2Cosine = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF2Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF2Welch = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF2Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF2Lanczos = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF2Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF3Hamming = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF3Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF3Cosine = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF3Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF3Welch = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF3Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF3Lanczos = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIF3Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC2Hamming = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 2, itk::Function::HammingWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC2Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 2, itk::Function::HammingWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC2Cosine = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 2, itk::Function::CosineWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC2Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 2, itk::Function::CosineWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC2Welch = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 2, itk::Function::WelchWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC2Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 2, itk::Function::WelchWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC2Lanczos = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 2, itk::Function::LanczosWindowFunction< 2 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC2Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 2, itk::Function::LanczosWindowFunction< 2 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC3Hamming = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 3, itk::Function::HammingWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC3Hamming_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 3, itk::Function::HammingWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC3Cosine = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 3, itk::Function::CosineWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC3Cosine_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 3, itk::Function::CosineWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC3Welch = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 3, itk::Function::WelchWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC3Welch_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 3, itk::Function::WelchWindowFunction< 3 > >::Pointer;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC3Lanczos = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 3, itk::Function::LanczosWindowFunction< 3 > >;
using itkWindowedSincInterpolateImageFunctionPA3DSCIUC3Lanczos_Pointer = itk::WindowedSincInterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, 3, itk::Function::LanczosWindowFunction< 3 > >::Pointer;


#include "itkPhasedArray3DSpecialCoordinatesImageSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkWindowedSincInterpolateImageFunctionSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkInterpolateImageFunctionSwigInterface.h"
#include "itkSizeSwigInterface.h"
#include "itkContinuousIndexSwigInterface.h"
#endif
