/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// PodGroupApplyConfiguration represents a declarative configuration of the PodGroup type for use
// with apply.
//
// PodGroup represents a set of pods with a common scheduling policy.
type PodGroupApplyConfiguration struct {
	// Name is a unique identifier for the PodGroup within the Workload.
	// It must be a DNS label. This field is immutable.
	Name *string `json:"name,omitempty"`
	// Policy defines the scheduling policy for this PodGroup.
	Policy *PodGroupPolicyApplyConfiguration `json:"policy,omitempty"`
}

// PodGroupApplyConfiguration constructs a declarative configuration of the PodGroup type for use with
// apply.
func PodGroup() *PodGroupApplyConfiguration {
	return &PodGroupApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *PodGroupApplyConfiguration) WithName(value string) *PodGroupApplyConfiguration {
	b.Name = &value
	return b
}

// WithPolicy sets the Policy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Policy field is set to the value of the last call.
func (b *PodGroupApplyConfiguration) WithPolicy(value *PodGroupPolicyApplyConfiguration) *PodGroupApplyConfiguration {
	b.Policy = value
	return b
}
