// python wrapper for vtkInitializationHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkInitializationHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkInitializationHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkInitializationHelper_ClassNew(); }


static PyObject *
PyvtkInitializationHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkInitializationHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInitializationHelper *op = static_cast<vtkInitializationHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkInitializationHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkInitializationHelper *tempr = vtkInitializationHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInitializationHelper *op = static_cast<vtkInitializationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkInitializationHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkInitializationHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkInitializationHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInitializationHelper *op = static_cast<vtkInitializationHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkInitializationHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_Initialize_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Initialize");

  vtkStringList *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkStringList") &&
      ap.GetValue(temp1))
  {
    bool tempr = vtkInitializationHelper::Initialize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkInitializationHelper_Initialize_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Initialize");

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = vtkInitializationHelper::Initialize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkInitializationHelper_Initialize_Methods[] = {
  {"Initialize", PyvtkInitializationHelper_Initialize_s1, METH_VARARGS | METH_STATIC,
   "Vi *vtkStringList"},
  {"Initialize", PyvtkInitializationHelper_Initialize_s2, METH_VARARGS | METH_STATIC,
   "zi"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkInitializationHelper_Initialize(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkInitializationHelper_Initialize_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Initialize");
  return nullptr;
}


static PyObject *
PyvtkInitializationHelper_InitializeSettings(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "InitializeSettings");

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = vtkInitializationHelper::InitializeSettings(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_InitializeOthers(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "InitializeOthers");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkInitializationHelper::InitializeOthers();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_InitializeMiscellaneous(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod InitializeMiscellaneous."
    " (" "Use InitializeSettings and InitializeOthers instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "InitializeMiscellaneous");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = vtkInitializationHelper::InitializeMiscellaneous(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_InitializePythonVirtualEnvironment(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "InitializePythonVirtualEnvironment");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInitializationHelper::InitializePythonVirtualEnvironment();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_Finalize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Finalize");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInitializationHelper::Finalize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_GetExitCode(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetExitCode");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    int tempr = vtkInitializationHelper::GetExitCode();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_StandaloneInitialize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "StandaloneInitialize");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInitializationHelper::StandaloneInitialize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_StandaloneFinalize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "StandaloneFinalize");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInitializationHelper::StandaloneFinalize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_SetLoadSettingsFilesDuringInitialization(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetLoadSettingsFilesDuringInitialization");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkInitializationHelper::SetLoadSettingsFilesDuringInitialization(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_GetLoadSettingsFilesDuringInitialization(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetLoadSettingsFilesDuringInitialization");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkInitializationHelper::GetLoadSettingsFilesDuringInitialization();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_SetOrganizationName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetOrganizationName");

  std::string temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkInitializationHelper::SetOrganizationName(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_GetOrganizationName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetOrganizationName");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    const std::string *tempr = &vtkInitializationHelper::GetOrganizationName();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_SetApplicationName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetApplicationName");

  std::string temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkInitializationHelper::SetApplicationName(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_GetApplicationName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetApplicationName");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    const std::string *tempr = &vtkInitializationHelper::GetApplicationName();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_GetUserSettingsDirectory(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod GetUserSettingsDirectory."
    " (" "Use vtkPVStandardPaths::GetUserSettingsDirectory instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "GetUserSettingsDirectory");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    std::string tempr = vtkInitializationHelper::GetUserSettingsDirectory();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInitializationHelper_GetUserSettingsFilePath(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod GetUserSettingsFilePath."
    " (" "Use vtkPVStandardPaths::GetUserSettingsFilePath instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(args, "GetUserSettingsFilePath");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    std::string tempr = vtkInitializationHelper::GetUserSettingsFilePath();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkInitializationHelper_Methods[] = {
  {"IsTypeOf", PyvtkInitializationHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkInitializationHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkInitializationHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkInitializationHelper\nC++: static vtkInitializationHelper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkInitializationHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkInitializationHelper\nC++: vtkInitializationHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkInitializationHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkInitializationHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkInitializationHelper_Initialize, METH_VARARGS,
   "Initialize(argv:vtkStringList, processType:int) -> bool\nC++: static bool Initialize(vtkStringList *argv, int processType)\nInitialize(executable:str, type:int) -> bool\nC++: static bool Initialize(const char *executable, int type)\n\nOverload primary intended for Python wrapping.\n"},
  {"InitializeSettings", PyvtkInitializationHelper_InitializeSettings, METH_VARARGS,
   "InitializeSettings(type:int, defaultCoreConfig:bool) -> bool\nC++: static bool InitializeSettings(int type,\n    bool defaultCoreConfig)\n\nInitialize the setting by reading the settings file, unless\ncoreConfig DisableRegistry is set to true. Assume that\nInitializeProcessModule has been called.\n\nIf defaultCoreConfig is set to true, this will use the setting to\nset default values on the vtkRemotingCoreConfiguration\n\nThis method always returns `true`.\n\nThis method is used by Initialize but can be used when separating\noptions initialization from the rest of the initialization.\n"},
  {"InitializeOthers", PyvtkInitializationHelper_InitializeOthers, METH_VARARGS,
   "InitializeOthers() -> bool\nC++: static bool InitializeOthers()\n\nInitialize everything that is not initialized by specific\nmethods, see Initialize method for more info.\n\nAssume that InitializeProcessModule has been called. Returns\n`true` on success, `false` otherwise.\n\nThis method is used by Initialize but can be used when separating\noptions initialization from the rest of the initialization.\n"},
  {"InitializeMiscellaneous", PyvtkInitializationHelper_InitializeMiscellaneous, METH_VARARGS,
   "InitializeMiscellaneous(type:int) -> bool\nC++: static bool InitializeMiscellaneous(int type)\n\nInitialize everything that needs to be initialized in the\nparaview engine after the options. Returns `true` on success,\n`false` otherwise.\n"},
  {"InitializePythonVirtualEnvironment", PyvtkInitializationHelper_InitializePythonVirtualEnvironment, METH_VARARGS,
   "InitializePythonVirtualEnvironment() -> None\nC++: static void InitializePythonVirtualEnvironment()\n\nInitialize Python virtual environment from --venv command-line\nargument if any was provided.\n\nMake sure that the vtkPythonInterpreter has been initialized\nbefore calling this function.\n"},
  {"Finalize", PyvtkInitializationHelper_Finalize, METH_VARARGS,
   "Finalize() -> None\nC++: static void Finalize()\n\nFinalizes the server manager. Do not use the server manager after\ncalling this.\n"},
  {"GetExitCode", PyvtkInitializationHelper_GetExitCode, METH_VARARGS,
   "GetExitCode() -> int\nC++: static int GetExitCode()\n\nReturns the exit code after `Initialize`.\n"},
  {"StandaloneInitialize", PyvtkInitializationHelper_StandaloneInitialize, METH_VARARGS,
   "StandaloneInitialize() -> None\nC++: static void StandaloneInitialize()\n\nInitialization for standalone executables linking against a PV\nlibrary. This is needed to insure that linker does not remove\nobject factories' auto init during static linking. It also cleans\nup after protobuf.\n"},
  {"StandaloneFinalize", PyvtkInitializationHelper_StandaloneFinalize, METH_VARARGS,
   "StandaloneFinalize() -> None\nC++: static void StandaloneFinalize()\n\n"},
  {"SetLoadSettingsFilesDuringInitialization", PyvtkInitializationHelper_SetLoadSettingsFilesDuringInitialization, METH_VARARGS,
   "SetLoadSettingsFilesDuringInitialization(__a:bool) -> None\nC++: static void SetLoadSettingsFilesDuringInitialization(bool)\n\nDuring initialization, vtkInitializationHelper reads \"settings\"\nfiles for configuring vtkSMSettings. To disable this processing\nof the settings file for an application (e.g. in Catalyst), turn\nthis off. On by default.\n"},
  {"GetLoadSettingsFilesDuringInitialization", PyvtkInitializationHelper_GetLoadSettingsFilesDuringInitialization, METH_VARARGS,
   "GetLoadSettingsFilesDuringInitialization() -> bool\nC++: static bool GetLoadSettingsFilesDuringInitialization()\n\n"},
  {"SetOrganizationName", PyvtkInitializationHelper_SetOrganizationName, METH_VARARGS,
   "SetOrganizationName(organizationName:str) -> None\nC++: static void SetOrganizationName(\n    const std::string &organizationName)\n\nSets the organization producing this application. This is\n\"ParaView\" by default, but can be different for branded\napplications.\n"},
  {"GetOrganizationName", PyvtkInitializationHelper_GetOrganizationName, METH_VARARGS,
   "GetOrganizationName() -> str\nC++: static const std::string &GetOrganizationName()\n\n"},
  {"SetApplicationName", PyvtkInitializationHelper_SetApplicationName, METH_VARARGS,
   "SetApplicationName(appName:str) -> None\nC++: static void SetApplicationName(const std::string &appName)\n\nSets the name of the application. This is \"ParaView\" by default,\nbut can be different for branded applications.\n"},
  {"GetApplicationName", PyvtkInitializationHelper_GetApplicationName, METH_VARARGS,
   "GetApplicationName() -> str\nC++: static const std::string &GetApplicationName()\n\n"},
  {"GetUserSettingsDirectory", PyvtkInitializationHelper_GetUserSettingsDirectory, METH_VARARGS,
   "GetUserSettingsDirectory() -> str\nC++: static std::string GetUserSettingsDirectory()\n\nGet directory for user settings file. The last character is\nalways the file path separator appropriate for the system.\n"},
  {"GetUserSettingsFilePath", PyvtkInitializationHelper_GetUserSettingsFilePath, METH_VARARGS,
   "GetUserSettingsFilePath() -> str\nC++: static std::string GetUserSettingsFilePath()\n\nGet file path for the user settings file.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkInitializationHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("load_settings_files_during_initialization"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInitializationHelper_GetLoadSettingsFilesDuringInitialization(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkInitializationHelper_SetLoadSettingsFilesDuringInitialization(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkInitializationHelper_SetLoadSettingsFilesDuringInitialization(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLoadSettingsFilesDuringInitialization/SetLoadSettingsFilesDuringInitialization\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("organization_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInitializationHelper_GetOrganizationName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkInitializationHelper_SetOrganizationName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkInitializationHelper_SetOrganizationName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOrganizationName/SetOrganizationName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("application_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInitializationHelper_GetApplicationName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkInitializationHelper_SetApplicationName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkInitializationHelper_SetApplicationName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetApplicationName/SetApplicationName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exit_code"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInitializationHelper_GetExitCode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetExitCode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user_settings_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInitializationHelper_GetUserSettingsDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUserSettingsDirectory\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user_settings_file_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInitializationHelper_GetUserSettingsFilePath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUserSettingsFilePath\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkInitializationHelper_Doc =
  "vtkInitializationHelper - Helpers class to initialize ParaView\nClients.\n\n"
  "Superclass: vtkObject\n\n"
  "It initializes the server manager so that it can be used.\n\n"
  "This class is in fact a collection of static methods to initialize\n"
  "different part of the application: parse command line argument, load\n"
  "settings, initialize a vtkProcessModule.\n\n"
  "A main `Initialize` method calls subsequent methods in the\n"
  "appropriate order for ParaView.\n\n"
  "Also cleanup is available through `Finalize`.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkInitializationHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingApplication.vtkInitializationHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkInitializationHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkInitializationHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkInitializationHelper_Type, PyvtkInitializationHelper_Methods,
    "vtkInitializationHelper",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkInitializationHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkInitializationHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkInitializationHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkInitializationHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

