/* autogenerated by pidl */
#include "includes.h"
#include "bin/default/source4/lib/registry/tdr_regf.h"




static NTSTATUS tdr_pull_regf_version (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct regf_version *v)
{
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->major));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->minor));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->release));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->build));
	return NT_STATUS_OK;
}

static NTSTATUS tdr_push_regf_version (struct tdr_push *tdr, struct regf_version *v)
{
	v->major = 1;
	TDR_CHECK(tdr_push_uint32(tdr, &v->major));
	TDR_CHECK(tdr_push_uint32(tdr, &v->minor));
	TDR_CHECK(tdr_push_uint32(tdr, &v->release));
	v->build = 1;
	TDR_CHECK(tdr_push_uint32(tdr, &v->build));
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_regf_hdr (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct regf_hdr *v)
{
	int i;
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->REGF_ID, 4, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->update_counter1));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->update_counter2));
	TDR_CHECK(tdr_pull_NTTIME(tdr, mem_ctx, &v->modtime));
	TDR_CHECK(tdr_pull_regf_version(tdr, mem_ctx, &v->version));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->data_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->last_block));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->uk7));
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->description, 0x20, sizeof(uint16_t), CH_UTF16));
	for (i = 0; i < 99; i++) {
		TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->padding[i]));
	}
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->chksum));
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_regf_hdr (struct tdr_push *tdr, struct regf_hdr *v)
{
	int i;
	TDR_CHECK(tdr_push_charset(tdr, &v->REGF_ID, 4, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_push_uint32(tdr, &v->update_counter1));
	TDR_CHECK(tdr_push_uint32(tdr, &v->update_counter2));
	TDR_CHECK(tdr_push_NTTIME(tdr, &v->modtime));
	TDR_CHECK(tdr_push_regf_version(tdr, &v->version));
	TDR_CHECK(tdr_push_uint32(tdr, &v->data_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->last_block));
	v->uk7 = 1;
	TDR_CHECK(tdr_push_uint32(tdr, &v->uk7));
	TDR_CHECK(tdr_push_charset(tdr, &v->description, 0x20, sizeof(uint16_t), CH_UTF16));
	for (i = 0; i < 99; i++) {
		TDR_CHECK(tdr_push_uint32(tdr, &v->padding[i]));
	}
	TDR_CHECK(tdr_push_uint32(tdr, &v->chksum));
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_hbin_block (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct hbin_block *v)
{
	int i;
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->HBIN_ID, 4, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->offset_from_first));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->offset_to_next));
	for (i = 0; i < 2; i++) {
		TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->unknown[i]));
	}
	TDR_CHECK(tdr_pull_NTTIME(tdr, mem_ctx, &v->last_change));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->block_size));
	TDR_ALLOC(mem_ctx, v->data, v->offset_to_next - 0x20);
	for (i = 0; i < v->offset_to_next - 0x20; i++) {
		TDR_CHECK(tdr_pull_uint8(tdr, v->data, &v->data[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_hbin_block (struct tdr_push *tdr, struct hbin_block *v)
{
	int i;
	TDR_CHECK(tdr_push_charset(tdr, &v->HBIN_ID, 4, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_push_uint32(tdr, &v->offset_from_first));
	TDR_CHECK(tdr_push_uint32(tdr, &v->offset_to_next));
	for (i = 0; i < 2; i++) {
		TDR_CHECK(tdr_push_uint32(tdr, &v->unknown[i]));
	}
	TDR_CHECK(tdr_push_NTTIME(tdr, &v->last_change));
	TDR_CHECK(tdr_push_uint32(tdr, &v->block_size));
	for (i = 0; i < v->offset_to_next - 0x20; i++) {
		TDR_CHECK(tdr_push_uint8(tdr, &v->data[i]));
	}
	return NT_STATUS_OK;
}

static NTSTATUS tdr_pull_reg_key_type (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, enum reg_key_type *v)
{
	uint16_t r;
	TDR_CHECK(tdr_pull_uint1632(tdr, mem_ctx, &r));
	*v = r;
	return NT_STATUS_OK;
}

static NTSTATUS tdr_push_reg_key_type (struct tdr_push *tdr, enum reg_key_type *v)
{
	TDR_CHECK(tdr_push_uint1632(tdr, (uint16_t *)v));
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_nk_block (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct nk_block *v)
{
	int i;
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_reg_key_type(tdr, mem_ctx, &v->type));
	TDR_CHECK(tdr_pull_NTTIME(tdr, mem_ctx, &v->last_change));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->uk1));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->parent_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->num_subkeys));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->uk2));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->subkeys_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->unknown_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->num_values));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->values_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->sk_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->clsname_offset));
	for (i = 0; i < 5; i++) {
		TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->unk3[i]));
	}
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->name_length));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->clsname_length));
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->key_name, v->name_length, sizeof(uint8_t), CH_DOS));
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_nk_block (struct tdr_push *tdr, struct nk_block *v)
{
	int i;
	TDR_CHECK(tdr_push_charset(tdr, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_push_reg_key_type(tdr, &v->type));
	TDR_CHECK(tdr_push_NTTIME(tdr, &v->last_change));
	TDR_CHECK(tdr_push_uint32(tdr, &v->uk1));
	TDR_CHECK(tdr_push_uint32(tdr, &v->parent_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->num_subkeys));
	TDR_CHECK(tdr_push_uint32(tdr, &v->uk2));
	TDR_CHECK(tdr_push_uint32(tdr, &v->subkeys_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->unknown_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->num_values));
	TDR_CHECK(tdr_push_uint32(tdr, &v->values_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->sk_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->clsname_offset));
	for (i = 0; i < 5; i++) {
		TDR_CHECK(tdr_push_uint32(tdr, &v->unk3[i]));
	}
	v->name_length = strlen(v->key_name);
	TDR_CHECK(tdr_push_uint16(tdr, &v->name_length));
	TDR_CHECK(tdr_push_uint16(tdr, &v->clsname_length));
	TDR_CHECK(tdr_push_charset(tdr, &v->key_name, v->name_length, sizeof(uint8_t), CH_DOS));
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_sk_block (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct sk_block *v)
{
	int i;
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->tag));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->prev_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->next_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->ref_cnt));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->rec_size));
	TDR_ALLOC(mem_ctx, v->sec_desc, v->rec_size);
	for (i = 0; i < v->rec_size; i++) {
		TDR_CHECK(tdr_pull_uint8(tdr, v->sec_desc, &v->sec_desc[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_sk_block (struct tdr_push *tdr, struct sk_block *v)
{
	int i;
	TDR_CHECK(tdr_push_charset(tdr, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_push_uint16(tdr, &v->tag));
	TDR_CHECK(tdr_push_uint32(tdr, &v->prev_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->next_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->ref_cnt));
	TDR_CHECK(tdr_push_uint32(tdr, &v->rec_size));
	for (i = 0; i < v->rec_size; i++) {
		TDR_CHECK(tdr_push_uint8(tdr, &v->sec_desc[i]));
	}
	return NT_STATUS_OK;
}

static NTSTATUS tdr_pull_lh_hash (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct lh_hash *v)
{
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->nk_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->base37));
	return NT_STATUS_OK;
}

static NTSTATUS tdr_push_lh_hash (struct tdr_push *tdr, struct lh_hash *v)
{
	TDR_CHECK(tdr_push_uint32(tdr, &v->nk_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->base37));
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_lh_block (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct lh_block *v)
{
	int i;
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->key_count));
	TDR_ALLOC(mem_ctx, v->hr, v->key_count);
	for (i = 0; i < v->key_count; i++) {
		TDR_CHECK(tdr_pull_lh_hash(tdr, v->hr, &v->hr[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_lh_block (struct tdr_push *tdr, struct lh_block *v)
{
	int i;
	TDR_CHECK(tdr_push_charset(tdr, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_push_uint16(tdr, &v->key_count));
	for (i = 0; i < v->key_count; i++) {
		TDR_CHECK(tdr_push_lh_hash(tdr, &v->hr[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_li_block (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct li_block *v)
{
	int i;
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->key_count));
	TDR_ALLOC(mem_ctx, v->nk_offset, v->key_count);
	for (i = 0; i < v->key_count; i++) {
		TDR_CHECK(tdr_pull_uint32(tdr, v->nk_offset, &v->nk_offset[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_li_block (struct tdr_push *tdr, struct li_block *v)
{
	int i;
	TDR_CHECK(tdr_push_charset(tdr, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_push_uint16(tdr, &v->key_count));
	for (i = 0; i < v->key_count; i++) {
		TDR_CHECK(tdr_push_uint32(tdr, &v->nk_offset[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_ri_block (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct ri_block *v)
{
	int i;
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->key_count));
	TDR_ALLOC(mem_ctx, v->offset, v->key_count);
	for (i = 0; i < v->key_count; i++) {
		TDR_CHECK(tdr_pull_uint32(tdr, v->offset, &v->offset[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_ri_block (struct tdr_push *tdr, struct ri_block *v)
{
	int i;
	TDR_CHECK(tdr_push_charset(tdr, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_push_uint16(tdr, &v->key_count));
	for (i = 0; i < v->key_count; i++) {
		TDR_CHECK(tdr_push_uint32(tdr, &v->offset[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_vk_block (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct vk_block *v)
{
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->name_length));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->data_length));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->data_offset));
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->data_type));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->flag));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->unk1));
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->data_name, v->name_length, sizeof(uint8_t), CH_DOS));
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_vk_block (struct tdr_push *tdr, struct vk_block *v)
{
	TDR_CHECK(tdr_push_charset(tdr, &v->header, 2, sizeof(uint8_t), CH_DOS));
	v->name_length = strlen(v->data_name);
	TDR_CHECK(tdr_push_uint16(tdr, &v->name_length));
	TDR_CHECK(tdr_push_uint32(tdr, &v->data_length));
	TDR_CHECK(tdr_push_uint32(tdr, &v->data_offset));
	TDR_CHECK(tdr_push_uint32(tdr, &v->data_type));
	TDR_CHECK(tdr_push_uint16(tdr, &v->flag));
	TDR_CHECK(tdr_push_uint16(tdr, &v->unk1));
	TDR_CHECK(tdr_push_charset(tdr, &v->data_name, v->name_length, sizeof(uint8_t), CH_DOS));
	return NT_STATUS_OK;
}

static NTSTATUS tdr_pull_hash_record (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct hash_record *v)
{
	TDR_CHECK(tdr_pull_uint32(tdr, mem_ctx, &v->nk_offset));
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->hash, 4, sizeof(uint8_t), CH_DOS));
	return NT_STATUS_OK;
}

static NTSTATUS tdr_push_hash_record (struct tdr_push *tdr, struct hash_record *v)
{
	TDR_CHECK(tdr_push_uint32(tdr, &v->nk_offset));
	TDR_CHECK(tdr_push_charset(tdr, &v->hash, 4, sizeof(uint8_t), CH_DOS));
	return NT_STATUS_OK;
}

NTSTATUS tdr_pull_lf_block (struct tdr_pull *tdr, TALLOC_CTX *mem_ctx, struct lf_block *v)
{
	int i;
	TDR_CHECK(tdr_pull_charset(tdr, mem_ctx, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_pull_uint16(tdr, mem_ctx, &v->key_count));
	TDR_ALLOC(mem_ctx, v->hr, v->key_count);
	for (i = 0; i < v->key_count; i++) {
		TDR_CHECK(tdr_pull_hash_record(tdr, v->hr, &v->hr[i]));
	}
	return NT_STATUS_OK;
}

NTSTATUS tdr_push_lf_block (struct tdr_push *tdr, struct lf_block *v)
{
	int i;
	TDR_CHECK(tdr_push_charset(tdr, &v->header, 2, sizeof(uint8_t), CH_DOS));
	TDR_CHECK(tdr_push_uint16(tdr, &v->key_count));
	for (i = 0; i < v->key_count; i++) {
		TDR_CHECK(tdr_push_hash_record(tdr, &v->hr[i]));
	}
	return NT_STATUS_OK;
}

