/** @file VBoxEvents.h
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator:      src/VBox/Main/idl/comimpl.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */


#include "EventImpl.h"

/** @name Fire off events
 * @{ */
/** Fire an IMachineStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireMachineStateChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, MachineState_T a_state);
/** Fire an IExtPackInstalledEvent event. */
DECLHIDDEN(HRESULT) FireExtPackInstalledEvent(IEventSource *aSource, const Utf8Str & a_name);
/** Fire an IExtPackUninstalledEvent event. */
DECLHIDDEN(HRESULT) FireExtPackUninstalledEvent(IEventSource *aSource, const Utf8Str & a_name);
/** Fire an IMachineDataChangedEvent event. */
DECLHIDDEN(HRESULT) FireMachineDataChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_temporary);
/** Fire an IMediumRegisteredEvent event. */
DECLHIDDEN(HRESULT) FireMediumRegisteredEvent(IEventSource *aSource, const Utf8Str & a_mediumId, DeviceType_T a_mediumType, BOOL a_registered);
/** Fire an IMediumConfigChangedEvent event. */
DECLHIDDEN(HRESULT) FireMediumConfigChangedEvent(IEventSource *aSource, IMedium * a_medium);
/** Fire an IMachineRegisteredEvent event. */
DECLHIDDEN(HRESULT) FireMachineRegisteredEvent(IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_registered);
/** Fire an ISessionStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireSessionStateChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, SessionState_T a_state);
/** Fire an IGuestPropertyChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestPropertyChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_name, const Utf8Str & a_value, const Utf8Str & a_flags, BOOL a_fWasDeleted);
/** Fire an ISnapshotTakenEvent event. */
DECLHIDDEN(HRESULT) FireSnapshotTakenEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId);
/** Fire an ISnapshotDeletedEvent event. */
DECLHIDDEN(HRESULT) FireSnapshotDeletedEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId);
/** Fire an ISnapshotRestoredEvent event. */
DECLHIDDEN(HRESULT) FireSnapshotRestoredEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId);
/** Fire an ISnapshotChangedEvent event. */
DECLHIDDEN(HRESULT) FireSnapshotChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId);
/** Fire an IMousePointerShapeChangedEvent event. */
DECLHIDDEN(HRESULT) FireMousePointerShapeChangedEvent(IEventSource *aSource, BOOL a_visible, BOOL a_alpha, ULONG a_xhot, ULONG a_yhot, ULONG a_width, ULONG a_height, ComSafeArrayIn(BYTE,a_shape));
/** Fire an IMouseCapabilityChangedEvent event. */
DECLHIDDEN(HRESULT) FireMouseCapabilityChangedEvent(IEventSource *aSource, BOOL a_supportsAbsolute, BOOL a_supportsRelative, BOOL a_supportsTouchScreen, BOOL a_supportsTouchPad, BOOL a_needsHostCursor);
/** Fire an IKeyboardLedsChangedEvent event. */
DECLHIDDEN(HRESULT) FireKeyboardLedsChangedEvent(IEventSource *aSource, BOOL a_numLock, BOOL a_capsLock, BOOL a_scrollLock);
/** Fire an IStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireStateChangedEvent(IEventSource *aSource, MachineState_T a_state);
/** Fire an IAdditionsStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireAdditionsStateChangedEvent(IEventSource *aSource);
/** Fire an INetworkAdapterChangedEvent event. */
DECLHIDDEN(HRESULT) FireNetworkAdapterChangedEvent(IEventSource *aSource, INetworkAdapter * a_networkAdapter);
/** Fire an IAudioAdapterChangedEvent event. */
DECLHIDDEN(HRESULT) FireAudioAdapterChangedEvent(IEventSource *aSource, IAudioAdapter * a_audioAdapter);
/** Fire an ISerialPortChangedEvent event. */
DECLHIDDEN(HRESULT) FireSerialPortChangedEvent(IEventSource *aSource, ISerialPort * a_serialPort);
/** Fire an IParallelPortChangedEvent event. */
DECLHIDDEN(HRESULT) FireParallelPortChangedEvent(IEventSource *aSource, IParallelPort * a_parallelPort);
/** Fire an IStorageControllerChangedEvent event. */
DECLHIDDEN(HRESULT) FireStorageControllerChangedEvent(IEventSource *aSource, const Utf8Str & a_machinId, const Utf8Str & a_controllerName);
/** Fire an IMediumChangedEvent event. */
DECLHIDDEN(HRESULT) FireMediumChangedEvent(IEventSource *aSource, IMediumAttachment * a_mediumAttachment);
/** Fire an IClipboardModeChangedEvent event. */
DECLHIDDEN(HRESULT) FireClipboardModeChangedEvent(IEventSource *aSource, ClipboardMode_T a_clipboardMode);
/** Fire an IClipboardFileTransferModeChangedEvent event. */
DECLHIDDEN(HRESULT) FireClipboardFileTransferModeChangedEvent(IEventSource *aSource, BOOL a_enabled);
/** Fire an IClipboardErrorEvent event. */
DECLHIDDEN(HRESULT) FireClipboardErrorEvent(IEventSource *aSource, const Utf8Str & a_id, const Utf8Str & a_msg, LONG a_rcError);
/** Fire an IDnDModeChangedEvent event. */
DECLHIDDEN(HRESULT) FireDnDModeChangedEvent(IEventSource *aSource, DnDMode_T a_dndMode);
/** Fire an ICPUChangedEvent event. */
DECLHIDDEN(HRESULT) FireCPUChangedEvent(IEventSource *aSource, ULONG a_CPU, BOOL a_add);
/** Fire an ICPUExecutionCapChangedEvent event. */
DECLHIDDEN(HRESULT) FireCPUExecutionCapChangedEvent(IEventSource *aSource, ULONG a_executionCap);
/** Fire an IGuestKeyboardEvent event. */
DECLHIDDEN(HRESULT) FireGuestKeyboardEvent(IEventSource *aSource, ComSafeArrayIn(LONG,a_scancodes));
/** Fire an IGuestMouseEvent event. */
DECLHIDDEN(HRESULT) FireGuestMouseEvent(IEventSource *aSource, GuestMouseEventMode_T a_mode, LONG a_x, LONG a_y, LONG a_z, LONG a_w, LONG a_buttons);
/** Fire an IGuestMultiTouchEvent event. */
DECLHIDDEN(HRESULT) FireGuestMultiTouchEvent(IEventSource *aSource, LONG a_contactCount, ComSafeArrayIn(SHORT,a_xPositions), ComSafeArrayIn(SHORT,a_yPositions), ComSafeArrayIn(USHORT,a_contactIds), ComSafeArrayIn(USHORT,a_contactFlags), BOOL a_isTouchScreen, ULONG a_scanTime);
/** Fire an IGuestSessionStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestSessionStateChangedEvent(IEventSource *aSource, IGuestSession * a_session, ULONG a_id, GuestSessionStatus_T a_status, IVirtualBoxErrorInfo * a_error);
/** Fire an IGuestSessionRegisteredEvent event. */
DECLHIDDEN(HRESULT) FireGuestSessionRegisteredEvent(IEventSource *aSource, IGuestSession * a_session, BOOL a_registered);
/** Fire an IGuestProcessRegisteredEvent event. */
DECLHIDDEN(HRESULT) FireGuestProcessRegisteredEvent(IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, BOOL a_registered);
/** Fire an IGuestProcessStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestProcessStateChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ProcessStatus_T a_status, IVirtualBoxErrorInfo * a_error);
/** Fire an IGuestProcessInputNotifyEvent event. */
DECLHIDDEN(HRESULT) FireGuestProcessInputNotifyEvent(IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ULONG a_handle, ULONG a_processed, ProcessInputStatus_T a_status);
/** Fire an IGuestProcessOutputEvent event. */
DECLHIDDEN(HRESULT) FireGuestProcessOutputEvent(IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ULONG a_handle, ULONG a_processed, ComSafeArrayIn(BYTE,a_data));
/** Fire an IGuestDirectoryRegisteredEvent event. */
DECLHIDDEN(HRESULT) FireGuestDirectoryRegisteredEvent(IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, BOOL a_registered);
/** Fire an IGuestDirectoryStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestDirectoryStateChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, DirectoryStatus_T a_status, IVirtualBoxErrorInfo * a_error);
/** Fire an IGuestDirectoryReadEvent event. */
DECLHIDDEN(HRESULT) FireGuestDirectoryReadEvent(IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, const Utf8Str & a_path, IFsObjInfo * a_objInfo, const Utf8Str & a_owner, const Utf8Str & a_groups);
/** Fire an IGuestFileRegisteredEvent event. */
DECLHIDDEN(HRESULT) FireGuestFileRegisteredEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, BOOL a_registered);
/** Fire an IGuestFileStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestFileStateChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, FileStatus_T a_status, IVirtualBoxErrorInfo * a_error);
/** Fire an IGuestFileOffsetChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestFileOffsetChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed);
/** Fire an IGuestFileSizeChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestFileSizeChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_newSize);
/** Fire an IGuestFileReadEvent event. */
DECLHIDDEN(HRESULT) FireGuestFileReadEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed, ComSafeArrayIn(BYTE,a_data));
/** Fire an IGuestFileWriteEvent event. */
DECLHIDDEN(HRESULT) FireGuestFileWriteEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed);
/** Fire an IVRDEServerChangedEvent event. */
DECLHIDDEN(HRESULT) FireVRDEServerChangedEvent(IEventSource *aSource);
/** Fire an IVRDEServerInfoChangedEvent event. */
DECLHIDDEN(HRESULT) FireVRDEServerInfoChangedEvent(IEventSource *aSource);
/** Fire an IRecordingStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireRecordingStateChangedEvent(IEventSource *aSource, RecordingState_T a_state, IVirtualBoxErrorInfo * a_error);
/** Fire an IRecordingScreenStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireRecordingScreenStateChangedEvent(IEventSource *aSource, RecordingState_T a_state, IVirtualBoxErrorInfo * a_error, ULONG a_screen);
/** Fire an IUSBControllerChangedEvent event. */
DECLHIDDEN(HRESULT) FireUSBControllerChangedEvent(IEventSource *aSource);
/** Fire an IUSBDeviceStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireUSBDeviceStateChangedEvent(IEventSource *aSource, IUSBDevice * a_device, BOOL a_attached, IVirtualBoxErrorInfo * a_error);
/** Fire an ISharedFolderChangedEvent event. */
DECLHIDDEN(HRESULT) FireSharedFolderChangedEvent(IEventSource *aSource, Scope_T a_scope);
/** Fire an IRuntimeErrorEvent event. */
DECLHIDDEN(HRESULT) FireRuntimeErrorEvent(IEventSource *aSource, BOOL a_fatal, const Utf8Str & a_id, const Utf8Str & a_message);
DECLHIDDEN(HRESULT) FireRuntimeErrorEvent(IEventSource *aSource, BOOL a_fatal, CBSTR a_id, CBSTR a_message);
/** Fire an IEventSourceChangedEvent event. */
DECLHIDDEN(HRESULT) FireEventSourceChangedEvent(IEventSource *aSource, IEventListener * a_listener, BOOL a_add);
/** Fire an IExtraDataChangedEvent event. */
DECLHIDDEN(HRESULT) FireExtraDataChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_key, const Utf8Str & a_value);
DECLHIDDEN(HRESULT) FireExtraDataChangedEvent(IEventSource *aSource, CBSTR a_machineId, CBSTR a_key, CBSTR a_value);
/** Fire an IExtraDataCanChangeEvent event. */
DECLHIDDEN(HRESULT) FireExtraDataCanChangeEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_key, const Utf8Str & a_value);
/** Fire an ICanShowWindowEvent event. */
DECLHIDDEN(HRESULT) FireCanShowWindowEvent(IEventSource *aSource);
/** Fire an IShowWindowEvent event. */
DECLHIDDEN(HRESULT) FireShowWindowEvent(IEventSource *aSource, LONG64 a_winId);
/** Fire an INATRedirectEvent event. */
DECLHIDDEN(HRESULT) FireNATRedirectEvent(IEventSource *aSource, const Utf8Str & a_machineId, ULONG a_slot, BOOL a_remove, const Utf8Str & a_name, NATProtocol_T a_proto, const Utf8Str & a_hostIP, LONG a_hostPort, const Utf8Str & a_guestIP, LONG a_guestPort);
/** Fire an IHostAudioDeviceChangedEvent event. */
DECLHIDDEN(HRESULT) FireHostAudioDeviceChangedEvent(IEventSource *aSource, IHostAudioDevice * a_device, BOOL a_new, AudioDeviceState_T a_state, IVirtualBoxErrorInfo * a_error);
/** Fire an IHostPCIDevicePlugEvent event. */
DECLHIDDEN(HRESULT) FireHostPCIDevicePlugEvent(IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_plugged, BOOL a_success, IPCIDeviceAttachment * a_attachment, const Utf8Str & a_message);
DECLHIDDEN(HRESULT) FireHostPCIDevicePlugEvent(IEventSource *aSource, CBSTR a_machineId, BOOL a_plugged, BOOL a_success, IPCIDeviceAttachment * a_attachment, CBSTR a_message);
/** Fire an IVBoxSVCAvailabilityChangedEvent event. */
DECLHIDDEN(HRESULT) FireVBoxSVCAvailabilityChangedEvent(IEventSource *aSource, BOOL a_available);
/** Fire an IBandwidthGroupChangedEvent event. */
DECLHIDDEN(HRESULT) FireBandwidthGroupChangedEvent(IEventSource *aSource, IBandwidthGroup * a_bandwidthGroup);
/** Fire an IGuestMonitorChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestMonitorChangedEvent(IEventSource *aSource, GuestMonitorChangedEventType_T a_changeType, ULONG a_screenId, ULONG a_originX, ULONG a_originY, ULONG a_width, ULONG a_height);
/** Fire an IGuestUserStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestUserStateChangedEvent(IEventSource *aSource, const Utf8Str & a_name, const Utf8Str & a_domain, GuestUserState_T a_state, const Utf8Str & a_stateDetails);
/** Fire an IStorageDeviceChangedEvent event. */
DECLHIDDEN(HRESULT) FireStorageDeviceChangedEvent(IEventSource *aSource, IMediumAttachment * a_storageDevice, BOOL a_removed, BOOL a_silent);
/** Fire an INATNetworkChangedEvent event. */
DECLHIDDEN(HRESULT) FireNATNetworkChangedEvent(IEventSource *aSource, const Utf8Str & a_networkName);
/** Fire an INATNetworkStartStopEvent event. */
DECLHIDDEN(HRESULT) FireNATNetworkStartStopEvent(IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_startEvent);
/** Fire an INATNetworkAlterEvent event. */
DECLHIDDEN(HRESULT) FireNATNetworkAlterEvent(IEventSource *aSource, const Utf8Str & a_networkName);
/** Fire an INATNetworkCreationDeletionEvent event. */
DECLHIDDEN(HRESULT) FireNATNetworkCreationDeletionEvent(IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_creationEvent);
DECLHIDDEN(HRESULT) FireNATNetworkCreationDeletionEvent(IEventSource *aSource, CBSTR a_networkName, BOOL a_creationEvent);
/** Fire an INATNetworkSettingEvent event. */
DECLHIDDEN(HRESULT) FireNATNetworkSettingEvent(IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_enabled, const Utf8Str & a_network, const Utf8Str & a_gateway, BOOL a_advertiseDefaultIPv6RouteEnabled, BOOL a_needDhcpServer);
/** Fire an INATNetworkPortForwardEvent event. */
DECLHIDDEN(HRESULT) FireNATNetworkPortForwardEvent(IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_create, BOOL a_ipv6, const Utf8Str & a_name, NATProtocol_T a_proto, const Utf8Str & a_hostIp, LONG a_hostPort, const Utf8Str & a_guestIp, LONG a_guestPort);
/** Fire an IHostNameResolutionConfigurationChangeEvent event. */
DECLHIDDEN(HRESULT) FireHostNameResolutionConfigurationChangeEvent(IEventSource *aSource);
/** Fire an IProgressCreatedEvent event. */
DECLHIDDEN(HRESULT) FireProgressCreatedEvent(IEventSource *aSource, const Utf8Str & a_progressId, BOOL a_create);
/** Fire an IProgressPercentageChangedEvent event. */
DECLHIDDEN(HRESULT) FireProgressPercentageChangedEvent(IEventSource *aSource, const Utf8Str & a_progressId, LONG a_percent);
/** Fire an IProgressTaskCompletedEvent event. */
DECLHIDDEN(HRESULT) FireProgressTaskCompletedEvent(IEventSource *aSource, const Utf8Str & a_progressId);
/** Fire an ICursorPositionChangedEvent event. */
DECLHIDDEN(HRESULT) FireCursorPositionChangedEvent(IEventSource *aSource, BOOL a_hasData, ULONG a_x, ULONG a_y);
/** Fire an IGuestAdditionsStatusChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestAdditionsStatusChangedEvent(IEventSource *aSource, AdditionsFacilityType_T a_facility, AdditionsFacilityStatus_T a_status, AdditionsRunLevelType_T a_runLevel, LONG64 a_timestamp);
/** Fire an IGuestMonitorInfoChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestMonitorInfoChangedEvent(IEventSource *aSource, ULONG a_output);
/** Fire an IUpdateAgentSettingsChangedEvent event. */
DECLHIDDEN(HRESULT) FireUpdateAgentSettingsChangedEvent(IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_attributeHint);
/** Fire an IUpdateAgentErrorEvent event. */
DECLHIDDEN(HRESULT) FireUpdateAgentErrorEvent(IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_msg, LONG a_rcError);
/** Fire an IUpdateAgentAvailableEvent event. */
DECLHIDDEN(HRESULT) FireUpdateAgentAvailableEvent(IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_version, UpdateChannel_T a_channel, UpdateSeverity_T a_severity, const Utf8Str & a_downloadURL, const Utf8Str & a_webURL, const Utf8Str & a_releaseNotes);
/** Fire an IUpdateAgentStateChangedEvent event. */
DECLHIDDEN(HRESULT) FireUpdateAgentStateChangedEvent(IEventSource *aSource, IUpdateAgent * a_agent, UpdateState_T a_state);
/** Fire an IGuestDebugControlChangedEvent event. */
DECLHIDDEN(HRESULT) FireGuestDebugControlChangedEvent(IEventSource *aSource, IGuestDebugControl * a_guestDebugControl);
/** Fire an IMachineGroupsChangedEvent event. */
DECLHIDDEN(HRESULT) FireMachineGroupsChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_dummy);
/** Fire an ICloudProviderListChangedEvent event. */
DECLHIDDEN(HRESULT) FireCloudProviderListChangedEvent(IEventSource *aSource, BOOL a_registered);
/** Fire an ICloudProviderRegisteredEvent event. */
DECLHIDDEN(HRESULT) FireCloudProviderRegisteredEvent(IEventSource *aSource, const Utf8Str & a_id, BOOL a_registered);
/** Fire an ICloudProviderUninstallEvent event. */
DECLHIDDEN(HRESULT) FireCloudProviderUninstallEvent(IEventSource *aSource, const Utf8Str & a_id);
/** Fire an ILanguageChangedEvent event. */
DECLHIDDEN(HRESULT) FireLanguageChangedEvent(IEventSource *aSource, const Utf8Str & a_languageId);
/** @} */

/** @name Instantiate events
 * @{ */
/** Create an IMachineStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateMachineStateChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, MachineState_T a_state);
/** Create an IExtPackInstalledEvent event. */
DECLHIDDEN(HRESULT) CreateExtPackInstalledEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_name);
/** Create an IExtPackUninstalledEvent event. */
DECLHIDDEN(HRESULT) CreateExtPackUninstalledEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_name);
/** Create an IMachineDataChangedEvent event. */
DECLHIDDEN(HRESULT) CreateMachineDataChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_temporary);
/** Create an IMediumRegisteredEvent event. */
DECLHIDDEN(HRESULT) CreateMediumRegisteredEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_mediumId, DeviceType_T a_mediumType, BOOL a_registered);
/** Create an IMediumConfigChangedEvent event. */
DECLHIDDEN(HRESULT) CreateMediumConfigChangedEvent(IEvent **aEvent, IEventSource *aSource, IMedium * a_medium);
/** Create an IMachineRegisteredEvent event. */
DECLHIDDEN(HRESULT) CreateMachineRegisteredEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_registered);
/** Create an ISessionStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateSessionStateChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, SessionState_T a_state);
/** Create an IGuestPropertyChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestPropertyChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_name, const Utf8Str & a_value, const Utf8Str & a_flags, BOOL a_fWasDeleted);
/** Create an ISnapshotTakenEvent event. */
DECLHIDDEN(HRESULT) CreateSnapshotTakenEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId);
/** Create an ISnapshotDeletedEvent event. */
DECLHIDDEN(HRESULT) CreateSnapshotDeletedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId);
/** Create an ISnapshotRestoredEvent event. */
DECLHIDDEN(HRESULT) CreateSnapshotRestoredEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId);
/** Create an ISnapshotChangedEvent event. */
DECLHIDDEN(HRESULT) CreateSnapshotChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId);
/** Create an IMousePointerShapeChangedEvent event. */
DECLHIDDEN(HRESULT) CreateMousePointerShapeChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_visible, BOOL a_alpha, ULONG a_xhot, ULONG a_yhot, ULONG a_width, ULONG a_height, ComSafeArrayIn(BYTE,a_shape));
/** Create an IMouseCapabilityChangedEvent event. */
DECLHIDDEN(HRESULT) CreateMouseCapabilityChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_supportsAbsolute, BOOL a_supportsRelative, BOOL a_supportsTouchScreen, BOOL a_supportsTouchPad, BOOL a_needsHostCursor);
/** Create an IKeyboardLedsChangedEvent event. */
DECLHIDDEN(HRESULT) CreateKeyboardLedsChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_numLock, BOOL a_capsLock, BOOL a_scrollLock);
/** Create an IStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateStateChangedEvent(IEvent **aEvent, IEventSource *aSource, MachineState_T a_state);
/** Create an IAdditionsStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateAdditionsStateChangedEvent(IEvent **aEvent, IEventSource *aSource);
/** Create an INetworkAdapterChangedEvent event. */
DECLHIDDEN(HRESULT) CreateNetworkAdapterChangedEvent(IEvent **aEvent, IEventSource *aSource, INetworkAdapter * a_networkAdapter);
/** Create an IAudioAdapterChangedEvent event. */
DECLHIDDEN(HRESULT) CreateAudioAdapterChangedEvent(IEvent **aEvent, IEventSource *aSource, IAudioAdapter * a_audioAdapter);
/** Create an ISerialPortChangedEvent event. */
DECLHIDDEN(HRESULT) CreateSerialPortChangedEvent(IEvent **aEvent, IEventSource *aSource, ISerialPort * a_serialPort);
/** Create an IParallelPortChangedEvent event. */
DECLHIDDEN(HRESULT) CreateParallelPortChangedEvent(IEvent **aEvent, IEventSource *aSource, IParallelPort * a_parallelPort);
/** Create an IStorageControllerChangedEvent event. */
DECLHIDDEN(HRESULT) CreateStorageControllerChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machinId, const Utf8Str & a_controllerName);
/** Create an IMediumChangedEvent event. */
DECLHIDDEN(HRESULT) CreateMediumChangedEvent(IEvent **aEvent, IEventSource *aSource, IMediumAttachment * a_mediumAttachment);
/** Create an IClipboardModeChangedEvent event. */
DECLHIDDEN(HRESULT) CreateClipboardModeChangedEvent(IEvent **aEvent, IEventSource *aSource, ClipboardMode_T a_clipboardMode);
/** Create an IClipboardFileTransferModeChangedEvent event. */
DECLHIDDEN(HRESULT) CreateClipboardFileTransferModeChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_enabled);
/** Create an IClipboardErrorEvent event. */
DECLHIDDEN(HRESULT) CreateClipboardErrorEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_id, const Utf8Str & a_msg, LONG a_rcError);
/** Create an IDnDModeChangedEvent event. */
DECLHIDDEN(HRESULT) CreateDnDModeChangedEvent(IEvent **aEvent, IEventSource *aSource, DnDMode_T a_dndMode);
/** Create an ICPUChangedEvent event. */
DECLHIDDEN(HRESULT) CreateCPUChangedEvent(IEvent **aEvent, IEventSource *aSource, ULONG a_CPU, BOOL a_add);
/** Create an ICPUExecutionCapChangedEvent event. */
DECLHIDDEN(HRESULT) CreateCPUExecutionCapChangedEvent(IEvent **aEvent, IEventSource *aSource, ULONG a_executionCap);
/** Create an IGuestKeyboardEvent event. */
DECLHIDDEN(HRESULT) CreateGuestKeyboardEvent(IEvent **aEvent, IEventSource *aSource, ComSafeArrayIn(LONG,a_scancodes));
/** Create an IGuestMouseEvent event. */
DECLHIDDEN(HRESULT) CreateGuestMouseEvent(IEvent **aEvent, IEventSource *aSource, GuestMouseEventMode_T a_mode, LONG a_x, LONG a_y, LONG a_z, LONG a_w, LONG a_buttons);
/** Create an IGuestMultiTouchEvent event. */
DECLHIDDEN(HRESULT) CreateGuestMultiTouchEvent(IEvent **aEvent, IEventSource *aSource, LONG a_contactCount, ComSafeArrayIn(SHORT,a_xPositions), ComSafeArrayIn(SHORT,a_yPositions), ComSafeArrayIn(USHORT,a_contactIds), ComSafeArrayIn(USHORT,a_contactFlags), BOOL a_isTouchScreen, ULONG a_scanTime);
/** Create an IGuestSessionStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestSessionStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, ULONG a_id, GuestSessionStatus_T a_status, IVirtualBoxErrorInfo * a_error);
/** Create an IGuestSessionRegisteredEvent event. */
DECLHIDDEN(HRESULT) CreateGuestSessionRegisteredEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, BOOL a_registered);
/** Create an IGuestProcessRegisteredEvent event. */
DECLHIDDEN(HRESULT) CreateGuestProcessRegisteredEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, BOOL a_registered);
/** Create an IGuestProcessStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestProcessStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ProcessStatus_T a_status, IVirtualBoxErrorInfo * a_error);
/** Create an IGuestProcessInputNotifyEvent event. */
DECLHIDDEN(HRESULT) CreateGuestProcessInputNotifyEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ULONG a_handle, ULONG a_processed, ProcessInputStatus_T a_status);
/** Create an IGuestProcessOutputEvent event. */
DECLHIDDEN(HRESULT) CreateGuestProcessOutputEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ULONG a_handle, ULONG a_processed, ComSafeArrayIn(BYTE,a_data));
/** Create an IGuestDirectoryRegisteredEvent event. */
DECLHIDDEN(HRESULT) CreateGuestDirectoryRegisteredEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, BOOL a_registered);
/** Create an IGuestDirectoryStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestDirectoryStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, DirectoryStatus_T a_status, IVirtualBoxErrorInfo * a_error);
/** Create an IGuestDirectoryReadEvent event. */
DECLHIDDEN(HRESULT) CreateGuestDirectoryReadEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, const Utf8Str & a_path, IFsObjInfo * a_objInfo, const Utf8Str & a_owner, const Utf8Str & a_groups);
/** Create an IGuestFileRegisteredEvent event. */
DECLHIDDEN(HRESULT) CreateGuestFileRegisteredEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, BOOL a_registered);
/** Create an IGuestFileStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestFileStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, FileStatus_T a_status, IVirtualBoxErrorInfo * a_error);
/** Create an IGuestFileOffsetChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestFileOffsetChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed);
/** Create an IGuestFileSizeChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestFileSizeChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_newSize);
/** Create an IGuestFileReadEvent event. */
DECLHIDDEN(HRESULT) CreateGuestFileReadEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed, ComSafeArrayIn(BYTE,a_data));
/** Create an IGuestFileWriteEvent event. */
DECLHIDDEN(HRESULT) CreateGuestFileWriteEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed);
/** Create an IVRDEServerChangedEvent event. */
DECLHIDDEN(HRESULT) CreateVRDEServerChangedEvent(IEvent **aEvent, IEventSource *aSource);
/** Create an IVRDEServerInfoChangedEvent event. */
DECLHIDDEN(HRESULT) CreateVRDEServerInfoChangedEvent(IEvent **aEvent, IEventSource *aSource);
/** Create an IRecordingStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateRecordingStateChangedEvent(IEvent **aEvent, IEventSource *aSource, RecordingState_T a_state, IVirtualBoxErrorInfo * a_error);
/** Create an IRecordingScreenStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateRecordingScreenStateChangedEvent(IEvent **aEvent, IEventSource *aSource, RecordingState_T a_state, IVirtualBoxErrorInfo * a_error, ULONG a_screen);
/** Create an IUSBControllerChangedEvent event. */
DECLHIDDEN(HRESULT) CreateUSBControllerChangedEvent(IEvent **aEvent, IEventSource *aSource);
/** Create an IUSBDeviceStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateUSBDeviceStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IUSBDevice * a_device, BOOL a_attached, IVirtualBoxErrorInfo * a_error);
/** Create an ISharedFolderChangedEvent event. */
DECLHIDDEN(HRESULT) CreateSharedFolderChangedEvent(IEvent **aEvent, IEventSource *aSource, Scope_T a_scope);
/** Create an IRuntimeErrorEvent event. */
DECLHIDDEN(HRESULT) CreateRuntimeErrorEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_fatal, const Utf8Str & a_id, const Utf8Str & a_message);
DECLHIDDEN(HRESULT) CreateRuntimeErrorEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_fatal, CBSTR a_id, CBSTR a_message);
/** Create an IEventSourceChangedEvent event. */
DECLHIDDEN(HRESULT) CreateEventSourceChangedEvent(IEvent **aEvent, IEventSource *aSource, IEventListener * a_listener, BOOL a_add);
/** Create an IExtraDataChangedEvent event. */
DECLHIDDEN(HRESULT) CreateExtraDataChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_key, const Utf8Str & a_value);
DECLHIDDEN(HRESULT) CreateExtraDataChangedEvent(IEvent **aEvent, IEventSource *aSource, CBSTR a_machineId, CBSTR a_key, CBSTR a_value);
/** Create an IExtraDataCanChangeEvent event. */
DECLHIDDEN(HRESULT) CreateExtraDataCanChangeEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_key, const Utf8Str & a_value);
/** Create an ICanShowWindowEvent event. */
DECLHIDDEN(HRESULT) CreateCanShowWindowEvent(IEvent **aEvent, IEventSource *aSource);
/** Create an IShowWindowEvent event. */
DECLHIDDEN(HRESULT) CreateShowWindowEvent(IEvent **aEvent, IEventSource *aSource, LONG64 a_winId);
/** Create an INATRedirectEvent event. */
DECLHIDDEN(HRESULT) CreateNATRedirectEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, ULONG a_slot, BOOL a_remove, const Utf8Str & a_name, NATProtocol_T a_proto, const Utf8Str & a_hostIP, LONG a_hostPort, const Utf8Str & a_guestIP, LONG a_guestPort);
/** Create an IHostAudioDeviceChangedEvent event. */
DECLHIDDEN(HRESULT) CreateHostAudioDeviceChangedEvent(IEvent **aEvent, IEventSource *aSource, IHostAudioDevice * a_device, BOOL a_new, AudioDeviceState_T a_state, IVirtualBoxErrorInfo * a_error);
/** Create an IHostPCIDevicePlugEvent event. */
DECLHIDDEN(HRESULT) CreateHostPCIDevicePlugEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_plugged, BOOL a_success, IPCIDeviceAttachment * a_attachment, const Utf8Str & a_message);
DECLHIDDEN(HRESULT) CreateHostPCIDevicePlugEvent(IEvent **aEvent, IEventSource *aSource, CBSTR a_machineId, BOOL a_plugged, BOOL a_success, IPCIDeviceAttachment * a_attachment, CBSTR a_message);
/** Create an IVBoxSVCAvailabilityChangedEvent event. */
DECLHIDDEN(HRESULT) CreateVBoxSVCAvailabilityChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_available);
/** Create an IBandwidthGroupChangedEvent event. */
DECLHIDDEN(HRESULT) CreateBandwidthGroupChangedEvent(IEvent **aEvent, IEventSource *aSource, IBandwidthGroup * a_bandwidthGroup);
/** Create an IGuestMonitorChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestMonitorChangedEvent(IEvent **aEvent, IEventSource *aSource, GuestMonitorChangedEventType_T a_changeType, ULONG a_screenId, ULONG a_originX, ULONG a_originY, ULONG a_width, ULONG a_height);
/** Create an IGuestUserStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestUserStateChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_name, const Utf8Str & a_domain, GuestUserState_T a_state, const Utf8Str & a_stateDetails);
/** Create an IStorageDeviceChangedEvent event. */
DECLHIDDEN(HRESULT) CreateStorageDeviceChangedEvent(IEvent **aEvent, IEventSource *aSource, IMediumAttachment * a_storageDevice, BOOL a_removed, BOOL a_silent);
/** Create an INATNetworkChangedEvent event. */
DECLHIDDEN(HRESULT) CreateNATNetworkChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName);
/** Create an INATNetworkStartStopEvent event. */
DECLHIDDEN(HRESULT) CreateNATNetworkStartStopEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_startEvent);
/** Create an INATNetworkAlterEvent event. */
DECLHIDDEN(HRESULT) CreateNATNetworkAlterEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName);
/** Create an INATNetworkCreationDeletionEvent event. */
DECLHIDDEN(HRESULT) CreateNATNetworkCreationDeletionEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_creationEvent);
DECLHIDDEN(HRESULT) CreateNATNetworkCreationDeletionEvent(IEvent **aEvent, IEventSource *aSource, CBSTR a_networkName, BOOL a_creationEvent);
/** Create an INATNetworkSettingEvent event. */
DECLHIDDEN(HRESULT) CreateNATNetworkSettingEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_enabled, const Utf8Str & a_network, const Utf8Str & a_gateway, BOOL a_advertiseDefaultIPv6RouteEnabled, BOOL a_needDhcpServer);
/** Create an INATNetworkPortForwardEvent event. */
DECLHIDDEN(HRESULT) CreateNATNetworkPortForwardEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_create, BOOL a_ipv6, const Utf8Str & a_name, NATProtocol_T a_proto, const Utf8Str & a_hostIp, LONG a_hostPort, const Utf8Str & a_guestIp, LONG a_guestPort);
/** Create an IHostNameResolutionConfigurationChangeEvent event. */
DECLHIDDEN(HRESULT) CreateHostNameResolutionConfigurationChangeEvent(IEvent **aEvent, IEventSource *aSource);
/** Create an IProgressCreatedEvent event. */
DECLHIDDEN(HRESULT) CreateProgressCreatedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_progressId, BOOL a_create);
/** Create an IProgressPercentageChangedEvent event. */
DECLHIDDEN(HRESULT) CreateProgressPercentageChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_progressId, LONG a_percent);
/** Create an IProgressTaskCompletedEvent event. */
DECLHIDDEN(HRESULT) CreateProgressTaskCompletedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_progressId);
/** Create an ICursorPositionChangedEvent event. */
DECLHIDDEN(HRESULT) CreateCursorPositionChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_hasData, ULONG a_x, ULONG a_y);
/** Create an IGuestAdditionsStatusChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestAdditionsStatusChangedEvent(IEvent **aEvent, IEventSource *aSource, AdditionsFacilityType_T a_facility, AdditionsFacilityStatus_T a_status, AdditionsRunLevelType_T a_runLevel, LONG64 a_timestamp);
/** Create an IGuestMonitorInfoChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestMonitorInfoChangedEvent(IEvent **aEvent, IEventSource *aSource, ULONG a_output);
/** Create an IUpdateAgentSettingsChangedEvent event. */
DECLHIDDEN(HRESULT) CreateUpdateAgentSettingsChangedEvent(IEvent **aEvent, IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_attributeHint);
/** Create an IUpdateAgentErrorEvent event. */
DECLHIDDEN(HRESULT) CreateUpdateAgentErrorEvent(IEvent **aEvent, IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_msg, LONG a_rcError);
/** Create an IUpdateAgentAvailableEvent event. */
DECLHIDDEN(HRESULT) CreateUpdateAgentAvailableEvent(IEvent **aEvent, IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_version, UpdateChannel_T a_channel, UpdateSeverity_T a_severity, const Utf8Str & a_downloadURL, const Utf8Str & a_webURL, const Utf8Str & a_releaseNotes);
/** Create an IUpdateAgentStateChangedEvent event. */
DECLHIDDEN(HRESULT) CreateUpdateAgentStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IUpdateAgent * a_agent, UpdateState_T a_state);
/** Create an IGuestDebugControlChangedEvent event. */
DECLHIDDEN(HRESULT) CreateGuestDebugControlChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestDebugControl * a_guestDebugControl);
/** Create an IMachineGroupsChangedEvent event. */
DECLHIDDEN(HRESULT) CreateMachineGroupsChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_dummy);
/** Create an ICloudProviderListChangedEvent event. */
DECLHIDDEN(HRESULT) CreateCloudProviderListChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_registered);
/** Create an ICloudProviderRegisteredEvent event. */
DECLHIDDEN(HRESULT) CreateCloudProviderRegisteredEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_id, BOOL a_registered);
/** Create an ICloudProviderUninstallEvent event. */
DECLHIDDEN(HRESULT) CreateCloudProviderUninstallEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_id);
/** Create an ILanguageChangedEvent event. */
DECLHIDDEN(HRESULT) CreateLanguageChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_languageId);
/** @} */

/** @name Re-init reusable events
 * @{ */
/** Re-init an IGuestMouseEvent event. */
DECLHIDDEN(HRESULT) ReinitGuestMouseEvent(IEvent *aEvent, GuestMouseEventMode_T a_mode, LONG a_x, LONG a_y, LONG a_z, LONG a_w, LONG a_buttons);
/** @} */
