// python wrapper for vtkGenericDataArray
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkSOADataArrayTemplate.h"
#include "vtkAOSDataArrayTemplate.h"
#ifdef VTK_USE_SCALED_SOA_ARRAYS
#include "vtkScaledSOADataArrayTemplate.h"
#endif
#include "vtkGenericDataArray.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkGenericDataArray(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    char tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<char> store1(2*size1);
  char *temp1 = store1.Data();
  char *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<char> store1(size1);
  char *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    char tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  int temp1;
  char temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    char *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<char> store1(size1);
  char *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<char> store0(size0);
  char *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  int temp1;
  char temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  const size_t size0 = 2;
  char *temp0 = nullptr;
  char *save0 = nullptr;
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  const size_t size0 = 2;
  char *temp0 = nullptr;
  char *save0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildBytes(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildBytes(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  const size_t size0 = 2;
  char *temp0 = nullptr;
  char *save0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s5, METH_VARARGS,
   "@P *c"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  const size_t size0 = 2;
  char *temp0 = nullptr;
  char *save0 = nullptr;
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  const size_t size0 = 2;
  char *temp0 = nullptr;
  char *save0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildBytes(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildBytes(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  const size_t size0 = 2;
  char *temp0 = nullptr;
  char *save0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *c"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  int temp0;
  char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  char temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> str\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:str) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[str, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(str, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> str\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:str)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> str\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> str\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:str) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:str) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(str, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(str, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:str)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[str, str], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[str, str], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (str, str)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (str, str)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[str, str]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[str, str], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[str, str], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (str, str)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (str, str)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[str, str]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:str) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_FillValue, METH_VARARGS,
   "FillValue(self, value:str) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, num:int) -> None\nC++: void SetNumberOfComponents(int num) override;\n\nSet/Get the dimension (n) of the components. Must be >= 1. Make\nsure that this is set before allocation.\n"},
  {"SetNumberOfTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetNumberOfTuples, METH_VARARGS,
   "SetNumberOfTuples(self, number:int) -> None\nC++: void SetNumberOfTuples(vtkIdType number) override;\n\nSet the number of tuples (a component group) in the array. Note\nthat this may allocate space depending on the number of\ncomponents. Also note that if allocation is performed no copy is\nperformed so existing data will be lost (if data conservation is\nsought, one may use the Resize method instead).\n"},
  {"Initialize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nRelease storage and reset array to initial state.\n"},
  {"Squeeze", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze() override;\n\nFree any unnecessary memory. Description: Resize object to just\nfit data requirement. Reclaims extra memory.\n"},
  {"SetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetTuple, METH_VARARGS,
   "SetTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void SetTuple(vtkIdType dstTupleIdx, vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nSetTuple(self, tupleIdx:int, tuple:(float, ...)) -> None\nC++: void SetTuple(vtkIdType tupleIdx, const double *tuple)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the tuple at\nsrcTupleIdx in the source array. This method assumes that the two\narrays have the same type and structure. Note that range checking\nand memory allocation is not performed; use in conjunction with\nSetNumberOfTuples() to allocate space.\n"},
  {"InsertTuplesStartingAt", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuplesStartingAt, METH_VARARGS,
   "InsertTuplesStartingAt(self, dstStart:int, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuplesStartingAt(vtkIdType dstStart,\n    vtkIdList *srcIds, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations starting at index dstStart. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuples, METH_VARARGS,
   "InsertTuples(self, dstIds:vtkIdList, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdList *dstIds, vtkIdList *srcIds,\n    vtkAbstractArray *source) override;\nInsertTuples(self, dstStart:int, n:int, srcStart:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdType dstStart, vtkIdType n,\n    vtkIdType srcStart, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations indexed by dstIds in this array. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertTuple, METH_VARARGS,
   "InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx, vtkAbstractArray *source) override;\nInsertTuple(self, tupleIdx:int, source:(float, ...)) -> None\nC++: void InsertTuple(vtkIdType tupleIdx, const double *source)\n    override;\n\nSee documentation from parent class. This method assumes that the\n`source` inherits from `vtkDataArray`, but its value type doesn't\nhave to match the type of the current instance.\n"},
  {"InsertComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertComponent, METH_VARARGS,
   "InsertComponent(self, tupleIdx:int, compIdx:int, value:float)\n    -> None\nC++: void InsertComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nInsert value at the location specified by tupleIdx and compIdx.\nNote that memory allocation is performed as necessary to hold the\ndata.\n"},
  {"InsertNextTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertNextTuple, METH_VARARGS,
   "InsertNextTuple(self, srcTupleIdx:int, source:vtkAbstractArray)\n    -> int\nC++: vtkIdType InsertNextTuple(vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nInsertNextTuple(self, tuple:(float, ...)) -> int\nC++: vtkIdType InsertNextTuple(const double *tuple) override;\n\nInsert the tuple from srcTupleIdx in the source array at the end\nof this array. Note that memory allocation is performed as\nnecessary to hold the data. Returns the tuple index at which the\ndata was inserted.\n"},
  {"GetTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuples, METH_VARARGS,
   "GetTuples(self, tupleIds:vtkIdList, output:vtkAbstractArray)\n    -> None\nC++: void GetTuples(vtkIdList *tupleIds, vtkAbstractArray *output)\n     override;\nGetTuples(self, p1:int, p2:int, output:vtkAbstractArray) -> None\nC++: void GetTuples(vtkIdType p1, vtkIdType p2,\n    vtkAbstractArray *output) override;\n\nGiven a list of tuple ids, return an array of tuples. You must\nensure that the output array has been previously allocated with\nenough space to hold the data.\n"},
  {"GetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetTuple, METH_VARARGS,
   "GetTuple(self, tupleIdx:int) -> (float, ...)\nC++: double *GetTuple(vtkIdType tupleIdx) override;\nGetTuple(self, tupleIdx:int, tuple:[float, ...]) -> None\nC++: void GetTuple(vtkIdType tupleIdx, double *tuple) override;\n\nGet the data tuple at tupleIdx. Return it as a pointer to an\narray. Note: this method is not thread-safe, and the pointer is\nonly valid as long as another method invocation to a vtk object\nis not performed.\n"},
  {"InterpolateTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InterpolateTuple, METH_VARARGS,
   "InterpolateTuple(self, dstTupleIdx:int, ptIndices:vtkIdList,\n    source:vtkAbstractArray, weights:[float, ...]) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdList *ptIndices, vtkAbstractArray *source,\n    double *weights) override;\nInterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int,\n    source1:vtkAbstractArray, srcTupleIdx2:int,\n    source2:vtkAbstractArray, t:float) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx1, vtkAbstractArray *source1,\n    vtkIdType srcTupleIdx2, vtkAbstractArray *source2, double t)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the interpolated\ntuple value, given the ptIndices in the source array and\nassociated interpolation weights. This method assumes that the\ntwo arrays are of the same type and structure.\n"},
  {"SetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetComponent, METH_VARARGS,
   "SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None\nC++: void SetComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nSet the data component at the location specified by tupleIdx and\ncompIdx to value. Note that i is less than NumberOfTuples and j\nis less than NumberOfComponents. Make sure enough memory has been\nallocated (use SetNumberOfTuples() and SetNumberOfComponents()).\n"},
  {"GetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetComponent, METH_VARARGS,
   "GetComponent(self, tupleIdx:int, compIdx:int) -> float\nC++: double GetComponent(vtkIdType tupleIdx, int compIdx)\n    override;\n\nReturn the data component at the location specified by tupleIdx\nand compIdx.\n"},
  {"SetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetVariantValue, METH_VARARGS,
   "SetVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void SetVariantValue(vtkIdType valueIdx, vtkVariant value)\n    override;\n\nSet a value in the array from a variant.  This method does NOT do\nbounds checking.\n"},
  {"GetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetVariantValue, METH_VARARGS,
   "GetVariantValue(self, valueIdx:int) -> vtkVariant\nC++: vtkVariant GetVariantValue(vtkIdType valueIdx) override;\n\nRetrieve value from the array as a variant.\n"},
  {"InsertVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_InsertVariantValue, METH_VARARGS,
   "InsertVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void InsertVariantValue(vtkIdType valueIdx, vtkVariant value)\n     override;\n\nInsert a value into the array from a variant.  This method does\nbounds checking.\n"},
  {"LookupValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupValue, METH_VARARGS,
   "LookupValue(self, value:vtkVariant) -> int\nC++: vtkIdType LookupValue(vtkVariant value) override;\nLookupValue(self, value:vtkVariant, valueIds:vtkIdList) -> None\nC++: void LookupValue(vtkVariant value, vtkIdList *valueIds)\n    override;\n\nReturn the value indices where a specific value appears.\n\n@warning Make sure that the lookup structure is not outdated.\n    Calls\nto `Modified` should be done appropriately so the array knows\nwhen to update its lookup structure.\n"},
  {"LookupTypedValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_LookupTypedValue, METH_VARARGS,
   "LookupTypedValue(self, value:str) -> int\nC++: virtual vtkIdType LookupTypedValue(ValueType value)\nLookupTypedValue(self, value:str, valueIds:vtkIdList) -> None\nC++: virtual void LookupTypedValue(ValueType value,\n    vtkIdList *valueIds)\n\n"},
  {"ClearLookup", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_ClearLookup, METH_VARARGS,
   "ClearLookup(self) -> None\nC++: void ClearLookup() override;\n\nDelete the associated fast lookup data structure on this array,\nif it exists.  The lookup will be rebuilt on the next call to a\nlookup function.\n"},
  {"DataChanged", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_DataChanged, METH_VARARGS,
   "DataChanged(self) -> None\nC++: void DataChanged() override;\n\nTell the array explicitly that the data has changed. This is only\nnecessary to call when you modify the array contents without\nusing the array's API (i.e. you retrieve a pointer to the data\nand modify the array contents).  You need to call this so that\nthe fast lookup will know to rebuild itself.  Otherwise, the\nlookup functions will give incorrect results.\n"},
  {"FillComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_FillComponent, METH_VARARGS,
   "FillComponent(self, compIdx:int, value:float) -> None\nC++: void FillComponent(int compIdx, double value) override;\n\nFill a component of a data array with a specified value. This\nmethod sets the specified component to specified value for all\ntuples in the data array.  This methods can be used to initialize\nor reinitialize a single component of a multi-component array.\n"},
  {"NewIterator", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_NewIterator, METH_VARARGS,
   "NewIterator(self) -> vtkArrayIterator\nC++: vtkArrayIterator *NewIterator() override;\n\nSubclasses must override this method and provide the right kind\nof templated vtkArrayIteratorTemplate.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("finite_value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetFiniteValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFiniteValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetDataTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetNumberOfTuples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_SetNumberOfTuples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Doc =
  "vtkGenericDataArray<vtkSOADataArrayTemplate, char> - Base interface\nfor all typed vtkDataArray subclasses.\n\n"
  "Superclass: vtkDataArray\n\n"
  "A more detailed description of this class and related tools can be\n"
  "found\n"
  "[here](https://docs.vtk.org/en/latest/design_documents/array_dispatch.\n"
  "html)\n\n"
  "The vtkGenericDataArray class provides a generic implementation of\n"
  "the vtkDataArray API. It relies on subclasses providing access to\n"
  "data via 8 \"concept methods\", which should be implemented as\n"
  "non-virtual methods of the subclass. These methods are:\n\n"
  "- ValueType GetValue(vtkIdType valueIdx) const\n"
  "- [public] void SetValue(vtkIdType valueIdx, ValueType value)\n"
  "- [public] void GetTypedTuple(vtkIdType tupleIdx, ValueType* tuple)\n"
  "  const\n"
  "- [public] void SetTypedTuple(vtkIdType tupleIdx, const ValueType*\n"
  "  tuple)\n"
  "- [public] ValueType GetTypedComponent(vtkIdType tupleIdx, int\n"
  "  compIdx) const\n"
  "- [public] void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n"
  "  ValueType value)\n"
  "- [protected] bool AllocateTuples(vtkIdType numTuples)\n"
  "- [protected] bool ReallocateTuples(vtkIdType numTuples)\n\n"
  "Note that these methods use the CRTP idiom, which provides static\n"
  "binding to avoid virtual calls. This allows the compiler to optimize\n"
  "away layers of indirection when these methods are used. Well-designed\n"
  "implementations of these methods will reduce to raw memory accesses,\n"
  "providing efficient performance comparable to working with the\n"
  "pointer data.\n\n"
  "See vtkAOSDataArrayTemplate and vtkSOADataArrayTemplate for example\n"
  "implementations.\n\n"
  "In practice, code should not be written to use vtkGenericDataArray\n"
  "objects. Doing so is rather unweildy due to the CRTP pattern\n"
  "requiring the derived class be provided as a template argument.\n"
  "Instead, the vtkArrayDispatch framework can be used to detect a\n"
  "vtkDataArray's implementation type and instantiate appropriate\n"
  "templated worker code.\n\n"
  "vtkArrayDispatch is also intended to replace code that currently\n"
  "relies on the encapsulation-breaking GetVoidPointer method. Not all\n"
  "subclasses of vtkDataArray use the memory layout assumed by\n"
  "GetVoidPointer; calling this method on, e.g. a\n"
  "vtkSOADataArrayTemplate will trigger a deep copy of the array data\n"
  "into an AOS buffer. This is very inefficient and should be avoided.\n\n"
  "@sa\n"
  "vtkArrayDispatcher vtkDataArrayRange\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Type, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_Methods,
    typeid(vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>).name(),
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkDataArray_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkGenericDataArray<vtkSOADataArrayTemplate<char>, char>::VTK_DATA_TYPE);
  if (o)
  {
    PyDict_SetItemString(d, "VTK_DATA_TYPE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIcEcE_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    signed char tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  signed char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<signed char> store1(2*size1);
  signed char *temp1 = store1.Data();
  signed char *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<signed char> store1(size1);
  signed char *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    signed char tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  int temp1;
  signed char temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    signed char *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    signed char *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  signed char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  signed char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<signed char> store1(size1);
  signed char *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<signed char> store0(size0);
  signed char *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  int temp1;
  signed char temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  const size_t size0 = 2;
  signed char temp0[2];
  signed char save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  const size_t size0 = 2;
  signed char temp0[2];
  signed char save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    signed char *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    signed char *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  const size_t size0 = 2;
  signed char temp0[2];
  signed char save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s5, METH_VARARGS,
   "@P *b"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  const size_t size0 = 2;
  signed char temp0[2];
  signed char save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  const size_t size0 = 2;
  signed char temp0[2];
  signed char save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    signed char *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    signed char *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  const size_t size0 = 2;
  signed char temp0[2];
  signed char save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *b"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  int temp0;
  signed char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  signed char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  signed char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  signed char temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> int\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:int) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[int, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(int, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> Pointer\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:int) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:int) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(int, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(int, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[int, int], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (int, int)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[int, int]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[int, int], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (int, int)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[int, int]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:int) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_FillValue, METH_VARARGS,
   "FillValue(self, value:int) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, num:int) -> None\nC++: void SetNumberOfComponents(int num) override;\n\nSet/Get the dimension (n) of the components. Must be >= 1. Make\nsure that this is set before allocation.\n"},
  {"SetNumberOfTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetNumberOfTuples, METH_VARARGS,
   "SetNumberOfTuples(self, number:int) -> None\nC++: void SetNumberOfTuples(vtkIdType number) override;\n\nSet the number of tuples (a component group) in the array. Note\nthat this may allocate space depending on the number of\ncomponents. Also note that if allocation is performed no copy is\nperformed so existing data will be lost (if data conservation is\nsought, one may use the Resize method instead).\n"},
  {"Initialize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nRelease storage and reset array to initial state.\n"},
  {"Squeeze", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze() override;\n\nFree any unnecessary memory. Description: Resize object to just\nfit data requirement. Reclaims extra memory.\n"},
  {"SetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetTuple, METH_VARARGS,
   "SetTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void SetTuple(vtkIdType dstTupleIdx, vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nSetTuple(self, tupleIdx:int, tuple:(float, ...)) -> None\nC++: void SetTuple(vtkIdType tupleIdx, const double *tuple)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the tuple at\nsrcTupleIdx in the source array. This method assumes that the two\narrays have the same type and structure. Note that range checking\nand memory allocation is not performed; use in conjunction with\nSetNumberOfTuples() to allocate space.\n"},
  {"InsertTuplesStartingAt", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuplesStartingAt, METH_VARARGS,
   "InsertTuplesStartingAt(self, dstStart:int, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuplesStartingAt(vtkIdType dstStart,\n    vtkIdList *srcIds, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations starting at index dstStart. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuples, METH_VARARGS,
   "InsertTuples(self, dstIds:vtkIdList, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdList *dstIds, vtkIdList *srcIds,\n    vtkAbstractArray *source) override;\nInsertTuples(self, dstStart:int, n:int, srcStart:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdType dstStart, vtkIdType n,\n    vtkIdType srcStart, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations indexed by dstIds in this array. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertTuple, METH_VARARGS,
   "InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx, vtkAbstractArray *source) override;\nInsertTuple(self, tupleIdx:int, source:(float, ...)) -> None\nC++: void InsertTuple(vtkIdType tupleIdx, const double *source)\n    override;\n\nSee documentation from parent class. This method assumes that the\n`source` inherits from `vtkDataArray`, but its value type doesn't\nhave to match the type of the current instance.\n"},
  {"InsertComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertComponent, METH_VARARGS,
   "InsertComponent(self, tupleIdx:int, compIdx:int, value:float)\n    -> None\nC++: void InsertComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nInsert value at the location specified by tupleIdx and compIdx.\nNote that memory allocation is performed as necessary to hold the\ndata.\n"},
  {"InsertNextTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertNextTuple, METH_VARARGS,
   "InsertNextTuple(self, srcTupleIdx:int, source:vtkAbstractArray)\n    -> int\nC++: vtkIdType InsertNextTuple(vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nInsertNextTuple(self, tuple:(float, ...)) -> int\nC++: vtkIdType InsertNextTuple(const double *tuple) override;\n\nInsert the tuple from srcTupleIdx in the source array at the end\nof this array. Note that memory allocation is performed as\nnecessary to hold the data. Returns the tuple index at which the\ndata was inserted.\n"},
  {"GetTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuples, METH_VARARGS,
   "GetTuples(self, tupleIds:vtkIdList, output:vtkAbstractArray)\n    -> None\nC++: void GetTuples(vtkIdList *tupleIds, vtkAbstractArray *output)\n     override;\nGetTuples(self, p1:int, p2:int, output:vtkAbstractArray) -> None\nC++: void GetTuples(vtkIdType p1, vtkIdType p2,\n    vtkAbstractArray *output) override;\n\nGiven a list of tuple ids, return an array of tuples. You must\nensure that the output array has been previously allocated with\nenough space to hold the data.\n"},
  {"GetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetTuple, METH_VARARGS,
   "GetTuple(self, tupleIdx:int) -> (float, ...)\nC++: double *GetTuple(vtkIdType tupleIdx) override;\nGetTuple(self, tupleIdx:int, tuple:[float, ...]) -> None\nC++: void GetTuple(vtkIdType tupleIdx, double *tuple) override;\n\nGet the data tuple at tupleIdx. Return it as a pointer to an\narray. Note: this method is not thread-safe, and the pointer is\nonly valid as long as another method invocation to a vtk object\nis not performed.\n"},
  {"InterpolateTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InterpolateTuple, METH_VARARGS,
   "InterpolateTuple(self, dstTupleIdx:int, ptIndices:vtkIdList,\n    source:vtkAbstractArray, weights:[float, ...]) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdList *ptIndices, vtkAbstractArray *source,\n    double *weights) override;\nInterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int,\n    source1:vtkAbstractArray, srcTupleIdx2:int,\n    source2:vtkAbstractArray, t:float) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx1, vtkAbstractArray *source1,\n    vtkIdType srcTupleIdx2, vtkAbstractArray *source2, double t)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the interpolated\ntuple value, given the ptIndices in the source array and\nassociated interpolation weights. This method assumes that the\ntwo arrays are of the same type and structure.\n"},
  {"SetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetComponent, METH_VARARGS,
   "SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None\nC++: void SetComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nSet the data component at the location specified by tupleIdx and\ncompIdx to value. Note that i is less than NumberOfTuples and j\nis less than NumberOfComponents. Make sure enough memory has been\nallocated (use SetNumberOfTuples() and SetNumberOfComponents()).\n"},
  {"GetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetComponent, METH_VARARGS,
   "GetComponent(self, tupleIdx:int, compIdx:int) -> float\nC++: double GetComponent(vtkIdType tupleIdx, int compIdx)\n    override;\n\nReturn the data component at the location specified by tupleIdx\nand compIdx.\n"},
  {"SetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetVariantValue, METH_VARARGS,
   "SetVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void SetVariantValue(vtkIdType valueIdx, vtkVariant value)\n    override;\n\nSet a value in the array from a variant.  This method does NOT do\nbounds checking.\n"},
  {"GetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetVariantValue, METH_VARARGS,
   "GetVariantValue(self, valueIdx:int) -> vtkVariant\nC++: vtkVariant GetVariantValue(vtkIdType valueIdx) override;\n\nRetrieve value from the array as a variant.\n"},
  {"InsertVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_InsertVariantValue, METH_VARARGS,
   "InsertVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void InsertVariantValue(vtkIdType valueIdx, vtkVariant value)\n     override;\n\nInsert a value into the array from a variant.  This method does\nbounds checking.\n"},
  {"LookupValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupValue, METH_VARARGS,
   "LookupValue(self, value:vtkVariant) -> int\nC++: vtkIdType LookupValue(vtkVariant value) override;\nLookupValue(self, value:vtkVariant, valueIds:vtkIdList) -> None\nC++: void LookupValue(vtkVariant value, vtkIdList *valueIds)\n    override;\n\nReturn the value indices where a specific value appears.\n\n@warning Make sure that the lookup structure is not outdated.\n    Calls\nto `Modified` should be done appropriately so the array knows\nwhen to update its lookup structure.\n"},
  {"LookupTypedValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_LookupTypedValue, METH_VARARGS,
   "LookupTypedValue(self, value:int) -> int\nC++: virtual vtkIdType LookupTypedValue(ValueType value)\nLookupTypedValue(self, value:int, valueIds:vtkIdList) -> None\nC++: virtual void LookupTypedValue(ValueType value,\n    vtkIdList *valueIds)\n\n"},
  {"ClearLookup", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_ClearLookup, METH_VARARGS,
   "ClearLookup(self) -> None\nC++: void ClearLookup() override;\n\nDelete the associated fast lookup data structure on this array,\nif it exists.  The lookup will be rebuilt on the next call to a\nlookup function.\n"},
  {"DataChanged", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_DataChanged, METH_VARARGS,
   "DataChanged(self) -> None\nC++: void DataChanged() override;\n\nTell the array explicitly that the data has changed. This is only\nnecessary to call when you modify the array contents without\nusing the array's API (i.e. you retrieve a pointer to the data\nand modify the array contents).  You need to call this so that\nthe fast lookup will know to rebuild itself.  Otherwise, the\nlookup functions will give incorrect results.\n"},
  {"FillComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_FillComponent, METH_VARARGS,
   "FillComponent(self, compIdx:int, value:float) -> None\nC++: void FillComponent(int compIdx, double value) override;\n\nFill a component of a data array with a specified value. This\nmethod sets the specified component to specified value for all\ntuples in the data array.  This methods can be used to initialize\nor reinitialize a single component of a multi-component array.\n"},
  {"NewIterator", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_NewIterator, METH_VARARGS,
   "NewIterator(self) -> vtkArrayIterator\nC++: vtkArrayIterator *NewIterator() override;\n\nSubclasses must override this method and provide the right kind\nof templated vtkArrayIteratorTemplate.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("finite_value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetFiniteValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFiniteValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetDataTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetNumberOfTuples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_SetNumberOfTuples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Doc =
  "vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed\nchar> - Base interface for all typed vtkDataArray subclasses.\n\n"
  "Superclass: vtkDataArray\n\n"
  "A more detailed description of this class and related tools can be\n"
  "found\n"
  "[here](https://docs.vtk.org/en/latest/design_documents/array_dispatch.\n"
  "html)\n\n"
  "The vtkGenericDataArray class provides a generic implementation of\n"
  "the vtkDataArray API. It relies on subclasses providing access to\n"
  "data via 8 \"concept methods\", which should be implemented as\n"
  "non-virtual methods of the subclass. These methods are:\n\n"
  "- ValueType GetValue(vtkIdType valueIdx) const\n"
  "- [public] void SetValue(vtkIdType valueIdx, ValueType value)\n"
  "- [public] void GetTypedTuple(vtkIdType tupleIdx, ValueType* tuple)\n"
  "  const\n"
  "- [public] void SetTypedTuple(vtkIdType tupleIdx, const ValueType*\n"
  "  tuple)\n"
  "- [public] ValueType GetTypedComponent(vtkIdType tupleIdx, int\n"
  "  compIdx) const\n"
  "- [public] void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n"
  "  ValueType value)\n"
  "- [protected] bool AllocateTuples(vtkIdType numTuples)\n"
  "- [protected] bool ReallocateTuples(vtkIdType numTuples)\n\n"
  "Note that these methods use the CRTP idiom, which provides static\n"
  "binding to avoid virtual calls. This allows the compiler to optimize\n"
  "away layers of indirection when these methods are used. Well-designed\n"
  "implementations of these methods will reduce to raw memory accesses,\n"
  "providing efficient performance comparable to working with the\n"
  "pointer data.\n\n"
  "See vtkAOSDataArrayTemplate and vtkSOADataArrayTemplate for example\n"
  "implementations.\n\n"
  "In practice, code should not be written to use vtkGenericDataArray\n"
  "objects. Doing so is rather unweildy due to the CRTP pattern\n"
  "requiring the derived class be provided as a template argument.\n"
  "Instead, the vtkArrayDispatch framework can be used to detect a\n"
  "vtkDataArray's implementation type and instantiate appropriate\n"
  "templated worker code.\n\n"
  "vtkArrayDispatch is also intended to replace code that currently\n"
  "relies on the encapsulation-breaking GetVoidPointer method. Not all\n"
  "subclasses of vtkDataArray use the memory layout assumed by\n"
  "GetVoidPointer; calling this method on, e.g. a\n"
  "vtkSOADataArrayTemplate will trigger a deep copy of the array data\n"
  "into an AOS buffer. This is very inefficient and should be avoided.\n\n"
  "@sa\n"
  "vtkArrayDispatcher vtkDataArrayRange\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Type, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_Methods,
    typeid(vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>).name(),
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkDataArray_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkGenericDataArray<vtkSOADataArrayTemplate<signed char>, signed char>::VTK_DATA_TYPE);
  if (o)
  {
    PyDict_SetItemString(d, "VTK_DATA_TYPE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIaEaE_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned char tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  unsigned char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned char> store1(2*size1);
  unsigned char *temp1 = store1.Data();
  unsigned char *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned char> store1(size1);
  unsigned char *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    unsigned char tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  int temp1;
  unsigned char temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned char *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned char *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  unsigned char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  unsigned char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned char> store1(size1);
  unsigned char *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<unsigned char> store0(size0);
  unsigned char *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  int temp1;
  unsigned char temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  const size_t size0 = 2;
  unsigned char temp0[2];
  unsigned char save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  const size_t size0 = 2;
  unsigned char temp0[2];
  unsigned char save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned char *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned char *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  const size_t size0 = 2;
  unsigned char temp0[2];
  unsigned char save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s5, METH_VARARGS,
   "@P *B"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  const size_t size0 = 2;
  unsigned char temp0[2];
  unsigned char save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  const size_t size0 = 2;
  unsigned char temp0[2];
  unsigned char save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned char *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned char *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  const size_t size0 = 2;
  unsigned char temp0[2];
  unsigned char save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *B"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  int temp0;
  unsigned char temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  unsigned char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  unsigned char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  unsigned char temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> int\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:int) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[int, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(int, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> Pointer\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:int) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:int) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(int, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(int, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[int, int], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (int, int)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[int, int]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[int, int], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (int, int)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[int, int]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:int) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_FillValue, METH_VARARGS,
   "FillValue(self, value:int) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, num:int) -> None\nC++: void SetNumberOfComponents(int num) override;\n\nSet/Get the dimension (n) of the components. Must be >= 1. Make\nsure that this is set before allocation.\n"},
  {"SetNumberOfTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetNumberOfTuples, METH_VARARGS,
   "SetNumberOfTuples(self, number:int) -> None\nC++: void SetNumberOfTuples(vtkIdType number) override;\n\nSet the number of tuples (a component group) in the array. Note\nthat this may allocate space depending on the number of\ncomponents. Also note that if allocation is performed no copy is\nperformed so existing data will be lost (if data conservation is\nsought, one may use the Resize method instead).\n"},
  {"Initialize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nRelease storage and reset array to initial state.\n"},
  {"Squeeze", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze() override;\n\nFree any unnecessary memory. Description: Resize object to just\nfit data requirement. Reclaims extra memory.\n"},
  {"SetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetTuple, METH_VARARGS,
   "SetTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void SetTuple(vtkIdType dstTupleIdx, vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nSetTuple(self, tupleIdx:int, tuple:(float, ...)) -> None\nC++: void SetTuple(vtkIdType tupleIdx, const double *tuple)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the tuple at\nsrcTupleIdx in the source array. This method assumes that the two\narrays have the same type and structure. Note that range checking\nand memory allocation is not performed; use in conjunction with\nSetNumberOfTuples() to allocate space.\n"},
  {"InsertTuplesStartingAt", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuplesStartingAt, METH_VARARGS,
   "InsertTuplesStartingAt(self, dstStart:int, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuplesStartingAt(vtkIdType dstStart,\n    vtkIdList *srcIds, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations starting at index dstStart. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuples, METH_VARARGS,
   "InsertTuples(self, dstIds:vtkIdList, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdList *dstIds, vtkIdList *srcIds,\n    vtkAbstractArray *source) override;\nInsertTuples(self, dstStart:int, n:int, srcStart:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdType dstStart, vtkIdType n,\n    vtkIdType srcStart, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations indexed by dstIds in this array. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertTuple, METH_VARARGS,
   "InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx, vtkAbstractArray *source) override;\nInsertTuple(self, tupleIdx:int, source:(float, ...)) -> None\nC++: void InsertTuple(vtkIdType tupleIdx, const double *source)\n    override;\n\nSee documentation from parent class. This method assumes that the\n`source` inherits from `vtkDataArray`, but its value type doesn't\nhave to match the type of the current instance.\n"},
  {"InsertComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertComponent, METH_VARARGS,
   "InsertComponent(self, tupleIdx:int, compIdx:int, value:float)\n    -> None\nC++: void InsertComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nInsert value at the location specified by tupleIdx and compIdx.\nNote that memory allocation is performed as necessary to hold the\ndata.\n"},
  {"InsertNextTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertNextTuple, METH_VARARGS,
   "InsertNextTuple(self, srcTupleIdx:int, source:vtkAbstractArray)\n    -> int\nC++: vtkIdType InsertNextTuple(vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nInsertNextTuple(self, tuple:(float, ...)) -> int\nC++: vtkIdType InsertNextTuple(const double *tuple) override;\n\nInsert the tuple from srcTupleIdx in the source array at the end\nof this array. Note that memory allocation is performed as\nnecessary to hold the data. Returns the tuple index at which the\ndata was inserted.\n"},
  {"GetTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuples, METH_VARARGS,
   "GetTuples(self, tupleIds:vtkIdList, output:vtkAbstractArray)\n    -> None\nC++: void GetTuples(vtkIdList *tupleIds, vtkAbstractArray *output)\n     override;\nGetTuples(self, p1:int, p2:int, output:vtkAbstractArray) -> None\nC++: void GetTuples(vtkIdType p1, vtkIdType p2,\n    vtkAbstractArray *output) override;\n\nGiven a list of tuple ids, return an array of tuples. You must\nensure that the output array has been previously allocated with\nenough space to hold the data.\n"},
  {"GetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetTuple, METH_VARARGS,
   "GetTuple(self, tupleIdx:int) -> (float, ...)\nC++: double *GetTuple(vtkIdType tupleIdx) override;\nGetTuple(self, tupleIdx:int, tuple:[float, ...]) -> None\nC++: void GetTuple(vtkIdType tupleIdx, double *tuple) override;\n\nGet the data tuple at tupleIdx. Return it as a pointer to an\narray. Note: this method is not thread-safe, and the pointer is\nonly valid as long as another method invocation to a vtk object\nis not performed.\n"},
  {"InterpolateTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InterpolateTuple, METH_VARARGS,
   "InterpolateTuple(self, dstTupleIdx:int, ptIndices:vtkIdList,\n    source:vtkAbstractArray, weights:[float, ...]) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdList *ptIndices, vtkAbstractArray *source,\n    double *weights) override;\nInterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int,\n    source1:vtkAbstractArray, srcTupleIdx2:int,\n    source2:vtkAbstractArray, t:float) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx1, vtkAbstractArray *source1,\n    vtkIdType srcTupleIdx2, vtkAbstractArray *source2, double t)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the interpolated\ntuple value, given the ptIndices in the source array and\nassociated interpolation weights. This method assumes that the\ntwo arrays are of the same type and structure.\n"},
  {"SetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetComponent, METH_VARARGS,
   "SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None\nC++: void SetComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nSet the data component at the location specified by tupleIdx and\ncompIdx to value. Note that i is less than NumberOfTuples and j\nis less than NumberOfComponents. Make sure enough memory has been\nallocated (use SetNumberOfTuples() and SetNumberOfComponents()).\n"},
  {"GetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetComponent, METH_VARARGS,
   "GetComponent(self, tupleIdx:int, compIdx:int) -> float\nC++: double GetComponent(vtkIdType tupleIdx, int compIdx)\n    override;\n\nReturn the data component at the location specified by tupleIdx\nand compIdx.\n"},
  {"SetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetVariantValue, METH_VARARGS,
   "SetVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void SetVariantValue(vtkIdType valueIdx, vtkVariant value)\n    override;\n\nSet a value in the array from a variant.  This method does NOT do\nbounds checking.\n"},
  {"GetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetVariantValue, METH_VARARGS,
   "GetVariantValue(self, valueIdx:int) -> vtkVariant\nC++: vtkVariant GetVariantValue(vtkIdType valueIdx) override;\n\nRetrieve value from the array as a variant.\n"},
  {"InsertVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_InsertVariantValue, METH_VARARGS,
   "InsertVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void InsertVariantValue(vtkIdType valueIdx, vtkVariant value)\n     override;\n\nInsert a value into the array from a variant.  This method does\nbounds checking.\n"},
  {"LookupValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupValue, METH_VARARGS,
   "LookupValue(self, value:vtkVariant) -> int\nC++: vtkIdType LookupValue(vtkVariant value) override;\nLookupValue(self, value:vtkVariant, valueIds:vtkIdList) -> None\nC++: void LookupValue(vtkVariant value, vtkIdList *valueIds)\n    override;\n\nReturn the value indices where a specific value appears.\n\n@warning Make sure that the lookup structure is not outdated.\n    Calls\nto `Modified` should be done appropriately so the array knows\nwhen to update its lookup structure.\n"},
  {"LookupTypedValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_LookupTypedValue, METH_VARARGS,
   "LookupTypedValue(self, value:int) -> int\nC++: virtual vtkIdType LookupTypedValue(ValueType value)\nLookupTypedValue(self, value:int, valueIds:vtkIdList) -> None\nC++: virtual void LookupTypedValue(ValueType value,\n    vtkIdList *valueIds)\n\n"},
  {"ClearLookup", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_ClearLookup, METH_VARARGS,
   "ClearLookup(self) -> None\nC++: void ClearLookup() override;\n\nDelete the associated fast lookup data structure on this array,\nif it exists.  The lookup will be rebuilt on the next call to a\nlookup function.\n"},
  {"DataChanged", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_DataChanged, METH_VARARGS,
   "DataChanged(self) -> None\nC++: void DataChanged() override;\n\nTell the array explicitly that the data has changed. This is only\nnecessary to call when you modify the array contents without\nusing the array's API (i.e. you retrieve a pointer to the data\nand modify the array contents).  You need to call this so that\nthe fast lookup will know to rebuild itself.  Otherwise, the\nlookup functions will give incorrect results.\n"},
  {"FillComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_FillComponent, METH_VARARGS,
   "FillComponent(self, compIdx:int, value:float) -> None\nC++: void FillComponent(int compIdx, double value) override;\n\nFill a component of a data array with a specified value. This\nmethod sets the specified component to specified value for all\ntuples in the data array.  This methods can be used to initialize\nor reinitialize a single component of a multi-component array.\n"},
  {"NewIterator", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_NewIterator, METH_VARARGS,
   "NewIterator(self) -> vtkArrayIterator\nC++: vtkArrayIterator *NewIterator() override;\n\nSubclasses must override this method and provide the right kind\nof templated vtkArrayIteratorTemplate.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("finite_value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetFiniteValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFiniteValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetDataTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetNumberOfTuples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_SetNumberOfTuples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Doc =
  "vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned\nchar> - Base interface for all typed vtkDataArray subclasses.\n\n"
  "Superclass: vtkDataArray\n\n"
  "A more detailed description of this class and related tools can be\n"
  "found\n"
  "[here](https://docs.vtk.org/en/latest/design_documents/array_dispatch.\n"
  "html)\n\n"
  "The vtkGenericDataArray class provides a generic implementation of\n"
  "the vtkDataArray API. It relies on subclasses providing access to\n"
  "data via 8 \"concept methods\", which should be implemented as\n"
  "non-virtual methods of the subclass. These methods are:\n\n"
  "- ValueType GetValue(vtkIdType valueIdx) const\n"
  "- [public] void SetValue(vtkIdType valueIdx, ValueType value)\n"
  "- [public] void GetTypedTuple(vtkIdType tupleIdx, ValueType* tuple)\n"
  "  const\n"
  "- [public] void SetTypedTuple(vtkIdType tupleIdx, const ValueType*\n"
  "  tuple)\n"
  "- [public] ValueType GetTypedComponent(vtkIdType tupleIdx, int\n"
  "  compIdx) const\n"
  "- [public] void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n"
  "  ValueType value)\n"
  "- [protected] bool AllocateTuples(vtkIdType numTuples)\n"
  "- [protected] bool ReallocateTuples(vtkIdType numTuples)\n\n"
  "Note that these methods use the CRTP idiom, which provides static\n"
  "binding to avoid virtual calls. This allows the compiler to optimize\n"
  "away layers of indirection when these methods are used. Well-designed\n"
  "implementations of these methods will reduce to raw memory accesses,\n"
  "providing efficient performance comparable to working with the\n"
  "pointer data.\n\n"
  "See vtkAOSDataArrayTemplate and vtkSOADataArrayTemplate for example\n"
  "implementations.\n\n"
  "In practice, code should not be written to use vtkGenericDataArray\n"
  "objects. Doing so is rather unweildy due to the CRTP pattern\n"
  "requiring the derived class be provided as a template argument.\n"
  "Instead, the vtkArrayDispatch framework can be used to detect a\n"
  "vtkDataArray's implementation type and instantiate appropriate\n"
  "templated worker code.\n\n"
  "vtkArrayDispatch is also intended to replace code that currently\n"
  "relies on the encapsulation-breaking GetVoidPointer method. Not all\n"
  "subclasses of vtkDataArray use the memory layout assumed by\n"
  "GetVoidPointer; calling this method on, e.g. a\n"
  "vtkSOADataArrayTemplate will trigger a deep copy of the array data\n"
  "into an AOS buffer. This is very inefficient and should be avoided.\n\n"
  "@sa\n"
  "vtkArrayDispatcher vtkDataArrayRange\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Type, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_Methods,
    typeid(vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>).name(),
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkDataArray_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned char>, unsigned char>::VTK_DATA_TYPE);
  if (o)
  {
    PyDict_SetItemString(d, "VTK_DATA_TYPE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIhEhE_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    short tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  short temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<short> store1(2*size1);
  short *temp1 = store1.Data();
  short *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<short> store1(size1);
  short *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    short tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  int temp1;
  short temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    short *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    short *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  short temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  short temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<short> store1(size1);
  short *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<short> store0(size0);
  short *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  int temp1;
  short temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  const size_t size0 = 2;
  short temp0[2];
  short save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  const size_t size0 = 2;
  short temp0[2];
  short save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    short *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    short *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  const size_t size0 = 2;
  short temp0[2];
  short save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s5, METH_VARARGS,
   "@P *h"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  const size_t size0 = 2;
  short temp0[2];
  short save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  const size_t size0 = 2;
  short temp0[2];
  short save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    short *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    short *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  const size_t size0 = 2;
  short temp0[2];
  short save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *h"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  int temp0;
  short temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  short temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  short temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  short temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> int\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:int) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[int, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(int, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> Pointer\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:int) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:int) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(int, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(int, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[int, int], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (int, int)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[int, int]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[int, int], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (int, int)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[int, int]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:int) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_FillValue, METH_VARARGS,
   "FillValue(self, value:int) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, num:int) -> None\nC++: void SetNumberOfComponents(int num) override;\n\nSet/Get the dimension (n) of the components. Must be >= 1. Make\nsure that this is set before allocation.\n"},
  {"SetNumberOfTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetNumberOfTuples, METH_VARARGS,
   "SetNumberOfTuples(self, number:int) -> None\nC++: void SetNumberOfTuples(vtkIdType number) override;\n\nSet the number of tuples (a component group) in the array. Note\nthat this may allocate space depending on the number of\ncomponents. Also note that if allocation is performed no copy is\nperformed so existing data will be lost (if data conservation is\nsought, one may use the Resize method instead).\n"},
  {"Initialize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nRelease storage and reset array to initial state.\n"},
  {"Squeeze", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze() override;\n\nFree any unnecessary memory. Description: Resize object to just\nfit data requirement. Reclaims extra memory.\n"},
  {"SetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetTuple, METH_VARARGS,
   "SetTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void SetTuple(vtkIdType dstTupleIdx, vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nSetTuple(self, tupleIdx:int, tuple:(float, ...)) -> None\nC++: void SetTuple(vtkIdType tupleIdx, const double *tuple)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the tuple at\nsrcTupleIdx in the source array. This method assumes that the two\narrays have the same type and structure. Note that range checking\nand memory allocation is not performed; use in conjunction with\nSetNumberOfTuples() to allocate space.\n"},
  {"InsertTuplesStartingAt", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuplesStartingAt, METH_VARARGS,
   "InsertTuplesStartingAt(self, dstStart:int, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuplesStartingAt(vtkIdType dstStart,\n    vtkIdList *srcIds, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations starting at index dstStart. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuples, METH_VARARGS,
   "InsertTuples(self, dstIds:vtkIdList, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdList *dstIds, vtkIdList *srcIds,\n    vtkAbstractArray *source) override;\nInsertTuples(self, dstStart:int, n:int, srcStart:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdType dstStart, vtkIdType n,\n    vtkIdType srcStart, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations indexed by dstIds in this array. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertTuple, METH_VARARGS,
   "InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx, vtkAbstractArray *source) override;\nInsertTuple(self, tupleIdx:int, source:(float, ...)) -> None\nC++: void InsertTuple(vtkIdType tupleIdx, const double *source)\n    override;\n\nSee documentation from parent class. This method assumes that the\n`source` inherits from `vtkDataArray`, but its value type doesn't\nhave to match the type of the current instance.\n"},
  {"InsertComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertComponent, METH_VARARGS,
   "InsertComponent(self, tupleIdx:int, compIdx:int, value:float)\n    -> None\nC++: void InsertComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nInsert value at the location specified by tupleIdx and compIdx.\nNote that memory allocation is performed as necessary to hold the\ndata.\n"},
  {"InsertNextTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertNextTuple, METH_VARARGS,
   "InsertNextTuple(self, srcTupleIdx:int, source:vtkAbstractArray)\n    -> int\nC++: vtkIdType InsertNextTuple(vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nInsertNextTuple(self, tuple:(float, ...)) -> int\nC++: vtkIdType InsertNextTuple(const double *tuple) override;\n\nInsert the tuple from srcTupleIdx in the source array at the end\nof this array. Note that memory allocation is performed as\nnecessary to hold the data. Returns the tuple index at which the\ndata was inserted.\n"},
  {"GetTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuples, METH_VARARGS,
   "GetTuples(self, tupleIds:vtkIdList, output:vtkAbstractArray)\n    -> None\nC++: void GetTuples(vtkIdList *tupleIds, vtkAbstractArray *output)\n     override;\nGetTuples(self, p1:int, p2:int, output:vtkAbstractArray) -> None\nC++: void GetTuples(vtkIdType p1, vtkIdType p2,\n    vtkAbstractArray *output) override;\n\nGiven a list of tuple ids, return an array of tuples. You must\nensure that the output array has been previously allocated with\nenough space to hold the data.\n"},
  {"GetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetTuple, METH_VARARGS,
   "GetTuple(self, tupleIdx:int) -> (float, ...)\nC++: double *GetTuple(vtkIdType tupleIdx) override;\nGetTuple(self, tupleIdx:int, tuple:[float, ...]) -> None\nC++: void GetTuple(vtkIdType tupleIdx, double *tuple) override;\n\nGet the data tuple at tupleIdx. Return it as a pointer to an\narray. Note: this method is not thread-safe, and the pointer is\nonly valid as long as another method invocation to a vtk object\nis not performed.\n"},
  {"InterpolateTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InterpolateTuple, METH_VARARGS,
   "InterpolateTuple(self, dstTupleIdx:int, ptIndices:vtkIdList,\n    source:vtkAbstractArray, weights:[float, ...]) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdList *ptIndices, vtkAbstractArray *source,\n    double *weights) override;\nInterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int,\n    source1:vtkAbstractArray, srcTupleIdx2:int,\n    source2:vtkAbstractArray, t:float) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx1, vtkAbstractArray *source1,\n    vtkIdType srcTupleIdx2, vtkAbstractArray *source2, double t)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the interpolated\ntuple value, given the ptIndices in the source array and\nassociated interpolation weights. This method assumes that the\ntwo arrays are of the same type and structure.\n"},
  {"SetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetComponent, METH_VARARGS,
   "SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None\nC++: void SetComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nSet the data component at the location specified by tupleIdx and\ncompIdx to value. Note that i is less than NumberOfTuples and j\nis less than NumberOfComponents. Make sure enough memory has been\nallocated (use SetNumberOfTuples() and SetNumberOfComponents()).\n"},
  {"GetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetComponent, METH_VARARGS,
   "GetComponent(self, tupleIdx:int, compIdx:int) -> float\nC++: double GetComponent(vtkIdType tupleIdx, int compIdx)\n    override;\n\nReturn the data component at the location specified by tupleIdx\nand compIdx.\n"},
  {"SetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetVariantValue, METH_VARARGS,
   "SetVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void SetVariantValue(vtkIdType valueIdx, vtkVariant value)\n    override;\n\nSet a value in the array from a variant.  This method does NOT do\nbounds checking.\n"},
  {"GetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetVariantValue, METH_VARARGS,
   "GetVariantValue(self, valueIdx:int) -> vtkVariant\nC++: vtkVariant GetVariantValue(vtkIdType valueIdx) override;\n\nRetrieve value from the array as a variant.\n"},
  {"InsertVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_InsertVariantValue, METH_VARARGS,
   "InsertVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void InsertVariantValue(vtkIdType valueIdx, vtkVariant value)\n     override;\n\nInsert a value into the array from a variant.  This method does\nbounds checking.\n"},
  {"LookupValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupValue, METH_VARARGS,
   "LookupValue(self, value:vtkVariant) -> int\nC++: vtkIdType LookupValue(vtkVariant value) override;\nLookupValue(self, value:vtkVariant, valueIds:vtkIdList) -> None\nC++: void LookupValue(vtkVariant value, vtkIdList *valueIds)\n    override;\n\nReturn the value indices where a specific value appears.\n\n@warning Make sure that the lookup structure is not outdated.\n    Calls\nto `Modified` should be done appropriately so the array knows\nwhen to update its lookup structure.\n"},
  {"LookupTypedValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_LookupTypedValue, METH_VARARGS,
   "LookupTypedValue(self, value:int) -> int\nC++: virtual vtkIdType LookupTypedValue(ValueType value)\nLookupTypedValue(self, value:int, valueIds:vtkIdList) -> None\nC++: virtual void LookupTypedValue(ValueType value,\n    vtkIdList *valueIds)\n\n"},
  {"ClearLookup", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_ClearLookup, METH_VARARGS,
   "ClearLookup(self) -> None\nC++: void ClearLookup() override;\n\nDelete the associated fast lookup data structure on this array,\nif it exists.  The lookup will be rebuilt on the next call to a\nlookup function.\n"},
  {"DataChanged", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_DataChanged, METH_VARARGS,
   "DataChanged(self) -> None\nC++: void DataChanged() override;\n\nTell the array explicitly that the data has changed. This is only\nnecessary to call when you modify the array contents without\nusing the array's API (i.e. you retrieve a pointer to the data\nand modify the array contents).  You need to call this so that\nthe fast lookup will know to rebuild itself.  Otherwise, the\nlookup functions will give incorrect results.\n"},
  {"FillComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_FillComponent, METH_VARARGS,
   "FillComponent(self, compIdx:int, value:float) -> None\nC++: void FillComponent(int compIdx, double value) override;\n\nFill a component of a data array with a specified value. This\nmethod sets the specified component to specified value for all\ntuples in the data array.  This methods can be used to initialize\nor reinitialize a single component of a multi-component array.\n"},
  {"NewIterator", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_NewIterator, METH_VARARGS,
   "NewIterator(self) -> vtkArrayIterator\nC++: vtkArrayIterator *NewIterator() override;\n\nSubclasses must override this method and provide the right kind\nof templated vtkArrayIteratorTemplate.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("finite_value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetFiniteValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFiniteValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetDataTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetNumberOfTuples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_SetNumberOfTuples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Doc =
  "vtkGenericDataArray<vtkSOADataArrayTemplate, short> - Base interface\nfor all typed vtkDataArray subclasses.\n\n"
  "Superclass: vtkDataArray\n\n"
  "A more detailed description of this class and related tools can be\n"
  "found\n"
  "[here](https://docs.vtk.org/en/latest/design_documents/array_dispatch.\n"
  "html)\n\n"
  "The vtkGenericDataArray class provides a generic implementation of\n"
  "the vtkDataArray API. It relies on subclasses providing access to\n"
  "data via 8 \"concept methods\", which should be implemented as\n"
  "non-virtual methods of the subclass. These methods are:\n\n"
  "- ValueType GetValue(vtkIdType valueIdx) const\n"
  "- [public] void SetValue(vtkIdType valueIdx, ValueType value)\n"
  "- [public] void GetTypedTuple(vtkIdType tupleIdx, ValueType* tuple)\n"
  "  const\n"
  "- [public] void SetTypedTuple(vtkIdType tupleIdx, const ValueType*\n"
  "  tuple)\n"
  "- [public] ValueType GetTypedComponent(vtkIdType tupleIdx, int\n"
  "  compIdx) const\n"
  "- [public] void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n"
  "  ValueType value)\n"
  "- [protected] bool AllocateTuples(vtkIdType numTuples)\n"
  "- [protected] bool ReallocateTuples(vtkIdType numTuples)\n\n"
  "Note that these methods use the CRTP idiom, which provides static\n"
  "binding to avoid virtual calls. This allows the compiler to optimize\n"
  "away layers of indirection when these methods are used. Well-designed\n"
  "implementations of these methods will reduce to raw memory accesses,\n"
  "providing efficient performance comparable to working with the\n"
  "pointer data.\n\n"
  "See vtkAOSDataArrayTemplate and vtkSOADataArrayTemplate for example\n"
  "implementations.\n\n"
  "In practice, code should not be written to use vtkGenericDataArray\n"
  "objects. Doing so is rather unweildy due to the CRTP pattern\n"
  "requiring the derived class be provided as a template argument.\n"
  "Instead, the vtkArrayDispatch framework can be used to detect a\n"
  "vtkDataArray's implementation type and instantiate appropriate\n"
  "templated worker code.\n\n"
  "vtkArrayDispatch is also intended to replace code that currently\n"
  "relies on the encapsulation-breaking GetVoidPointer method. Not all\n"
  "subclasses of vtkDataArray use the memory layout assumed by\n"
  "GetVoidPointer; calling this method on, e.g. a\n"
  "vtkSOADataArrayTemplate will trigger a deep copy of the array data\n"
  "into an AOS buffer. This is very inefficient and should be avoided.\n\n"
  "@sa\n"
  "vtkArrayDispatcher vtkDataArrayRange\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Type, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_Methods,
    typeid(vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>).name(),
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkDataArray_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkGenericDataArray<vtkSOADataArrayTemplate<short>, short>::VTK_DATA_TYPE);
  if (o)
  {
    PyDict_SetItemString(d, "VTK_DATA_TYPE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIsEsE_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned short tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  unsigned short temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned short> store1(2*size1);
  unsigned short *temp1 = store1.Data();
  unsigned short *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned short> store1(size1);
  unsigned short *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    unsigned short tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  int temp1;
  unsigned short temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned short *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned short *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  unsigned short temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  unsigned short temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned short> store1(size1);
  unsigned short *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<unsigned short> store0(size0);
  unsigned short *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  int temp1;
  unsigned short temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  const size_t size0 = 2;
  unsigned short temp0[2];
  unsigned short save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  const size_t size0 = 2;
  unsigned short temp0[2];
  unsigned short save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned short *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned short *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  const size_t size0 = 2;
  unsigned short temp0[2];
  unsigned short save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s5, METH_VARARGS,
   "@P *H"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  const size_t size0 = 2;
  unsigned short temp0[2];
  unsigned short save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  const size_t size0 = 2;
  unsigned short temp0[2];
  unsigned short save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned short *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned short *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  const size_t size0 = 2;
  unsigned short temp0[2];
  unsigned short save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *H"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  int temp0;
  unsigned short temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  unsigned short temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  unsigned short temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  unsigned short temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> int\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:int) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[int, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(int, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> Pointer\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:int) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:int) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(int, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(int, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[int, int], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (int, int)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[int, int]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[int, int], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (int, int)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[int, int]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:int) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_FillValue, METH_VARARGS,
   "FillValue(self, value:int) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, num:int) -> None\nC++: void SetNumberOfComponents(int num) override;\n\nSet/Get the dimension (n) of the components. Must be >= 1. Make\nsure that this is set before allocation.\n"},
  {"SetNumberOfTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetNumberOfTuples, METH_VARARGS,
   "SetNumberOfTuples(self, number:int) -> None\nC++: void SetNumberOfTuples(vtkIdType number) override;\n\nSet the number of tuples (a component group) in the array. Note\nthat this may allocate space depending on the number of\ncomponents. Also note that if allocation is performed no copy is\nperformed so existing data will be lost (if data conservation is\nsought, one may use the Resize method instead).\n"},
  {"Initialize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nRelease storage and reset array to initial state.\n"},
  {"Squeeze", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze() override;\n\nFree any unnecessary memory. Description: Resize object to just\nfit data requirement. Reclaims extra memory.\n"},
  {"SetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetTuple, METH_VARARGS,
   "SetTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void SetTuple(vtkIdType dstTupleIdx, vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nSetTuple(self, tupleIdx:int, tuple:(float, ...)) -> None\nC++: void SetTuple(vtkIdType tupleIdx, const double *tuple)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the tuple at\nsrcTupleIdx in the source array. This method assumes that the two\narrays have the same type and structure. Note that range checking\nand memory allocation is not performed; use in conjunction with\nSetNumberOfTuples() to allocate space.\n"},
  {"InsertTuplesStartingAt", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuplesStartingAt, METH_VARARGS,
   "InsertTuplesStartingAt(self, dstStart:int, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuplesStartingAt(vtkIdType dstStart,\n    vtkIdList *srcIds, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations starting at index dstStart. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuples, METH_VARARGS,
   "InsertTuples(self, dstIds:vtkIdList, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdList *dstIds, vtkIdList *srcIds,\n    vtkAbstractArray *source) override;\nInsertTuples(self, dstStart:int, n:int, srcStart:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdType dstStart, vtkIdType n,\n    vtkIdType srcStart, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations indexed by dstIds in this array. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertTuple, METH_VARARGS,
   "InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx, vtkAbstractArray *source) override;\nInsertTuple(self, tupleIdx:int, source:(float, ...)) -> None\nC++: void InsertTuple(vtkIdType tupleIdx, const double *source)\n    override;\n\nSee documentation from parent class. This method assumes that the\n`source` inherits from `vtkDataArray`, but its value type doesn't\nhave to match the type of the current instance.\n"},
  {"InsertComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertComponent, METH_VARARGS,
   "InsertComponent(self, tupleIdx:int, compIdx:int, value:float)\n    -> None\nC++: void InsertComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nInsert value at the location specified by tupleIdx and compIdx.\nNote that memory allocation is performed as necessary to hold the\ndata.\n"},
  {"InsertNextTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertNextTuple, METH_VARARGS,
   "InsertNextTuple(self, srcTupleIdx:int, source:vtkAbstractArray)\n    -> int\nC++: vtkIdType InsertNextTuple(vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nInsertNextTuple(self, tuple:(float, ...)) -> int\nC++: vtkIdType InsertNextTuple(const double *tuple) override;\n\nInsert the tuple from srcTupleIdx in the source array at the end\nof this array. Note that memory allocation is performed as\nnecessary to hold the data. Returns the tuple index at which the\ndata was inserted.\n"},
  {"GetTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuples, METH_VARARGS,
   "GetTuples(self, tupleIds:vtkIdList, output:vtkAbstractArray)\n    -> None\nC++: void GetTuples(vtkIdList *tupleIds, vtkAbstractArray *output)\n     override;\nGetTuples(self, p1:int, p2:int, output:vtkAbstractArray) -> None\nC++: void GetTuples(vtkIdType p1, vtkIdType p2,\n    vtkAbstractArray *output) override;\n\nGiven a list of tuple ids, return an array of tuples. You must\nensure that the output array has been previously allocated with\nenough space to hold the data.\n"},
  {"GetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetTuple, METH_VARARGS,
   "GetTuple(self, tupleIdx:int) -> (float, ...)\nC++: double *GetTuple(vtkIdType tupleIdx) override;\nGetTuple(self, tupleIdx:int, tuple:[float, ...]) -> None\nC++: void GetTuple(vtkIdType tupleIdx, double *tuple) override;\n\nGet the data tuple at tupleIdx. Return it as a pointer to an\narray. Note: this method is not thread-safe, and the pointer is\nonly valid as long as another method invocation to a vtk object\nis not performed.\n"},
  {"InterpolateTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InterpolateTuple, METH_VARARGS,
   "InterpolateTuple(self, dstTupleIdx:int, ptIndices:vtkIdList,\n    source:vtkAbstractArray, weights:[float, ...]) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdList *ptIndices, vtkAbstractArray *source,\n    double *weights) override;\nInterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int,\n    source1:vtkAbstractArray, srcTupleIdx2:int,\n    source2:vtkAbstractArray, t:float) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx1, vtkAbstractArray *source1,\n    vtkIdType srcTupleIdx2, vtkAbstractArray *source2, double t)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the interpolated\ntuple value, given the ptIndices in the source array and\nassociated interpolation weights. This method assumes that the\ntwo arrays are of the same type and structure.\n"},
  {"SetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetComponent, METH_VARARGS,
   "SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None\nC++: void SetComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nSet the data component at the location specified by tupleIdx and\ncompIdx to value. Note that i is less than NumberOfTuples and j\nis less than NumberOfComponents. Make sure enough memory has been\nallocated (use SetNumberOfTuples() and SetNumberOfComponents()).\n"},
  {"GetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetComponent, METH_VARARGS,
   "GetComponent(self, tupleIdx:int, compIdx:int) -> float\nC++: double GetComponent(vtkIdType tupleIdx, int compIdx)\n    override;\n\nReturn the data component at the location specified by tupleIdx\nand compIdx.\n"},
  {"SetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetVariantValue, METH_VARARGS,
   "SetVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void SetVariantValue(vtkIdType valueIdx, vtkVariant value)\n    override;\n\nSet a value in the array from a variant.  This method does NOT do\nbounds checking.\n"},
  {"GetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetVariantValue, METH_VARARGS,
   "GetVariantValue(self, valueIdx:int) -> vtkVariant\nC++: vtkVariant GetVariantValue(vtkIdType valueIdx) override;\n\nRetrieve value from the array as a variant.\n"},
  {"InsertVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_InsertVariantValue, METH_VARARGS,
   "InsertVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void InsertVariantValue(vtkIdType valueIdx, vtkVariant value)\n     override;\n\nInsert a value into the array from a variant.  This method does\nbounds checking.\n"},
  {"LookupValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupValue, METH_VARARGS,
   "LookupValue(self, value:vtkVariant) -> int\nC++: vtkIdType LookupValue(vtkVariant value) override;\nLookupValue(self, value:vtkVariant, valueIds:vtkIdList) -> None\nC++: void LookupValue(vtkVariant value, vtkIdList *valueIds)\n    override;\n\nReturn the value indices where a specific value appears.\n\n@warning Make sure that the lookup structure is not outdated.\n    Calls\nto `Modified` should be done appropriately so the array knows\nwhen to update its lookup structure.\n"},
  {"LookupTypedValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_LookupTypedValue, METH_VARARGS,
   "LookupTypedValue(self, value:int) -> int\nC++: virtual vtkIdType LookupTypedValue(ValueType value)\nLookupTypedValue(self, value:int, valueIds:vtkIdList) -> None\nC++: virtual void LookupTypedValue(ValueType value,\n    vtkIdList *valueIds)\n\n"},
  {"ClearLookup", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_ClearLookup, METH_VARARGS,
   "ClearLookup(self) -> None\nC++: void ClearLookup() override;\n\nDelete the associated fast lookup data structure on this array,\nif it exists.  The lookup will be rebuilt on the next call to a\nlookup function.\n"},
  {"DataChanged", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_DataChanged, METH_VARARGS,
   "DataChanged(self) -> None\nC++: void DataChanged() override;\n\nTell the array explicitly that the data has changed. This is only\nnecessary to call when you modify the array contents without\nusing the array's API (i.e. you retrieve a pointer to the data\nand modify the array contents).  You need to call this so that\nthe fast lookup will know to rebuild itself.  Otherwise, the\nlookup functions will give incorrect results.\n"},
  {"FillComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_FillComponent, METH_VARARGS,
   "FillComponent(self, compIdx:int, value:float) -> None\nC++: void FillComponent(int compIdx, double value) override;\n\nFill a component of a data array with a specified value. This\nmethod sets the specified component to specified value for all\ntuples in the data array.  This methods can be used to initialize\nor reinitialize a single component of a multi-component array.\n"},
  {"NewIterator", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_NewIterator, METH_VARARGS,
   "NewIterator(self) -> vtkArrayIterator\nC++: vtkArrayIterator *NewIterator() override;\n\nSubclasses must override this method and provide the right kind\nof templated vtkArrayIteratorTemplate.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("finite_value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetFiniteValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFiniteValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetDataTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetNumberOfTuples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_SetNumberOfTuples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Doc =
  "vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned\nshort> - Base interface for all typed vtkDataArray subclasses.\n\n"
  "Superclass: vtkDataArray\n\n"
  "A more detailed description of this class and related tools can be\n"
  "found\n"
  "[here](https://docs.vtk.org/en/latest/design_documents/array_dispatch.\n"
  "html)\n\n"
  "The vtkGenericDataArray class provides a generic implementation of\n"
  "the vtkDataArray API. It relies on subclasses providing access to\n"
  "data via 8 \"concept methods\", which should be implemented as\n"
  "non-virtual methods of the subclass. These methods are:\n\n"
  "- ValueType GetValue(vtkIdType valueIdx) const\n"
  "- [public] void SetValue(vtkIdType valueIdx, ValueType value)\n"
  "- [public] void GetTypedTuple(vtkIdType tupleIdx, ValueType* tuple)\n"
  "  const\n"
  "- [public] void SetTypedTuple(vtkIdType tupleIdx, const ValueType*\n"
  "  tuple)\n"
  "- [public] ValueType GetTypedComponent(vtkIdType tupleIdx, int\n"
  "  compIdx) const\n"
  "- [public] void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n"
  "  ValueType value)\n"
  "- [protected] bool AllocateTuples(vtkIdType numTuples)\n"
  "- [protected] bool ReallocateTuples(vtkIdType numTuples)\n\n"
  "Note that these methods use the CRTP idiom, which provides static\n"
  "binding to avoid virtual calls. This allows the compiler to optimize\n"
  "away layers of indirection when these methods are used. Well-designed\n"
  "implementations of these methods will reduce to raw memory accesses,\n"
  "providing efficient performance comparable to working with the\n"
  "pointer data.\n\n"
  "See vtkAOSDataArrayTemplate and vtkSOADataArrayTemplate for example\n"
  "implementations.\n\n"
  "In practice, code should not be written to use vtkGenericDataArray\n"
  "objects. Doing so is rather unweildy due to the CRTP pattern\n"
  "requiring the derived class be provided as a template argument.\n"
  "Instead, the vtkArrayDispatch framework can be used to detect a\n"
  "vtkDataArray's implementation type and instantiate appropriate\n"
  "templated worker code.\n\n"
  "vtkArrayDispatch is also intended to replace code that currently\n"
  "relies on the encapsulation-breaking GetVoidPointer method. Not all\n"
  "subclasses of vtkDataArray use the memory layout assumed by\n"
  "GetVoidPointer; calling this method on, e.g. a\n"
  "vtkSOADataArrayTemplate will trigger a deep copy of the array data\n"
  "into an AOS buffer. This is very inefficient and should be avoided.\n\n"
  "@sa\n"
  "vtkArrayDispatcher vtkDataArrayRange\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Type, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_Methods,
    typeid(vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>).name(),
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkDataArray_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned short>, unsigned short>::VTK_DATA_TYPE);
  if (o)
  {
    PyDict_SetItemString(d, "VTK_DATA_TYPE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateItEtE_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<int> store1(2*size1);
  int *temp1 = store1.Data();
  int *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<int> store1(size1);
  int *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    int tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    int *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<int> store1(size1);
  int *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(size0);
  int *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s5, METH_VARARGS,
   "@P *i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> int\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:int) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[int, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(int, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> Pointer\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:int) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:int) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(int, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(int, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[int, int], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (int, int)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[int, int]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[int, int], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (int, int)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[int, int]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:int) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_FillValue, METH_VARARGS,
   "FillValue(self, value:int) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, num:int) -> None\nC++: void SetNumberOfComponents(int num) override;\n\nSet/Get the dimension (n) of the components. Must be >= 1. Make\nsure that this is set before allocation.\n"},
  {"SetNumberOfTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetNumberOfTuples, METH_VARARGS,
   "SetNumberOfTuples(self, number:int) -> None\nC++: void SetNumberOfTuples(vtkIdType number) override;\n\nSet the number of tuples (a component group) in the array. Note\nthat this may allocate space depending on the number of\ncomponents. Also note that if allocation is performed no copy is\nperformed so existing data will be lost (if data conservation is\nsought, one may use the Resize method instead).\n"},
  {"Initialize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nRelease storage and reset array to initial state.\n"},
  {"Squeeze", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze() override;\n\nFree any unnecessary memory. Description: Resize object to just\nfit data requirement. Reclaims extra memory.\n"},
  {"SetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetTuple, METH_VARARGS,
   "SetTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void SetTuple(vtkIdType dstTupleIdx, vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nSetTuple(self, tupleIdx:int, tuple:(float, ...)) -> None\nC++: void SetTuple(vtkIdType tupleIdx, const double *tuple)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the tuple at\nsrcTupleIdx in the source array. This method assumes that the two\narrays have the same type and structure. Note that range checking\nand memory allocation is not performed; use in conjunction with\nSetNumberOfTuples() to allocate space.\n"},
  {"InsertTuplesStartingAt", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuplesStartingAt, METH_VARARGS,
   "InsertTuplesStartingAt(self, dstStart:int, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuplesStartingAt(vtkIdType dstStart,\n    vtkIdList *srcIds, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations starting at index dstStart. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuples, METH_VARARGS,
   "InsertTuples(self, dstIds:vtkIdList, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdList *dstIds, vtkIdList *srcIds,\n    vtkAbstractArray *source) override;\nInsertTuples(self, dstStart:int, n:int, srcStart:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdType dstStart, vtkIdType n,\n    vtkIdType srcStart, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations indexed by dstIds in this array. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertTuple, METH_VARARGS,
   "InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx, vtkAbstractArray *source) override;\nInsertTuple(self, tupleIdx:int, source:(float, ...)) -> None\nC++: void InsertTuple(vtkIdType tupleIdx, const double *source)\n    override;\n\nSee documentation from parent class. This method assumes that the\n`source` inherits from `vtkDataArray`, but its value type doesn't\nhave to match the type of the current instance.\n"},
  {"InsertComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertComponent, METH_VARARGS,
   "InsertComponent(self, tupleIdx:int, compIdx:int, value:float)\n    -> None\nC++: void InsertComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nInsert value at the location specified by tupleIdx and compIdx.\nNote that memory allocation is performed as necessary to hold the\ndata.\n"},
  {"InsertNextTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertNextTuple, METH_VARARGS,
   "InsertNextTuple(self, srcTupleIdx:int, source:vtkAbstractArray)\n    -> int\nC++: vtkIdType InsertNextTuple(vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nInsertNextTuple(self, tuple:(float, ...)) -> int\nC++: vtkIdType InsertNextTuple(const double *tuple) override;\n\nInsert the tuple from srcTupleIdx in the source array at the end\nof this array. Note that memory allocation is performed as\nnecessary to hold the data. Returns the tuple index at which the\ndata was inserted.\n"},
  {"GetTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuples, METH_VARARGS,
   "GetTuples(self, tupleIds:vtkIdList, output:vtkAbstractArray)\n    -> None\nC++: void GetTuples(vtkIdList *tupleIds, vtkAbstractArray *output)\n     override;\nGetTuples(self, p1:int, p2:int, output:vtkAbstractArray) -> None\nC++: void GetTuples(vtkIdType p1, vtkIdType p2,\n    vtkAbstractArray *output) override;\n\nGiven a list of tuple ids, return an array of tuples. You must\nensure that the output array has been previously allocated with\nenough space to hold the data.\n"},
  {"GetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetTuple, METH_VARARGS,
   "GetTuple(self, tupleIdx:int) -> (float, ...)\nC++: double *GetTuple(vtkIdType tupleIdx) override;\nGetTuple(self, tupleIdx:int, tuple:[float, ...]) -> None\nC++: void GetTuple(vtkIdType tupleIdx, double *tuple) override;\n\nGet the data tuple at tupleIdx. Return it as a pointer to an\narray. Note: this method is not thread-safe, and the pointer is\nonly valid as long as another method invocation to a vtk object\nis not performed.\n"},
  {"InterpolateTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InterpolateTuple, METH_VARARGS,
   "InterpolateTuple(self, dstTupleIdx:int, ptIndices:vtkIdList,\n    source:vtkAbstractArray, weights:[float, ...]) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdList *ptIndices, vtkAbstractArray *source,\n    double *weights) override;\nInterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int,\n    source1:vtkAbstractArray, srcTupleIdx2:int,\n    source2:vtkAbstractArray, t:float) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx1, vtkAbstractArray *source1,\n    vtkIdType srcTupleIdx2, vtkAbstractArray *source2, double t)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the interpolated\ntuple value, given the ptIndices in the source array and\nassociated interpolation weights. This method assumes that the\ntwo arrays are of the same type and structure.\n"},
  {"SetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetComponent, METH_VARARGS,
   "SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None\nC++: void SetComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nSet the data component at the location specified by tupleIdx and\ncompIdx to value. Note that i is less than NumberOfTuples and j\nis less than NumberOfComponents. Make sure enough memory has been\nallocated (use SetNumberOfTuples() and SetNumberOfComponents()).\n"},
  {"GetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetComponent, METH_VARARGS,
   "GetComponent(self, tupleIdx:int, compIdx:int) -> float\nC++: double GetComponent(vtkIdType tupleIdx, int compIdx)\n    override;\n\nReturn the data component at the location specified by tupleIdx\nand compIdx.\n"},
  {"SetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetVariantValue, METH_VARARGS,
   "SetVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void SetVariantValue(vtkIdType valueIdx, vtkVariant value)\n    override;\n\nSet a value in the array from a variant.  This method does NOT do\nbounds checking.\n"},
  {"GetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetVariantValue, METH_VARARGS,
   "GetVariantValue(self, valueIdx:int) -> vtkVariant\nC++: vtkVariant GetVariantValue(vtkIdType valueIdx) override;\n\nRetrieve value from the array as a variant.\n"},
  {"InsertVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_InsertVariantValue, METH_VARARGS,
   "InsertVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void InsertVariantValue(vtkIdType valueIdx, vtkVariant value)\n     override;\n\nInsert a value into the array from a variant.  This method does\nbounds checking.\n"},
  {"LookupValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupValue, METH_VARARGS,
   "LookupValue(self, value:vtkVariant) -> int\nC++: vtkIdType LookupValue(vtkVariant value) override;\nLookupValue(self, value:vtkVariant, valueIds:vtkIdList) -> None\nC++: void LookupValue(vtkVariant value, vtkIdList *valueIds)\n    override;\n\nReturn the value indices where a specific value appears.\n\n@warning Make sure that the lookup structure is not outdated.\n    Calls\nto `Modified` should be done appropriately so the array knows\nwhen to update its lookup structure.\n"},
  {"LookupTypedValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_LookupTypedValue, METH_VARARGS,
   "LookupTypedValue(self, value:int) -> int\nC++: virtual vtkIdType LookupTypedValue(ValueType value)\nLookupTypedValue(self, value:int, valueIds:vtkIdList) -> None\nC++: virtual void LookupTypedValue(ValueType value,\n    vtkIdList *valueIds)\n\n"},
  {"ClearLookup", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_ClearLookup, METH_VARARGS,
   "ClearLookup(self) -> None\nC++: void ClearLookup() override;\n\nDelete the associated fast lookup data structure on this array,\nif it exists.  The lookup will be rebuilt on the next call to a\nlookup function.\n"},
  {"DataChanged", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_DataChanged, METH_VARARGS,
   "DataChanged(self) -> None\nC++: void DataChanged() override;\n\nTell the array explicitly that the data has changed. This is only\nnecessary to call when you modify the array contents without\nusing the array's API (i.e. you retrieve a pointer to the data\nand modify the array contents).  You need to call this so that\nthe fast lookup will know to rebuild itself.  Otherwise, the\nlookup functions will give incorrect results.\n"},
  {"FillComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_FillComponent, METH_VARARGS,
   "FillComponent(self, compIdx:int, value:float) -> None\nC++: void FillComponent(int compIdx, double value) override;\n\nFill a component of a data array with a specified value. This\nmethod sets the specified component to specified value for all\ntuples in the data array.  This methods can be used to initialize\nor reinitialize a single component of a multi-component array.\n"},
  {"NewIterator", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_NewIterator, METH_VARARGS,
   "NewIterator(self) -> vtkArrayIterator\nC++: vtkArrayIterator *NewIterator() override;\n\nSubclasses must override this method and provide the right kind\nof templated vtkArrayIteratorTemplate.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("finite_value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetFiniteValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFiniteValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetDataTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetNumberOfTuples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_SetNumberOfTuples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Doc =
  "vtkGenericDataArray<vtkSOADataArrayTemplate, int> - Base interface\nfor all typed vtkDataArray subclasses.\n\n"
  "Superclass: vtkDataArray\n\n"
  "A more detailed description of this class and related tools can be\n"
  "found\n"
  "[here](https://docs.vtk.org/en/latest/design_documents/array_dispatch.\n"
  "html)\n\n"
  "The vtkGenericDataArray class provides a generic implementation of\n"
  "the vtkDataArray API. It relies on subclasses providing access to\n"
  "data via 8 \"concept methods\", which should be implemented as\n"
  "non-virtual methods of the subclass. These methods are:\n\n"
  "- ValueType GetValue(vtkIdType valueIdx) const\n"
  "- [public] void SetValue(vtkIdType valueIdx, ValueType value)\n"
  "- [public] void GetTypedTuple(vtkIdType tupleIdx, ValueType* tuple)\n"
  "  const\n"
  "- [public] void SetTypedTuple(vtkIdType tupleIdx, const ValueType*\n"
  "  tuple)\n"
  "- [public] ValueType GetTypedComponent(vtkIdType tupleIdx, int\n"
  "  compIdx) const\n"
  "- [public] void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n"
  "  ValueType value)\n"
  "- [protected] bool AllocateTuples(vtkIdType numTuples)\n"
  "- [protected] bool ReallocateTuples(vtkIdType numTuples)\n\n"
  "Note that these methods use the CRTP idiom, which provides static\n"
  "binding to avoid virtual calls. This allows the compiler to optimize\n"
  "away layers of indirection when these methods are used. Well-designed\n"
  "implementations of these methods will reduce to raw memory accesses,\n"
  "providing efficient performance comparable to working with the\n"
  "pointer data.\n\n"
  "See vtkAOSDataArrayTemplate and vtkSOADataArrayTemplate for example\n"
  "implementations.\n\n"
  "In practice, code should not be written to use vtkGenericDataArray\n"
  "objects. Doing so is rather unweildy due to the CRTP pattern\n"
  "requiring the derived class be provided as a template argument.\n"
  "Instead, the vtkArrayDispatch framework can be used to detect a\n"
  "vtkDataArray's implementation type and instantiate appropriate\n"
  "templated worker code.\n\n"
  "vtkArrayDispatch is also intended to replace code that currently\n"
  "relies on the encapsulation-breaking GetVoidPointer method. Not all\n"
  "subclasses of vtkDataArray use the memory layout assumed by\n"
  "GetVoidPointer; calling this method on, e.g. a\n"
  "vtkSOADataArrayTemplate will trigger a deep copy of the array data\n"
  "into an AOS buffer. This is very inefficient and should be avoided.\n\n"
  "@sa\n"
  "vtkArrayDispatcher vtkDataArrayRange\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Type, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_Methods,
    typeid(vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>).name(),
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkDataArray_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkGenericDataArray<vtkSOADataArrayTemplate<int>, int>::VTK_DATA_TYPE);
  if (o)
  {
    PyDict_SetItemString(d, "VTK_DATA_TYPE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIiEiE_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned int> store1(2*size1);
  unsigned int *temp1 = store1.Data();
  unsigned int *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned int> store1(size1);
  unsigned int *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  int temp1;
  unsigned int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned int *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned int *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned int> store1(size1);
  unsigned int *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<unsigned int> store0(size0);
  unsigned int *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  int temp1;
  unsigned int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  const size_t size0 = 2;
  unsigned int temp0[2];
  unsigned int save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  const size_t size0 = 2;
  unsigned int temp0[2];
  unsigned int save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned int *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  const size_t size0 = 2;
  unsigned int temp0[2];
  unsigned int save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s5, METH_VARARGS,
   "@P *I"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  const size_t size0 = 2;
  unsigned int temp0[2];
  unsigned int save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  const size_t size0 = 2;
  unsigned int temp0[2];
  unsigned int save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned int *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  const size_t size0 = 2;
  unsigned int temp0[2];
  unsigned int save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *I"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  int temp0;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  unsigned int temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> int\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:int) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[int, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(int, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> Pointer\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:int) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:int) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(int, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(int, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[int, int], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (int, int)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[int, int]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[int, int], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (int, int)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[int, int]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:int) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_FillValue, METH_VARARGS,
   "FillValue(self, value:int) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, num:int) -> None\nC++: void SetNumberOfComponents(int num) override;\n\nSet/Get the dimension (n) of the components. Must be >= 1. Make\nsure that this is set before allocation.\n"},
  {"SetNumberOfTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetNumberOfTuples, METH_VARARGS,
   "SetNumberOfTuples(self, number:int) -> None\nC++: void SetNumberOfTuples(vtkIdType number) override;\n\nSet the number of tuples (a component group) in the array. Note\nthat this may allocate space depending on the number of\ncomponents. Also note that if allocation is performed no copy is\nperformed so existing data will be lost (if data conservation is\nsought, one may use the Resize method instead).\n"},
  {"Initialize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nRelease storage and reset array to initial state.\n"},
  {"Squeeze", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze() override;\n\nFree any unnecessary memory. Description: Resize object to just\nfit data requirement. Reclaims extra memory.\n"},
  {"SetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetTuple, METH_VARARGS,
   "SetTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void SetTuple(vtkIdType dstTupleIdx, vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nSetTuple(self, tupleIdx:int, tuple:(float, ...)) -> None\nC++: void SetTuple(vtkIdType tupleIdx, const double *tuple)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the tuple at\nsrcTupleIdx in the source array. This method assumes that the two\narrays have the same type and structure. Note that range checking\nand memory allocation is not performed; use in conjunction with\nSetNumberOfTuples() to allocate space.\n"},
  {"InsertTuplesStartingAt", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuplesStartingAt, METH_VARARGS,
   "InsertTuplesStartingAt(self, dstStart:int, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuplesStartingAt(vtkIdType dstStart,\n    vtkIdList *srcIds, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations starting at index dstStart. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuples, METH_VARARGS,
   "InsertTuples(self, dstIds:vtkIdList, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdList *dstIds, vtkIdList *srcIds,\n    vtkAbstractArray *source) override;\nInsertTuples(self, dstStart:int, n:int, srcStart:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdType dstStart, vtkIdType n,\n    vtkIdType srcStart, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations indexed by dstIds in this array. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertTuple, METH_VARARGS,
   "InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx, vtkAbstractArray *source) override;\nInsertTuple(self, tupleIdx:int, source:(float, ...)) -> None\nC++: void InsertTuple(vtkIdType tupleIdx, const double *source)\n    override;\n\nSee documentation from parent class. This method assumes that the\n`source` inherits from `vtkDataArray`, but its value type doesn't\nhave to match the type of the current instance.\n"},
  {"InsertComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertComponent, METH_VARARGS,
   "InsertComponent(self, tupleIdx:int, compIdx:int, value:float)\n    -> None\nC++: void InsertComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nInsert value at the location specified by tupleIdx and compIdx.\nNote that memory allocation is performed as necessary to hold the\ndata.\n"},
  {"InsertNextTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertNextTuple, METH_VARARGS,
   "InsertNextTuple(self, srcTupleIdx:int, source:vtkAbstractArray)\n    -> int\nC++: vtkIdType InsertNextTuple(vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nInsertNextTuple(self, tuple:(float, ...)) -> int\nC++: vtkIdType InsertNextTuple(const double *tuple) override;\n\nInsert the tuple from srcTupleIdx in the source array at the end\nof this array. Note that memory allocation is performed as\nnecessary to hold the data. Returns the tuple index at which the\ndata was inserted.\n"},
  {"GetTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuples, METH_VARARGS,
   "GetTuples(self, tupleIds:vtkIdList, output:vtkAbstractArray)\n    -> None\nC++: void GetTuples(vtkIdList *tupleIds, vtkAbstractArray *output)\n     override;\nGetTuples(self, p1:int, p2:int, output:vtkAbstractArray) -> None\nC++: void GetTuples(vtkIdType p1, vtkIdType p2,\n    vtkAbstractArray *output) override;\n\nGiven a list of tuple ids, return an array of tuples. You must\nensure that the output array has been previously allocated with\nenough space to hold the data.\n"},
  {"GetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetTuple, METH_VARARGS,
   "GetTuple(self, tupleIdx:int) -> (float, ...)\nC++: double *GetTuple(vtkIdType tupleIdx) override;\nGetTuple(self, tupleIdx:int, tuple:[float, ...]) -> None\nC++: void GetTuple(vtkIdType tupleIdx, double *tuple) override;\n\nGet the data tuple at tupleIdx. Return it as a pointer to an\narray. Note: this method is not thread-safe, and the pointer is\nonly valid as long as another method invocation to a vtk object\nis not performed.\n"},
  {"InterpolateTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InterpolateTuple, METH_VARARGS,
   "InterpolateTuple(self, dstTupleIdx:int, ptIndices:vtkIdList,\n    source:vtkAbstractArray, weights:[float, ...]) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdList *ptIndices, vtkAbstractArray *source,\n    double *weights) override;\nInterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int,\n    source1:vtkAbstractArray, srcTupleIdx2:int,\n    source2:vtkAbstractArray, t:float) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx1, vtkAbstractArray *source1,\n    vtkIdType srcTupleIdx2, vtkAbstractArray *source2, double t)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the interpolated\ntuple value, given the ptIndices in the source array and\nassociated interpolation weights. This method assumes that the\ntwo arrays are of the same type and structure.\n"},
  {"SetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetComponent, METH_VARARGS,
   "SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None\nC++: void SetComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nSet the data component at the location specified by tupleIdx and\ncompIdx to value. Note that i is less than NumberOfTuples and j\nis less than NumberOfComponents. Make sure enough memory has been\nallocated (use SetNumberOfTuples() and SetNumberOfComponents()).\n"},
  {"GetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetComponent, METH_VARARGS,
   "GetComponent(self, tupleIdx:int, compIdx:int) -> float\nC++: double GetComponent(vtkIdType tupleIdx, int compIdx)\n    override;\n\nReturn the data component at the location specified by tupleIdx\nand compIdx.\n"},
  {"SetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetVariantValue, METH_VARARGS,
   "SetVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void SetVariantValue(vtkIdType valueIdx, vtkVariant value)\n    override;\n\nSet a value in the array from a variant.  This method does NOT do\nbounds checking.\n"},
  {"GetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetVariantValue, METH_VARARGS,
   "GetVariantValue(self, valueIdx:int) -> vtkVariant\nC++: vtkVariant GetVariantValue(vtkIdType valueIdx) override;\n\nRetrieve value from the array as a variant.\n"},
  {"InsertVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_InsertVariantValue, METH_VARARGS,
   "InsertVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void InsertVariantValue(vtkIdType valueIdx, vtkVariant value)\n     override;\n\nInsert a value into the array from a variant.  This method does\nbounds checking.\n"},
  {"LookupValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupValue, METH_VARARGS,
   "LookupValue(self, value:vtkVariant) -> int\nC++: vtkIdType LookupValue(vtkVariant value) override;\nLookupValue(self, value:vtkVariant, valueIds:vtkIdList) -> None\nC++: void LookupValue(vtkVariant value, vtkIdList *valueIds)\n    override;\n\nReturn the value indices where a specific value appears.\n\n@warning Make sure that the lookup structure is not outdated.\n    Calls\nto `Modified` should be done appropriately so the array knows\nwhen to update its lookup structure.\n"},
  {"LookupTypedValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_LookupTypedValue, METH_VARARGS,
   "LookupTypedValue(self, value:int) -> int\nC++: virtual vtkIdType LookupTypedValue(ValueType value)\nLookupTypedValue(self, value:int, valueIds:vtkIdList) -> None\nC++: virtual void LookupTypedValue(ValueType value,\n    vtkIdList *valueIds)\n\n"},
  {"ClearLookup", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_ClearLookup, METH_VARARGS,
   "ClearLookup(self) -> None\nC++: void ClearLookup() override;\n\nDelete the associated fast lookup data structure on this array,\nif it exists.  The lookup will be rebuilt on the next call to a\nlookup function.\n"},
  {"DataChanged", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_DataChanged, METH_VARARGS,
   "DataChanged(self) -> None\nC++: void DataChanged() override;\n\nTell the array explicitly that the data has changed. This is only\nnecessary to call when you modify the array contents without\nusing the array's API (i.e. you retrieve a pointer to the data\nand modify the array contents).  You need to call this so that\nthe fast lookup will know to rebuild itself.  Otherwise, the\nlookup functions will give incorrect results.\n"},
  {"FillComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_FillComponent, METH_VARARGS,
   "FillComponent(self, compIdx:int, value:float) -> None\nC++: void FillComponent(int compIdx, double value) override;\n\nFill a component of a data array with a specified value. This\nmethod sets the specified component to specified value for all\ntuples in the data array.  This methods can be used to initialize\nor reinitialize a single component of a multi-component array.\n"},
  {"NewIterator", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_NewIterator, METH_VARARGS,
   "NewIterator(self) -> vtkArrayIterator\nC++: vtkArrayIterator *NewIterator() override;\n\nSubclasses must override this method and provide the right kind\nof templated vtkArrayIteratorTemplate.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("finite_value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetFiniteValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFiniteValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetDataTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetNumberOfTuples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_SetNumberOfTuples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Doc =
  "vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned\nint> - Base interface for all typed vtkDataArray subclasses.\n\n"
  "Superclass: vtkDataArray\n\n"
  "A more detailed description of this class and related tools can be\n"
  "found\n"
  "[here](https://docs.vtk.org/en/latest/design_documents/array_dispatch.\n"
  "html)\n\n"
  "The vtkGenericDataArray class provides a generic implementation of\n"
  "the vtkDataArray API. It relies on subclasses providing access to\n"
  "data via 8 \"concept methods\", which should be implemented as\n"
  "non-virtual methods of the subclass. These methods are:\n\n"
  "- ValueType GetValue(vtkIdType valueIdx) const\n"
  "- [public] void SetValue(vtkIdType valueIdx, ValueType value)\n"
  "- [public] void GetTypedTuple(vtkIdType tupleIdx, ValueType* tuple)\n"
  "  const\n"
  "- [public] void SetTypedTuple(vtkIdType tupleIdx, const ValueType*\n"
  "  tuple)\n"
  "- [public] ValueType GetTypedComponent(vtkIdType tupleIdx, int\n"
  "  compIdx) const\n"
  "- [public] void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n"
  "  ValueType value)\n"
  "- [protected] bool AllocateTuples(vtkIdType numTuples)\n"
  "- [protected] bool ReallocateTuples(vtkIdType numTuples)\n\n"
  "Note that these methods use the CRTP idiom, which provides static\n"
  "binding to avoid virtual calls. This allows the compiler to optimize\n"
  "away layers of indirection when these methods are used. Well-designed\n"
  "implementations of these methods will reduce to raw memory accesses,\n"
  "providing efficient performance comparable to working with the\n"
  "pointer data.\n\n"
  "See vtkAOSDataArrayTemplate and vtkSOADataArrayTemplate for example\n"
  "implementations.\n\n"
  "In practice, code should not be written to use vtkGenericDataArray\n"
  "objects. Doing so is rather unweildy due to the CRTP pattern\n"
  "requiring the derived class be provided as a template argument.\n"
  "Instead, the vtkArrayDispatch framework can be used to detect a\n"
  "vtkDataArray's implementation type and instantiate appropriate\n"
  "templated worker code.\n\n"
  "vtkArrayDispatch is also intended to replace code that currently\n"
  "relies on the encapsulation-breaking GetVoidPointer method. Not all\n"
  "subclasses of vtkDataArray use the memory layout assumed by\n"
  "GetVoidPointer; calling this method on, e.g. a\n"
  "vtkSOADataArrayTemplate will trigger a deep copy of the array data\n"
  "into an AOS buffer. This is very inefficient and should be avoided.\n\n"
  "@sa\n"
  "vtkArrayDispatcher vtkDataArrayRange\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Type, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_Methods,
    typeid(vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>).name(),
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkDataArray_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned int>, unsigned int>::VTK_DATA_TYPE);
  if (o)
  {
    PyDict_SetItemString(d, "VTK_DATA_TYPE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIjEjE_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<long> store1(2*size1);
  long *temp1 = store1.Data();
  long *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<long> store1(size1);
  long *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    long tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  int temp1;
  long temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    long *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<long> store1(size1);
  long *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<long> store0(size0);
  long *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  int temp1;
  long temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  const size_t size0 = 2;
  long temp0[2];
  long save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  const size_t size0 = 2;
  long temp0[2];
  long save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  const size_t size0 = 2;
  long temp0[2];
  long save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s5, METH_VARARGS,
   "@P *l"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  const size_t size0 = 2;
  long temp0[2];
  long save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  const size_t size0 = 2;
  long temp0[2];
  long save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  const size_t size0 = 2;
  long temp0[2];
  long save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *l"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  int temp0;
  long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  long temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> int\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:int) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[int, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(int, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> Pointer\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:int) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:int) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(int, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(int, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[int, int], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (int, int)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[int, int]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[int, int], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (int, int)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[int, int]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:int) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_FillValue, METH_VARARGS,
   "FillValue(self, value:int) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, num:int) -> None\nC++: void SetNumberOfComponents(int num) override;\n\nSet/Get the dimension (n) of the components. Must be >= 1. Make\nsure that this is set before allocation.\n"},
  {"SetNumberOfTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetNumberOfTuples, METH_VARARGS,
   "SetNumberOfTuples(self, number:int) -> None\nC++: void SetNumberOfTuples(vtkIdType number) override;\n\nSet the number of tuples (a component group) in the array. Note\nthat this may allocate space depending on the number of\ncomponents. Also note that if allocation is performed no copy is\nperformed so existing data will be lost (if data conservation is\nsought, one may use the Resize method instead).\n"},
  {"Initialize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nRelease storage and reset array to initial state.\n"},
  {"Squeeze", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze() override;\n\nFree any unnecessary memory. Description: Resize object to just\nfit data requirement. Reclaims extra memory.\n"},
  {"SetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetTuple, METH_VARARGS,
   "SetTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void SetTuple(vtkIdType dstTupleIdx, vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nSetTuple(self, tupleIdx:int, tuple:(float, ...)) -> None\nC++: void SetTuple(vtkIdType tupleIdx, const double *tuple)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the tuple at\nsrcTupleIdx in the source array. This method assumes that the two\narrays have the same type and structure. Note that range checking\nand memory allocation is not performed; use in conjunction with\nSetNumberOfTuples() to allocate space.\n"},
  {"InsertTuplesStartingAt", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuplesStartingAt, METH_VARARGS,
   "InsertTuplesStartingAt(self, dstStart:int, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuplesStartingAt(vtkIdType dstStart,\n    vtkIdList *srcIds, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations starting at index dstStart. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuples, METH_VARARGS,
   "InsertTuples(self, dstIds:vtkIdList, srcIds:vtkIdList,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdList *dstIds, vtkIdList *srcIds,\n    vtkAbstractArray *source) override;\nInsertTuples(self, dstStart:int, n:int, srcStart:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuples(vtkIdType dstStart, vtkIdType n,\n    vtkIdType srcStart, vtkAbstractArray *source) override;\n\nCopy the tuples indexed in srcIds from the source array to the\ntuple locations indexed by dstIds in this array. Note that memory\nallocation is performed as necessary to hold the data.\n"},
  {"InsertTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertTuple, METH_VARARGS,
   "InsertTuple(self, dstTupleIdx:int, srcTupleIdx:int,\n    source:vtkAbstractArray) -> None\nC++: void InsertTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx, vtkAbstractArray *source) override;\nInsertTuple(self, tupleIdx:int, source:(float, ...)) -> None\nC++: void InsertTuple(vtkIdType tupleIdx, const double *source)\n    override;\n\nSee documentation from parent class. This method assumes that the\n`source` inherits from `vtkDataArray`, but its value type doesn't\nhave to match the type of the current instance.\n"},
  {"InsertComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertComponent, METH_VARARGS,
   "InsertComponent(self, tupleIdx:int, compIdx:int, value:float)\n    -> None\nC++: void InsertComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nInsert value at the location specified by tupleIdx and compIdx.\nNote that memory allocation is performed as necessary to hold the\ndata.\n"},
  {"InsertNextTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertNextTuple, METH_VARARGS,
   "InsertNextTuple(self, srcTupleIdx:int, source:vtkAbstractArray)\n    -> int\nC++: vtkIdType InsertNextTuple(vtkIdType srcTupleIdx,\n    vtkAbstractArray *source) override;\nInsertNextTuple(self, tuple:(float, ...)) -> int\nC++: vtkIdType InsertNextTuple(const double *tuple) override;\n\nInsert the tuple from srcTupleIdx in the source array at the end\nof this array. Note that memory allocation is performed as\nnecessary to hold the data. Returns the tuple index at which the\ndata was inserted.\n"},
  {"GetTuples", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuples, METH_VARARGS,
   "GetTuples(self, tupleIds:vtkIdList, output:vtkAbstractArray)\n    -> None\nC++: void GetTuples(vtkIdList *tupleIds, vtkAbstractArray *output)\n     override;\nGetTuples(self, p1:int, p2:int, output:vtkAbstractArray) -> None\nC++: void GetTuples(vtkIdType p1, vtkIdType p2,\n    vtkAbstractArray *output) override;\n\nGiven a list of tuple ids, return an array of tuples. You must\nensure that the output array has been previously allocated with\nenough space to hold the data.\n"},
  {"GetTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetTuple, METH_VARARGS,
   "GetTuple(self, tupleIdx:int) -> (float, ...)\nC++: double *GetTuple(vtkIdType tupleIdx) override;\nGetTuple(self, tupleIdx:int, tuple:[float, ...]) -> None\nC++: void GetTuple(vtkIdType tupleIdx, double *tuple) override;\n\nGet the data tuple at tupleIdx. Return it as a pointer to an\narray. Note: this method is not thread-safe, and the pointer is\nonly valid as long as another method invocation to a vtk object\nis not performed.\n"},
  {"InterpolateTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InterpolateTuple, METH_VARARGS,
   "InterpolateTuple(self, dstTupleIdx:int, ptIndices:vtkIdList,\n    source:vtkAbstractArray, weights:[float, ...]) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdList *ptIndices, vtkAbstractArray *source,\n    double *weights) override;\nInterpolateTuple(self, dstTupleIdx:int, srcTupleIdx1:int,\n    source1:vtkAbstractArray, srcTupleIdx2:int,\n    source2:vtkAbstractArray, t:float) -> None\nC++: void InterpolateTuple(vtkIdType dstTupleIdx,\n    vtkIdType srcTupleIdx1, vtkAbstractArray *source1,\n    vtkIdType srcTupleIdx2, vtkAbstractArray *source2, double t)\n    override;\n\nSet the tuple at dstTupleIdx in this array to the interpolated\ntuple value, given the ptIndices in the source array and\nassociated interpolation weights. This method assumes that the\ntwo arrays are of the same type and structure.\n"},
  {"SetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetComponent, METH_VARARGS,
   "SetComponent(self, tupleIdx:int, compIdx:int, value:float) -> None\nC++: void SetComponent(vtkIdType tupleIdx, int compIdx,\n    double value) override;\n\nSet the data component at the location specified by tupleIdx and\ncompIdx to value. Note that i is less than NumberOfTuples and j\nis less than NumberOfComponents. Make sure enough memory has been\nallocated (use SetNumberOfTuples() and SetNumberOfComponents()).\n"},
  {"GetComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetComponent, METH_VARARGS,
   "GetComponent(self, tupleIdx:int, compIdx:int) -> float\nC++: double GetComponent(vtkIdType tupleIdx, int compIdx)\n    override;\n\nReturn the data component at the location specified by tupleIdx\nand compIdx.\n"},
  {"SetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetVariantValue, METH_VARARGS,
   "SetVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void SetVariantValue(vtkIdType valueIdx, vtkVariant value)\n    override;\n\nSet a value in the array from a variant.  This method does NOT do\nbounds checking.\n"},
  {"GetVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetVariantValue, METH_VARARGS,
   "GetVariantValue(self, valueIdx:int) -> vtkVariant\nC++: vtkVariant GetVariantValue(vtkIdType valueIdx) override;\n\nRetrieve value from the array as a variant.\n"},
  {"InsertVariantValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_InsertVariantValue, METH_VARARGS,
   "InsertVariantValue(self, valueIdx:int, value:vtkVariant) -> None\nC++: void InsertVariantValue(vtkIdType valueIdx, vtkVariant value)\n     override;\n\nInsert a value into the array from a variant.  This method does\nbounds checking.\n"},
  {"LookupValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupValue, METH_VARARGS,
   "LookupValue(self, value:vtkVariant) -> int\nC++: vtkIdType LookupValue(vtkVariant value) override;\nLookupValue(self, value:vtkVariant, valueIds:vtkIdList) -> None\nC++: void LookupValue(vtkVariant value, vtkIdList *valueIds)\n    override;\n\nReturn the value indices where a specific value appears.\n\n@warning Make sure that the lookup structure is not outdated.\n    Calls\nto `Modified` should be done appropriately so the array knows\nwhen to update its lookup structure.\n"},
  {"LookupTypedValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_LookupTypedValue, METH_VARARGS,
   "LookupTypedValue(self, value:int) -> int\nC++: virtual vtkIdType LookupTypedValue(ValueType value)\nLookupTypedValue(self, value:int, valueIds:vtkIdList) -> None\nC++: virtual void LookupTypedValue(ValueType value,\n    vtkIdList *valueIds)\n\n"},
  {"ClearLookup", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_ClearLookup, METH_VARARGS,
   "ClearLookup(self) -> None\nC++: void ClearLookup() override;\n\nDelete the associated fast lookup data structure on this array,\nif it exists.  The lookup will be rebuilt on the next call to a\nlookup function.\n"},
  {"DataChanged", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_DataChanged, METH_VARARGS,
   "DataChanged(self) -> None\nC++: void DataChanged() override;\n\nTell the array explicitly that the data has changed. This is only\nnecessary to call when you modify the array contents without\nusing the array's API (i.e. you retrieve a pointer to the data\nand modify the array contents).  You need to call this so that\nthe fast lookup will know to rebuild itself.  Otherwise, the\nlookup functions will give incorrect results.\n"},
  {"FillComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_FillComponent, METH_VARARGS,
   "FillComponent(self, compIdx:int, value:float) -> None\nC++: void FillComponent(int compIdx, double value) override;\n\nFill a component of a data array with a specified value. This\nmethod sets the specified component to specified value for all\ntuples in the data array.  This methods can be used to initialize\nor reinitialize a single component of a multi-component array.\n"},
  {"NewIterator", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_NewIterator, METH_VARARGS,
   "NewIterator(self) -> vtkArrayIterator\nC++: vtkArrayIterator *NewIterator() override;\n\nSubclasses must override this method and provide the right kind\nof templated vtkArrayIteratorTemplate.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("finite_value_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetFiniteValueRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFiniteValueRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetDataTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetNumberOfTuples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_SetNumberOfTuples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Doc =
  "vtkGenericDataArray<vtkSOADataArrayTemplate, long> - Base interface\nfor all typed vtkDataArray subclasses.\n\n"
  "Superclass: vtkDataArray\n\n"
  "A more detailed description of this class and related tools can be\n"
  "found\n"
  "[here](https://docs.vtk.org/en/latest/design_documents/array_dispatch.\n"
  "html)\n\n"
  "The vtkGenericDataArray class provides a generic implementation of\n"
  "the vtkDataArray API. It relies on subclasses providing access to\n"
  "data via 8 \"concept methods\", which should be implemented as\n"
  "non-virtual methods of the subclass. These methods are:\n\n"
  "- ValueType GetValue(vtkIdType valueIdx) const\n"
  "- [public] void SetValue(vtkIdType valueIdx, ValueType value)\n"
  "- [public] void GetTypedTuple(vtkIdType tupleIdx, ValueType* tuple)\n"
  "  const\n"
  "- [public] void SetTypedTuple(vtkIdType tupleIdx, const ValueType*\n"
  "  tuple)\n"
  "- [public] ValueType GetTypedComponent(vtkIdType tupleIdx, int\n"
  "  compIdx) const\n"
  "- [public] void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n"
  "  ValueType value)\n"
  "- [protected] bool AllocateTuples(vtkIdType numTuples)\n"
  "- [protected] bool ReallocateTuples(vtkIdType numTuples)\n\n"
  "Note that these methods use the CRTP idiom, which provides static\n"
  "binding to avoid virtual calls. This allows the compiler to optimize\n"
  "away layers of indirection when these methods are used. Well-designed\n"
  "implementations of these methods will reduce to raw memory accesses,\n"
  "providing efficient performance comparable to working with the\n"
  "pointer data.\n\n"
  "See vtkAOSDataArrayTemplate and vtkSOADataArrayTemplate for example\n"
  "implementations.\n\n"
  "In practice, code should not be written to use vtkGenericDataArray\n"
  "objects. Doing so is rather unweildy due to the CRTP pattern\n"
  "requiring the derived class be provided as a template argument.\n"
  "Instead, the vtkArrayDispatch framework can be used to detect a\n"
  "vtkDataArray's implementation type and instantiate appropriate\n"
  "templated worker code.\n\n"
  "vtkArrayDispatch is also intended to replace code that currently\n"
  "relies on the encapsulation-breaking GetVoidPointer method. Not all\n"
  "subclasses of vtkDataArray use the memory layout assumed by\n"
  "GetVoidPointer; calling this method on, e.g. a\n"
  "vtkSOADataArrayTemplate will trigger a deep copy of the array data\n"
  "into an AOS buffer. This is very inefficient and should be avoided.\n\n"
  "@sa\n"
  "vtkArrayDispatcher vtkDataArrayRange\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonCore.vtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Type, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_Methods,
    typeid(vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>).name(),
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkDataArray_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkGenericDataArray<vtkSOADataArrayTemplate<long>, long>::VTK_DATA_TYPE);
  if (o)
  {
    PyDict_SetItemString(d, "VTK_DATA_TYPE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericDataArray_I23vtkSOADataArrayTemplateIlElE_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_ClassNew(); }

#ifndef DECLARED_PyvtkDataArray_ClassNew
extern "C" { PyObject *PyvtkDataArray_ClassNew(); }
#define DECLARED_PyvtkDataArray_ClassNew
#endif

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  unsigned long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned long> store1(2*size1);
  unsigned long *temp1 = store1.Data();
  unsigned long *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetTypedTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned long> store1(size1);
  unsigned long *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetTypedComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetTypedComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  int temp1;
  unsigned long temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetVoidPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetVoidPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned long *tempr = (ap.IsBound() ?
      op->GetPointer(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetPointer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetVoidArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetVoidArray(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetVoidArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVoidArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetVoidArray(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetVoidArray(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetVoidArray(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetVoidArray_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetVoidArray_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetVoidArray");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_WriteVoidPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteVoidPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    void  *tempr = (ap.IsBound() ?
      op->WriteVoidPointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::WriteVoidPointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_WritePointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WritePointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned long *tempr = (ap.IsBound() ?
      op->WritePointer(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::WritePointer(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_RemoveTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->RemoveTuple(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::RemoveTuple(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertNextValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  unsigned long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->InsertValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned long> store1(size1);
  unsigned long *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()))
  {
    if (ap.IsBound())
    {
      op->InsertTypedTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertTypedTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextTypedTuple(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTypedTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<unsigned long> store0(size0);
  unsigned long *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTypedTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertNextTypedTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  int temp1;
  unsigned long temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertTypedComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertTypedComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  const size_t size0 = 2;
  unsigned long temp0[2];
  unsigned long save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  const size_t size0 = 2;
  unsigned long temp0[2];
  unsigned long save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned long *tempr = (ap.IsBound() ?
      op->GetValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long *tempr = (ap.IsBound() ?
      op->GetValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  const size_t size0 = 2;
  unsigned long temp0[2];
  unsigned long save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_Methods[] = {
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s5, METH_VARARGS,
   "@P *L"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  const size_t size0 = 2;
  unsigned long temp0[2];
  unsigned long save0[2];
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned char> store2(size2);
  unsigned char *temp2 = store2.Data();
  unsigned char temp3 = 0xff;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetFiniteValueRange(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  const size_t size0 = 2;
  unsigned long temp0[2];
  unsigned long save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetFiniteValueRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned long *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetFiniteValueRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long *tempr = (ap.IsBound() ?
      op->GetFiniteValueRange() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetFiniteValueRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFiniteValueRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  const size_t size0 = 2;
  unsigned long temp0[2];
  unsigned long save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetFiniteValueRange(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetFiniteValueRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_Methods[] = {
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s3, METH_VARARGS,
   "@i"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s5, METH_VARARGS,
   "@P *L"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s2(self, args);
    case 0:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange_s4(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetFiniteValueRange");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_FillTypedComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillTypedComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  int temp0;
  unsigned long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->FillTypedComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::FillTypedComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_FillValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->FillValue(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::FillValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetDataTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataTypeSize() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetDataTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_HasStandardMemoryLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStandardMemoryLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStandardMemoryLayout() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::HasStandardMemoryLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Allocate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Allocate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  long long temp1 = 1000;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->Allocate(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::Allocate(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Resize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Resize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->Resize(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::Resize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfTuples(temp0);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetNumberOfTuples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    if (ap.IsBound())
    {
      op->SetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuplesStartingAt(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuplesStartingAt");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuplesStartingAt(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertTuplesStartingAt(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  long long temp1;
  long long temp2;
  vtkAbstractArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuples(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertTuples(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuples_s1(self, args);
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertTuple(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertTuple(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0), "0 <= tupleIdx") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->InsertComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertNextTuple(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertNextTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(size0);
  double *temp0 = store0.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0) &&
      ap.CheckSizeHint(0, size0, op->GetNumberOfComponents()))
  {
    long long tempr = (ap.IsBound() ?
      op->InsertNextTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertNextTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextTuple_s1(self, args);
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InsertNextTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuples_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  vtkIdList *temp0 = nullptr;
  vtkAbstractArray *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkIdList") &&
      ap.GetVTKObject(temp1, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetTuples(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuples_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->GetTuples(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetTuples(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuples(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuples_s1(self, args);
    case 3:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuples_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuples");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    size_t sizer = op->GetNumberOfComponents();
    double *tempr = (ap.IsBound() ?
      op->GetTuple(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetTuple(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.CheckSizeHint(1, size1, op->GetNumberOfComponents()) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfTuples()),
                      "0 <= tupleIdx && tupleIdx < GetNumberOfTuples()"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetTuple(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetTuple(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuple_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InterpolateTuple_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  vtkIdList *temp1 = nullptr;
  vtkAbstractArray *temp2 = nullptr;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList") &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InterpolateTuple(temp0, temp1, temp2, temp3);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InterpolateTuple_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InterpolateTuple");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  long long temp1;
  vtkAbstractArray *temp2 = nullptr;
  long long temp3;
  vtkAbstractArray *temp4 = nullptr;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkAbstractArray") &&
      ap.GetValue(temp3) &&
      ap.GetVTKObject(temp4, "vtkAbstractArray") &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InterpolateTuple(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InterpolateTuple(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InterpolateTuple_s1(self, args);
    case 6:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InterpolateTuple_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "InterpolateTuple");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->SetComponent(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetComponent(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && op->GetNumberOfComponents() * temp0 + temp1 < op->GetNumberOfValues()),
                      "0 <= tupleIdx && GetNumberOfComponents() * tupleIdx + compIdx < GetNumberOfValues()") &&
      ap.CheckPrecond((0 <= temp1 && temp1 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    double tempr = (ap.IsBound() ?
      op->GetComponent(temp0, temp1) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetComponent(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    if (ap.IsBound())
    {
      op->SetVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::SetVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfValues()),
                      "0 <= valueIdx && valueIdx < GetNumberOfValues()"))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->GetVariantValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::GetVariantValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertVariantValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertVariantValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  long long temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant") &&
      ap.CheckPrecond((0 <= temp0), "0 <= valueIdx"))
  {
    if (ap.IsBound())
    {
      op->InsertVariantValue(temp0, *temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::InsertVariantValue(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant"))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupValue(*temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::LookupValue(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  vtkVariant *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVariant") &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupValue(*temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::LookupValue(*temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupTypedValue_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->LookupTypedValue(temp0) :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::LookupTypedValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupTypedValue_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LookupTypedValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  unsigned long temp0;
  vtkIdList *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkIdList"))
  {
    if (ap.IsBound())
    {
      op->LookupTypedValue(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::LookupTypedValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupTypedValue(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupTypedValue_s1(self, args);
    case 2:
      return PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_LookupTypedValue_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LookupTypedValue");
  return nullptr;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_ClearLookup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLookup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLookup();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::ClearLookup();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_DataChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataChanged();
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::DataChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_FillComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.CheckPrecond((0 <= temp0 && temp0 < op->GetNumberOfComponents()),
                      "0 <= compIdx && compIdx < GetNumberOfComponents()"))
  {
    if (ap.IsBound())
    {
      op->FillComponent(temp0, temp1);
    }
    else
    {
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::FillComponent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_NewIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *op = static_cast<vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long> *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayIterator *tempr = (ap.IsBound() ?
      op->NewIterator() :
      op->vtkGenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned long>::NewIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Methods[] = {
  {"IsTypeOf", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE\nC++: static SelfType *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_NewInstance, METH_VARARGS,
   "NewInstance(self)\n    -> vtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE\nC++: SelfType *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValue, METH_VARARGS,
   "GetValue(self, valueIdx:int) -> int\nC++: ValueType GetValue(vtkIdType valueIdx)\n\nGet the value at valueIdx. valueIdx assumes AOS ordering.\n\note GetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"SetValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetValue, METH_VARARGS,
   "SetValue(self, valueIdx:int, value:int) -> None\nC++: void SetValue(vtkIdType valueIdx, ValueType value)\n\nSet the value at valueIdx to value. valueIdx assumes AOS\nordering.\n\note SetTypedComponent is preferred over this method. It is faster\nfor SOA arrays, and shows equivalent performance for AOS arrays\nwhen NumberOfComponents is known to the compiler (See\nvtkAssume.h).@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTypedTuple, METH_VARARGS,
   "GetTypedTuple(self, tupleIdx:int, tuple:[int, ...]) -> None\nC++: void GetTypedTuple(vtkIdType tupleIdx, ValueType *tuple)\n\nCopy the tuple at tupleIdx into tuple.\n\note GetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"SetTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTypedTuple, METH_VARARGS,
   "SetTypedTuple(self, tupleIdx:int, tuple:(int, ...)) -> None\nC++: void SetTypedTuple(vtkIdType tupleIdx,\n    const ValueType *tuple)\n\nSet this array's tuple at tupleIdx to the values in tuple.\n\note SetTypedComponent is preferred over this method. The overhead\nof copying the tuple is significant compared to the more\nperformant component-wise access methods, which typically\noptimize to raw memory access.@ingroup vtkGDAConceptMethods\n"},
  {"GetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetTypedComponent, METH_VARARGS,
   "GetTypedComponent(self, tupleIdx:int, compIdx:int) -> int\nC++: ValueType GetTypedComponent(vtkIdType tupleIdx, int compIdx)\n\nGet component compIdx of the tuple at tupleIdx. This is typically\nthe fastest way to access array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"SetTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetTypedComponent, METH_VARARGS,
   "SetTypedComponent(self, tupleIdx:int, compIdx:int, value:int)\n    -> None\nC++: void SetTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType value)\n\nSet component compIdx of the tuple at tupleIdx to value. This is\ntypically the fastest way to set array data.@ingroup\nvtkGDAConceptMethods\n"},
  {"GetVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetVoidPointer, METH_VARARGS,
   "GetVoidPointer(self, valueIdx:int) -> Pointer\nC++: void *GetVoidPointer(vtkIdType valueIdx) override;\n\nDefault implementation raises a runtime error. If subclasses keep\non supporting this API, they should override this method.\n"},
  {"GetPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetPointer, METH_VARARGS,
   "GetPointer(self, valueIdx:int) -> Pointer\nC++: ValueType *GetPointer(vtkIdType valueIdx)\n\n"},
  {"SetVoidArray", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetVoidArray, METH_VARARGS,
   "SetVoidArray(self, __a:Pointer, __b:int, __c:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int) override;\nSetVoidArray(self, __a:Pointer, __b:int, __c:int, __d:int) -> None\nC++: void SetVoidArray(void *, vtkIdType, int, int) override;\n\nThis method lets the user specify data to be held by the array. \nThe array argument is a pointer to the data.  size is the size of\nthe array supplied by the user.  Set save to 1 to keep the class\nfrom deleting the array when it cleans up or reallocates memory. \nThe class uses the actual array provided; it does not copy the\ndata from the supplied array. If specified, the delete method\ndetermines how the data array will be deallocated. If the delete\nmethod is VTK_DATA_ARRAY_FREE, free() will be used. If the delete\nmethod is VTK_DATA_ARRAY_DELETE, delete[] will be used. If the\ndelete method is VTK_DATA_ARRAY_ALIGNED_FREE _aligned_free() will\nbe used on windows, while free() will be used everywhere else. If\nthe delete method is VTK_DATA_ARRAY_USER_DEFINED a custom free\nfunction can be assigned to be called using SetArrayFreeFunction,\nif no custom function is assigned we will default to free(). The\ndefault is FREE. (Note not all subclasses can support\ndeleteMethod.)\n"},
  {"WriteVoidPointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_WriteVoidPointer, METH_VARARGS,
   "WriteVoidPointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: void *WriteVoidPointer(vtkIdType valueIdx,\n    vtkIdType numValues) override;\n\nGet the address of a particular data index. Make sure data is\nallocated for the number of items requested. If needed, increase\nMaxId to mark any new value ranges as in-use.\n"},
  {"WritePointer", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_WritePointer, METH_VARARGS,
   "WritePointer(self, valueIdx:int, numValues:int) -> Pointer\nC++: ValueType *WritePointer(vtkIdType valueIdx,\n    vtkIdType numValues)\n\n"},
  {"RemoveTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_RemoveTuple, METH_VARARGS,
   "RemoveTuple(self, tupleIdx:int) -> None\nC++: void RemoveTuple(vtkIdType tupleIdx) override;\n\nRemoves a tuple at the given index. Default implementation\niterates over tuples to move elements. Subclasses are encouraged\nto reimplemented this method to support faster implementations,\nif needed.\n"},
  {"InsertNextValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextValue, METH_VARARGS,
   "InsertNextValue(self, value:int) -> int\nC++: vtkIdType InsertNextValue(ValueType value)\n\nInsert data at the end of the array. Return its location in the\narray.\n"},
  {"InsertValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertValue, METH_VARARGS,
   "InsertValue(self, valueIdx:int, value:int) -> None\nC++: void InsertValue(vtkIdType valueIdx, ValueType value)\n\nInsert data at a specified position in the array.\n"},
  {"InsertTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTypedTuple, METH_VARARGS,
   "InsertTypedTuple(self, tupleIdx:int, t:(int, ...)) -> None\nC++: void InsertTypedTuple(vtkIdType tupleIdx, const ValueType *t)\n\nInsert (memory allocation performed) the tuple t at tupleIdx.\n"},
  {"InsertNextTypedTuple", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertNextTypedTuple, METH_VARARGS,
   "InsertNextTypedTuple(self, t:(int, ...)) -> int\nC++: vtkIdType InsertNextTypedTuple(const ValueType *t)\n\nInsert (memory allocation performed) the tuple onto the end of\nthe array.\n"},
  {"InsertTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_InsertTypedComponent, METH_VARARGS,
   "InsertTypedComponent(self, tupleIdx:int, compIdx:int, val:int)\n    -> None\nC++: void InsertTypedComponent(vtkIdType tupleIdx, int compIdx,\n    ValueType val)\n\nInsert (memory allocation performed) the value at the specified\ntuple and component location.\n"},
  {"GetValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetValueRange, METH_VARARGS,
   "GetValueRange(self, range:[int, int], comp:int, ghosts:(int, ...),\n     ghostsToSkip:int=0xff) -> None\nC++: void GetValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetValueRange(ValueType range[2], int comp)\nGetValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetValueRange(int comp)\nGetValueRange(self) -> (int, int)\nC++: ValueType *GetValueRange()\nGetValueRange(self, range:[int, int]) -> None\nC++: void GetValueRange(ValueType range[2])\n\nGet the range of array values for the given component in the\nnative data type.\n\nThe optional `ghosts` array is used to skip values when computing\nthe range. Values whose associated ghost matches types from\n`ghostsToSkip` are skipped. See `vtkDataSetAttributes` for a\ndefinition of ghosts.\n\n@sa\nvtkDataSetAttributes\n"},
  {"GetFiniteValueRange", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetFiniteValueRange, METH_VARARGS,
   "GetFiniteValueRange(self, range:[int, int], comp:int, ghosts:(int,\n     ...), ghostsToSkip:int=0xff) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp,\n    const unsigned char *ghosts, unsigned char ghostsToSkip=0xff)\nGetFiniteValueRange(self, range:[int, int], comp:int) -> None\nC++: void GetFiniteValueRange(ValueType range[2], int comp)\nGetFiniteValueRange(self, comp:int) -> (int, int)\nC++: ValueType *GetFiniteValueRange(int comp)\nGetFiniteValueRange(self) -> (int, int)\nC++: ValueType *GetFiniteValueRange()\nGetFiniteValueRange(self, range:[int, int]) -> None\nC++: void GetFiniteValueRange(ValueType range[2])\n\n"},
  {"Capacity", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nReturn the capacity in typeof T units of the current array. TODO\nLeftover from vtkDataArrayTemplate, redundant with GetSize.\nDeprecate?\n"},
  {"FillTypedComponent", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_FillTypedComponent, METH_VARARGS,
   "FillTypedComponent(self, compIdx:int, value:int) -> None\nC++: virtual void FillTypedComponent(int compIdx, ValueType value)\n\nSet component comp of all tuples to value.\n"},
  {"FillValue", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_FillValue, METH_VARARGS,
   "FillValue(self, value:int) -> None\nC++: virtual void FillValue(ValueType value)\n\nSet all the values in array to value.\n"},
  {"GetDataType", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: int GetDataType() override;\n\nReturn the underlying data type. An integer indicating data type\nis returned as specified in vtkType.h.\n"},
  {"GetDataTypeSize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_GetDataTypeSize, METH_VARARGS,
   "GetDataTypeSize(self) -> int\nC++: int GetDataTypeSize() override;\n\nReturn the size of the underlying data type.  For a bit, 0 is\nreturned.  For string 0 is returned. Arrays with variable length\ncomponents return 0.\n"},
  {"HasStandardMemoryLayout", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_HasStandardMemoryLayout, METH_VARARGS,
   "HasStandardMemoryLayout(self) -> bool\nC++: bool HasStandardMemoryLayout() override;\n\nReturns true if this array uses the standard memory layout\ndefined in the VTK user guide, e.g. a contiguous array: {t1c1,\nt1c2, t1c3, ... t1cM, t2c1, ... tNcM} where t1c2 is the second\ncomponent of the first tuple.\n"},
  {"Allocate", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Allocate, METH_VARARGS,
   "Allocate(self, size:int, ext:int=1000) -> int\nC++: vtkTypeBool Allocate(vtkIdType size, vtkIdType ext=1000)\n    override;\n\nAllocate memory for this array. Delete old storage only if\nnecessary. Note that ext is no longer used. This method will\nreset MaxId to -1 and resize the array capacity such that\nthis->Size >= numValues. If numValues is 0, all memory will be\nfreed. Return 1 on success, 0 on failure.\n"},
  {"Resize", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_Resize, METH_VARARGS,
   "Resize(self, numTuples:int) -> int\nC++: vtkTypeBool Resize(vtkIdType numTuples) override;\n\nResize the array to the requested number of tuples and preserve\ndata. Increasing the array size may allocate extra memory beyond\nwhat was requested. MaxId will not be modified when increasing\narray size. Decreasing the array size will trim memory to the\nrequested size and may update MaxId if the valid id range is\ntruncated. Requesting an array size of 0 will free all memory.\nReturns 1 if resizing succeeded and 0 otherwise.\n"},
  {"SetNumberOfComponents", PyvtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE_SetNumberOfComponents, METH_VARA