// java wrapper for vtkPoints2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPoints2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPoints2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPoints2D",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints2D_Allocate_14(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_Initialize_15(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetData_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints2D_GetData_17(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints2D_GetDataType_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataType_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToBit_110(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToBit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToChar_111(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToUnsignedChar_112(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToUnsignedChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToShort_113(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToUnsignedShort_114(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToInt_115(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToUnsignedInt_116(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToUnsignedInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToLong_117(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToUnsignedLong_118(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToUnsignedLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToFloat_119(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetDataTypeToDouble_120(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_Squeeze_121(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_Reset_122(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_DeepCopy_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints2D * temp0;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_ShallowCopy_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints2D * temp0;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints2D_GetActualMemorySize_125(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints2D_GetNumberOfPoints_126(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPoints2D_GetPoint_127(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_GetPoint_128(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetPoint_129(JNIEnv* env, jobject obj,jlong id0,jfloatArray id1)
{
  long long   temp0;
  float temp1[2];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetPoint_130(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetPoint_131(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_InsertPoint_132(JNIEnv* env, jobject obj,jlong id0,jfloatArray id1)
{
  long long   temp0;
  float temp1[2];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_InsertPoint_133(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_InsertPoint_134(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints2D_InsertNextPoint_135(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  long long   temp20;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints2D_InsertNextPoint_136(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPoints2D_InsertNextPoint_137(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextPoint(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_RemovePoint_138(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemovePoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_SetNumberOfPoints_139(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPoints(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPoints2D_Resize_140(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Resize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_GetPoints_141(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdList * temp0;
  vtkPoints2D * temp1;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_ComputeBounds_142(JNIEnv* env, jobject obj)
{

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPoints2D_GetBounds_143(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPoints2D_GetBounds_144(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkPoints2D* op = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPoints2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPoints2D::New());
}
