// java wrapper for vtkTriangle object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTriangle.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCell_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTriangle_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTriangle",dType)) { return me; }
  if ((res= vtkCell_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTriangle_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTriangle_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTriangle_GetEdge_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_GetCellType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_GetCellDimension_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_GetNumberOfEdges_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_GetNumberOfFaces_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTriangle_GetFace_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_CellBoundary_110(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_Contour_111(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_TriangulateLocalIds_112(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTriangle_ComputeArea_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeArea();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_Clip_114(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_InterpolationFunctions_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_InterpolationDerivs_116(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[6];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_InterpolateFunctions_117(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_InterpolateDerivs_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[6];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_GetParametricCenter_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTriangle_GetParametricDistance_120(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricDistance(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_TriangleCenter_121(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->TriangleCenter(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTriangle_TriangleArea_122(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangleArea(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTriangle_Circumcircle_123(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[2];
  double temp1[2];
  double temp2[2];
  double temp3[2];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 2, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 2, &temp3[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Circumcircle(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 2, &temp3[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_BarycentricCoords_124(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4)
{
  double temp0[2];
  double temp1[2];
  double temp2[2];
  double temp3[2];
  double temp4[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 2, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 2, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->BarycentricCoords(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_ProjectTo2D_125(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4,jdoubleArray id5)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[2];
  double temp4[2];
  double temp5[2];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 2, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 2, &temp4[0]);
  env->GetDoubleArrayRegion(id5, 0, 2, &temp5[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ProjectTo2D(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetDoubleArrayRegion(id3, 0, 2, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 2, &temp4[0]);
  env->SetDoubleArrayRegion(id5, 0, 2, &temp5[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_ComputeNormal_126(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeNormal(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_ComputeNormalDirection_127(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeNormalDirection(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_TrianglesIntersect_128(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4,jdoubleArray id5)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  double temp5[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->GetDoubleArrayRegion(id5, 0, 3, &temp5[0]);

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TrianglesIntersect(temp0,temp1,temp2,temp3,temp4,temp5);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTriangle_PointInTriangle_129(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdouble id4)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double   temp4;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  temp4 = id4;

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PointInTriangle(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTriangle_ComputeQuadric_130(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jobject id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  vtkQuadric * temp3;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  temp3 = static_cast<vtkQuadric*>(vtkJavaGetPointerFromObject(env, id3));

  vtkTriangle* op = static_cast<vtkTriangle*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeQuadric(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTriangle_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTriangle::New());
}
