// java wrapper for vtkOpenVDBReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenVDBReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPartitionedDataSetCollectionAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenVDBReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenVDBReader",dType)) { return me; }
  if ((res= vtkPartitionedDataSetCollectionAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenVDBReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenVDBReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenVDBReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenVDBReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenVDBReader_CanReadFile_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenVDBReader_GetFileExtensions_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_SetFileName_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenVDBReader_GetFileName_17(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenVDBReader_GetDescriptiveName_18(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_SetDownsamplingFactor_19(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDownsamplingFactor(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkOpenVDBReader_GetDownsamplingFactorMinValue_110(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDownsamplingFactorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkOpenVDBReader_GetDownsamplingFactorMaxValue_111(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDownsamplingFactorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkOpenVDBReader_GetDownsamplingFactor_112(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDownsamplingFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_SetMergeImageVolumes_113(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMergeImageVolumes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenVDBReader_GetMergeImageVolumes_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergeImageVolumes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_MergeImageVolumesOn_115(JNIEnv* env, jobject obj)
{

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergeImageVolumesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_MergeImageVolumesOff_116(JNIEnv* env, jobject obj)
{

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergeImageVolumesOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenVDBReader_GetMergePointSets_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergePointSets();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_SetMergePointSets_118(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMergePointSets(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_MergePointSetsOn_119(JNIEnv* env, jobject obj)
{

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergePointSetsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_MergePointSetsOff_120(JNIEnv* env, jobject obj)
{

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergePointSetsOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenVDBReader_GetGridSelection_121(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenVDBReader_GetNumberOfGridsSelectionArrays_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGridsSelectionArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenVDBReader_GetGridsSelectionArrayName_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridsSelectionArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenVDBReader_GetGridsSelectionArrayStatus_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridsSelectionArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBReader_SetGridsSelectionArrayStatus_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridsSelectionArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenVDBReader_GetGridArrayName_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenVDBReader_GetGridArrayType_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridArrayType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenVDBReader_NumberOfGrids_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenVDBReader* op = static_cast<vtkOpenVDBReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NumberOfGrids();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenVDBReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenVDBReader::New());
}
