// java wrapper for vtkVPICReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVPICReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVPICReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVPICReader",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVPICReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVPICReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVPICReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVPICReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVPICReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetStride_16(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStride(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetStride_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStride(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVPICReader_GetStride_18(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStride();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetXExtent_19(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXExtent(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetXExtent_110(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXExtent(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetYExtent_111(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYExtent(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetYExtent_112(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYExtent(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetZExtent_113(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZExtent(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetZExtent_114(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVPICReader_GetXLayout_115(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXLayout();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVPICReader_GetYLayout_116(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYLayout();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVPICReader_GetZLayout_117(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZLayout();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVPICReader_GetOutput_118(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVPICReader_GetOutput_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkImageData * temp20;
  temp0 = id0;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVPICReader_GetNumberOfPointArrays_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVPICReader_GetPointArrayName_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVPICReader_GetPointArrayStatus_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_SetPointArrayStatus_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_DisableAllPointArrays_124(JNIEnv* env, jobject obj)
{

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllPointArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVPICReader_EnableAllPointArrays_125(JNIEnv* env, jobject obj)
{

  vtkVPICReader* op = static_cast<vtkVPICReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllPointArrays();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVPICReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVPICReader::New());
}
