// java wrapper for vtkSurfaceLICInterface object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSurfaceLICInterface.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSurfaceLICInterface_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSurfaceLICInterface",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetNumberOfSteps_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfSteps(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNumberOfSteps_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetStepSize_16(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStepSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetStepSize_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStepSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetNormalizeVectors_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalizeVectors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_NormalizeVectorsOn_19(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalizeVectorsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_NormalizeVectorsOff_110(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalizeVectorsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNormalizeVectors_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalizeVectors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetMaskOnSurface_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaskOnSurface(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_MaskOnSurfaceOn_113(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->MaskOnSurfaceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_MaskOnSurfaceOff_114(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->MaskOnSurfaceOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetMaskOnSurface_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaskOnSurface();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetMaskThreshold_116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaskThreshold(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetMaskThreshold_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaskThreshold();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetMaskColor_118(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaskColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSurfaceLICInterface_GetMaskColor_119(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaskColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetMaskIntensity_120(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaskIntensity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetMaskIntensity_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaskIntensity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetEnhancedLIC_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnhancedLIC(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetEnhancedLIC_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnhancedLIC();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_EnhancedLICOn_124(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnhancedLICOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_EnhancedLICOff_125(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnhancedLICOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetEnhanceContrast_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnhanceContrast(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetEnhanceContrast_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnhanceContrast();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetLowLICContrastEnhancementFactor_128(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLowLICContrastEnhancementFactor();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetHighLICContrastEnhancementFactor_129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHighLICContrastEnhancementFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetLowLICContrastEnhancementFactor_130(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLowLICContrastEnhancementFactor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetHighLICContrastEnhancementFactor_131(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHighLICContrastEnhancementFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetLowColorContrastEnhancementFactor_132(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLowColorContrastEnhancementFactor();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetHighColorContrastEnhancementFactor_133(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHighColorContrastEnhancementFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetLowColorContrastEnhancementFactor_134(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLowColorContrastEnhancementFactor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetHighColorContrastEnhancementFactor_135(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHighColorContrastEnhancementFactor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetAntiAlias_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAntiAlias(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_AntiAliasOn_137(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->AntiAliasOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_AntiAliasOff_138(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->AntiAliasOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetAntiAlias_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAntiAlias();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetColorMode_140(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetColorMode_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetLICIntensity_142(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLICIntensity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetLICIntensity_143(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLICIntensity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetMapModeBias_144(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMapModeBias(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetMapModeBias_145(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapModeBias();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetNoiseDataSet_146(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNoiseDataSet(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNoiseDataSet_147(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNoiseDataSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetGenerateNoiseTexture_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateNoiseTexture(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetGenerateNoiseTexture_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateNoiseTexture();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetNoiseType_150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNoiseType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNoiseType_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNoiseType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetNoiseTextureSize_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNoiseTextureSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNoiseTextureSize_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNoiseTextureSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetNoiseGrainSize_154(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNoiseGrainSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNoiseGrainSize_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNoiseGrainSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetMinNoiseValue_156(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinNoiseValue(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetMaxNoiseValue_157(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxNoiseValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetMinNoiseValue_158(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinNoiseValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetMaxNoiseValue_159(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNoiseValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetNumberOfNoiseLevels_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfNoiseLevels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNumberOfNoiseLevels_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNoiseLevels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetImpulseNoiseProbability_162(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImpulseNoiseProbability(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetImpulseNoiseProbability_163(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImpulseNoiseProbability();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetImpulseNoiseBackgroundValue_164(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImpulseNoiseBackgroundValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSurfaceLICInterface_GetImpulseNoiseBackgroundValue_165(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImpulseNoiseBackgroundValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetNoiseGeneratorSeed_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNoiseGeneratorSeed(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetNoiseGeneratorSeed_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNoiseGeneratorSeed();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetCompositeStrategy_168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompositeStrategy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetCompositeStrategy_169(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompositeStrategy();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSurfaceLICInterface_IsSupported_170(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  bool   temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_WriteTimerLog_171(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteTimerLog(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_ShallowCopy_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSurfaceLICInterface * temp0;
  temp0 = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_ReleaseGraphicsResources_173(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSurfaceLICInterface_CanRenderSurfaceLIC_174(JNIEnv* env, jobject obj,jobject id0)
{
  vtkActor * temp0;
  bool   temp20;
  temp0 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanRenderSurfaceLIC(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_ValidateContext_175(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->ValidateContext(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_CreateCommunicator_176(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  vtkDataObject * temp2;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id2));

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateCommunicator(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_UpdateCommunicator_177(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  vtkDataObject * temp2;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id2));

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateCommunicator(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetHasVectors_178(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHasVectors(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSurfaceLICInterface_GetHasVectors_179(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHasVectors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_InitializeResources_180(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeResources();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_PrepareForGeometry_181(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrepareForGeometry();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_CompletedGeometry_182(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->CompletedGeometry();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_GatherVectors_183(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->GatherVectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_ApplyLIC_184(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyLIC();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_CombineColorsAndLIC_185(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->CombineColorsAndLIC();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_CopyToScreen_186(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyToScreen();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_SetEnable_187(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnable(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSurfaceLICInterface_GetEnable_188(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_EnableOn_189(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSurfaceLICInterface_EnableOff_190(JNIEnv* env, jobject obj)
{

  vtkSurfaceLICInterface* op = static_cast<vtkSurfaceLICInterface*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSurfaceLICInterface_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSurfaceLICInterface::New());
}
