// java wrapper for vtkDataTransferHelper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataTransferHelper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataTransferHelper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataTransferHelper",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataTransferHelper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataTransferHelper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataTransferHelper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataTransferHelper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetContext_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContext(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataTransferHelper_GetContext_15(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContext();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetCPUExtent_16(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCPUExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetCPUExtent_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCPUExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkDataTransferHelper_GetCPUExtent_18(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCPUExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetGPUExtent_19(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGPUExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetGPUExtent_110(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGPUExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkDataTransferHelper_GetGPUExtent_111(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGPUExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetTextureExtent_112(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetTextureExtent_113(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkDataTransferHelper_GetTextureExtent_114(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataTransferHelper_GetCPUExtentIsValid_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCPUExtentIsValid();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataTransferHelper_GetGPUExtentIsValid_116(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGPUExtentIsValid();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataTransferHelper_GetTextureExtentIsValid_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureExtentIsValid();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetMinTextureDimension_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinTextureDimension(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataTransferHelper_GetMinTextureDimension_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinTextureDimension();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataTransferHelper_GetArray_120(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetArray_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArray(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataTransferHelper_GetTexture_122(JNIEnv* env, jobject obj)
{
  vtkTextureObject * temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetTexture_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextureObject * temp0;
  temp0 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTexture(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataTransferHelper_Download_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Download();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataTransferHelper_DownloadAsync1_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DownloadAsync1();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataTransferHelper_DownloadAsync2_126(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DownloadAsync2();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataTransferHelper_GetShaderSupportsTextureInt_127(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShaderSupportsTextureInt();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataTransferHelper_SetShaderSupportsTextureInt_128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShaderSupportsTextureInt(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataTransferHelper_IsSupported_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  bool   temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataTransferHelper* op = static_cast<vtkDataTransferHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataTransferHelper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataTransferHelper::New());
}
