﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/awstransfer/model/DescribedAgreement.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Transfer {
namespace Model {
class DescribeAgreementResult {
 public:
  AWS_TRANSFER_API DescribeAgreementResult() = default;
  AWS_TRANSFER_API DescribeAgreementResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TRANSFER_API DescribeAgreementResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The details for the specified agreement, returned as a
   * <code>DescribedAgreement</code> object.</p>
   */
  inline const DescribedAgreement& GetAgreement() const { return m_agreement; }
  template <typename AgreementT = DescribedAgreement>
  void SetAgreement(AgreementT&& value) {
    m_agreementHasBeenSet = true;
    m_agreement = std::forward<AgreementT>(value);
  }
  template <typename AgreementT = DescribedAgreement>
  DescribeAgreementResult& WithAgreement(AgreementT&& value) {
    SetAgreement(std::forward<AgreementT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeAgreementResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  DescribedAgreement m_agreement;

  Aws::String m_requestId;
  bool m_agreementHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Transfer
}  // namespace Aws
