﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/BatchPutPropertyErrorEntry.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {
class BatchPutPropertyValuesResult {
 public:
  AWS_IOTTWINMAKER_API BatchPutPropertyValuesResult() = default;
  AWS_IOTTWINMAKER_API BatchPutPropertyValuesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTTWINMAKER_API BatchPutPropertyValuesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Entries that caused errors in the batch put operation.</p>
   */
  inline const Aws::Vector<BatchPutPropertyErrorEntry>& GetErrorEntries() const { return m_errorEntries; }
  template <typename ErrorEntriesT = Aws::Vector<BatchPutPropertyErrorEntry>>
  void SetErrorEntries(ErrorEntriesT&& value) {
    m_errorEntriesHasBeenSet = true;
    m_errorEntries = std::forward<ErrorEntriesT>(value);
  }
  template <typename ErrorEntriesT = Aws::Vector<BatchPutPropertyErrorEntry>>
  BatchPutPropertyValuesResult& WithErrorEntries(ErrorEntriesT&& value) {
    SetErrorEntries(std::forward<ErrorEntriesT>(value));
    return *this;
  }
  template <typename ErrorEntriesT = BatchPutPropertyErrorEntry>
  BatchPutPropertyValuesResult& AddErrorEntries(ErrorEntriesT&& value) {
    m_errorEntriesHasBeenSet = true;
    m_errorEntries.emplace_back(std::forward<ErrorEntriesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  BatchPutPropertyValuesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<BatchPutPropertyErrorEntry> m_errorEntries;

  Aws::String m_requestId;
  bool m_errorEntriesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
