/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtImplementationDetail;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;

public class KotlinModifierListStubImpl
extends KotlinStubBaseImpl<KtDeclarationModifierList>
implements KotlinModifierListStub {
    private final long mask;

    public KotlinModifierListStubImpl(@Nullable StubElement<?> parent, long mask) {
        super(parent, KtStubElementTypes.MODIFIER_LIST);
        this.mask = mask;
    }

    public long getMask() {
        return this.mask;
    }

    @Override
    public boolean hasModifier(@NotNull KtModifierKeywordToken modifierToken) {
        if (modifierToken == null) {
            KotlinModifierListStubImpl.$$$reportNull$$$0(0);
        }
        return ModifierMaskUtils.maskHasModifier(this.mask, modifierToken);
    }

    @Override
    public boolean hasSpecialFlag(@NotNull KotlinModifierListStub.SpecialFlag flag) {
        if (flag == null) {
            KotlinModifierListStubImpl.$$$reportNull$$$0(1);
        }
        return ModifierMaskUtils.maskHasSpecialFlag(this.mask, flag);
    }

    @Override
    @NotNull
    public String toString() {
        String string = super.toString() + ModifierMaskUtils.maskToString(this.mask);
        if (string == null) {
            KotlinModifierListStubImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean hasAnyModifier() {
        return this.mask != 0L;
    }

    @KtImplementationDetail
    @NotNull
    public KotlinModifierListStubImpl copyInto(@Nullable StubElement<?> newParent) {
        return new KotlinModifierListStubImpl(newParent, this.mask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierToken";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/stubs/impl/KotlinModifierListStubImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/impl/KotlinModifierListStubImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasSpecialFlag";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

