/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.Setup;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u0013\u001a\u00020\u0007J\b\u0010\u0014\u001a\u00020\u0007H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/skiko/Library;", "", "<init>", "()V", "copyDir", "Ljava/io/File;", "loadLibraryOrCopy", "", "library", "unpackIfNeeded", "dest", "resourceName", "", "deleteOnExit", "", "loadingLock", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/locks/ReentrantLock;", "kotlin.jvm.PlatformType", "load", "findAndLoad", "skiko"})
@SourceDebugExtension(value={"SMAP\nLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Library.kt\norg/jetbrains/skiko/Library\n+ 2 Library.kt\norg/jetbrains/skiko/LibraryKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n176#2,6:185\n1#3:191\n*S KotlinDebug\n*F\n+ 1 Library.kt\norg/jetbrains/skiko/Library\n*L\n43#1:185,6\n*E\n"})
public final class Library {
    @NotNull
    public static final Library INSTANCE = new Library();
    @Nullable
    private static File copyDir;
    @NotNull
    private static final AtomicReference<ReentrantLock> loadingLock;

    private Library() {
    }

    private final void loadLibraryOrCopy(File library) {
        try {
            System.load(library.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already loaded in another classloader", (boolean)false, (int)2, null) : false;
            if (bl) {
                File file = copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)file);
                String string2 = library.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                File tempFile = FilesKt.resolve((File)file, (String)string2);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(library.toPath(), tempFile.toPath(), copyOptionArray);
                tempFile.deleteOnExit();
                System.load(tempFile.getAbsolutePath());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File unpackIfNeeded(File dest, String resourceName, boolean deleteOnExit) {
        File file = new File(dest, resourceName);
        if (!file.exists()) {
            Path path = FilesKt.resolve((File)dest, (String)".lock").toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path path$iv = path;
            boolean $i$f$withFileLock = false;
            PathsKt.createParentDirectories((Path)path$iv, (FileAttribute[])new FileAttribute[0]);
            Object object = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
            object = FileChannel.open(path$iv, object);
            Throwable throwable = null;
            try {
                Path path2;
                FileChannel channel$iv = (FileChannel)object;
                boolean bl = false;
                FileLock lock$iv = channel$iv.lock();
                AutoCloseable autoCloseable = lock$iv;
                Throwable throwable2 = null;
                try {
                    FileLock it$iv = (FileLock)autoCloseable;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (file.exists()) {
                        File file2 = file;
                        File file3 = file2;
                        return file3;
                    }
                    File tempFile = File.createTempFile("skiko", "", dest);
                    if (deleteOnExit) {
                        file.deleteOnExit();
                    }
                    CopyOption[] copyOptionArray = (CopyOption[])Library.class.getResourceAsStream('/' + resourceName);
                    Throwable throwable3 = null;
                    try {
                        InputStream input = (InputStream)copyOptionArray;
                        boolean bl4 = false;
                        CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        long l = Files.copy(input, tempFile.toPath(), copyOptionArray2);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)copyOptionArray, (Throwable)throwable3);
                    }
                    copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                    path2 = Files.move(tempFile.toPath(), file.toPath(), copyOptionArray);
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                Path path3 = path2;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        ReentrantLock reentrantLock = loadingLock.get();
        if (reentrantLock == null) {
            return;
        }
        ReentrantLock lock = reentrantLock;
        if (lock.isHeldByCurrentThread()) {
            return;
        }
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            if (loadingLock.get() != lock) {
                return;
            }
            INSTANCE.findAndLoad();
            Setup.init$default(Setup.INSTANCE, false, false, false, false, false, 31, null);
            try {
                org.jetbrains.skia.impl.Library.Companion._nAfterLoad();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                loadingLock.compareAndSet(lock, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findAndLoad() {
        String string;
        String icu;
        String name = "skiko-" + OsArch_jvmKt.getHostId();
        String platformName = System.mapLibraryName(name);
        String string2 = icu = OsArch_jvmKt.getHostOs().isWindows() ? "icudtl.dat" : null;
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary("skiko-" + OsArch_jvmKt.getHostId());
            return;
        }
        String skikoLibraryPath = SkikoProperties.INSTANCE.getLibraryPath();
        if (skikoLibraryPath != null) {
            File library = new File(new File(skikoLibraryPath), platformName);
            this.loadLibraryOrCopy(library);
            if (icu != null && copyDir != null) {
                File file = copyDir;
                Intrinsics.checkNotNull((Object)file);
                this.unpackIfNeeded(file, icu, true);
            }
            return;
        }
        File jvmFiles = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNull((Object)platformName);
        File pathInJvm = FilesKt.resolve((File)jvmFiles, (String)platformName);
        if (pathInJvm.exists()) {
            boolean bl;
            String string3 = icu;
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                bl = !FilesKt.resolve((File)jvmFiles, (String)it).exists();
            } else {
                bl = false;
            }
            if (!bl) {
                this.loadLibraryOrCopy(pathInJvm);
                return;
            }
        }
        InputStream inputStream = Library.class.getResourceAsStream('/' + platformName + ".sha256");
        if (inputStream == null) {
            throw new LibraryLoadException("Cannot find " + platformName + ".sha256, proper native dependency missing.");
        }
        InputStream hashResourceStream = inputStream;
        AutoCloseable bl2 = hashResourceStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)bl2;
            boolean bl = false;
            InputStream inputStream2 = it;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            string = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)bl2, (Throwable)throwable);
        }
        String hash = string;
        File dataDir = new File(new File(SkikoProperties.INSTANCE.getDataPath()), hash);
        dataDir.mkdirs();
        File library = this.unpackIfNeeded(dataDir, platformName, false);
        this.loadLibraryOrCopy(library);
        if (icu != null) {
            File file;
            if (copyDir != null) {
                File file2 = copyDir;
                Intrinsics.checkNotNull((Object)file2);
                file = this.unpackIfNeeded(file2, icu, true);
            } else {
                file = this.unpackIfNeeded(dataDir, icu, false);
            }
        }
    }

    static {
        loadingLock = new AtomicReference<ReentrantLock>(new ReentrantLock());
    }
}

