/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenResource;

public class MavenSource
implements Serializable {
    public static final String MAIN_SCOPE = "main";
    public static final String TEST_SCOPE = "test";
    public static final String JAVA_LANG = "java";
    public static final String RESOURCES_LANG = "resources";
    @NotNull
    private final String myDirectory;
    private final ArrayList<String> myIncludes;
    private final ArrayList<String> myExcludes;
    private final String myScope;
    private final String myLang;
    private final String myTargetPath;
    private final String myTargetVersion;
    private final boolean myFiltered;
    private final boolean myEnabled;
    private final boolean myIsSourceTag;

    private MavenSource(boolean isSourceTag, @NotNull String directory, List<String> includes, List<String> excludes, String scope, String lang, String targetPath, String targetVersion, boolean filtered, boolean enabled) {
        if (directory == null) {
            MavenSource.$$$reportNull$$$0(0);
        }
        this.myIsSourceTag = isSourceTag;
        this.myDirectory = directory;
        this.myIncludes = new ArrayList<String>(includes);
        this.myExcludes = new ArrayList<String>(excludes);
        this.myScope = scope;
        this.myLang = lang;
        this.myTargetPath = targetPath;
        this.myTargetVersion = targetVersion;
        this.myFiltered = filtered;
        this.myEnabled = enabled;
    }

    @NotNull
    public String getDirectory() {
        String string = this.myDirectory;
        if (string == null) {
            MavenSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    public List<String> getIncludes() {
        return this.myIncludes;
    }

    public List<String> getExcludes() {
        return this.myExcludes;
    }

    public String getScope() {
        return this.myScope;
    }

    public String getLang() {
        return this.myLang;
    }

    public String getTargetPath() {
        return this.myTargetPath;
    }

    public String getTargetVersion() {
        return this.myTargetVersion;
    }

    public boolean isFiltered() {
        return this.myFiltered;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isFromSourceTag() {
        return this.myIsSourceTag;
    }

    public MavenSource withNewDirectory(@NotNull String newDir) {
        if (newDir == null) {
            MavenSource.$$$reportNull$$$0(2);
        }
        return new MavenSource(this.myIsSourceTag, newDir, this.myIncludes, this.myExcludes, this.myScope, this.myLang, this.myTargetPath, this.myTargetVersion, this.myFiltered, this.myEnabled);
    }

    public static boolean isSource(MavenSource src) {
        return src.isEnabled() && (src.getScope() == null || src.getScope().equals(MAIN_SCOPE)) && JAVA_LANG.equals(src.getLang());
    }

    public static boolean isTestSource(MavenSource src) {
        return src.isEnabled() && src.getScope().equals(TEST_SCOPE) && JAVA_LANG.equals(src.getLang());
    }

    public static boolean isResource(MavenSource src) {
        return src.isEnabled() && (src.getScope() == null || src.getScope().equals(MAIN_SCOPE)) && RESOURCES_LANG.equals(src.getLang());
    }

    public static boolean isTestResource(MavenSource src) {
        return src.isEnabled() && src.getScope().equals(TEST_SCOPE) && RESOURCES_LANG.equals(src.getLang());
    }

    @NotNull
    public static MavenSource fromSrc(@NotNull String dir, boolean forTests) {
        if (dir == null) {
            MavenSource.$$$reportNull$$$0(3);
        }
        return new MavenSource(false, dir, Collections.emptyList(), Collections.emptyList(), forTests ? TEST_SCOPE : MAIN_SCOPE, JAVA_LANG, null, null, false, true);
    }

    @NotNull
    public static MavenSource fromResource(MavenResource resource, boolean forTests) {
        return new MavenSource(false, resource.getDirectory(), resource.getIncludes(), resource.getExcludes(), forTests ? TEST_SCOPE : MAIN_SCOPE, RESOURCES_LANG, resource.getTargetPath(), null, resource.isFiltered(), true);
    }

    public static MavenSource fromSourceTag(@NotNull String directory, List<String> includes, List<String> excludes, String scope, String lang, String targetPath, String targetVersion, boolean filtered, boolean enabled) {
        if (directory == null) {
            MavenSource.$$$reportNull$$$0(4);
        }
        return new MavenSource(true, directory, includes, excludes, scope, lang, targetPath, targetVersion, filtered, enabled);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSource)) {
            return false;
        }
        MavenSource source = (MavenSource)o;
        return this.myFiltered == source.myFiltered && this.myEnabled == source.myEnabled && Objects.equals(this.myDirectory, source.myDirectory) && Objects.equals(this.myIncludes, source.myIncludes) && Objects.equals(this.myExcludes, source.myExcludes) && Objects.equals(this.myScope, source.myScope) && Objects.equals(this.myLang, source.myLang) && Objects.equals(this.myTargetPath, source.myTargetPath) && Objects.equals(this.myTargetVersion, source.myTargetVersion);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.myDirectory);
        result = 31 * result + Objects.hashCode(this.myIncludes);
        result = 31 * result + Objects.hashCode(this.myExcludes);
        result = 31 * result + Objects.hashCode(this.myScope);
        result = 31 * result + Objects.hashCode(this.myLang);
        result = 31 * result + Objects.hashCode(this.myTargetPath);
        result = 31 * result + Objects.hashCode(this.myTargetVersion);
        result = 31 * result + Boolean.hashCode(this.myFiltered);
        result = 31 * result + Boolean.hashCode(this.myEnabled);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/model/MavenSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/model/MavenSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withNewDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromSrc";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromSourceTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

