/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.properties;

public enum MetaPropertiesVersion {
    V0(0),
    V1(1);

    private final int number;

    public static MetaPropertiesVersion fromNumberString(String numberString) {
        int number;
        try {
            number = Integer.parseInt(numberString.trim());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid meta.properties version string '" + numberString + "'");
        }
        return MetaPropertiesVersion.fromNumber(number);
    }

    public static MetaPropertiesVersion fromNumber(int number) {
        return switch (number) {
            case 0 -> V0;
            case 1 -> V1;
            default -> throw new RuntimeException("Unknown meta.properties version number " + number);
        };
    }

    private MetaPropertiesVersion(int number) {
        this.number = number;
    }

    public int number() {
        return this.number;
    }

    public String numberString() {
        return Integer.toString(this.number);
    }

    public boolean hasBrokerId() {
        return this == V0;
    }

    public boolean alwaysHasNodeId() {
        return this != V0;
    }

    public boolean alwaysHasClusterId() {
        return this != V0;
    }
}

