/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.util.Objects;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.chart.util.Args;

public abstract class Tick
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6668230383875149773L;
    private String text;
    private TextAnchor textAnchor;
    private TextAnchor rotationAnchor;
    private double angle;

    public Tick(String text, TextAnchor textAnchor, TextAnchor rotationAnchor, double angle) {
        Args.nullNotPermitted(textAnchor, "textAnchor");
        Args.nullNotPermitted(rotationAnchor, "rotationAnchor");
        this.text = text;
        this.textAnchor = textAnchor;
        this.rotationAnchor = rotationAnchor;
        this.angle = angle;
    }

    public String getText() {
        return this.text;
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tick)) {
            return false;
        }
        Tick that = (Tick)obj;
        if (Double.doubleToLongBits(this.angle) != Double.doubleToLongBits(that.angle)) {
            return false;
        }
        if (!Objects.equals(this.text, that.text)) {
            return false;
        }
        if (!Objects.equals(this.textAnchor, that.textAnchor)) {
            return false;
        }
        if (!Objects.equals(this.rotationAnchor, that.rotationAnchor)) {
            return false;
        }
        return that.canEqual(this);
    }

    public boolean canEqual(Object other) {
        return other instanceof Tick;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.text);
        hash = 79 * hash + Objects.hashCode(this.textAnchor);
        hash = 79 * hash + Objects.hashCode(this.rotationAnchor);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.angle) ^ Double.doubleToLongBits(this.angle) >>> 32);
        return hash;
    }

    public Object clone() throws CloneNotSupportedException {
        Tick clone = (Tick)super.clone();
        return clone;
    }

    public String toString() {
        return this.text;
    }
}

