/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.dangling.delete;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.clustermanager.AcknowledgedRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="1.0.0")
public class DeleteDanglingIndexRequest
extends AcknowledgedRequest<DeleteDanglingIndexRequest> {
    private final String indexUUID;
    private final boolean acceptDataLoss;

    public DeleteDanglingIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.indexUUID = in.readString();
        this.acceptDataLoss = in.readBoolean();
    }

    public DeleteDanglingIndexRequest(String indexUUID, boolean acceptDataLoss) {
        this.indexUUID = Objects.requireNonNull(indexUUID, "indexUUID cannot be null");
        this.acceptDataLoss = acceptDataLoss;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getIndexUUID() {
        return this.indexUUID;
    }

    public boolean isAcceptDataLoss() {
        return this.acceptDataLoss;
    }

    public String toString() {
        return "DeleteDanglingIndexRequest{indexUUID='" + this.indexUUID + "', acceptDataLoss=" + this.acceptDataLoss + "}";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.indexUUID);
        out.writeBoolean(this.acceptDataLoss);
    }
}

