/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.common.lucene.store.IndexOutputOutputStream;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.OutputStreamStreamOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.compress.CompressorRegistry;
import org.opensearch.gateway.CorruptStateException;

public class ChecksumWritableBlobStoreFormat<T extends Writeable> {
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    private final String codec;
    private final CheckedFunction<StreamInput, T, IOException> reader;
    private final Version opensearchVersion;

    public ChecksumWritableBlobStoreFormat(String codec, CheckedFunction<StreamInput, T, IOException> reader) {
        this(codec, reader, Version.CURRENT);
    }

    public ChecksumWritableBlobStoreFormat(String codec, CheckedFunction<StreamInput, T, IOException> reader, Version opensearchVersion) {
        this.codec = codec;
        this.reader = reader;
        this.opensearchVersion = opensearchVersion;
    }

    public BytesReference serialize(T obj, String blobName, Compressor compressor) throws IOException {
        return this.serialize((out, unSerializedObj) -> unSerializedObj.writeTo(out), obj, blobName, compressor);
    }

    public BytesReference serialize(Writeable.Writer<T> writer, T obj, String blobName, Compressor compressor) throws IOException {
        try (BytesStreamOutput outputStream = new BytesStreamOutput();){
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")", blobName, (OutputStream)((Object)outputStream), 4096);){
                CodecUtil.writeHeader((DataOutput)indexOutput, (String)this.codec, (int)1);
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream(this, (IndexOutput)indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };
                     OutputStreamStreamOutput stream = new OutputStreamStreamOutput(compressor.threadLocalOutputStream((OutputStream)indexOutputOutputStream));){
                    stream.setVersion(Version.CURRENT);
                    writer.write((StreamOutput)stream, obj);
                }
                CodecUtil.writeFooter((IndexOutput)indexOutput);
            }
            BytesReference bytesReference = outputStream.bytes();
            return bytesReference;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String blobName, BytesReference bytes) throws IOException {
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try {
            Object indexInput = bytes.length() > 0 ? new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(BytesReference.toByteBuffers((BytesReference)bytes))), resourceDesc) : new ByteArrayIndexInput(resourceDesc, BytesRef.EMPTY_BYTES);
            CodecUtil.checksumEntireFile((IndexInput)indexInput);
            CodecUtil.checkHeader((DataInput)indexInput, (String)this.codec, (int)1, (int)1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            BytesReference bytesReference = bytes.slice((int)filePointer, (int)contentSize);
            Compressor compressor = CompressorRegistry.compressorForWritable((BytesReference)bytesReference);
            try (InputStreamStreamInput in = new InputStreamStreamInput(compressor.threadLocalInputStream((InputStream)bytesReference.streamInput()));){
                in.setVersion(this.opensearchVersion);
                Writeable writeable = (Writeable)this.reader.apply((Object)in);
                return (T)writeable;
            }
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }
}

