/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.fetch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opensearch.search.profile.ProfileResult;
import org.opensearch.search.profile.fetch.FetchProfileBreakdown;
import org.opensearch.search.profile.fetch.FetchTimingType;

class FlatFetchProfileTree {
    private static final Set<String> ROOT_KEYS = Set.of(FetchTimingType.CREATE_STORED_FIELDS_VISITOR.toString(), FetchTimingType.CREATE_STORED_FIELDS_VISITOR.toString() + "_count", FetchTimingType.BUILD_SUB_PHASE_PROCESSORS.toString(), FetchTimingType.BUILD_SUB_PHASE_PROCESSORS.toString() + "_count", FetchTimingType.LOAD_STORED_FIELDS.toString(), FetchTimingType.LOAD_STORED_FIELDS.toString() + "_count", FetchTimingType.LOAD_SOURCE.toString(), FetchTimingType.LOAD_SOURCE.toString() + "_count", FetchTimingType.GET_NEXT_READER.toString(), FetchTimingType.GET_NEXT_READER.toString() + "_count");
    private static final Set<String> SUB_PHASE_KEYS = Set.of(FetchTimingType.PROCESS.toString(), FetchTimingType.PROCESS.toString() + "_count", FetchTimingType.SET_NEXT_READER.toString(), FetchTimingType.SET_NEXT_READER.toString() + "_count");
    private final List<Node> roots = new ArrayList<Node>();
    private final ConcurrentMap<String, Node> rootsMap = new ConcurrentHashMap<String, Node>();
    private final ConcurrentMap<String, Node> phaseMap = new ConcurrentHashMap<String, Node>();

    FlatFetchProfileTree() {
    }

    FetchProfileBreakdown startFetchPhase(String element) {
        String uniqueElement = element + "_" + Thread.currentThread().threadId();
        Node node = (Node)this.rootsMap.get(uniqueElement);
        if (node == null) {
            node = new Node(element);
            this.roots.add(node);
            this.rootsMap.put(uniqueElement, node);
        }
        ++node.references;
        this.phaseMap.put(uniqueElement, node);
        return node.breakdown;
    }

    FetchProfileBreakdown startSubPhase(String element, String parentElement) {
        String uniqueParentElement = parentElement + "_" + Thread.currentThread().threadId();
        String uniqueElement = element + "_" + Thread.currentThread().threadId();
        Node parent = (Node)this.phaseMap.get(uniqueParentElement);
        if (parent == null) {
            throw new IllegalStateException("Parent phase '" + parentElement + "' does not exist for sub-phase '" + element + "'");
        }
        Node child = null;
        for (Node existing : parent.children) {
            if (!existing.element.equals(element)) continue;
            child = existing;
            break;
        }
        if (child == null) {
            child = new Node(element);
            parent.children.add(child);
        }
        return child.breakdown;
    }

    void endFetchPhase(String element) {
        String uniqueElement = element + "_" + Thread.currentThread().threadId();
        Node node = (Node)this.phaseMap.get(uniqueElement);
        if (node == null) {
            throw new IllegalStateException("Fetch phase '" + element + "' does not exist");
        }
        --node.references;
        if (node.references == 0) {
            this.phaseMap.remove(uniqueElement);
        }
    }

    List<ProfileResult> getTree() {
        ArrayList<ProfileResult> results = new ArrayList<ProfileResult>(this.roots.size());
        for (Node root : this.roots) {
            results.add(this.toProfileResult(root, true));
        }
        return results;
    }

    private ProfileResult toProfileResult(Node node, boolean isRoot) {
        ArrayList<ProfileResult> children = new ArrayList<ProfileResult>(node.children.size());
        for (Node child : node.children) {
            children.add(this.toProfileResult(child, false));
        }
        Map<String, Long> raw = node.breakdown.toBreakdownMap();
        Map<String, Long> filtered = this.filterBreakdown(raw, isRoot);
        return new ProfileResult(node.element, node.element, filtered, node.breakdown.toDebugMap(), this.inclusiveTime(node), children);
    }

    private long inclusiveTime(Node node) {
        long total = node.breakdown.toNodeTime();
        for (Node child : node.children) {
            total += this.inclusiveTime(child);
        }
        return total;
    }

    private Map<String, Long> filterBreakdown(Map<String, Long> raw, boolean isRoot) {
        Set<String> allowed = isRoot ? ROOT_KEYS : SUB_PHASE_KEYS;
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        for (String key : allowed) {
            map.put(key, raw.getOrDefault(key, 0L));
        }
        return map;
    }

    private static class Node {
        final String element;
        final FetchProfileBreakdown breakdown;
        final List<Node> children = new ArrayList<Node>();
        int references;

        Node(String element) {
            this.element = element;
            this.breakdown = new FetchProfileBreakdown();
            this.references = 0;
        }
    }
}

