/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.WrappedRunnable;
import org.opensearch.tasks.TaskManager;
import org.opensearch.threadpool.RunnableTaskExecutionListener;

public class TaskAwareRunnable
extends AbstractRunnable
implements WrappedRunnable {
    private static final Logger logger = LogManager.getLogger(TaskManager.class);
    private final Runnable original;
    private final ThreadContext threadContext;
    private final AtomicReference<RunnableTaskExecutionListener> runnableTaskListener;

    public TaskAwareRunnable(ThreadContext threadContext, Runnable original, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener) {
        this.original = original;
        this.threadContext = threadContext;
        this.runnableTaskListener = runnableTaskListener;
    }

    @Override
    public void onFailure(Exception e) {
        ExceptionsHelper.reThrowIfNotNull((Throwable)e);
    }

    @Override
    public boolean isForceExecution() {
        AbstractRunnable abstractRunnable;
        Runnable runnable = this.original;
        return runnable instanceof AbstractRunnable && (abstractRunnable = (AbstractRunnable)runnable).isForceExecution();
    }

    @Override
    public void onRejection(Exception e) {
        Runnable runnable = this.original;
        if (runnable instanceof AbstractRunnable) {
            AbstractRunnable abstractRunnable = (AbstractRunnable)runnable;
            abstractRunnable.onRejection(e);
        } else {
            ExceptionsHelper.reThrowIfNotNull((Throwable)e);
        }
    }

    @Override
    protected void doRun() throws Exception {
        assert (this.runnableTaskListener.get() != null) : "Listener should be attached";
        Long taskId = (Long)this.threadContext.getTransient("TASK_ID");
        if (Objects.nonNull(taskId)) {
            this.runnableTaskListener.get().taskExecutionStartedOnThread(taskId, Thread.currentThread().threadId());
        } else {
            logger.debug("Task Id not available in thread context. Skipping update. Thread Info: {}", (Object)Thread.currentThread());
        }
        try {
            this.original.run();
        }
        finally {
            if (Objects.nonNull(taskId)) {
                this.runnableTaskListener.get().taskExecutionFinishedOnThread(taskId, Thread.currentThread().threadId());
            }
        }
    }

    @Override
    public Runnable unwrap() {
        return this.original;
    }
}

