/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.remotestore.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.remotestore.metadata.RemoteStoreMetadataRequest;
import org.opensearch.action.admin.cluster.remotestore.metadata.RemoteStoreMetadataResponse;
import org.opensearch.action.admin.cluster.remotestore.metadata.RemoteStoreShardMetadata;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.TransportAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.index.store.RemoteSegmentStoreDirectoryFactory;
import org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.opensearch.index.translog.RemoteFsTranslog;
import org.opensearch.index.translog.transfer.FileTransferTracker;
import org.opensearch.index.translog.transfer.TranslogTransferManager;
import org.opensearch.index.translog.transfer.TranslogTransferMetadata;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportRemoteStoreMetadataAction
extends TransportAction<RemoteStoreMetadataRequest, RemoteStoreMetadataResponse> {
    private static final Logger logger = LogManager.getLogger(TransportRemoteStoreMetadataAction.class);
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final RepositoriesService repositoriesService;
    private final ThreadPool threadPool;
    private final RemoteStoreSettings remoteStoreSettings;

    @Inject
    public TransportRemoteStoreMetadataAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RepositoriesService repositoriesService, ThreadPool threadPool, RemoteStoreSettings remoteStoreSettings) {
        super("cluster:admin/remote_store/metadata", actionFilters, transportService.getTaskManager());
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
        this.remoteStoreSettings = remoteStoreSettings;
    }

    @Override
    protected void doExecute(Task task, RemoteStoreMetadataRequest request, ActionListener<RemoteStoreMetadataResponse> listener) {
        try {
            ClusterState state = this.clusterService.state();
            state.blocks().globalBlockedRaiseException(ClusterBlockLevel.METADATA_READ);
            String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request);
            if (concreteIndices.length == 0) {
                listener.onResponse((Object)new RemoteStoreMetadataResponse(new RemoteStoreShardMetadata[0], 0, 0, 0, Collections.emptyList()));
                return;
            }
            ArrayList<RemoteStoreShardMetadata> responses = new ArrayList<RemoteStoreShardMetadata>();
            ArrayList<DefaultShardOperationFailedException> shardFailures = new ArrayList<DefaultShardOperationFailedException>();
            int totalShards = 0;
            int successfulShards = 0;
            int failedShards = 0;
            RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory = new RemoteSegmentStoreDirectoryFactory(() -> this.repositoriesService, this.threadPool, this.remoteStoreSettings.getSegmentsPathFixedPrefix());
            for (String indexName : concreteIndices) {
                int[] shardIds;
                IndexMetadata indexMetadata = state.metadata().index(indexName);
                Index index = indexMetadata.getIndex();
                IndexSettings indexSettings = new IndexSettings(indexMetadata, this.clusterService.getSettings());
                for (int shardId : shardIds = request.shards().length == 0 ? IntStream.range(0, indexMetadata.getNumberOfShards()).toArray() : Arrays.stream(request.shards()).mapToInt(Integer::parseInt).toArray()) {
                    ++totalShards;
                    ShardId sid = new ShardId(index, shardId);
                    if (!indexMetadata.getSettings().getAsBoolean("index.remote_store.enabled", false).booleanValue()) {
                        ++failedShards;
                        shardFailures.add(new DefaultShardOperationFailedException(indexName, shardId, (Throwable)new IllegalStateException("Remote store not enabled for index")));
                        continue;
                    }
                    try {
                        Map<String, Map<String, Object>> segmentMetadataFiles = this.getSegmentMetadata(remoteDirectoryFactory, indexMetadata, index, sid, indexSettings);
                        String latestSegmentMetadataFilename = segmentMetadataFiles.isEmpty() ? null : new ArrayList<String>(segmentMetadataFiles.keySet()).get(0);
                        Map<String, Map<String, Object>> translogMetadataFiles = this.getTranslogMetadataFiles(indexMetadata, sid, indexSettings);
                        String latestTranslogMetadataFilename = translogMetadataFiles.isEmpty() ? null : new ArrayList<String>(translogMetadataFiles.keySet()).get(0);
                        responses.add(new RemoteStoreShardMetadata(indexName, shardId, segmentMetadataFiles, translogMetadataFiles, latestSegmentMetadataFilename, latestTranslogMetadataFilename));
                        ++successfulShards;
                    }
                    catch (Exception e) {
                        ++failedShards;
                        shardFailures.add(new DefaultShardOperationFailedException(indexName, shardId, (Throwable)e));
                        logger.error("Failed to fetch metadata for shard [" + shardId + "]", (Throwable)e);
                    }
                }
            }
            listener.onResponse((Object)new RemoteStoreMetadataResponse(responses.toArray(new RemoteStoreShardMetadata[0]), totalShards, successfulShards, failedShards, shardFailures));
        }
        catch (Exception e) {
            logger.error("Failed to execute remote store metadata action", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private Map<String, Map<String, Object>> getSegmentMetadata(RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory, IndexMetadata indexMetadata, Index index, ShardId shardId, IndexSettings indexSettings) throws IOException {
        RemoteSegmentStoreDirectory remoteDirectory = (RemoteSegmentStoreDirectory)remoteDirectoryFactory.newDirectory(IndexMetadata.INDEX_REMOTE_SEGMENT_STORE_REPOSITORY_SETTING.get(indexMetadata.getSettings()), index.getUUID(), shardId, indexSettings.getRemoteStorePathStrategy(), null, RemoteStoreUtils.isServerSideEncryptionEnabledIndex(indexSettings.getIndexMetadata()));
        Map<String, RemoteSegmentMetadata> segmentMetadataMapWithFilenames = remoteDirectory.readLatestNMetadataFiles(5);
        LinkedHashMap<String, Map<String, Object>> metadataFilesMap = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, RemoteSegmentMetadata> entry : segmentMetadataMapWithFilenames.entrySet()) {
            String fileName = entry.getKey();
            RemoteSegmentMetadata segmentMetadata = entry.getValue();
            HashMap segmentMetadataMap = new HashMap();
            HashMap filesMap = new HashMap();
            segmentMetadata.getMetadata().forEach((file, meta) -> {
                HashMap<String, Object> metaMap = new HashMap<String, Object>();
                metaMap.put("original_name", meta.getOriginalFilename());
                metaMap.put("checksum", meta.getChecksum());
                metaMap.put("length", meta.getLength());
                filesMap.put(file, metaMap);
            });
            segmentMetadataMap.put("files", filesMap);
            ReplicationCheckpoint checkpoint = segmentMetadata.getReplicationCheckpoint();
            if (checkpoint != null) {
                HashMap<String, Object> checkpointMap = new HashMap<String, Object>();
                checkpointMap.put("primary_term", checkpoint.getPrimaryTerm());
                checkpointMap.put("segments_gen", checkpoint.getSegmentsGen());
                checkpointMap.put("segment_infos_version", checkpoint.getSegmentInfosVersion());
                checkpointMap.put("length", checkpoint.getLength());
                checkpointMap.put("codec", checkpoint.getCodec());
                checkpointMap.put("created_timestamp", checkpoint.getCreatedTimeStamp());
                segmentMetadataMap.put("replication_checkpoint", checkpointMap);
            }
            metadataFilesMap.put(fileName, segmentMetadataMap);
        }
        return metadataFilesMap;
    }

    private Map<String, Map<String, Object>> getTranslogMetadataFiles(IndexMetadata indexMetadata, ShardId shardId, IndexSettings indexSettings) throws IOException {
        String repository = IndexMetadata.INDEX_REMOTE_TRANSLOG_REPOSITORY_SETTING.get(indexMetadata.getSettings());
        if (repository == null) {
            return Collections.emptyMap();
        }
        RemoteTranslogTransferTracker tracker = new RemoteTranslogTransferTracker(shardId, 1000);
        FileTransferTracker fileTransferTracker = new FileTransferTracker(shardId, tracker);
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)this.repositoriesService.repository(repository);
        TranslogTransferManager manager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, this.threadPool, shardId, fileTransferTracker, tracker, indexSettings.getRemoteStorePathStrategy(), new RemoteStoreSettings(this.clusterService.getSettings(), this.clusterService.getClusterSettings()), RemoteStoreUtils.determineTranslogMetadataEnabled(indexMetadata), RemoteStoreUtils.isServerSideEncryptionEnabledIndex(indexSettings.getIndexMetadata()));
        Map<String, TranslogTransferMetadata> metadataMap = manager.readLatestNMetadataFiles(5);
        LinkedHashMap<String, Map<String, Object>> translogFilesMap = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, TranslogTransferMetadata> entry : metadataMap.entrySet()) {
            String fileName = entry.getKey();
            TranslogTransferMetadata metadata = entry.getValue();
            HashMap<String, Object> fileMap = new HashMap<String, Object>();
            fileMap.put("primary_term", metadata.getPrimaryTerm());
            fileMap.put("generation", metadata.getGeneration());
            fileMap.put("min_translog_gen", metadata.getMinTranslogGeneration());
            Map<String, String> genToTerm = metadata.getGenerationToPrimaryTermMapper();
            if (genToTerm == null || genToTerm.isEmpty()) {
                genToTerm = Map.of(String.valueOf(metadata.getGeneration()), String.valueOf(metadata.getPrimaryTerm()));
            }
            fileMap.put("generation_to_primary_term", genToTerm);
            translogFilesMap.put(fileName, fileMap);
        }
        return translogFilesMap;
    }
}

