/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class ThreadPoolStats
implements Writeable,
ToXContentFragment,
Iterable<Stats> {
    private List<Stats> stats;

    public ThreadPoolStats(List<Stats> stats) {
        Collections.sort(stats);
        this.stats = stats;
    }

    public ThreadPoolStats(StreamInput in) throws IOException {
        this.stats = in.readList(Stats::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.stats);
    }

    @Override
    public Iterator<Stats> iterator() {
        return this.stats.iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("thread_pool");
        for (Stats stat : this.stats) {
            stat.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String THREAD_POOL = "thread_pool";
        static final String THREADS = "threads";
        static final String QUEUE = "queue";
        static final String ACTIVE = "active";
        static final String REJECTED = "rejected";
        static final String LARGEST = "largest";
        static final String COMPLETED = "completed";
        static final String WAIT_TIME = "total_wait_time";
        static final String WAIT_TIME_NANOS = "total_wait_time_in_nanos";
        static final String PARALLELISM = "parallelism";

        Fields() {
        }
    }

    @PublicApi(since="1.0.0")
    public static class Stats
    implements Writeable,
    ToXContentFragment,
    Comparable<Stats> {
        private final String name;
        private final int threads;
        private final int queue;
        private final int active;
        private final long rejected;
        private final int largest;
        private final long completed;
        private final long waitTimeNanos;
        private final int parallelism;

        private Stats(Builder builder) {
            this.name = builder.name;
            this.threads = builder.threads;
            this.queue = builder.queue;
            this.active = builder.active;
            this.rejected = builder.rejected;
            this.largest = builder.largest;
            this.completed = builder.completed;
            this.waitTimeNanos = builder.waitTimeNanos;
            this.parallelism = builder.parallelism;
        }

        @Deprecated
        public Stats(String name, int threads, int queue, int active, long rejected, int largest, long completed, long waitTimeNanos) {
            this.name = name;
            this.threads = threads;
            this.queue = queue;
            this.active = active;
            this.rejected = rejected;
            this.largest = largest;
            this.completed = completed;
            this.waitTimeNanos = waitTimeNanos;
            this.parallelism = -1;
        }

        @Deprecated
        public Stats(String name, int threads, int queue, int active, long rejected, int largest, long completed, long waitTimeNanos, int parallelism) {
            this.name = name;
            this.threads = threads;
            this.queue = queue;
            this.active = active;
            this.rejected = rejected;
            this.largest = largest;
            this.completed = completed;
            this.waitTimeNanos = waitTimeNanos;
            this.parallelism = parallelism;
        }

        public Stats(StreamInput in) throws IOException {
            this.name = in.readString();
            this.threads = in.readInt();
            this.queue = in.readInt();
            this.active = in.readInt();
            this.rejected = in.readLong();
            this.largest = in.readInt();
            this.completed = in.readLong();
            this.waitTimeNanos = in.getVersion().onOrAfter(Version.V_2_11_0) ? in.readLong() : -1L;
            this.parallelism = in.getVersion().onOrAfter(Version.V_3_4_0) ? in.readInt() : -1;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeInt(this.threads);
            out.writeInt(this.queue);
            out.writeInt(this.active);
            out.writeLong(this.rejected);
            out.writeInt(this.largest);
            out.writeLong(this.completed);
            if (out.getVersion().onOrAfter(Version.V_2_11_0)) {
                out.writeLong(this.waitTimeNanos);
            }
            if (out.getVersion().onOrAfter(Version.V_3_4_0)) {
                out.writeInt(this.parallelism);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getThreads() {
            return this.threads;
        }

        public int getQueue() {
            return this.queue;
        }

        public int getActive() {
            return this.active;
        }

        public long getRejected() {
            return this.rejected;
        }

        public int getLargest() {
            return this.largest;
        }

        public long getCompleted() {
            return this.completed;
        }

        public TimeValue getWaitTime() {
            return TimeValue.timeValueNanos((long)this.waitTimeNanos);
        }

        public long getWaitTimeNanos() {
            return this.waitTimeNanos;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name);
            if (this.parallelism != -1) {
                builder.field("parallelism", this.parallelism);
            }
            if (this.threads != -1) {
                builder.field("threads", this.threads);
            }
            if (this.queue != -1) {
                builder.field("queue", this.queue);
            }
            if (this.active != -1) {
                builder.field("active", this.active);
            }
            if (this.rejected != -1L) {
                builder.field("rejected", this.rejected);
            }
            if (this.largest != -1) {
                builder.field("largest", this.largest);
            }
            if (this.completed != -1L) {
                builder.field("completed", this.completed);
            }
            if (this.waitTimeNanos != -1L) {
                if (builder.humanReadable()) {
                    builder.field("total_wait_time", (Object)this.getWaitTime());
                }
                builder.field("total_wait_time_in_nanos", this.getWaitTimeNanos());
            }
            builder.endObject();
            return builder;
        }

        @Override
        public int compareTo(Stats other) {
            if (this.getName() == null && other.getName() == null) {
                return 0;
            }
            if (this.getName() != null && other.getName() == null) {
                return 1;
            }
            if (this.getName() == null) {
                return -1;
            }
            int compare = this.getName().compareTo(other.getName());
            if (compare == 0) {
                compare = Integer.compare(this.getThreads(), other.getThreads());
            }
            return compare;
        }

        public static class Builder {
            private String name = "";
            private int threads = 0;
            private int queue = 0;
            private int active = 0;
            private long rejected = 0L;
            private int largest = 0;
            private long completed = 0L;
            private long waitTimeNanos = 0L;
            private int parallelism = 0;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder threads(int threads) {
                this.threads = threads;
                return this;
            }

            public Builder queue(int queue) {
                this.queue = queue;
                return this;
            }

            public Builder active(int active) {
                this.active = active;
                return this;
            }

            public Builder rejected(long rejected) {
                this.rejected = rejected;
                return this;
            }

            public Builder largest(int largest) {
                this.largest = largest;
                return this;
            }

            public Builder completed(long completed) {
                this.completed = completed;
                return this;
            }

            public Builder waitTimeNanos(long waitTimeNanos) {
                this.waitTimeNanos = waitTimeNanos;
                return this;
            }

            public Builder parallelism(int parallelism) {
                this.parallelism = parallelism;
                return this;
            }

            public Stats build() {
                return new Stats(this);
            }
        }
    }
}

