/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.ExpressionEvaluationException;

public abstract class AbstractExprValue
implements ExprValue {
    @Override
    public int compareTo(ExprValue other) {
        if (this.isNull() || this.isMissing() || other.isNull() || other.isMissing()) {
            throw new IllegalStateException("[BUG] Unreachable, Comparing with NULL or MISSING is undefined");
        }
        if (this.isNumber() && other.isNumber() || this.isDateTime() && other.isDateTime() || this.type().equals(other.type())) {
            return this.compare(other);
        }
        throw new ExpressionEvaluationException(String.format("compare expected value have same type, but with [%s, %s]", this.type(), other.type()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprValue)) {
            return false;
        }
        ExprValue other = (ExprValue)o;
        if (this.isNull() || this.isMissing()) {
            return this.equal(other);
        }
        if (other.isNull() || other.isMissing()) {
            return other.equals(this);
        }
        return this.equal(other);
    }

    public abstract int compare(ExprValue var1);

    public abstract boolean equal(ExprValue var1);

    @Override
    public Object valueForCalcite() {
        return this.value();
    }
}

